/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xlightweb.AbstractHttpConnection;
import org.xlightweb.BodyType;
import org.xlightweb.HttpRequest;
import org.xlightweb.HttpRequestHeader;
import org.xlightweb.HttpUtils;
import org.xlightweb.IBodyCompleteListener;
import org.xlightweb.IBodyDataHandler;
import org.xlightweb.IHttpRequest;
import org.xlightweb.IHttpRequestHeader;
import org.xlightweb.IPart;
import org.xlightweb.IPartHandler;
import org.xlightweb.MultipartFormDataPart;
import org.xlightweb.NonBlockingBodyDataSource;
import org.xlightweb.PartHandlerInfo;
import org.xsocket.DataConverter;
import org.xsocket.Execution;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartFormDataRequest
extends HttpRequest {
    private static final Logger LOG = Logger.getLogger(MultipartFormDataRequest.class.getName());
    private final String boundary;
    private final Map<String, MultipartFormDataPart> parts = new HashMap<String, MultipartFormDataPart>();
    private boolean isModifyable;
    private AtomicBoolean isComplete = new AtomicBoolean(false);
    private AtomicReference<IPartHandler> handlerRef = new AtomicReference<Object>(null);
    private AtomicReference<PartHandlerInfo> handlerInfo = new AtomicReference<Object>(null);
    private final AbstractHttpConnection.IMultimodeExecutor executor;

    public MultipartFormDataRequest(String url) throws MalformedURLException, IOException {
        this(new HttpRequestHeader("POST", url), UUID.randomUUID().toString(), new NonBlockingBodyDataSource(BodyType.IN_MEMORY, "ISO-8859-1"));
        this.isModifyable = true;
        super.setContentType("multipart/form-data; boundary=" + this.boundary);
        this.setContentLength(0);
        this.getNonBlockingBody().setComplete(true);
    }

    MultipartFormDataRequest(IHttpRequest request) throws IOException {
        this(request.getRequestHeader(), MultipartFormDataRequest.parseBoundary(request.getRequestHeader()), request.getNonBlockingBody());
        this.isModifyable = false;
        if (!MultipartFormDataRequest.isMultipartFormDataRequest(request)) {
            throw new IOException("request is not a multipart/form-data request ");
        }
        NonBlockingBodyDataSource bodyDataSource = request.getNonBlockingBody();
        MultpartRequestBodyDataHandler dh = new MultpartRequestBodyDataHandler();
        bodyDataSource.setDataHandler(dh);
        dh.onData(bodyDataSource);
    }

    private MultipartFormDataRequest(IHttpRequestHeader header, String boundary, NonBlockingBodyDataSource body) throws IOException {
        super(header);
        AbstractHttpConnection con = body.getConnection();
        this.executor = con != null ? body.getConnection().getExecutor() : new DefaultMultimodeExecutor();
        this.setBodyDataSource(body);
        this.boundary = boundary;
    }

    boolean isComplete() {
        return this.isComplete.get();
    }

    private static String parseBoundary(IHttpRequestHeader requestHeader) throws IOException {
        String[] atts;
        String contentType = requestHeader.getContentType();
        String attr = contentType.substring("multipart/form-data".length(), contentType.length()).trim();
        for (String att : atts = attr.split(";")) {
            if (!(att = att.trim()).toLowerCase().startsWith("boundary=")) continue;
            return att.substring("boundary=".length(), att.length()).trim();
        }
        throw new IOException("request " + requestHeader + " does not declares the boundary");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPartHandler(IPartHandler handler) throws IOException {
        this.handlerRef.set(handler);
        this.handlerInfo.set(HttpUtils.getPartHandlerInfo(handler));
        ArrayList<MultipartFormDataPart> partsCopy = new ArrayList<MultipartFormDataPart>();
        Map<String, MultipartFormDataPart> map = this.parts;
        synchronized (map) {
            partsCopy.addAll(this.parts.values());
        }
        for (MultipartFormDataPart part : partsCopy) {
            this.onPart(part);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPart(MultipartFormDataPart part) throws IOException {
        Map<String, MultipartFormDataPart> map = this.parts;
        synchronized (map) {
            this.parts.put(part.getDispositionParam("name"), part);
        }
        this.onPart(part);
    }

    private void onPart(final MultipartFormDataPart part) throws IOException {
        IPartHandler handler = this.handlerRef.get();
        if (handler != null) {
            if (this.handlerInfo.get().isHandlerInvokeOnMessageReceived()) {
                IBodyCompleteListener cl = new IBodyCompleteListener(){

                    @Execution(value=0)
                    public void onComplete() throws IOException {
                        if (((PartHandlerInfo)MultipartFormDataRequest.this.handlerInfo.get()).isHandlerMultithreaded()) {
                            MultipartFormDataRequest.this.executor.processMultithreaded(new PartHandlerCaller(part));
                        } else {
                            MultipartFormDataRequest.this.executor.processNonthreaded(new PartHandlerCaller(part));
                        }
                    }
                };
                part.getNonBlockingBody().addCompleteListener(cl);
            } else if (this.handlerInfo.get().isHandlerMultithreaded()) {
                this.executor.processMultithreaded(new PartHandlerCaller(part));
            } else {
                this.executor.processNonthreaded(new PartHandlerCaller(part));
            }
        }
    }

    @Override
    public void setContentType(String type) {
        LOG.warning("current content type " + this.getContentType() + " will be overriden by " + type);
        super.setContentType(type);
    }

    IPart getPart(String name) throws IOException {
        this.throwExceptionIfnotComplete();
        return this.parts.get(name);
    }

    Map<String, IPart> getPartMap() throws IOException {
        this.throwExceptionIfnotComplete();
        HashMap<String, IPart> result = new HashMap<String, IPart>();
        for (Map.Entry<String, MultipartFormDataPart> entry : this.parts.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    Set<String> getPartnameSet() throws IOException {
        this.throwExceptionIfnotComplete();
        return Collections.unmodifiableSet(this.parts.keySet());
    }

    private void throwExceptionIfnotComplete() throws IOException {
        if (!this.isComplete.get()) {
            LOG.warning("request " + this.getRequestHeader() + " is not received completly (hint: set @InvokeOn(InvokeOn.MESSAGE_RECEIVED) or uses a IBodyCompleteListener)");
            throw new IOException("request is not received completly (hint: set @InvokeOn(InvokeOn.MESSAGE_RECEIVED) or uses a IBodyCompleteListener)");
        }
    }

    static boolean isMultipartFormDataRequest(IHttpRequest request) {
        if (!request.hasBody()) {
            return false;
        }
        String contentType = request.getContentType();
        return contentType != null && contentType.startsWith("multipart/form-data");
    }

    public void addPart(String name, String content) throws IOException {
        this.addPart(name, content, "text/plain", this.getNonBlockingBody().getEncoding());
    }

    public void addPart(String name, String contentType, String content) throws IOException {
        this.addPart(name, content, contentType, HttpUtils.parseEncoding(contentType, this.getNonBlockingBody().getEncoding()));
    }

    private void addPart(String name, String content, String contentType, String encoding) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("--" + this.boundary + "\r\n");
        sb.append("Content-Disposition: form-data; name=\"" + name + "\"\r\n");
        sb.append("Content-Type: " + contentType + "; " + encoding + "\r\n");
        sb.append("\r\n");
        byte[] header = sb.toString().getBytes("US-ASCII");
        ByteBuffer buffer = DataConverter.toByteBuffer((String)content, (String)encoding);
        this.addPart(DataConverter.toByteBuffer((byte[])header), buffer);
    }

    public void addPart(String name, File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("--" + this.boundary + "\r\n");
        sb.append("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + file.getName() + "\"\r\n");
        sb.append("Content-Type: " + MultipartFormDataRequest.getContentTypeByFileExtension(file) + "\r\n");
        sb.append("\r\n");
        byte[] header = sb.toString().getBytes("US-ASCII");
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        FileChannel fc = raf.getChannel();
        ByteBuffer buffer = ByteBuffer.allocate((int)fc.size());
        fc.read(buffer);
        fc.close();
        raf.close();
        buffer.flip();
        this.addPart(DataConverter.toByteBuffer((byte[])header), buffer);
    }

    private void addPart(ByteBuffer ... part) throws IOException {
        if (!this.isModifyable) {
            throw new IOException("modifying a recevied message is not supported");
        }
        int size = this.getNonBlockingBody().available();
        if (size < 0) {
            size = 0;
        }
        if (size > 0) {
            ByteBuffer[] oldContent = this.getNonBlockingBody().readByteBufferByLength(size);
            size = 0;
            for (int i = 0; i < oldContent.length; ++i) {
                ByteBuffer buf = null;
                buf = i == oldContent.length - 1 ? (("\r\n--" + this.boundary + "--\r\n").equals(DataConverter.toString((ByteBuffer)oldContent[i].duplicate(), (String)"US-ASCII")) ? DataConverter.toByteBuffer((String)"\r\n", (String)"US-ASCII") : oldContent[i]) : oldContent[i];
                if (buf == null) continue;
                size += buf.remaining();
                this.getNonBlockingBody().append(true, buf);
            }
        }
        for (ByteBuffer buffer : part) {
            size += buffer.remaining();
        }
        this.getNonBlockingBody().append(true, part, null);
        StringBuilder sb = new StringBuilder("\r\n--" + this.boundary + "--\r\n");
        byte[] bound = sb.toString().getBytes("US-ASCII");
        this.getNonBlockingBody().append(true, ByteBuffer.wrap(bound));
        this.setContentLength(size += bound.length);
        this.getNonBlockingBody().setComplete(true);
    }

    private static class DefaultMultimodeExecutor
    implements AbstractHttpConnection.IMultimodeExecutor {
        private static final Executor defaultExecutor = Executors.newCachedThreadPool();

        private DefaultMultimodeExecutor() {
        }

        public void processMultithreaded(Runnable task) {
            defaultExecutor.execute(task);
        }

        public void processNonthreaded(Runnable task) {
            task.run();
        }
    }

    @Execution(value=0)
    private final class MultpartRequestBodyDataHandler
    implements IBodyDataHandler,
    MultipartFormDataPart.IPartReadListener {
        private static final int STATE_PRE_BOUNDARY = 0;
        private static final int STATE_READ_HEADER = 5;
        private static final int STATE_COMPLETE = 10;
        private int state = 0;

        private MultpartRequestBodyDataHandler() {
        }

        public boolean onData(NonBlockingBodyDataSource bodyDataSource) throws BufferUnderflowException {
            block13: {
                try {
                    if (MultipartFormDataRequest.this.isComplete.get()) {
                        return true;
                    }
                    switch (this.state) {
                        case 0: {
                            String leadingString = MultipartFormDataRequest.this.getNonBlockingBody().readStringByDelimiter("--" + MultipartFormDataRequest.this.boundary + "\r");
                            if (leadingString.trim().length() > 0 && LOG.isLoggable(Level.FINE)) {
                                LOG.fine("first part has leading chars " + leadingString + " chars will be ignored");
                            }
                            this.state = 5;
                            this.onData(bodyDataSource);
                            break;
                        }
                        case 5: {
                            String header = null;
                            try {
                                header = MultipartFormDataRequest.this.getNonBlockingBody().readStringByDelimiter("\r\n\r\n");
                            }
                            catch (BufferUnderflowException bue) {
                                header = MultipartFormDataRequest.this.getNonBlockingBody().readStringByDelimiter("\r\r");
                            }
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("header read: " + header);
                            }
                            String[] headerlines = header.split("\r");
                            for (int i = 0; i < headerlines.length; ++i) {
                                if (headerlines[i].startsWith("\n")) {
                                    headerlines[i] = headerlines[i].substring(1, headerlines[i].length());
                                }
                                headerlines[i] = headerlines[i].trim();
                            }
                            new MultipartFormDataPart(this, MultipartFormDataRequest.this.boundary, headerlines, MultipartFormDataRequest.this.getNonBlockingBody());
                            break;
                        }
                    }
                }
                catch (IOException ioe) {
                    if (!LOG.isLoggable(Level.FINE)) break block13;
                    LOG.fine("error occured by parsing multipart request " + ioe.toString());
                }
            }
            return true;
        }

        public void onPartRead(MultipartFormDataPart part) {
            try {
                this.state = 0;
                MultipartFormDataRequest.this.addPart(part);
                MultipartFormDataRequest.this.getNonBlockingBody().setDataHandler(this);
                this.onData(MultipartFormDataRequest.this.getNonBlockingBody());
            }
            catch (IOException ioe) {
                this.onException(ioe);
            }
        }

        public void onLastPartRead(MultipartFormDataPart part) {
            try {
                this.state = 10;
                MultipartFormDataRequest.this.isComplete.set(true);
                MultipartFormDataRequest.this.addPart(part);
            }
            catch (IOException ioe) {
                this.onException(ioe);
            }
        }

        public void onException(IOException ioe) {
            block2: {
                try {
                    MultipartFormDataRequest.this.getNonBlockingBody().destroy();
                }
                catch (IOException e) {
                    if (!LOG.isLoggable(Level.FINE)) break block2;
                    LOG.fine("error occred by destroying non blcoking body " + e.toString());
                }
            }
        }
    }

    private final class PartHandlerCaller
    implements Runnable {
        private final MultipartFormDataPart part;

        public PartHandlerCaller(MultipartFormDataPart part) {
            this.part = part;
        }

        public void run() {
            IPartHandler handler = (IPartHandler)MultipartFormDataRequest.this.handlerRef.get();
            if (handler != null) {
                try {
                    handler.onPart(this.part);
                }
                catch (IOException ioe) {
                    this.part.destroy();
                    throw new RuntimeException(ioe);
                }
            }
        }
    }
}

