/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.automation.view.startup;

import com.paterva.maltego.automation.Payloads;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.store.structure.GraphStructureStore;
import com.paterva.maltego.graph.wrapper.GraphStoreHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.openide.util.Exceptions;

public class EntityNodePayload
extends Payloads.Abstract {
    private final GraphID _graphID;
    private Collection<EntityID> _entityIDs;
    private Collection<MaltegoEntity> _entities;

    public EntityNodePayload(GraphID graphID, Collection<EntityID> entities) {
        this._graphID = graphID;
        this._entityIDs = Collections.unmodifiableCollection(entities);
    }

    @Override
    public int size() {
        return this._entityIDs.size();
    }

    @Override
    public Collection<EntityID> getEntityIDs() {
        return this._entityIDs;
    }

    @Override
    public Collection<MaltegoEntity> getEntities() {
        if (this._entities == null) {
            this._entities = GraphStoreHelper.getMaltegoEntities((GraphID)this._graphID, this._entityIDs);
        }
        return this._entities;
    }

    @Override
    public void sync() {
        this._entities = null;
        Set entityIDs = Collections.EMPTY_SET;
        try {
            GraphStoreRegistry registry = GraphStoreRegistry.getDefault();
            if (this._graphID != null && registry.isExistingAndOpen(this._graphID)) {
                GraphStore graphStore = registry.forGraphID(this._graphID);
                GraphStructureStore structureStore = graphStore.getGraphStructureStore();
                GraphStructureReader structureReader = structureStore.getStructureReader();
                entityIDs = structureReader.getExistingEntities(this._entityIDs);
            }
        }
        catch (GraphStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this._entityIDs = Collections.unmodifiableSet(entityIDs);
    }
}

