/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.policy;

import org.keycloak.models.KeycloakContext;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.policy.PasswordPolicyProvider;
import org.keycloak.policy.PolicyError;

public class NotContainsUsernamePasswordPolicyProvider
implements PasswordPolicyProvider {
    private static final String ERROR_MESSAGE = "invalidPasswordNotContainsUsernameMessage";
    private KeycloakContext context;

    public NotContainsUsernamePasswordPolicyProvider(KeycloakContext context) {
        this.context = context;
    }

    public PolicyError validate(String username, String password) {
        if (username == null) {
            return null;
        }
        return password.contains(username) ? new PolicyError(ERROR_MESSAGE, new Object[0]) : null;
    }

    public PolicyError validate(RealmModel realm, UserModel user, String password) {
        return this.validate(user.getUsername(), password);
    }

    public Object parseConfig(String value) {
        return null;
    }

    public void close() {
    }
}

