/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.attachments;

import com.paterva.maltego.typing.editing.AttachmentUtils;
import com.paterva.maltego.typing.types.Attachment;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbPreferences;
import org.openide.util.actions.NodeAction;
import org.openide.windows.WindowManager;

public class AttachmentsExportAction
extends NodeAction {
    public static String PREF_PREV_DIR = "attachmentExportPrevDir";

    public String getName() {
        return "Export";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction(Node[] activatedNodes) {
        File folder;
        JFileChooser fc = new JFileChooser(this.getPrevDir());
        fc.setDialogTitle("Select a folder");
        fc.setFileSelectionMode(1);
        if (0 == fc.showSaveDialog(WindowManager.getDefault().getMainWindow()) && (folder = fc.getSelectedFile()).isDirectory()) {
            String path = folder.getAbsolutePath();
            this.setPrevDir(path);
            this.saveSelectedItems(path, this.getAttachments(activatedNodes));
        }
    }

    public boolean enable(Node[] activatedNodes) {
        return !this.getAttachments(activatedNodes).isEmpty();
    }

    private List<Attachment> getAttachments(Node[] activatedNodes) {
        ArrayList<Attachment> atts = new ArrayList<Attachment>();
        for (Node node : activatedNodes) {
            Attachment att = (Attachment)node.getLookup().lookup(Attachment.class);
            if (att == null) continue;
            atts.add(att);
        }
        return atts;
    }

    private void saveSelectedItems(String path, List<Attachment> atts) {
        int savedCount = AttachmentUtils.export(path, atts);
        String msg = atts.size() == savedCount ? (savedCount == 1 ? "The file was exported successfully." : "All files were exported successfully.") : (savedCount == 0 ? "No files were exported" : savedCount + " of " + atts.size() + " files exported successfully.");
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)msg, 1);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
    }

    private String getPrevDir() {
        return NbPreferences.forModule(AttachmentsExportAction.class).get(PREF_PREV_DIR, "");
    }

    private void setPrevDir(String dir) {
        NbPreferences.forModule(AttachmentsExportAction.class).put(PREF_PREV_DIR, dir);
    }
}

