/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.typing.editing.inputform;

import com.paterva.maltego.typing.PropertyConfiguration;
import com.paterva.maltego.typing.editing.inputform.FormDataStub;
import com.paterva.maltego.typing.editing.inputform.FormDataTranslator;
import com.paterva.maltego.typing.editing.inputform.FormError;
import com.paterva.maltego.typing.editing.inputform.InputForm;
import com.paterva.maltego.typing.editing.inputform.InputFormException;
import com.paterva.maltego.typing.editing.inputform.PropertyStub;
import com.paterva.maltego.typing.serializer.FieldsSerializer;
import com.paterva.maltego.typing.serializer.PropertiesStub;
import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.XmlSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

public class InputFormSerializer {
    FieldsSerializer _fieldsSerializer = new FieldsSerializer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputForm readForm(String xml) throws IOException {
        try (ByteArrayInputStream stream = null;){
            stream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            InputForm inputForm = this.readForm(stream);
            return inputForm;
        }
    }

    public void readFormData(InputForm form, String xml) throws IOException {
        if (xml.contains("<MaltegoErrorMessage>")) {
            FormError error = this.readFormErrorImpl(xml);
            if (error != null) {
                throw new InputFormException(error.getMessages());
            }
        } else {
            this.readFormDataImpl(form, xml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FormError readFormErrorImpl(String xml) throws IOException {
        try (ByteArrayInputStream stream = null;){
            FormError stub;
            stream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            XmlSerializer serializer = new XmlSerializer();
            FormError formError = stub = (FormError)serializer.read(FormError.class, (InputStream)stream);
            return formError;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFormDataImpl(InputForm form, String xml) throws IOException {
        try (ByteArrayInputStream stream = null;){
            stream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
            XmlSerializer serializer = new XmlSerializer();
            FormDataStub stub = (FormDataStub)serializer.read(FormDataStub.class, (InputStream)stream);
            FormDataTranslator translator = new FormDataTranslator();
            translator.translate(stub.getProperties(), form.getProperties(), form.getData());
        }
    }

    public void readFormData(InputForm form, InputStream stream) throws IOException {
        this.readFormData(form, StringUtilities.toString((InputStream)stream, (String)"UTF-8"));
    }

    public String writeFormData(InputForm form) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.writeFormData(form, os);
        return os.toString("UTF-8");
    }

    public InputForm readForm(InputStream stream) throws IOException {
        XmlSerializer serializer = new XmlSerializer();
        InputFormStub stub = (InputFormStub)serializer.read(InputFormStub.class, stream);
        return this.translate(stub);
    }

    public void writeForm(InputForm form, OutputStream stream) throws IOException {
        InputFormStub stub = this.translate(form);
        XmlSerializer serializer = new XmlSerializer();
        serializer.write((Object)stub, stream);
    }

    public void writeFormData(InputForm form, OutputStream stream) throws IOException {
        FormDataTranslator translator = new FormDataTranslator();
        List<PropertyStub> stubs = translator.translate(form.getProperties(), form.getData());
        FormDataStub stub = new FormDataStub(stubs);
        XmlSerializer serializer = new XmlSerializer();
        serializer.write((Object)stub, stream);
    }

    private InputForm translate(InputFormStub from) throws IOException {
        PropertyConfiguration properties = this._fieldsSerializer.readSerializationStub(from.getProperties());
        InputForm to = new InputForm(properties);
        to.setName(from.getName());
        to.setPostBack(from.getPostBack());
        return to;
    }

    private InputFormStub translate(InputForm form) throws IOException {
        InputFormStub stub = new InputFormStub();
        stub.setPostBack(form.getPostBack());
        stub.setName(form.getName());
        stub.setProperties(this._fieldsSerializer.createSerializationStub(form.getPropertyConfiguration()));
        return stub;
    }

    @Root(name="MaltegoInputForm", strict=false)
    private static class InputFormStub {
        @Attribute(name="name", required=false)
        private String _name;
        @Attribute(name="postBack", required=false)
        private String _postBack;
        @Element(name="Properties", required=true)
        private PropertiesStub _properties;

        private InputFormStub() {
        }

        public String getName() {
            return this._name;
        }

        public void setName(String type) {
            this._name = type;
        }

        public void setPostBack(String url) {
            this._postBack = url;
        }

        public String getPostBack() {
            return this._postBack;
        }

        public PropertiesStub getProperties() {
            return this._properties;
        }

        public void setProperties(PropertiesStub stub) {
            this._properties = stub;
        }
    }
}

