/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.runner.inputs;

import com.paterva.maltego.util.StringUtilities;
import com.paterva.maltego.util.ui.GraphicsUtils;
import com.paterva.maltego.util.ui.VFlowLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class TransformInputsForm
extends JPanel {
    boolean _resize = true;
    private JPanel _contentPane;
    private JLabel _headingLabel;
    private JCheckBox _remember;
    private JScrollPane _scrollPane;

    public TransformInputsForm() {
        this.initComponents();
        this._contentPane.setLayout((LayoutManager)new VFlowLayout(0, 3));
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        this.setBackground(laf.getColor("transform-manager-content-bg"));
        this._contentPane.setBackground(laf.getColor("transform-manager-content-bg"));
        this._contentPane.setBorder(new LineBorder(laf.getColor("transform-manager-lowlight-border"), 0, false));
    }

    public TransformInputsForm(String headingLabel, boolean rememberCheckbox) {
        this.initComponents();
        if (!rememberCheckbox) {
            this._remember.setVisible(false);
            this._remember.setFocusable(false);
        }
        this._headingLabel.setText(headingLabel);
        this.setLabelWidth(headingLabel);
        this._contentPane.setLayout((LayoutManager)new VFlowLayout(0, 3));
        UIDefaults laf = UIManager.getLookAndFeelDefaults();
        this.setBackground(laf.getColor("transform-manager-content-bg"));
        this._contentPane.setBackground(laf.getColor("transform-manager-content-bg"));
        this._contentPane.setBorder(new LineBorder(laf.getColor("transform-manager-lowlight-border"), 0, false));
    }

    public Container getContentPane() {
        return this._contentPane;
    }

    public JScrollPane getScrollPane() {
        return this._scrollPane;
    }

    public boolean rememberSettings() {
        return this._remember.isSelected();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        int screenHeight = Utilities.getUsableScreenBounds().height;
        size.height = Math.min(size.height, screenHeight - 200);
        return size;
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this._resize) {
            int maxHeight = 500;
            int oldHeight = this._scrollPane.getHeight();
            if (oldHeight > maxHeight) {
                this._scrollPane.setSize(this._scrollPane.getWidth(), maxHeight);
                this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight() - (oldHeight - maxHeight)));
                this._resize = false;
                this.doLayout();
            }
        }
    }

    private void setLabelWidth(String headingLabel) {
        Graphics2D g2D = GraphicsUtils.createGraphics2D();
        Font font = this._headingLabel.getFont();
        g2D.setFont(font);
        int width = Math.max(222, Math.min(600, (int)Math.ceil(StringUtilities.getStringWidth((Graphics)g2D, (String)headingLabel))));
        g2D.dispose();
        this._headingLabel.setMinimumSize(new Dimension(width, 22));
        this._headingLabel.setPreferredSize(new Dimension(width, 22));
    }

    private void initComponents() {
        this._headingLabel = new JLabel();
        this._scrollPane = new JScrollPane();
        this._contentPane = new ContentPane();
        this._remember = new JCheckBox();
        this.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 5));
        this.setMaximumSize(new Dimension(620, 700));
        this.setMinimumSize(new Dimension(50, 50));
        this.setLayout(new BorderLayout(0, 20));
        this._headingLabel.setFont(this._headingLabel.getFont().deriveFont(this._headingLabel.getFont().getStyle() | 1));
        this._headingLabel.setText(NbBundle.getMessage(TransformInputsForm.class, (String)"TransformInputsForm._headingLabel.text"));
        this._headingLabel.setPreferredSize(new Dimension(222, 25));
        this._headingLabel.setVerticalTextPosition(1);
        this.add((Component)this._headingLabel, "First");
        this._scrollPane.setVerticalScrollBarPolicy(22);
        this._scrollPane.setHorizontalScrollBar(null);
        this._scrollPane.setMaximumSize(new Dimension(600, 500));
        this._contentPane.setBackground(new Color(255, 255, 255));
        GroupLayout _contentPaneLayout = new GroupLayout(this._contentPane);
        this._contentPane.setLayout(_contentPaneLayout);
        _contentPaneLayout.setHorizontalGroup(_contentPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 356, Short.MAX_VALUE));
        _contentPaneLayout.setVerticalGroup(_contentPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 847, Short.MAX_VALUE));
        this._scrollPane.setViewportView(this._contentPane);
        this.add((Component)this._scrollPane, "Center");
        this._remember.setText(NbBundle.getMessage(TransformInputsForm.class, (String)"TransformInputsForm._remember.text"));
        this._remember.setHorizontalAlignment(4);
        this._remember.setMargin(new Insets(2, 2, 10, 10));
        this._remember.setPreferredSize(new Dimension(147, 25));
        this._remember.setVerticalAlignment(3);
        this._remember.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TransformInputsForm.this._rememberActionPerformed(evt);
            }
        });
        this.add((Component)this._remember, "South");
    }

    private void _rememberActionPerformed(ActionEvent evt) {
    }

    private class ContentPane
    extends JPanel
    implements Scrollable {
        private ContentPane() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 16;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return (orientation == 1 ? visibleRect.height : visibleRect.width) - 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }
    }
}

