/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.javadoc;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jpype.html.Html;
import org.jpype.html.Parser;
import org.jpype.javadoc.Javadoc;
import org.jpype.javadoc.JavadocRenderer;
import org.jpype.javadoc.JavadocTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JavadocExtractor {
    static final JavadocTransformer transformer = new JavadocTransformer();
    public static boolean transform = true;
    public static boolean render = true;
    public static boolean failures = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Javadoc getDocumentation(Class clazz) {
        try (InputStream inputStream = JavadocExtractor.getDocumentationAsStream(clazz);){
            if (inputStream == null) return null;
            Parser<Document> parser = Html.newParser();
            Javadoc javadoc = JavadocExtractor.extractDocument(clazz, parser.parse(inputStream));
            return javadoc;
        }
        catch (Exception exception) {
            System.err.println("Failed to extract javadoc for " + String.valueOf(clazz) + ", caught " + String.valueOf(exception));
            if (!failures) return null;
            throw new RuntimeException(exception);
        }
    }

    public static InputStream getDocumentationAsStream(Class clazz) {
        InputStream inputStream = null;
        String string = clazz.getName().replace('.', '/') + ".html";
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        inputStream = classLoader.getResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        String string2 = "docs/api/" + string;
        inputStream = classLoader.getResourceAsStream(string2);
        if (inputStream != null) {
            return inputStream;
        }
        try {
            Method method = Class.class.getMethod("getModule", new Class[0]);
            String string3 = method.invoke((Object)clazz, new Object[0]).toString().substring(7);
            String string4 = "docs/api/" + string3 + "/" + string;
            inputStream = classLoader.getResourceAsStream(string4);
            if (inputStream != null) {
                return inputStream;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static Javadoc extractDocument(Class clazz, Document document) {
        JavadocRenderer javadocRenderer = new JavadocRenderer();
        try {
            String string;
            String string2;
            List<Node> list;
            List<Node> list2;
            Node node;
            Node node2;
            Javadoc javadoc = new Javadoc();
            XPath xPath = XPathFactory.newInstance().newXPath();
            Node node3 = (Node)xPath.compile("//div[@class='description']/ul/li").evaluate(document, XPathConstants.NODE);
            if (node3 == null) {
                node3 = (Node)xPath.compile("//section[@class='description']").evaluate(document, XPathConstants.NODE);
            }
            if (node3 == null) {
                node3 = (Node)xPath.compile("//section[@class='class-description']").evaluate(document, XPathConstants.NODE);
            }
            if ((node2 = JavadocExtractor.toFragment(node3)) != null) {
                javadoc.descriptionNode = node2;
                if (transform) {
                    transformer.transformDescription(clazz, node2);
                }
                if (render) {
                    javadoc.description = javadocRenderer.render(node2);
                }
            }
            if ((node = (Node)xPath.compile("//li/a[@name='constructor.detail' or @id='constructor.detail']").evaluate(document, XPathConstants.NODE)) == null) {
                node = (Node)xPath.compile("//section[@class='constructor-details']/ul").evaluate(document, XPathConstants.NODE);
            }
            if (node != null) {
                list2 = JavadocExtractor.convertNodes((NodeList)xPath.compile("./li/section").evaluate(node, XPathConstants.NODESET));
                if (list2.isEmpty()) {
                    list2 = JavadocExtractor.convertNodes((NodeList)xPath.compile("./ul/li").evaluate(node.getParentNode(), XPathConstants.NODESET));
                }
                javadoc.ctorsNode = list2;
                list = new StringBuilder();
                for (Node object : list2) {
                    if (transform) {
                        transformer.transformMember(clazz, object);
                    }
                    if (!render) continue;
                    ((StringBuilder)((Object)list)).append(javadocRenderer.render(object));
                }
                javadoc.ctors = ((StringBuilder)((Object)list)).toString();
            }
            if ((list2 = (Node)xPath.compile("//li/a[@name='method.detail' or  @id='method.detail']").evaluate(document, XPathConstants.NODE)) == null) {
                list2 = (Node)xPath.compile("//section[@class='method-details']/ul").evaluate(document, XPathConstants.NODE);
            }
            if (list2 != null) {
                list = JavadocExtractor.convertNodes((NodeList)xPath.compile("./li/section").evaluate(list2, XPathConstants.NODESET));
                if (list.isEmpty()) {
                    list = JavadocExtractor.convertNodes((NodeList)xPath.compile("./ul/li").evaluate(list2.getParentNode(), XPathConstants.NODESET));
                }
                javadoc.methodNodes = list;
                for (Node node4 : list) {
                    void var12_16;
                    if (transform) {
                        transformer.transformMember(clazz, node4);
                    }
                    if (!render) continue;
                    String string3 = javadocRenderer.render(node4);
                    string2 = javadocRenderer.memberName;
                    if (javadoc.methods.containsKey(string2)) {
                        string = javadoc.methods.get(string2);
                        String string4 = string + string3;
                    }
                    javadoc.methods.put(string2, (String)var12_16);
                }
            }
            if ((list = (Node)xPath.compile("//li/a[@name='field.detail' or @id='field.detail']").evaluate(document, XPathConstants.NODE)) == null) {
                list = (Node)xPath.compile("//section[@class='field-details']/ul").evaluate(document, XPathConstants.NODE);
            }
            if (list != null) {
                List<Node> list3 = JavadocExtractor.convertNodes((NodeList)xPath.compile("./li/section").evaluate(list, XPathConstants.NODESET));
                if (list3.isEmpty()) {
                    list3 = JavadocExtractor.convertNodes((NodeList)xPath.compile("./ul/li").evaluate(list.getParentNode(), XPathConstants.NODESET));
                }
                javadoc.fieldNodes = list3;
                for (Node node5 : list3) {
                    if (transform) {
                        transformer.transformMember(clazz, node5);
                    }
                    if (!render) continue;
                    string2 = javadocRenderer.render(node5);
                    string = javadocRenderer.memberName;
                    javadoc.fields.put(string, string2);
                }
            }
            return javadoc;
        }
        catch (IOException | XPathExpressionException exception) {
            throw new RuntimeException(exception);
        }
    }

    private static List<Node> convertNodes(NodeList nodeList) throws IOException {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            arrayList.add(JavadocExtractor.toFragment(nodeList.item(i)));
        }
        return arrayList;
    }

    public static Node toFragment(Node node) {
        Document document = node.getOwnerDocument();
        DocumentFragment documentFragment = document.createDocumentFragment();
        while (node.hasChildNodes()) {
            documentFragment.appendChild(node.getFirstChild());
        }
        if (documentFragment.getFirstChild() != null && documentFragment.getFirstChild().getNodeType() == 3) {
            documentFragment.removeChild(documentFragment.getFirstChild());
        }
        if (documentFragment.getLastChild() != null && documentFragment.getLastChild().getNodeType() == 3) {
            documentFragment.removeChild(documentFragment.getLastChild());
        }
        return documentFragment;
    }
}

