/*
 * Decompiled with CFR 0.152.
 */
package org.jpype.javadoc;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jpype.html.Html;
import org.jpype.javadoc.DomUtilities;
import org.jpype.javadoc.JavadocException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class JavadocTransformer {
    static final Pattern ARGS_PATTERN = Pattern.compile(".*\\((.*)\\).*");
    public static final Map<String, String> DETAIL_SECTIONS;
    static final String[] PASS1;

    public Node transformDescription(Class clazz, Node node) {
        try {
            Workspace workspace = new Workspace(clazz);
            DomUtilities.traverseDFS(node, this::fixEntities, (short)3);
            DomUtilities.traverseChildren(node, this::handleDescription, (short)1, workspace);
            DomUtilities.traverseDFS(node, this::pass1, (short)1, workspace);
            return node;
        }
        catch (Exception exception) {
            throw new JavadocException(node, (Throwable)exception);
        }
    }

    public Node transformMember(Class clazz, Node node) {
        try {
            Workspace workspace = new Workspace(clazz);
            DomUtilities.traverseDFS(node, this::fixEntities, (short)3);
            DomUtilities.traverseChildren(node, this::handleMembers, (short)1, workspace);
            DomUtilities.traverseDFS(node, this::pass1, (short)1, workspace);
            return node;
        }
        catch (Exception exception) {
            throw new JavadocException(node, (Throwable)exception);
        }
    }

    void handleDescription(Node node, Workspace workspace) {
        Element element = (Element)node;
        String string = element.getTagName();
        Document document = element.getOwnerDocument();
        Node node2 = node.getParentNode();
        if (string.equals("dl") && !workspace.hr) {
            node2.removeChild(node);
        } else if (string.equals("br")) {
            node2.removeChild(node);
        } else if (string.equals("hr")) {
            workspace.hr = true;
            node2.removeChild(node);
        } else if (string.equals("pre") || string.equals("div") && element.getAttribute("class").equals("type-signature")) {
            DomUtilities.removeWhitespace(node);
            document.renameNode(node, null, "signature");
        } else if (string.equals("div")) {
            document.renameNode(node, null, "description");
            DomUtilities.clearAttributes(node);
        } else if (string.equals("dl")) {
            document.renameNode(node, null, "details");
            DomUtilities.traverseChildren(node, this::handleDetails, (short)1, workspace);
        } else {
            throw new RuntimeException("Unknown item at top level " + string);
        }
    }

    void handleMembers(Node node, Workspace workspace) {
        Element element = (Element)node;
        String string = element.getTagName();
        Document document = element.getOwnerDocument();
        if (string.equals("h4") || string.equals("h3")) {
            document.renameNode(node, null, "title");
        } else if (string.equals("pre") || string.equals("div") && element.getAttribute("class").equals("member-signature")) {
            document.renameNode(node, null, "signature");
            DomUtilities.traverseDFS(node, this::pass1, (short)1, workspace);
            DomUtilities.removeWhitespace(node);
            String string2 = node.getTextContent();
            Matcher matcher = ARGS_PATTERN.matcher(string2);
            if (matcher.matches()) {
                LinkedList<String> linkedList = new LinkedList<String>();
                for (String string3 : matcher.group(1).split(", ")) {
                    String[] stringArray = string3.split("\u00a0", 2);
                    linkedList.add(stringArray[0]);
                }
                workspace.types = linkedList;
            }
        } else if (string.equals("div")) {
            document.renameNode(node, null, "description");
            DomUtilities.clearAttributes(node);
        } else if (string.equals("dl")) {
            document.renameNode(node, null, "details");
            DomUtilities.traverseChildren(node, this::handleDetails, (short)1, workspace);
        } else {
            throw new RuntimeException("Unknown item at top level " + string);
        }
    }

    void handleDetails(Node node, Workspace workspace) {
        Object object;
        Element element = (Element)node;
        String string = element.getTagName();
        Document document = element.getOwnerDocument();
        Node node2 = element.getParentNode();
        if (string.equals("dt")) {
            object = node.getTextContent().trim();
            if (DETAIL_SECTIONS.containsKey(object)) {
                document.renameNode(node, null, DETAIL_SECTIONS.get(object));
            } else if (((String)object).startsWith("See ")) {
                document.renameNode(node, null, "jls");
            } else {
                System.err.println("Bad detail key '" + (String)object + "'");
            }
            workspace.key = node.getNodeName();
            workspace.section = node;
            DomUtilities.clearChildren(workspace.section);
        }
        if (string.equals("dd")) {
            if (workspace.key.equals("parameters")) {
                object = node.getFirstChild();
                Node node3 = object.getNextSibling();
                Element element2 = document.createElement("parameter");
                element2.setAttribute("name", object.getTextContent());
                element2.setAttribute("type", workspace.types.removeFirst());
                String string2 = node3.getNodeValue();
                node3.setNodeValue(string2.substring(3));
                node.removeChild((Node)object);
                DomUtilities.transferContents(element2, node);
                workspace.section.appendChild(element2);
                node2.removeChild(node);
            } else if (workspace.key.equals("throws")) {
                object = node.getFirstChild();
                Node node4 = object.getNextSibling();
                Element element3 = document.createElement("exception");
                DomUtilities.traverseDFS((Node)object, this::pass1, (short)1, workspace);
                element3.setAttribute("name", object.getTextContent());
                if (node4 != null) {
                    String string3 = node4.getNodeValue();
                    node4.setNodeValue(string3.substring(3));
                }
                node.removeChild((Node)object);
                DomUtilities.transferContents(element3, node);
                workspace.section.appendChild(element3);
                node2.removeChild(node);
            } else {
                DomUtilities.transferContents(workspace.section, node);
                DomUtilities.traverseDFS(workspace.section, this::pass1, (short)1, workspace);
                DomUtilities.removeWhitespace(workspace.section);
                node2.removeChild(node);
                return;
            }
        }
    }

    void fixEntities(Node node) {
        Text text = (Text)node;
        String string = Html.decode(text.getTextContent());
        text.setTextContent(string);
    }

    void pass1(Node node, Workspace workspace) {
        Element element = (Element)node;
        String string = element.getTagName();
        Document document = element.getOwnerDocument();
        Node node2 = element.getParentNode();
        if (node2 == null) {
            return;
        }
        if (string.equals("pre")) {
            if (DomUtilities.containsNL(element)) {
                document.renameNode(node, null, "codeblock");
                string = "codeblock";
            } else {
                document.renameNode(node, null, "code");
                string = "code";
            }
        }
        if (string.equals("code") && (node2.getNodeName().equals("pre") || node2.getNodeName().equals("blockquote"))) {
            document.renameNode(node2, null, "codeblock");
            DomUtilities.mergeNode(node2, node);
            return;
        }
        if (string.equals("codeblock") && node2.getNodeName().equals("pre")) {
            if (DomUtilities.containsNL(node)) {
                document.renameNode(node2, null, "codeblock");
            } else {
                document.renameNode(node2, null, "code");
            }
            DomUtilities.mergeNode(node2, node);
            return;
        }
        if (string.equals("code") && node2.getNodeName().equals("a")) {
            Element element2 = (Element)node2;
            String string2 = this.toReference(workspace, element2.getAttribute("href"));
            DomUtilities.clearChildren(node2);
            node2.appendChild(document.createTextNode(string2));
            return;
        }
        if (string.equals("a") && node2.getNodeName().equals("code")) {
            String string3 = this.toReference(workspace, element.getAttribute("href"));
            DomUtilities.clearChildren(node2);
            document.renameNode(node2, null, "nop");
            node2.appendChild(document.createTextNode(string3));
            return;
        }
        if (string.equals("a")) {
            String string4 = element.getAttribute("href");
            if (string4.startsWith("http:") || string4.startsWith("shttp:")) {
                String string5 = node.getTextContent();
                string5 = String.format("`%s <%s>`", string5, string4);
                node2.replaceChild(document.createTextNode(string5), node);
                return;
            }
            if ((string4 = this.toReference(workspace, string4)) == null) {
                node2.replaceChild(document.createTextNode(node.getTextContent()), node);
            } else {
                node2.replaceChild(document.createTextNode(string4), node);
            }
            return;
        }
        for (int i = 0; i < PASS1.length; i += 2) {
            if (!string.equals(PASS1[i])) continue;
            String string6 = element.getTextContent();
            if (string6 == null) {
                element.getParentNode().removeChild(element);
            } else {
                element.getParentNode().replaceChild(document.createTextNode(String.format(PASS1[i + 1], string6.trim())), element);
            }
            return;
        }
    }

    public String toReference(Workspace workspace, String string) {
        try {
            Path path = Paths.get(workspace.cls.getName().replace('.', '/'), new String[0]);
            if (string.startsWith("#")) {
                Path path2 = path.resolve(string.substring(1).trim()).normalize();
                if (path2.startsWith("..")) {
                    path2 = path2.subpath(2, path2.getNameCount());
                }
                String string2 = path2.toString().replace('/', '.').replace('\\', '.').replaceAll("\\(.*\\)", "").replaceAll("-.*", "");
                return String.format(":meth:`~%s`", string2);
            }
            if (string.contains("#")) {
                Path path3 = path.getParent().resolve(string.trim()).normalize();
                if (path3.startsWith("..")) {
                    path3 = path3.subpath(2, path3.getNameCount());
                }
                String string3 = path3.toString().replace('/', '.').replace('\\', '.').replaceAll("\\(.*\\)", "").replaceAll("-.*", "").replaceAll(".html#", ".");
                return String.format(":meth:`~%s`", string3);
            }
            Path path4 = path.getParent().resolve(string.trim()).normalize();
            if (path4.startsWith("..")) {
                path4 = path4.subpath(2, path4.getNameCount());
            }
            String string4 = path4.toString().replace('/', '.').replace('\\', '.').replaceAll("-.*", "").replaceAll(".html", "");
            return String.format(":class:`~%s`", string4);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        Map<String, String> map = DETAIL_SECTIONS = new HashMap<String, String>();
        map.put("Author:", "author");
        map.put("Since:", "since");
        map.put("Parameters:", "parameters");
        map.put("Returns:", "returns");
        map.put("Overrides:", "overrides");
        map.put("See Also:", "see");
        map.put("API Note:", "api_note");
        map.put("Version:", "version");
        map.put("Type Parameters:", "typeparams");
        map.put("Specified by:", "specified");
        map.put("Throws:", "throws");
        map.put("Implementation Requirements:", "requirements");
        map.put("Implementation Note:", "impl_note");
        PASS1 = new String[]{"cite", "\"%s\"", "code", ":code:`%s`", "pre", ":code:`%s`", "tt", "``%s``", "i", "*%s*", "em", "*%s*", "strong", "**%s**", "b", "**%s**", "sup", " :sup:`%s` ", "sub", " :sub:`%s` ", "small", ":sub:`%s`", "span", "%s", "nop", "%s", "font", "%s", "var", "*%s*"};
    }

    static class Workspace {
        private final Class cls;
        boolean hr = false;
        String key;
        Node section;
        private LinkedList<String> types;

        Workspace(Class clazz) {
            this.cls = clazz;
        }
    }
}

