/**
* @file src/llvmir2hll/semantics/semantics/win_api_semantics/get_name_of_param/d.cpp
* @brief Implementation of the initialization of WinAPI functions.
* @copyright (c) 2017 Avast Software, licensed under the MIT license
*/

#include "retdec/llvmir2hll/semantics/semantics/win_api_semantics/get_name_of_param/d.h"

namespace retdec {
namespace llvmir2hll {
namespace semantics {
namespace win_api {

/**
* @brief Initializes the given map with info about functions starting with D.
*/
void initFuncParamNamesMap_D(FuncParamNamesMap &funcParamNamesMap) {
	//
	// windows.h
	//
	ADD_PARAM_NAME("DPtoLP", 1, "hdc"); // HDC
	ADD_PARAM_NAME("DPtoLP", 2, "lppt"); // LPPOINT
	ADD_PARAM_NAME("DPtoLP", 3, "c"); // int
	ADD_PARAM_NAME("DeactivateActCtx", 1, "dwFlags"); // DWORD
	ADD_PARAM_NAME("DeactivateActCtx", 2, "ulCookie"); // ULONG_PTR
	ADD_PARAM_NAME("DebugActiveProcess", 1, "dwProcessId"); // DWORD
	ADD_PARAM_NAME("DebugActiveProcessStop", 1, "dwProcessId"); // DWORD
	ADD_PARAM_NAME("DebugBreakProcess", 1, "Process"); // HANDLE
	ADD_PARAM_NAME("DebugSetProcessKillOnExit", 1, "KillOnExit"); // WINBOOL
	ADD_PARAM_NAME("DecodePointer", 1, "Ptr"); // PVOID
	ADD_PARAM_NAME("DecodeSystemPointer", 1, "Ptr"); // PVOID
	ADD_PARAM_NAME("DecryptFileA", 1, "lpFileName"); // LPCSTR
	ADD_PARAM_NAME("DecryptFileA", 2, "dwReserved"); // DWORD
	ADD_PARAM_NAME("DecryptFileW", 1, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("DecryptFileW", 2, "dwReserved"); // DWORD
	ADD_PARAM_NAME("DefDlgProcA", 1, "hDlg"); // HWND
	ADD_PARAM_NAME("DefDlgProcA", 2, "Msg"); // UINT
	ADD_PARAM_NAME("DefDlgProcA", 3, "wParam"); // WPARAM
	ADD_PARAM_NAME("DefDlgProcA", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("DefDlgProcW", 1, "hDlg"); // HWND
	ADD_PARAM_NAME("DefDlgProcW", 2, "Msg"); // UINT
	ADD_PARAM_NAME("DefDlgProcW", 3, "wParam"); // WPARAM
	ADD_PARAM_NAME("DefDlgProcW", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("DefFrameProcA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("DefFrameProcA", 2, "hWndMDIClient"); // HWND
	ADD_PARAM_NAME("DefFrameProcA", 3, "uMsg"); // UINT
	ADD_PARAM_NAME("DefFrameProcA", 4, "wParam"); // WPARAM
	ADD_PARAM_NAME("DefFrameProcA", 5, "lParam"); // LPARAM
	ADD_PARAM_NAME("DefFrameProcW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("DefFrameProcW", 2, "hWndMDIClient"); // HWND
	ADD_PARAM_NAME("DefFrameProcW", 3, "uMsg"); // UINT
	ADD_PARAM_NAME("DefFrameProcW", 4, "wParam"); // WPARAM
	ADD_PARAM_NAME("DefFrameProcW", 5, "lParam"); // LPARAM
	ADD_PARAM_NAME("DefMDIChildProcA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("DefMDIChildProcA", 2, "uMsg"); // UINT
	ADD_PARAM_NAME("DefMDIChildProcA", 3, "wParam"); // WPARAM
	ADD_PARAM_NAME("DefMDIChildProcA", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("DefMDIChildProcW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("DefMDIChildProcW", 2, "uMsg"); // UINT
	ADD_PARAM_NAME("DefMDIChildProcW", 3, "wParam"); // WPARAM
	ADD_PARAM_NAME("DefMDIChildProcW", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("DefRawInputProc", 1, "paRawInput"); // PRAWINPUT *
	ADD_PARAM_NAME("DefRawInputProc", 2, "nInput"); // INT
	ADD_PARAM_NAME("DefRawInputProc", 3, "cbSizeHeader"); // UINT
	ADD_PARAM_NAME("DefWindowProcA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("DefWindowProcA", 2, "Msg"); // UINT
	ADD_PARAM_NAME("DefWindowProcA", 3, "wParam"); // WPARAM
	ADD_PARAM_NAME("DefWindowProcA", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("DefWindowProcW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("DefWindowProcW", 2, "Msg"); // UINT
	ADD_PARAM_NAME("DefWindowProcW", 3, "wParam"); // WPARAM
	ADD_PARAM_NAME("DefWindowProcW", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("DeferWindowPos", 1, "hWinPosInfo"); // HDWP
	ADD_PARAM_NAME("DeferWindowPos", 2, "hWnd"); // HWND
	ADD_PARAM_NAME("DeferWindowPos", 3, "hWndInsertAfter"); // HWND
	ADD_PARAM_NAME("DeferWindowPos", 4, "x"); // int
	ADD_PARAM_NAME("DeferWindowPos", 5, "y"); // int
	ADD_PARAM_NAME("DeferWindowPos", 6, "cx"); // int
	ADD_PARAM_NAME("DeferWindowPos", 7, "cy"); // int
	ADD_PARAM_NAME("DeferWindowPos", 8, "uFlags"); // UINT
	ADD_PARAM_NAME("DefineDosDeviceA", 1, "dwFlags"); // DWORD
	ADD_PARAM_NAME("DefineDosDeviceA", 2, "lpDeviceName"); // LPCSTR
	ADD_PARAM_NAME("DefineDosDeviceA", 3, "lpTargetPath"); // LPCSTR
	ADD_PARAM_NAME("DefineDosDeviceW", 1, "dwFlags"); // DWORD
	ADD_PARAM_NAME("DefineDosDeviceW", 2, "lpDeviceName"); // LPCWSTR
	ADD_PARAM_NAME("DefineDosDeviceW", 3, "lpTargetPath"); // LPCWSTR
	ADD_PARAM_NAME("DeleteAce", 1, "pAcl"); // PACL
	ADD_PARAM_NAME("DeleteAce", 2, "dwAceIndex"); // DWORD
	ADD_PARAM_NAME("DeleteAtom", 1, "nAtom"); // ATOM
	ADD_PARAM_NAME("DeleteBoundaryDescriptor", 1, "BoundaryDescriptor"); // HANDLE
	ADD_PARAM_NAME("DeleteColorSpace", 1, "hcs"); // HCOLORSPACE
	ADD_PARAM_NAME("DeleteCriticalSection", 1, "lpCriticalSection"); // LPCRITICAL_SECTION
	ADD_PARAM_NAME("DeleteDC", 1, "hdc"); // HDC
	ADD_PARAM_NAME("DeleteEnhMetaFile", 1, "hmf"); // HENHMETAFILE
	ADD_PARAM_NAME("DeleteFiber", 1, "lpFiber"); // LPVOID
	ADD_PARAM_NAME("DeleteFileA", 1, "lpFileName"); // LPCSTR
	ADD_PARAM_NAME("DeleteFileTransactedA", 1, "lpFileName"); // LPCSTR
	ADD_PARAM_NAME("DeleteFileTransactedA", 2, "hTransaction"); // HANDLE
	ADD_PARAM_NAME("DeleteFileTransactedW", 1, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("DeleteFileTransactedW", 2, "hTransaction"); // HANDLE
	ADD_PARAM_NAME("DeleteFileW", 1, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("DeleteFormA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("DeleteFormA", 2, "pFormName"); // LPSTR
	ADD_PARAM_NAME("DeleteFormW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("DeleteFormW", 2, "pFormName"); // LPWSTR
	ADD_PARAM_NAME("DeleteIE3Cache", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("DeleteIE3Cache", 2, "hInst"); // HINSTANCE
	ADD_PARAM_NAME("DeleteIE3Cache", 3, "lpszCmdLine"); // LPSTR
	ADD_PARAM_NAME("DeleteIE3Cache", 4, "nCmdShow"); // int
	ADD_PARAM_NAME("DeleteMenu", 1, "hMenu"); // HMENU
	ADD_PARAM_NAME("DeleteMenu", 2, "uPosition"); // UINT
	ADD_PARAM_NAME("DeleteMenu", 3, "uFlags"); // UINT
	ADD_PARAM_NAME("DeleteMetaFile", 1, "hmf"); // HMETAFILE
	ADD_PARAM_NAME("DeleteMonitorA", 1, "pName"); // LPSTR
	ADD_PARAM_NAME("DeleteMonitorA", 2, "pEnvironment"); // LPSTR
	ADD_PARAM_NAME("DeleteMonitorA", 3, "pMonitorName"); // LPSTR
	ADD_PARAM_NAME("DeleteMonitorW", 1, "pName"); // LPWSTR
	ADD_PARAM_NAME("DeleteMonitorW", 2, "pEnvironment"); // LPWSTR
	ADD_PARAM_NAME("DeleteMonitorW", 3, "pMonitorName"); // LPWSTR
	ADD_PARAM_NAME("DeleteObject", 1, "ho"); // HGDIOBJ
	ADD_PARAM_NAME("DeletePortA", 1, "pName"); // LPSTR
	ADD_PARAM_NAME("DeletePortA", 2, "hWnd"); // HWND
	ADD_PARAM_NAME("DeletePortA", 3, "pPortName"); // LPSTR
	ADD_PARAM_NAME("DeletePortW", 1, "pName"); // LPWSTR
	ADD_PARAM_NAME("DeletePortW", 2, "hWnd"); // HWND
	ADD_PARAM_NAME("DeletePortW", 3, "pPortName"); // LPWSTR
	ADD_PARAM_NAME("DeletePrintProcessorA", 1, "pName"); // LPSTR
	ADD_PARAM_NAME("DeletePrintProcessorA", 2, "pEnvironment"); // LPSTR
	ADD_PARAM_NAME("DeletePrintProcessorA", 3, "pPrintProcessorName"); // LPSTR
	ADD_PARAM_NAME("DeletePrintProcessorW", 1, "pName"); // LPWSTR
	ADD_PARAM_NAME("DeletePrintProcessorW", 2, "pEnvironment"); // LPWSTR
	ADD_PARAM_NAME("DeletePrintProcessorW", 3, "pPrintProcessorName"); // LPWSTR
	ADD_PARAM_NAME("DeletePrintProvidorA", 1, "pName"); // LPSTR
	ADD_PARAM_NAME("DeletePrintProvidorA", 2, "pEnvironment"); // LPSTR
	ADD_PARAM_NAME("DeletePrintProvidorA", 3, "pPrintProvidorName"); // LPSTR
	ADD_PARAM_NAME("DeletePrintProvidorW", 1, "pName"); // LPWSTR
	ADD_PARAM_NAME("DeletePrintProvidorW", 2, "pEnvironment"); // LPWSTR
	ADD_PARAM_NAME("DeletePrintProvidorW", 3, "pPrintProvidorName"); // LPWSTR
	ADD_PARAM_NAME("DeletePrinter", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("DeletePrinterConnectionA", 1, "pName"); // LPSTR
	ADD_PARAM_NAME("DeletePrinterConnectionW", 1, "pName"); // LPWSTR
	ADD_PARAM_NAME("DeletePrinterDataA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("DeletePrinterDataA", 2, "pValueName"); // LPSTR
	ADD_PARAM_NAME("DeletePrinterDataExA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("DeletePrinterDataExA", 2, "pKeyName"); // LPCSTR
	ADD_PARAM_NAME("DeletePrinterDataExA", 3, "pValueName"); // LPCSTR
	ADD_PARAM_NAME("DeletePrinterDataExW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("DeletePrinterDataExW", 2, "pKeyName"); // LPCWSTR
	ADD_PARAM_NAME("DeletePrinterDataExW", 3, "pValueName"); // LPCWSTR
	ADD_PARAM_NAME("DeletePrinterDataW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("DeletePrinterDataW", 2, "pValueName"); // LPWSTR
	ADD_PARAM_NAME("DeletePrinterDriverA", 1, "pName"); // LPSTR
	ADD_PARAM_NAME("DeletePrinterDriverA", 2, "pEnvironment"); // LPSTR
	ADD_PARAM_NAME("DeletePrinterDriverA", 3, "pDriverName"); // LPSTR
	ADD_PARAM_NAME("DeletePrinterDriverExA", 1, "pName"); // LPSTR
	ADD_PARAM_NAME("DeletePrinterDriverExA", 2, "pEnvironment"); // LPSTR
	ADD_PARAM_NAME("DeletePrinterDriverExA", 3, "pDriverName"); // LPSTR
	ADD_PARAM_NAME("DeletePrinterDriverExA", 4, "dwDeleteFlag"); // DWORD
	ADD_PARAM_NAME("DeletePrinterDriverExA", 5, "dwVersionFlag"); // DWORD
	ADD_PARAM_NAME("DeletePrinterDriverExW", 1, "pName"); // LPWSTR
	ADD_PARAM_NAME("DeletePrinterDriverExW", 2, "pEnvironment"); // LPWSTR
	ADD_PARAM_NAME("DeletePrinterDriverExW", 3, "pDriverName"); // LPWSTR
	ADD_PARAM_NAME("DeletePrinterDriverExW", 4, "dwDeleteFlag"); // DWORD
	ADD_PARAM_NAME("DeletePrinterDriverExW", 5, "dwVersionFlag"); // DWORD
	ADD_PARAM_NAME("DeletePrinterDriverPackageA", 1, "pszServer"); // LPCSTR
	ADD_PARAM_NAME("DeletePrinterDriverPackageA", 2, "pszInfPath"); // LPCSTR
	ADD_PARAM_NAME("DeletePrinterDriverPackageA", 3, "pszEnvironment"); // LPCSTR
	ADD_PARAM_NAME("DeletePrinterDriverPackageW", 1, "pszServer"); // LPCWSTR
	ADD_PARAM_NAME("DeletePrinterDriverPackageW", 2, "pszInfPath"); // LPCWSTR
	ADD_PARAM_NAME("DeletePrinterDriverPackageW", 3, "pszEnvironment"); // LPCWSTR
	ADD_PARAM_NAME("DeletePrinterDriverW", 1, "pName"); // LPWSTR
	ADD_PARAM_NAME("DeletePrinterDriverW", 2, "pEnvironment"); // LPWSTR
	ADD_PARAM_NAME("DeletePrinterDriverW", 3, "pDriverName"); // LPWSTR
	ADD_PARAM_NAME("DeletePrinterIC", 1, "hPrinterIC"); // HANDLE
	ADD_PARAM_NAME("DeletePrinterKeyA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("DeletePrinterKeyA", 2, "pKeyName"); // LPCSTR
	ADD_PARAM_NAME("DeletePrinterKeyW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("DeletePrinterKeyW", 2, "pKeyName"); // LPCWSTR
	ADD_PARAM_NAME("DeleteService", 1, "hService"); // SC_HANDLE
	ADD_PARAM_NAME("DeleteTimerQueue", 1, "TimerQueue"); // HANDLE
	ADD_PARAM_NAME("DeleteTimerQueueEx", 1, "TimerQueue"); // HANDLE
	ADD_PARAM_NAME("DeleteTimerQueueEx", 2, "CompletionEvent"); // HANDLE
	ADD_PARAM_NAME("DeleteTimerQueueTimer", 1, "TimerQueue"); // HANDLE
	ADD_PARAM_NAME("DeleteTimerQueueTimer", 2, "Timer"); // HANDLE
	ADD_PARAM_NAME("DeleteTimerQueueTimer", 3, "CompletionEvent"); // HANDLE
	ADD_PARAM_NAME("DeleteVolumeMountPointA", 1, "lpszVolumeMountPoint"); // LPCSTR
	ADD_PARAM_NAME("DeleteVolumeMountPointW", 1, "lpszVolumeMountPoint"); // LPCWSTR
	ADD_PARAM_NAME("DeregisterEventSource", 1, "hEventLog"); // HANDLE
	ADD_PARAM_NAME("DeregisterShellHookWindow", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("DescribePixelFormat", 1, "hdc"); // HDC
	ADD_PARAM_NAME("DescribePixelFormat", 2, "iPixelFormat"); // int
	ADD_PARAM_NAME("DescribePixelFormat", 3, "nBytes"); // UINT
	ADD_PARAM_NAME("DescribePixelFormat", 4, "ppfd"); // LPPIXELFORMATDESCRIPTOR
	ADD_PARAM_NAME("DestroyAcceleratorTable", 1, "hAccel"); // HACCEL
	ADD_PARAM_NAME("DestroyCursor", 1, "hCursor"); // HCURSOR
	ADD_PARAM_NAME("DestroyIcon", 1, "hIcon"); // HICON
	ADD_PARAM_NAME("DestroyMenu", 1, "hMenu"); // HMENU
	ADD_PARAM_NAME("DestroyPrivateObjectSecurity", 1, "ObjectDescriptor"); // PSECURITY_DESCRIPTOR *
	ADD_PARAM_NAME("DestroyThreadpoolEnvironment", 1, "pcbe"); // PTP_CALLBACK_ENVIRON
	ADD_PARAM_NAME("DestroyWindow", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("DevQueryPrint", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("DevQueryPrint", 2, "pDevMode"); // LPDEVMODEW
	ADD_PARAM_NAME("DevQueryPrint", 3, "pResID"); // DWORD *
	ADD_PARAM_NAME("DeviceCapabilitiesA", 1, "pDevice"); // LPCSTR
	ADD_PARAM_NAME("DeviceCapabilitiesA", 2, "pPort"); // LPCSTR
	ADD_PARAM_NAME("DeviceCapabilitiesA", 3, "fwCapability"); // WORD
	ADD_PARAM_NAME("DeviceCapabilitiesA", 4, "pOutput"); // LPSTR
	ADD_PARAM_NAME("DeviceCapabilitiesA", 5, "pDevMode"); // CONST DEVMODEA *
	ADD_PARAM_NAME("DeviceCapabilitiesW", 1, "pDevice"); // LPCWSTR
	ADD_PARAM_NAME("DeviceCapabilitiesW", 2, "pPort"); // LPCWSTR
	ADD_PARAM_NAME("DeviceCapabilitiesW", 3, "fwCapability"); // WORD
	ADD_PARAM_NAME("DeviceCapabilitiesW", 4, "pOutput"); // LPWSTR
	ADD_PARAM_NAME("DeviceCapabilitiesW", 5, "pDevMode"); // CONST DEVMODEW *
	ADD_PARAM_NAME("DeviceIoControl", 1, "hDevice"); // HANDLE
	ADD_PARAM_NAME("DeviceIoControl", 2, "dwIoControlCode"); // DWORD
	ADD_PARAM_NAME("DeviceIoControl", 3, "lpInBuffer"); // LPVOID
	ADD_PARAM_NAME("DeviceIoControl", 4, "nInBufferSize"); // DWORD
	ADD_PARAM_NAME("DeviceIoControl", 5, "lpOutBuffer"); // LPVOID
	ADD_PARAM_NAME("DeviceIoControl", 6, "nOutBufferSize"); // DWORD
	ADD_PARAM_NAME("DeviceIoControl", 7, "lpBytesReturned"); // LPDWORD
	ADD_PARAM_NAME("DeviceIoControl", 8, "lpOverlapped"); // LPOVERLAPPED
	ADD_PARAM_NAME("DialogBoxIndirectParamA", 1, "hInstance"); // HINSTANCE
	ADD_PARAM_NAME("DialogBoxIndirectParamA", 2, "hDialogTemplate"); // LPCDLGTEMPLATEA
	ADD_PARAM_NAME("DialogBoxIndirectParamA", 3, "hWndParent"); // HWND
	ADD_PARAM_NAME("DialogBoxIndirectParamA", 4, "lpDialogFunc"); // DLGPROC
	ADD_PARAM_NAME("DialogBoxIndirectParamA", 5, "dwInitParam"); // LPARAM
	ADD_PARAM_NAME("DialogBoxIndirectParamW", 1, "hInstance"); // HINSTANCE
	ADD_PARAM_NAME("DialogBoxIndirectParamW", 2, "hDialogTemplate"); // LPCDLGTEMPLATEW
	ADD_PARAM_NAME("DialogBoxIndirectParamW", 3, "hWndParent"); // HWND
	ADD_PARAM_NAME("DialogBoxIndirectParamW", 4, "lpDialogFunc"); // DLGPROC
	ADD_PARAM_NAME("DialogBoxIndirectParamW", 5, "dwInitParam"); // LPARAM
	ADD_PARAM_NAME("DialogBoxParamA", 1, "hInstance"); // HINSTANCE
	ADD_PARAM_NAME("DialogBoxParamA", 2, "lpTemplateName"); // LPCSTR
	ADD_PARAM_NAME("DialogBoxParamA", 3, "hWndParent"); // HWND
	ADD_PARAM_NAME("DialogBoxParamA", 4, "lpDialogFunc"); // DLGPROC
	ADD_PARAM_NAME("DialogBoxParamA", 5, "dwInitParam"); // LPARAM
	ADD_PARAM_NAME("DialogBoxParamW", 1, "hInstance"); // HINSTANCE
	ADD_PARAM_NAME("DialogBoxParamW", 2, "lpTemplateName"); // LPCWSTR
	ADD_PARAM_NAME("DialogBoxParamW", 3, "hWndParent"); // HWND
	ADD_PARAM_NAME("DialogBoxParamW", 4, "lpDialogFunc"); // DLGPROC
	ADD_PARAM_NAME("DialogBoxParamW", 5, "dwInitParam"); // LPARAM
	ADD_PARAM_NAME("DisableThreadLibraryCalls", 1, "hLibModule"); // HMODULE
	ADD_PARAM_NAME("DisassociateCurrentThreadFromCallback", 1, "pci"); // PTP_CALLBACK_INSTANCE
	ADD_PARAM_NAME("DisconnectNamedPipe", 1, "hNamedPipe"); // HANDLE
	ADD_PARAM_NAME("DispatchMessageA", 1, "lpMsg"); // CONST MSG *
	ADD_PARAM_NAME("DispatchMessageW", 1, "lpMsg"); // CONST MSG *
	ADD_PARAM_NAME("DlgDirListA", 1, "hDlg"); // HWND
	ADD_PARAM_NAME("DlgDirListA", 2, "lpPathSpec"); // LPSTR
	ADD_PARAM_NAME("DlgDirListA", 3, "nIDListBox"); // int
	ADD_PARAM_NAME("DlgDirListA", 4, "nIDStaticPath"); // int
	ADD_PARAM_NAME("DlgDirListA", 5, "uFileType"); // UINT
	ADD_PARAM_NAME("DlgDirListComboBoxA", 1, "hDlg"); // HWND
	ADD_PARAM_NAME("DlgDirListComboBoxA", 2, "lpPathSpec"); // LPSTR
	ADD_PARAM_NAME("DlgDirListComboBoxA", 3, "nIDComboBox"); // int
	ADD_PARAM_NAME("DlgDirListComboBoxA", 4, "nIDStaticPath"); // int
	ADD_PARAM_NAME("DlgDirListComboBoxA", 5, "uFiletype"); // UINT
	ADD_PARAM_NAME("DlgDirListComboBoxW", 1, "hDlg"); // HWND
	ADD_PARAM_NAME("DlgDirListComboBoxW", 2, "lpPathSpec"); // LPWSTR
	ADD_PARAM_NAME("DlgDirListComboBoxW", 3, "nIDComboBox"); // int
	ADD_PARAM_NAME("DlgDirListComboBoxW", 4, "nIDStaticPath"); // int
	ADD_PARAM_NAME("DlgDirListComboBoxW", 5, "uFiletype"); // UINT
	ADD_PARAM_NAME("DlgDirListW", 1, "hDlg"); // HWND
	ADD_PARAM_NAME("DlgDirListW", 2, "lpPathSpec"); // LPWSTR
	ADD_PARAM_NAME("DlgDirListW", 3, "nIDListBox"); // int
	ADD_PARAM_NAME("DlgDirListW", 4, "nIDStaticPath"); // int
	ADD_PARAM_NAME("DlgDirListW", 5, "uFileType"); // UINT
	ADD_PARAM_NAME("DlgDirSelectComboBoxExA", 1, "hwndDlg"); // HWND
	ADD_PARAM_NAME("DlgDirSelectComboBoxExA", 2, "lpString"); // LPSTR
	ADD_PARAM_NAME("DlgDirSelectComboBoxExA", 3, "cchOut"); // int
	ADD_PARAM_NAME("DlgDirSelectComboBoxExA", 4, "idComboBox"); // int
	ADD_PARAM_NAME("DlgDirSelectComboBoxExW", 1, "hwndDlg"); // HWND
	ADD_PARAM_NAME("DlgDirSelectComboBoxExW", 2, "lpString"); // LPWSTR
	ADD_PARAM_NAME("DlgDirSelectComboBoxExW", 3, "cchOut"); // int
	ADD_PARAM_NAME("DlgDirSelectComboBoxExW", 4, "idComboBox"); // int
	ADD_PARAM_NAME("DlgDirSelectExA", 1, "hwndDlg"); // HWND
	ADD_PARAM_NAME("DlgDirSelectExA", 2, "lpString"); // LPSTR
	ADD_PARAM_NAME("DlgDirSelectExA", 3, "chCount"); // int
	ADD_PARAM_NAME("DlgDirSelectExA", 4, "idListBox"); // int
	ADD_PARAM_NAME("DlgDirSelectExW", 1, "hwndDlg"); // HWND
	ADD_PARAM_NAME("DlgDirSelectExW", 2, "lpString"); // LPWSTR
	ADD_PARAM_NAME("DlgDirSelectExW", 3, "chCount"); // int
	ADD_PARAM_NAME("DlgDirSelectExW", 4, "idListBox"); // int
	ADD_PARAM_NAME("DnsAcquireContextHandle_A", 1, "CredentialFlags"); // DWORD
	ADD_PARAM_NAME("DnsAcquireContextHandle_A", 2, "pCredentials"); // PVOID
	ADD_PARAM_NAME("DnsAcquireContextHandle_A", 3, "pContextHandle"); // PHANDLE
	ADD_PARAM_NAME("DnsAcquireContextHandle_W", 1, "CredentialFlags"); // DWORD
	ADD_PARAM_NAME("DnsAcquireContextHandle_W", 2, "pCredentials"); // PVOID
	ADD_PARAM_NAME("DnsAcquireContextHandle_W", 3, "pContextHandle"); // PHANDLE
	ADD_PARAM_NAME("DnsExtractRecordsFromMessage_UTF8", 1, "pDnsBuffer"); // PDNS_MESSAGE_BUFFER
	ADD_PARAM_NAME("DnsExtractRecordsFromMessage_UTF8", 2, "wMessageLength"); // WORD
	ADD_PARAM_NAME("DnsExtractRecordsFromMessage_UTF8", 3, "ppRecord"); // PDNS_RECORD *
	ADD_PARAM_NAME("DnsExtractRecordsFromMessage_W", 1, "pDnsBuffer"); // PDNS_MESSAGE_BUFFER
	ADD_PARAM_NAME("DnsExtractRecordsFromMessage_W", 2, "wMessageLength"); // WORD
	ADD_PARAM_NAME("DnsExtractRecordsFromMessage_W", 3, "ppRecord"); // PDNS_RECORD *
	ADD_PARAM_NAME("DnsFree", 1, "pData"); // PVOID
	ADD_PARAM_NAME("DnsFree", 2, "FreeType"); // DNS_FREE_TYPE
	ADD_PARAM_NAME("DnsHostnameToComputerNameA", 1, "Hostname"); // LPCSTR
	ADD_PARAM_NAME("DnsHostnameToComputerNameA", 2, "ComputerName"); // LPSTR
	ADD_PARAM_NAME("DnsHostnameToComputerNameA", 3, "nSize"); // LPDWORD
	ADD_PARAM_NAME("DnsHostnameToComputerNameW", 1, "Hostname"); // LPCWSTR
	ADD_PARAM_NAME("DnsHostnameToComputerNameW", 2, "ComputerName"); // LPWSTR
	ADD_PARAM_NAME("DnsHostnameToComputerNameW", 3, "nSize"); // LPDWORD
	ADD_PARAM_NAME("DnsModifyRecordsInSet_A", 1, "pAddRecords"); // PDNS_RECORD
	ADD_PARAM_NAME("DnsModifyRecordsInSet_A", 2, "pDeleteRecords"); // PDNS_RECORD
	ADD_PARAM_NAME("DnsModifyRecordsInSet_A", 3, "Options"); // DWORD
	ADD_PARAM_NAME("DnsModifyRecordsInSet_A", 4, "hContext"); // HANDLE
	ADD_PARAM_NAME("DnsModifyRecordsInSet_A", 5, "pServerList"); // PIP4_ARRAY
	ADD_PARAM_NAME("DnsModifyRecordsInSet_A", 6, "pReserved"); // PVOID
	ADD_PARAM_NAME("DnsModifyRecordsInSet_UTF8", 1, "pAddRecords"); // PDNS_RECORD
	ADD_PARAM_NAME("DnsModifyRecordsInSet_UTF8", 2, "pDeleteRecords"); // PDNS_RECORD
	ADD_PARAM_NAME("DnsModifyRecordsInSet_UTF8", 3, "Options"); // DWORD
	ADD_PARAM_NAME("DnsModifyRecordsInSet_UTF8", 4, "hContext"); // HANDLE
	ADD_PARAM_NAME("DnsModifyRecordsInSet_UTF8", 5, "pServerList"); // PIP4_ARRAY
	ADD_PARAM_NAME("DnsModifyRecordsInSet_UTF8", 6, "pReserved"); // PVOID
	ADD_PARAM_NAME("DnsModifyRecordsInSet_W", 1, "pAddRecords"); // PDNS_RECORD
	ADD_PARAM_NAME("DnsModifyRecordsInSet_W", 2, "pDeleteRecords"); // PDNS_RECORD
	ADD_PARAM_NAME("DnsModifyRecordsInSet_W", 3, "Options"); // DWORD
	ADD_PARAM_NAME("DnsModifyRecordsInSet_W", 4, "hContext"); // HANDLE
	ADD_PARAM_NAME("DnsModifyRecordsInSet_W", 5, "pServerList"); // PIP4_ARRAY
	ADD_PARAM_NAME("DnsModifyRecordsInSet_W", 6, "pReserved"); // PVOID
	ADD_PARAM_NAME("DnsNameCompare_A", 1, "pName1"); // LPSTR
	ADD_PARAM_NAME("DnsNameCompare_A", 2, "pName2"); // LPSTR
	ADD_PARAM_NAME("DnsNameCompare_W", 1, "pName1"); // LPWSTR
	ADD_PARAM_NAME("DnsNameCompare_W", 2, "pName2"); // LPWSTR
	ADD_PARAM_NAME("DnsQueryConfig", 1, "Config"); // DNS_CONFIG_TYPE
	ADD_PARAM_NAME("DnsQueryConfig", 2, "Flag"); // DWORD
	ADD_PARAM_NAME("DnsQueryConfig", 3, "pwsAdapterName"); // PWSTR
	ADD_PARAM_NAME("DnsQueryConfig", 4, "pReserved"); // PVOID
	ADD_PARAM_NAME("DnsQueryConfig", 5, "pBuffer"); // PVOID
	ADD_PARAM_NAME("DnsQueryConfig", 6, "pBufferLength"); // PDWORD
	ADD_PARAM_NAME("DnsQuery_A", 1, "pszName"); // PCSTR
	ADD_PARAM_NAME("DnsQuery_A", 2, "wType"); // WORD
	ADD_PARAM_NAME("DnsQuery_A", 3, "Options"); // DWORD
	ADD_PARAM_NAME("DnsQuery_A", 4, "aipServers"); // PIP4_ARRAY
	ADD_PARAM_NAME("DnsQuery_A", 5, "ppQueryResults"); // PDNS_RECORD *
	ADD_PARAM_NAME("DnsQuery_A", 6, "pReserved"); // PVOID *
	ADD_PARAM_NAME("DnsQuery_UTF8", 1, "pszName"); // PCSTR
	ADD_PARAM_NAME("DnsQuery_UTF8", 2, "wType"); // WORD
	ADD_PARAM_NAME("DnsQuery_UTF8", 3, "Options"); // DWORD
	ADD_PARAM_NAME("DnsQuery_UTF8", 4, "aipServers"); // PIP4_ARRAY
	ADD_PARAM_NAME("DnsQuery_UTF8", 5, "ppQueryResults"); // PDNS_RECORD *
	ADD_PARAM_NAME("DnsQuery_UTF8", 6, "pReserved"); // PVOID *
	ADD_PARAM_NAME("DnsQuery_W", 1, "pszName"); // PCWSTR
	ADD_PARAM_NAME("DnsQuery_W", 2, "wType"); // WORD
	ADD_PARAM_NAME("DnsQuery_W", 3, "Options"); // DWORD
	ADD_PARAM_NAME("DnsQuery_W", 4, "aipServers"); // PIP4_ARRAY
	ADD_PARAM_NAME("DnsQuery_W", 5, "ppQueryResults"); // PDNS_RECORD *
	ADD_PARAM_NAME("DnsQuery_W", 6, "pReserved"); // PVOID *
	ADD_PARAM_NAME("DnsRecordCompare", 1, "pRecord1"); // PDNS_RECORD
	ADD_PARAM_NAME("DnsRecordCompare", 2, "pRecord2"); // PDNS_RECORD
	ADD_PARAM_NAME("DnsRecordCopyEx", 1, "pRecord"); // PDNS_RECORD
	ADD_PARAM_NAME("DnsRecordCopyEx", 2, "CharSetIn"); // DNS_CHARSET
	ADD_PARAM_NAME("DnsRecordCopyEx", 3, "CharSetOut"); // DNS_CHARSET
	ADD_PARAM_NAME("DnsRecordListFree", 1, "pRecordList"); // PDNS_RECORD
	ADD_PARAM_NAME("DnsRecordListFree", 2, "FreeType"); // DNS_FREE_TYPE
	ADD_PARAM_NAME("DnsRecordSetCompare", 1, "pRR1"); // PDNS_RECORD
	ADD_PARAM_NAME("DnsRecordSetCompare", 2, "pRR2"); // PDNS_RECORD
	ADD_PARAM_NAME("DnsRecordSetCompare", 3, "ppDiff1"); // PDNS_RECORD *
	ADD_PARAM_NAME("DnsRecordSetCompare", 4, "ppDiff2"); // PDNS_RECORD *
	ADD_PARAM_NAME("DnsRecordSetCopyEx", 1, "pRecordSet"); // PDNS_RECORD
	ADD_PARAM_NAME("DnsRecordSetCopyEx", 2, "CharSetIn"); // DNS_CHARSET
	ADD_PARAM_NAME("DnsRecordSetCopyEx", 3, "CharSetOut"); // DNS_CHARSET
	ADD_PARAM_NAME("DnsReleaseContextHandle", 1, "hContext"); // HANDLE
	ADD_PARAM_NAME("DnsReplaceRecordSetA", 1, "pNewSet"); // PDNS_RECORD
	ADD_PARAM_NAME("DnsReplaceRecordSetA", 2, "Options"); // DWORD
	ADD_PARAM_NAME("DnsReplaceRecordSetA", 3, "hContext"); // HANDLE
	ADD_PARAM_NAME("DnsReplaceRecordSetA", 4, "pServerList"); // PIP4_ARRAY
	ADD_PARAM_NAME("DnsReplaceRecordSetA", 5, "pReserved"); // PVOID
	ADD_PARAM_NAME("DnsReplaceRecordSetUTF8", 1, "pNewSet"); // PDNS_RECORD
	ADD_PARAM_NAME("DnsReplaceRecordSetUTF8", 2, "Options"); // DWORD
	ADD_PARAM_NAME("DnsReplaceRecordSetUTF8", 3, "hContext"); // HANDLE
	ADD_PARAM_NAME("DnsReplaceRecordSetUTF8", 4, "pServerList"); // PIP4_ARRAY
	ADD_PARAM_NAME("DnsReplaceRecordSetUTF8", 5, "pReserved"); // PVOID
	ADD_PARAM_NAME("DnsReplaceRecordSetW", 1, "pNewSet"); // PDNS_RECORD
	ADD_PARAM_NAME("DnsReplaceRecordSetW", 2, "Options"); // DWORD
	ADD_PARAM_NAME("DnsReplaceRecordSetW", 3, "hContext"); // HANDLE
	ADD_PARAM_NAME("DnsReplaceRecordSetW", 4, "pServerList"); // PIP4_ARRAY
	ADD_PARAM_NAME("DnsReplaceRecordSetW", 5, "pReserved"); // PVOID
	ADD_PARAM_NAME("DnsWriteQuestionToBuffer_UTF8", 1, "pDnsBuffer"); // PDNS_MESSAGE_BUFFER
	ADD_PARAM_NAME("DnsWriteQuestionToBuffer_UTF8", 2, "pdwBufferSize"); // LPDWORD
	ADD_PARAM_NAME("DnsWriteQuestionToBuffer_UTF8", 3, "pszName"); // LPSTR
	ADD_PARAM_NAME("DnsWriteQuestionToBuffer_UTF8", 4, "wType"); // WORD
	ADD_PARAM_NAME("DnsWriteQuestionToBuffer_UTF8", 5, "Xid"); // WORD
	ADD_PARAM_NAME("DnsWriteQuestionToBuffer_UTF8", 6, "fRecursionDesired"); // WINBOOL
	ADD_PARAM_NAME("DnsWriteQuestionToBuffer_W", 1, "pDnsBuffer"); // PDNS_MESSAGE_BUFFER
	ADD_PARAM_NAME("DnsWriteQuestionToBuffer_W", 2, "pdwBufferSize"); // PDWORD
	ADD_PARAM_NAME("DnsWriteQuestionToBuffer_W", 3, "pszName"); // LPWSTR
	ADD_PARAM_NAME("DnsWriteQuestionToBuffer_W", 4, "wType"); // WORD
	ADD_PARAM_NAME("DnsWriteQuestionToBuffer_W", 5, "Xid"); // WORD
	ADD_PARAM_NAME("DnsWriteQuestionToBuffer_W", 6, "fRecursionDesired"); // WINBOOL
	ADD_PARAM_NAME("DocumentPropertiesA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("DocumentPropertiesA", 2, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("DocumentPropertiesA", 3, "pDeviceName"); // LPSTR
	ADD_PARAM_NAME("DocumentPropertiesA", 4, "pDevModeOutput"); // PDEVMODEA
	ADD_PARAM_NAME("DocumentPropertiesA", 5, "pDevModeInput"); // PDEVMODEA
	ADD_PARAM_NAME("DocumentPropertiesA", 6, "fMode"); // DWORD
	ADD_PARAM_NAME("DocumentPropertiesW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("DocumentPropertiesW", 2, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("DocumentPropertiesW", 3, "pDeviceName"); // LPWSTR
	ADD_PARAM_NAME("DocumentPropertiesW", 4, "pDevModeOutput"); // PDEVMODEW
	ADD_PARAM_NAME("DocumentPropertiesW", 5, "pDevModeInput"); // PDEVMODEW
	ADD_PARAM_NAME("DocumentPropertiesW", 6, "fMode"); // DWORD
	ADD_PARAM_NAME("DosDateTimeToFileTime", 1, "wFatDate"); // WORD
	ADD_PARAM_NAME("DosDateTimeToFileTime", 2, "wFatTime"); // WORD
	ADD_PARAM_NAME("DosDateTimeToFileTime", 3, "lpFileTime"); // LPFILETIME
	ADD_PARAM_NAME("DragDetect", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("DragDetect", 2, "pt"); // POINT
	ADD_PARAM_NAME("DragObject", 1, "hwndParent"); // HWND
	ADD_PARAM_NAME("DragObject", 2, "hwndFrom"); // HWND
	ADD_PARAM_NAME("DragObject", 3, "fmt"); // UINT
	ADD_PARAM_NAME("DragObject", 4, "data"); // ULONG_PTR
	ADD_PARAM_NAME("DragObject", 5, "hcur"); // HCURSOR
	ADD_PARAM_NAME("DrawAnimatedRects", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("DrawAnimatedRects", 2, "idAni"); // int
	ADD_PARAM_NAME("DrawAnimatedRects", 3, "lprcFrom"); // CONST RECT *
	ADD_PARAM_NAME("DrawAnimatedRects", 4, "lprcTo"); // CONST RECT *
	ADD_PARAM_NAME("DrawCaption", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("DrawCaption", 2, "hdc"); // HDC
	ADD_PARAM_NAME("DrawCaption", 3, "lprect"); // CONST RECT *
	ADD_PARAM_NAME("DrawCaption", 4, "flags"); // UINT
	ADD_PARAM_NAME("DrawEdge", 1, "hdc"); // HDC
	ADD_PARAM_NAME("DrawEdge", 2, "qrc"); // LPRECT
	ADD_PARAM_NAME("DrawEdge", 3, "edge"); // UINT
	ADD_PARAM_NAME("DrawEdge", 4, "grfFlags"); // UINT
	ADD_PARAM_NAME("DrawEscape", 1, "hdc"); // HDC
	ADD_PARAM_NAME("DrawEscape", 2, "iEscape"); // int
	ADD_PARAM_NAME("DrawEscape", 3, "cjIn"); // int
	ADD_PARAM_NAME("DrawEscape", 4, "lpIn"); // LPCSTR
	ADD_PARAM_NAME("DrawFocusRect", 1, "hDC"); // HDC
	ADD_PARAM_NAME("DrawFocusRect", 2, "lprc"); // CONST RECT *
	ADD_PARAM_NAME("DrawFrameControl", 1, "hdc"); // HDC
	ADD_PARAM_NAME("DrawFrameControl", 2, "lprc"); // LPRECT
	ADD_PARAM_NAME("DrawFrameControl", 3, "uType"); // UINT
	ADD_PARAM_NAME("DrawFrameControl", 4, "uState"); // UINT
	ADD_PARAM_NAME("DrawIcon", 1, "hDC"); // HDC
	ADD_PARAM_NAME("DrawIcon", 2, "X"); // int
	ADD_PARAM_NAME("DrawIcon", 3, "Y"); // int
	ADD_PARAM_NAME("DrawIcon", 4, "hIcon"); // HICON
	ADD_PARAM_NAME("DrawIconEx", 1, "hdc"); // HDC
	ADD_PARAM_NAME("DrawIconEx", 2, "xLeft"); // int
	ADD_PARAM_NAME("DrawIconEx", 3, "yTop"); // int
	ADD_PARAM_NAME("DrawIconEx", 4, "hIcon"); // HICON
	ADD_PARAM_NAME("DrawIconEx", 5, "cxWidth"); // int
	ADD_PARAM_NAME("DrawIconEx", 6, "cyWidth"); // int
	ADD_PARAM_NAME("DrawIconEx", 7, "istepIfAniCur"); // UINT
	ADD_PARAM_NAME("DrawIconEx", 8, "hbrFlickerFreeDraw"); // HBRUSH
	ADD_PARAM_NAME("DrawIconEx", 9, "diFlags"); // UINT
	ADD_PARAM_NAME("DrawMenuBar", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("DrawStateA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("DrawStateA", 2, "hbrFore"); // HBRUSH
	ADD_PARAM_NAME("DrawStateA", 3, "qfnCallBack"); // DRAWSTATEPROC
	ADD_PARAM_NAME("DrawStateA", 4, "lData"); // LPARAM
	ADD_PARAM_NAME("DrawStateA", 5, "wData"); // WPARAM
	ADD_PARAM_NAME("DrawStateA", 6, "x"); // int
	ADD_PARAM_NAME("DrawStateA", 7, "y"); // int
	ADD_PARAM_NAME("DrawStateA", 8, "cx"); // int
	ADD_PARAM_NAME("DrawStateA", 9, "cy"); // int
	ADD_PARAM_NAME("DrawStateA", 10, "uFlags"); // UINT
	ADD_PARAM_NAME("DrawStateW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("DrawStateW", 2, "hbrFore"); // HBRUSH
	ADD_PARAM_NAME("DrawStateW", 3, "qfnCallBack"); // DRAWSTATEPROC
	ADD_PARAM_NAME("DrawStateW", 4, "lData"); // LPARAM
	ADD_PARAM_NAME("DrawStateW", 5, "wData"); // WPARAM
	ADD_PARAM_NAME("DrawStateW", 6, "x"); // int
	ADD_PARAM_NAME("DrawStateW", 7, "y"); // int
	ADD_PARAM_NAME("DrawStateW", 8, "cx"); // int
	ADD_PARAM_NAME("DrawStateW", 9, "cy"); // int
	ADD_PARAM_NAME("DrawStateW", 10, "uFlags"); // UINT
	ADD_PARAM_NAME("DrawTextA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("DrawTextA", 2, "lpchText"); // LPCSTR
	ADD_PARAM_NAME("DrawTextA", 3, "cchText"); // int
	ADD_PARAM_NAME("DrawTextA", 4, "lprc"); // LPRECT
	ADD_PARAM_NAME("DrawTextA", 5, "format"); // UINT
	ADD_PARAM_NAME("DrawTextExA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("DrawTextExA", 2, "lpchText"); // LPSTR
	ADD_PARAM_NAME("DrawTextExA", 3, "cchText"); // int
	ADD_PARAM_NAME("DrawTextExA", 4, "lprc"); // LPRECT
	ADD_PARAM_NAME("DrawTextExA", 5, "format"); // UINT
	ADD_PARAM_NAME("DrawTextExA", 6, "lpdtp"); // LPDRAWTEXTPARAMS
	ADD_PARAM_NAME("DrawTextExW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("DrawTextExW", 2, "lpchText"); // LPWSTR
	ADD_PARAM_NAME("DrawTextExW", 3, "cchText"); // int
	ADD_PARAM_NAME("DrawTextExW", 4, "lprc"); // LPRECT
	ADD_PARAM_NAME("DrawTextExW", 5, "format"); // UINT
	ADD_PARAM_NAME("DrawTextExW", 6, "lpdtp"); // LPDRAWTEXTPARAMS
	ADD_PARAM_NAME("DrawTextW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("DrawTextW", 2, "lpchText"); // LPCWSTR
	ADD_PARAM_NAME("DrawTextW", 3, "cchText"); // int
	ADD_PARAM_NAME("DrawTextW", 4, "lprc"); // LPRECT
	ADD_PARAM_NAME("DrawTextW", 5, "format"); // UINT
	ADD_PARAM_NAME("DrvDocumentEvent", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("DrvDocumentEvent", 2, "hdc"); // HDC
	ADD_PARAM_NAME("DrvDocumentEvent", 3, "iEsc"); // int
	ADD_PARAM_NAME("DrvDocumentEvent", 4, "cbIn"); // ULONG
	ADD_PARAM_NAME("DrvDocumentEvent", 5, "pvIn"); // PVOID
	ADD_PARAM_NAME("DrvDocumentEvent", 6, "cbOut"); // ULONG
	ADD_PARAM_NAME("DrvDocumentEvent", 7, "pvOut"); // PVOID
	ADD_PARAM_NAME("DrvDriverEvent", 1, "dwDriverEvent"); // DWORD
	ADD_PARAM_NAME("DrvDriverEvent", 2, "dwLevel"); // DWORD
	ADD_PARAM_NAME("DrvDriverEvent", 3, "pDriverInfo"); // LPBYTE
	ADD_PARAM_NAME("DrvDriverEvent", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("DrvPrinterEvent", 1, "pPrinterName"); // LPWSTR
	ADD_PARAM_NAME("DrvPrinterEvent", 2, "DriverEvent"); // int
	ADD_PARAM_NAME("DrvPrinterEvent", 3, "Flags"); // DWORD
	ADD_PARAM_NAME("DrvPrinterEvent", 4, "lParam"); // LPARAM
	ADD_PARAM_NAME("DuplicateEncryptionInfoFile", 1, "SrcFileName"); // LPCWSTR
	ADD_PARAM_NAME("DuplicateEncryptionInfoFile", 2, "DstFileName"); // LPCWSTR
	ADD_PARAM_NAME("DuplicateEncryptionInfoFile", 3, "dwCreationDistribution"); // DWORD
	ADD_PARAM_NAME("DuplicateEncryptionInfoFile", 4, "dwAttributes"); // DWORD
	ADD_PARAM_NAME("DuplicateEncryptionInfoFile", 5, "lpSecurityAttributes"); // CONST LPSECURITY_ATTRIBUTES
	ADD_PARAM_NAME("DuplicateHandle", 1, "hSourceProcessHandle"); // HANDLE
	ADD_PARAM_NAME("DuplicateHandle", 2, "hSourceHandle"); // HANDLE
	ADD_PARAM_NAME("DuplicateHandle", 3, "hTargetProcessHandle"); // HANDLE
	ADD_PARAM_NAME("DuplicateHandle", 4, "lpTargetHandle"); // LPHANDLE
	ADD_PARAM_NAME("DuplicateHandle", 5, "dwDesiredAccess"); // DWORD
	ADD_PARAM_NAME("DuplicateHandle", 6, "bInheritHandle"); // WINBOOL
	ADD_PARAM_NAME("DuplicateHandle", 7, "dwOptions"); // DWORD
	ADD_PARAM_NAME("DuplicateToken", 1, "ExistingTokenHandle"); // HANDLE
	ADD_PARAM_NAME("DuplicateToken", 2, "ImpersonationLevel"); // SECURITY_IMPERSONATION_LEVEL
	ADD_PARAM_NAME("DuplicateToken", 3, "DuplicateTokenHandle"); // PHANDLE
	ADD_PARAM_NAME("DuplicateTokenEx", 1, "hExistingToken"); // HANDLE
	ADD_PARAM_NAME("DuplicateTokenEx", 2, "dwDesiredAccess"); // DWORD
	ADD_PARAM_NAME("DuplicateTokenEx", 3, "lpTokenAttributes"); // LPSECURITY_ATTRIBUTES
	ADD_PARAM_NAME("DuplicateTokenEx", 4, "ImpersonationLevel"); // SECURITY_IMPERSONATION_LEVEL
	ADD_PARAM_NAME("DuplicateTokenEx", 5, "TokenType"); // TOKEN_TYPE
	ADD_PARAM_NAME("DuplicateTokenEx", 6, "phNewToken"); // PHANDLE
}

} // namespace win_api
} // namespace semantics
} // namespace llvmir2hll
} // namespace retdec
