/**
* @file src/llvmir2hll/semantics/semantics/win_api_semantics/get_name_of_param/g2.cpp
* @brief Implementation of the initialization of WinAPI functions.
* @copyright (c) 2017 Avast Software, licensed under the MIT license
*/

#include "retdec/llvmir2hll/semantics/semantics/win_api_semantics/get_name_of_param/g2.h"

namespace retdec {
namespace llvmir2hll {
namespace semantics {
namespace win_api {

/**
* @brief Initializes the given map with info about functions starting with G
*        (second part).
*/
void initFuncParamNamesMap_G2(FuncParamNamesMap &funcParamNamesMap) {
	//
	// windows.h
	//
	ADD_PARAM_NAME("GetNamedPipeClientComputerNameA", 1, "Pipe"); // HANDLE
	ADD_PARAM_NAME("GetNamedPipeClientComputerNameA", 2, "ClientComputerName"); // LPSTR
	ADD_PARAM_NAME("GetNamedPipeClientComputerNameA", 3, "ClientComputerNameLength"); // ULONG
	ADD_PARAM_NAME("GetNamedPipeClientComputerNameW", 1, "Pipe"); // HANDLE
	ADD_PARAM_NAME("GetNamedPipeClientComputerNameW", 2, "ClientComputerName"); // LPWSTR
	ADD_PARAM_NAME("GetNamedPipeClientComputerNameW", 3, "ClientComputerNameLength"); // ULONG
	ADD_PARAM_NAME("GetNamedPipeClientProcessId", 1, "Pipe"); // HANDLE
	ADD_PARAM_NAME("GetNamedPipeClientProcessId", 2, "ClientProcessId"); // PULONG
	ADD_PARAM_NAME("GetNamedPipeClientSessionId", 1, "Pipe"); // HANDLE
	ADD_PARAM_NAME("GetNamedPipeClientSessionId", 2, "ClientSessionId"); // PULONG
	ADD_PARAM_NAME("GetNamedPipeHandleStateA", 1, "hNamedPipe"); // HANDLE
	ADD_PARAM_NAME("GetNamedPipeHandleStateA", 2, "lpState"); // LPDWORD
	ADD_PARAM_NAME("GetNamedPipeHandleStateA", 3, "lpCurInstances"); // LPDWORD
	ADD_PARAM_NAME("GetNamedPipeHandleStateA", 4, "lpMaxCollectionCount"); // LPDWORD
	ADD_PARAM_NAME("GetNamedPipeHandleStateA", 5, "lpCollectDataTimeout"); // LPDWORD
	ADD_PARAM_NAME("GetNamedPipeHandleStateA", 6, "lpUserName"); // LPSTR
	ADD_PARAM_NAME("GetNamedPipeHandleStateA", 7, "nMaxUserNameSize"); // DWORD
	ADD_PARAM_NAME("GetNamedPipeHandleStateW", 1, "hNamedPipe"); // HANDLE
	ADD_PARAM_NAME("GetNamedPipeHandleStateW", 2, "lpState"); // LPDWORD
	ADD_PARAM_NAME("GetNamedPipeHandleStateW", 3, "lpCurInstances"); // LPDWORD
	ADD_PARAM_NAME("GetNamedPipeHandleStateW", 4, "lpMaxCollectionCount"); // LPDWORD
	ADD_PARAM_NAME("GetNamedPipeHandleStateW", 5, "lpCollectDataTimeout"); // LPDWORD
	ADD_PARAM_NAME("GetNamedPipeHandleStateW", 6, "lpUserName"); // LPWSTR
	ADD_PARAM_NAME("GetNamedPipeHandleStateW", 7, "nMaxUserNameSize"); // DWORD
	ADD_PARAM_NAME("GetNamedPipeInfo", 1, "hNamedPipe"); // HANDLE
	ADD_PARAM_NAME("GetNamedPipeInfo", 2, "lpFlags"); // LPDWORD
	ADD_PARAM_NAME("GetNamedPipeInfo", 3, "lpOutBufferSize"); // LPDWORD
	ADD_PARAM_NAME("GetNamedPipeInfo", 4, "lpInBufferSize"); // LPDWORD
	ADD_PARAM_NAME("GetNamedPipeInfo", 5, "lpMaxInstances"); // LPDWORD
	ADD_PARAM_NAME("GetNamedPipeServerProcessId", 1, "Pipe"); // HANDLE
	ADD_PARAM_NAME("GetNamedPipeServerProcessId", 2, "ServerProcessId"); // PULONG
	ADD_PARAM_NAME("GetNamedPipeServerSessionId", 1, "Pipe"); // HANDLE
	ADD_PARAM_NAME("GetNamedPipeServerSessionId", 2, "ServerSessionId"); // PULONG
	ADD_PARAM_NAME("GetNativeSystemInfo", 1, "lpSystemInfo"); // LPSYSTEM_INFO
	ADD_PARAM_NAME("GetNearestColor", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetNearestColor", 2, "color"); // COLORREF
	ADD_PARAM_NAME("GetNearestPaletteIndex", 1, "h"); // HPALETTE
	ADD_PARAM_NAME("GetNearestPaletteIndex", 2, "color"); // COLORREF
	ADD_PARAM_NAME("GetNextDlgGroupItem", 1, "hDlg"); // HWND
	ADD_PARAM_NAME("GetNextDlgGroupItem", 2, "hCtl"); // HWND
	ADD_PARAM_NAME("GetNextDlgGroupItem", 3, "bPrevious"); // WINBOOL
	ADD_PARAM_NAME("GetNextDlgTabItem", 1, "hDlg"); // HWND
	ADD_PARAM_NAME("GetNextDlgTabItem", 2, "hCtl"); // HWND
	ADD_PARAM_NAME("GetNextDlgTabItem", 3, "bPrevious"); // WINBOOL
	ADD_PARAM_NAME("GetNumaAvailableMemoryNode", 1, "Node"); // UCHAR
	ADD_PARAM_NAME("GetNumaAvailableMemoryNode", 2, "AvailableBytes"); // PULONGLONG
	ADD_PARAM_NAME("GetNumaAvailableMemoryNodeEx", 1, "Node"); // USHORT
	ADD_PARAM_NAME("GetNumaAvailableMemoryNodeEx", 2, "AvailableBytes"); // PULONGLONG
	ADD_PARAM_NAME("GetNumaHighestNodeNumber", 1, "HighestNodeNumber"); // PULONG
	ADD_PARAM_NAME("GetNumaNodeNumberFromHandle", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("GetNumaNodeNumberFromHandle", 2, "NodeNumber"); // PUSHORT
	ADD_PARAM_NAME("GetNumaNodeProcessorMask", 1, "Node"); // UCHAR
	ADD_PARAM_NAME("GetNumaNodeProcessorMask", 2, "ProcessorMask"); // PULONGLONG
	ADD_PARAM_NAME("GetNumaNodeProcessorMaskEx", 1, "Node"); // USHORT
	ADD_PARAM_NAME("GetNumaNodeProcessorMaskEx", 2, "ProcessorMask"); // PGROUP_AFFINITY
	ADD_PARAM_NAME("GetNumaProcessorNode", 1, "Processor"); // UCHAR
	ADD_PARAM_NAME("GetNumaProcessorNode", 2, "NodeNumber"); // PUCHAR
	ADD_PARAM_NAME("GetNumaProcessorNodeEx", 1, "Processor"); // PPROCESSOR_NUMBER
	ADD_PARAM_NAME("GetNumaProcessorNodeEx", 2, "NodeNumber"); // PUSHORT
	ADD_PARAM_NAME("GetNumaProximityNode", 1, "ProximityId"); // ULONG
	ADD_PARAM_NAME("GetNumaProximityNode", 2, "NodeNumber"); // PUCHAR
	ADD_PARAM_NAME("GetNumaProximityNodeEx", 1, "ProximityId"); // ULONG
	ADD_PARAM_NAME("GetNumaProximityNodeEx", 2, "NodeNumber"); // PUSHORT
	ADD_PARAM_NAME("GetNumberFormatA", 1, "Locale"); // LCID
	ADD_PARAM_NAME("GetNumberFormatA", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetNumberFormatA", 3, "lpValue"); // LPCSTR
	ADD_PARAM_NAME("GetNumberFormatA", 4, "lpFormat"); // CONST NUMBERFMTA *
	ADD_PARAM_NAME("GetNumberFormatA", 5, "lpNumberStr"); // LPSTR
	ADD_PARAM_NAME("GetNumberFormatA", 6, "cchNumber"); // int
	ADD_PARAM_NAME("GetNumberFormatEx", 1, "lpLocaleName"); // LPCWSTR
	ADD_PARAM_NAME("GetNumberFormatEx", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetNumberFormatEx", 3, "lpValue"); // LPCWSTR
	ADD_PARAM_NAME("GetNumberFormatEx", 4, "lpFormat"); // const NUMBERFMT *
	ADD_PARAM_NAME("GetNumberFormatEx", 5, "lpNumberStr"); // LPWSTR
	ADD_PARAM_NAME("GetNumberFormatEx", 6, "cchNumber"); // int
	ADD_PARAM_NAME("GetNumberFormatW", 1, "Locale"); // LCID
	ADD_PARAM_NAME("GetNumberFormatW", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetNumberFormatW", 3, "lpValue"); // LPCWSTR
	ADD_PARAM_NAME("GetNumberFormatW", 4, "lpFormat"); // CONST NUMBERFMTW *
	ADD_PARAM_NAME("GetNumberFormatW", 5, "lpNumberStr"); // LPWSTR
	ADD_PARAM_NAME("GetNumberFormatW", 6, "cchNumber"); // int
	ADD_PARAM_NAME("GetNumberOfConsoleInputEvents", 1, "hConsoleInput"); // HANDLE
	ADD_PARAM_NAME("GetNumberOfConsoleInputEvents", 2, "lpNumberOfEvents"); // LPDWORD
	ADD_PARAM_NAME("GetNumberOfConsoleMouseButtons", 1, "lpNumberOfMouseButtons"); // LPDWORD
	ADD_PARAM_NAME("GetNumberOfEventLogRecords", 1, "hEventLog"); // HANDLE
	ADD_PARAM_NAME("GetNumberOfEventLogRecords", 2, "NumberOfRecords"); // PDWORD
	ADD_PARAM_NAME("GetObjectA", 1, "h"); // HANDLE
	ADD_PARAM_NAME("GetObjectA", 2, "c"); // int
	ADD_PARAM_NAME("GetObjectA", 3, "pv"); // LPVOID
	ADD_PARAM_NAME("GetObjectType", 1, "h"); // HGDIOBJ
	ADD_PARAM_NAME("GetObjectW", 1, "h"); // HANDLE
	ADD_PARAM_NAME("GetObjectW", 2, "c"); // int
	ADD_PARAM_NAME("GetObjectW", 3, "pv"); // LPVOID
	ADD_PARAM_NAME("GetOldestEventLogRecord", 1, "hEventLog"); // HANDLE
	ADD_PARAM_NAME("GetOldestEventLogRecord", 2, "OldestRecord"); // PDWORD
	ADD_PARAM_NAME("GetOpenCardNameA", 1, "pDlgStruc"); // LPOPENCARDNAMEA
	ADD_PARAM_NAME("GetOpenCardNameW", 1, "pDlgStruc"); // LPOPENCARDNAMEW
	ADD_PARAM_NAME("GetOutlineTextMetricsA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetOutlineTextMetricsA", 2, "cjCopy"); // UINT
	ADD_PARAM_NAME("GetOutlineTextMetricsA", 3, "potm"); // LPOUTLINETEXTMETRICA
	ADD_PARAM_NAME("GetOutlineTextMetricsW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetOutlineTextMetricsW", 2, "cjCopy"); // UINT
	ADD_PARAM_NAME("GetOutlineTextMetricsW", 3, "potm"); // LPOUTLINETEXTMETRICW
	ADD_PARAM_NAME("GetOverlappedResult", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("GetOverlappedResult", 2, "lpOverlapped"); // LPOVERLAPPED
	ADD_PARAM_NAME("GetOverlappedResult", 3, "lpNumberOfBytesTransferred"); // LPDWORD
	ADD_PARAM_NAME("GetOverlappedResult", 4, "bWait"); // WINBOOL
	ADD_PARAM_NAME("GetPaletteEntries", 1, "hpal"); // HPALETTE
	ADD_PARAM_NAME("GetPaletteEntries", 2, "iStart"); // UINT
	ADD_PARAM_NAME("GetPaletteEntries", 3, "cEntries"); // UINT
	ADD_PARAM_NAME("GetPaletteEntries", 4, "pPalEntries"); // LPPALETTEENTRY
	ADD_PARAM_NAME("GetParent", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetPath", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetPath", 2, "apt"); // LPPOINT
	ADD_PARAM_NAME("GetPath", 3, "aj"); // LPBYTE
	ADD_PARAM_NAME("GetPath", 4, "cpt"); // int
	ADD_PARAM_NAME("GetPhysicallyInstalledSystemMemory", 1, "TotalMemoryInKilobytes"); // PULONGLONG
	ADD_PARAM_NAME("GetPixel", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetPixel", 2, "x"); // int
	ADD_PARAM_NAME("GetPixel", 3, "y"); // int
	ADD_PARAM_NAME("GetPixelFormat", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetPolyFillMode", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetPrintProcessorDirectoryA", 1, "pName"); // LPSTR
	ADD_PARAM_NAME("GetPrintProcessorDirectoryA", 2, "pEnvironment"); // LPSTR
	ADD_PARAM_NAME("GetPrintProcessorDirectoryA", 3, "Level"); // DWORD
	ADD_PARAM_NAME("GetPrintProcessorDirectoryA", 4, "pPrintProcessorInfo"); // LPBYTE
	ADD_PARAM_NAME("GetPrintProcessorDirectoryA", 5, "cbBuf"); // DWORD
	ADD_PARAM_NAME("GetPrintProcessorDirectoryA", 6, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetPrintProcessorDirectoryW", 1, "pName"); // LPWSTR
	ADD_PARAM_NAME("GetPrintProcessorDirectoryW", 2, "pEnvironment"); // LPWSTR
	ADD_PARAM_NAME("GetPrintProcessorDirectoryW", 3, "Level"); // DWORD
	ADD_PARAM_NAME("GetPrintProcessorDirectoryW", 4, "pPrintProcessorInfo"); // LPBYTE
	ADD_PARAM_NAME("GetPrintProcessorDirectoryW", 5, "cbBuf"); // DWORD
	ADD_PARAM_NAME("GetPrintProcessorDirectoryW", 6, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetPrinterA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("GetPrinterA", 2, "Level"); // DWORD
	ADD_PARAM_NAME("GetPrinterA", 3, "pPrinter"); // LPBYTE
	ADD_PARAM_NAME("GetPrinterA", 4, "cbBuf"); // DWORD
	ADD_PARAM_NAME("GetPrinterA", 5, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetPrinterDataA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("GetPrinterDataA", 2, "pValueName"); // LPSTR
	ADD_PARAM_NAME("GetPrinterDataA", 3, "pType"); // LPDWORD
	ADD_PARAM_NAME("GetPrinterDataA", 4, "pData"); // LPBYTE
	ADD_PARAM_NAME("GetPrinterDataA", 5, "nSize"); // DWORD
	ADD_PARAM_NAME("GetPrinterDataA", 6, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetPrinterDataExA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("GetPrinterDataExA", 2, "pKeyName"); // LPCSTR
	ADD_PARAM_NAME("GetPrinterDataExA", 3, "pValueName"); // LPCSTR
	ADD_PARAM_NAME("GetPrinterDataExA", 4, "pType"); // LPDWORD
	ADD_PARAM_NAME("GetPrinterDataExA", 5, "pData"); // LPBYTE
	ADD_PARAM_NAME("GetPrinterDataExA", 6, "nSize"); // DWORD
	ADD_PARAM_NAME("GetPrinterDataExA", 7, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetPrinterDataExW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("GetPrinterDataExW", 2, "pKeyName"); // LPCWSTR
	ADD_PARAM_NAME("GetPrinterDataExW", 3, "pValueName"); // LPCWSTR
	ADD_PARAM_NAME("GetPrinterDataExW", 4, "pType"); // LPDWORD
	ADD_PARAM_NAME("GetPrinterDataExW", 5, "pData"); // LPBYTE
	ADD_PARAM_NAME("GetPrinterDataExW", 6, "nSize"); // DWORD
	ADD_PARAM_NAME("GetPrinterDataExW", 7, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetPrinterDataW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("GetPrinterDataW", 2, "pValueName"); // LPWSTR
	ADD_PARAM_NAME("GetPrinterDataW", 3, "pType"); // LPDWORD
	ADD_PARAM_NAME("GetPrinterDataW", 4, "pData"); // LPBYTE
	ADD_PARAM_NAME("GetPrinterDataW", 5, "nSize"); // DWORD
	ADD_PARAM_NAME("GetPrinterDataW", 6, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetPrinterDriver2A", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetPrinterDriver2A", 2, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("GetPrinterDriver2A", 3, "pEnvironment"); // LPSTR
	ADD_PARAM_NAME("GetPrinterDriver2A", 4, "Level"); // DWORD
	ADD_PARAM_NAME("GetPrinterDriver2A", 5, "pDriverInfo"); // LPBYTE
	ADD_PARAM_NAME("GetPrinterDriver2A", 6, "cbBuf"); // DWORD
	ADD_PARAM_NAME("GetPrinterDriver2A", 7, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetPrinterDriver2W", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetPrinterDriver2W", 2, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("GetPrinterDriver2W", 3, "pEnvironment"); // LPWSTR
	ADD_PARAM_NAME("GetPrinterDriver2W", 4, "Level"); // DWORD
	ADD_PARAM_NAME("GetPrinterDriver2W", 5, "pDriverInfo"); // LPBYTE
	ADD_PARAM_NAME("GetPrinterDriver2W", 6, "cbBuf"); // DWORD
	ADD_PARAM_NAME("GetPrinterDriver2W", 7, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetPrinterDriverA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("GetPrinterDriverA", 2, "pEnvironment"); // LPSTR
	ADD_PARAM_NAME("GetPrinterDriverA", 3, "Level"); // DWORD
	ADD_PARAM_NAME("GetPrinterDriverA", 4, "pDriverInfo"); // LPBYTE
	ADD_PARAM_NAME("GetPrinterDriverA", 5, "cbBuf"); // DWORD
	ADD_PARAM_NAME("GetPrinterDriverA", 6, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetPrinterDriverDirectoryA", 1, "pName"); // LPSTR
	ADD_PARAM_NAME("GetPrinterDriverDirectoryA", 2, "pEnvironment"); // LPSTR
	ADD_PARAM_NAME("GetPrinterDriverDirectoryA", 3, "Level"); // DWORD
	ADD_PARAM_NAME("GetPrinterDriverDirectoryA", 4, "pDriverDirectory"); // LPBYTE
	ADD_PARAM_NAME("GetPrinterDriverDirectoryA", 5, "cbBuf"); // DWORD
	ADD_PARAM_NAME("GetPrinterDriverDirectoryA", 6, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetPrinterDriverDirectoryW", 1, "pName"); // LPWSTR
	ADD_PARAM_NAME("GetPrinterDriverDirectoryW", 2, "pEnvironment"); // LPWSTR
	ADD_PARAM_NAME("GetPrinterDriverDirectoryW", 3, "Level"); // DWORD
	ADD_PARAM_NAME("GetPrinterDriverDirectoryW", 4, "pDriverDirectory"); // LPBYTE
	ADD_PARAM_NAME("GetPrinterDriverDirectoryW", 5, "cbBuf"); // DWORD
	ADD_PARAM_NAME("GetPrinterDriverDirectoryW", 6, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetPrinterDriverPackagePathA", 1, "pszServer"); // LPCSTR
	ADD_PARAM_NAME("GetPrinterDriverPackagePathA", 2, "pszEnvironment"); // LPCSTR
	ADD_PARAM_NAME("GetPrinterDriverPackagePathA", 3, "pszLanguage"); // LPCSTR
	ADD_PARAM_NAME("GetPrinterDriverPackagePathA", 4, "pszPackageID"); // LPCSTR
	ADD_PARAM_NAME("GetPrinterDriverPackagePathA", 5, "pszDriverPackageCab"); // LPSTR
	ADD_PARAM_NAME("GetPrinterDriverPackagePathA", 6, "cchDriverPackageCab"); // DWORD
	ADD_PARAM_NAME("GetPrinterDriverPackagePathA", 7, "pcchRequiredSize"); // LPDWORD
	ADD_PARAM_NAME("GetPrinterDriverPackagePathW", 1, "pszServer"); // LPCWSTR
	ADD_PARAM_NAME("GetPrinterDriverPackagePathW", 2, "pszEnvironment"); // LPCWSTR
	ADD_PARAM_NAME("GetPrinterDriverPackagePathW", 3, "pszLanguage"); // LPCWSTR
	ADD_PARAM_NAME("GetPrinterDriverPackagePathW", 4, "pszPackageID"); // LPCWSTR
	ADD_PARAM_NAME("GetPrinterDriverPackagePathW", 5, "pszDriverPackageCab"); // LPWSTR
	ADD_PARAM_NAME("GetPrinterDriverPackagePathW", 6, "cchDriverPackageCab"); // DWORD
	ADD_PARAM_NAME("GetPrinterDriverPackagePathW", 7, "pcchRequiredSize"); // LPDWORD
	ADD_PARAM_NAME("GetPrinterDriverW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("GetPrinterDriverW", 2, "pEnvironment"); // LPWSTR
	ADD_PARAM_NAME("GetPrinterDriverW", 3, "Level"); // DWORD
	ADD_PARAM_NAME("GetPrinterDriverW", 4, "pDriverInfo"); // LPBYTE
	ADD_PARAM_NAME("GetPrinterDriverW", 5, "cbBuf"); // DWORD
	ADD_PARAM_NAME("GetPrinterDriverW", 6, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetPrinterW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("GetPrinterW", 2, "Level"); // DWORD
	ADD_PARAM_NAME("GetPrinterW", 3, "pPrinter"); // LPBYTE
	ADD_PARAM_NAME("GetPrinterW", 4, "cbBuf"); // DWORD
	ADD_PARAM_NAME("GetPrinterW", 5, "pcbNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetPriorityClass", 1, "hProcess"); // HANDLE
	ADD_PARAM_NAME("GetPriorityClipboardFormat", 1, "paFormatPriorityList"); // UINT *
	ADD_PARAM_NAME("GetPriorityClipboardFormat", 2, "cFormats"); // int
	ADD_PARAM_NAME("GetPrivateObjectSecurity", 1, "ObjectDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("GetPrivateObjectSecurity", 2, "SecurityInformation"); // SECURITY_INFORMATION
	ADD_PARAM_NAME("GetPrivateObjectSecurity", 3, "ResultantDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("GetPrivateObjectSecurity", 4, "DescriptorLength"); // DWORD
	ADD_PARAM_NAME("GetPrivateObjectSecurity", 5, "ReturnLength"); // PDWORD
	ADD_PARAM_NAME("GetPrivateProfileIntA", 1, "lpAppName"); // LPCSTR
	ADD_PARAM_NAME("GetPrivateProfileIntA", 2, "lpKeyName"); // LPCSTR
	ADD_PARAM_NAME("GetPrivateProfileIntA", 3, "nDefault"); // INT
	ADD_PARAM_NAME("GetPrivateProfileIntA", 4, "lpFileName"); // LPCSTR
	ADD_PARAM_NAME("GetPrivateProfileIntW", 1, "lpAppName"); // LPCWSTR
	ADD_PARAM_NAME("GetPrivateProfileIntW", 2, "lpKeyName"); // LPCWSTR
	ADD_PARAM_NAME("GetPrivateProfileIntW", 3, "nDefault"); // INT
	ADD_PARAM_NAME("GetPrivateProfileIntW", 4, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("GetPrivateProfileSectionA", 1, "lpAppName"); // LPCSTR
	ADD_PARAM_NAME("GetPrivateProfileSectionA", 2, "lpReturnedString"); // LPSTR
	ADD_PARAM_NAME("GetPrivateProfileSectionA", 3, "nSize"); // DWORD
	ADD_PARAM_NAME("GetPrivateProfileSectionA", 4, "lpFileName"); // LPCSTR
	ADD_PARAM_NAME("GetPrivateProfileSectionNamesA", 1, "lpszReturnBuffer"); // LPSTR
	ADD_PARAM_NAME("GetPrivateProfileSectionNamesA", 2, "nSize"); // DWORD
	ADD_PARAM_NAME("GetPrivateProfileSectionNamesA", 3, "lpFileName"); // LPCSTR
	ADD_PARAM_NAME("GetPrivateProfileSectionNamesW", 1, "lpszReturnBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetPrivateProfileSectionNamesW", 2, "nSize"); // DWORD
	ADD_PARAM_NAME("GetPrivateProfileSectionNamesW", 3, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("GetPrivateProfileSectionW", 1, "lpAppName"); // LPCWSTR
	ADD_PARAM_NAME("GetPrivateProfileSectionW", 2, "lpReturnedString"); // LPWSTR
	ADD_PARAM_NAME("GetPrivateProfileSectionW", 3, "nSize"); // DWORD
	ADD_PARAM_NAME("GetPrivateProfileSectionW", 4, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("GetPrivateProfileStringA", 1, "lpAppName"); // LPCSTR
	ADD_PARAM_NAME("GetPrivateProfileStringA", 2, "lpKeyName"); // LPCSTR
	ADD_PARAM_NAME("GetPrivateProfileStringA", 3, "lpDefault"); // LPCSTR
	ADD_PARAM_NAME("GetPrivateProfileStringA", 4, "lpReturnedString"); // LPSTR
	ADD_PARAM_NAME("GetPrivateProfileStringA", 5, "nSize"); // DWORD
	ADD_PARAM_NAME("GetPrivateProfileStringA", 6, "lpFileName"); // LPCSTR
	ADD_PARAM_NAME("GetPrivateProfileStringW", 1, "lpAppName"); // LPCWSTR
	ADD_PARAM_NAME("GetPrivateProfileStringW", 2, "lpKeyName"); // LPCWSTR
	ADD_PARAM_NAME("GetPrivateProfileStringW", 3, "lpDefault"); // LPCWSTR
	ADD_PARAM_NAME("GetPrivateProfileStringW", 4, "lpReturnedString"); // LPWSTR
	ADD_PARAM_NAME("GetPrivateProfileStringW", 5, "nSize"); // DWORD
	ADD_PARAM_NAME("GetPrivateProfileStringW", 6, "lpFileName"); // LPCWSTR
	ADD_PARAM_NAME("GetPrivateProfileStructA", 1, "lpszSection"); // LPCSTR
	ADD_PARAM_NAME("GetPrivateProfileStructA", 2, "lpszKey"); // LPCSTR
	ADD_PARAM_NAME("GetPrivateProfileStructA", 3, "lpStruct"); // LPVOID
	ADD_PARAM_NAME("GetPrivateProfileStructA", 4, "uSizeStruct"); // UINT
	ADD_PARAM_NAME("GetPrivateProfileStructA", 5, "szFile"); // LPCSTR
	ADD_PARAM_NAME("GetPrivateProfileStructW", 1, "lpszSection"); // LPCWSTR
	ADD_PARAM_NAME("GetPrivateProfileStructW", 2, "lpszKey"); // LPCWSTR
	ADD_PARAM_NAME("GetPrivateProfileStructW", 3, "lpStruct"); // LPVOID
	ADD_PARAM_NAME("GetPrivateProfileStructW", 4, "uSizeStruct"); // UINT
	ADD_PARAM_NAME("GetPrivateProfileStructW", 5, "szFile"); // LPCWSTR
	ADD_PARAM_NAME("GetProcAddress", 1, "hModule"); // HMODULE
	ADD_PARAM_NAME("GetProcAddress", 2, "lpProcName"); // LPCSTR
	ADD_PARAM_NAME("GetProcessAffinityMask", 1, "hProcess"); // HANDLE
	ADD_PARAM_NAME("GetProcessAffinityMask", 2, "lpProcessAffinityMask"); // PDWORD_PTR
	ADD_PARAM_NAME("GetProcessAffinityMask", 3, "lpSystemAffinityMask"); // PDWORD_PTR
	ADD_PARAM_NAME("GetProcessDEPPolicy", 1, "hProcess"); // HANDLE
	ADD_PARAM_NAME("GetProcessDEPPolicy", 2, "lpFlags"); // LPDWORD
	ADD_PARAM_NAME("GetProcessDEPPolicy", 3, "lpPermanent"); // PBOOL
	ADD_PARAM_NAME("GetProcessDefaultLayout", 1, "pdwDefaultLayout"); // DWORD *
	ADD_PARAM_NAME("GetProcessGroupAffinity", 1, "hProcess"); // HANDLE
	ADD_PARAM_NAME("GetProcessGroupAffinity", 2, "GroupCount"); // PUSHORT
	ADD_PARAM_NAME("GetProcessGroupAffinity", 3, "GroupArray"); // PUSHORT
	ADD_PARAM_NAME("GetProcessHandleCount", 1, "hProcess"); // HANDLE
	ADD_PARAM_NAME("GetProcessHandleCount", 2, "pdwHandleCount"); // PDWORD
	ADD_PARAM_NAME("GetProcessHeaps", 1, "NumberOfHeaps"); // DWORD
	ADD_PARAM_NAME("GetProcessHeaps", 2, "ProcessHeaps"); // PHANDLE
	ADD_PARAM_NAME("GetProcessId", 1, "Process"); // HANDLE
	ADD_PARAM_NAME("GetProcessIdOfThread", 1, "Thread"); // HANDLE
	ADD_PARAM_NAME("GetProcessIoCounters", 1, "hProcess"); // HANDLE
	ADD_PARAM_NAME("GetProcessIoCounters", 2, "lpIoCounters"); // PIO_COUNTERS
	ADD_PARAM_NAME("GetProcessPreferredUILanguages", 1, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetProcessPreferredUILanguages", 2, "pulNumLanguages"); // PULONG
	ADD_PARAM_NAME("GetProcessPreferredUILanguages", 3, "pwszLanguagesBuffer"); // PZZWSTR
	ADD_PARAM_NAME("GetProcessPreferredUILanguages", 4, "pcchLanguagesBuffer"); // PULONG
	ADD_PARAM_NAME("GetProcessPriorityBoost", 1, "hProcess"); // HANDLE
	ADD_PARAM_NAME("GetProcessPriorityBoost", 2, "pDisablePriorityBoost"); // PBOOL
	ADD_PARAM_NAME("GetProcessShutdownParameters", 1, "lpdwLevel"); // LPDWORD
	ADD_PARAM_NAME("GetProcessShutdownParameters", 2, "lpdwFlags"); // LPDWORD
	ADD_PARAM_NAME("GetProcessTimes", 1, "hProcess"); // HANDLE
	ADD_PARAM_NAME("GetProcessTimes", 2, "lpCreationTime"); // LPFILETIME
	ADD_PARAM_NAME("GetProcessTimes", 3, "lpExitTime"); // LPFILETIME
	ADD_PARAM_NAME("GetProcessTimes", 4, "lpKernelTime"); // LPFILETIME
	ADD_PARAM_NAME("GetProcessTimes", 5, "lpUserTime"); // LPFILETIME
	ADD_PARAM_NAME("GetProcessVersion", 1, "ProcessId"); // DWORD
	ADD_PARAM_NAME("GetProcessWorkingSetSize", 1, "hProcess"); // HANDLE
	ADD_PARAM_NAME("GetProcessWorkingSetSize", 2, "lpMinimumWorkingSetSize"); // PSIZE_T
	ADD_PARAM_NAME("GetProcessWorkingSetSize", 3, "lpMaximumWorkingSetSize"); // PSIZE_T
	ADD_PARAM_NAME("GetProcessWorkingSetSizeEx", 1, "hProcess"); // HANDLE
	ADD_PARAM_NAME("GetProcessWorkingSetSizeEx", 2, "lpMinimumWorkingSetSize"); // PSIZE_T
	ADD_PARAM_NAME("GetProcessWorkingSetSizeEx", 3, "lpMaximumWorkingSetSize"); // PSIZE_T
	ADD_PARAM_NAME("GetProcessWorkingSetSizeEx", 4, "Flags"); // PDWORD
	ADD_PARAM_NAME("GetProcessorSystemCycleTime", 1, "Group"); // USHORT
	ADD_PARAM_NAME("GetProcessorSystemCycleTime", 2, "Buffer"); // PSYSTEM_PROCESSOR_CYCLE_TIME_INFORMATION
	ADD_PARAM_NAME("GetProcessorSystemCycleTime", 3, "ReturnedLength"); // PDWORD
	ADD_PARAM_NAME("GetProductInfo", 1, "dwOSMajorVersion"); // DWORD
	ADD_PARAM_NAME("GetProductInfo", 2, "dwOSMinorVersion"); // DWORD
	ADD_PARAM_NAME("GetProductInfo", 3, "dwSpMajorVersion"); // DWORD
	ADD_PARAM_NAME("GetProductInfo", 4, "dwSpMinorVersion"); // DWORD
	ADD_PARAM_NAME("GetProductInfo", 5, "pdwReturnedProductType"); // PDWORD
	ADD_PARAM_NAME("GetProfileIntA", 1, "lpAppName"); // LPCSTR
	ADD_PARAM_NAME("GetProfileIntA", 2, "lpKeyName"); // LPCSTR
	ADD_PARAM_NAME("GetProfileIntA", 3, "nDefault"); // INT
	ADD_PARAM_NAME("GetProfileIntW", 1, "lpAppName"); // LPCWSTR
	ADD_PARAM_NAME("GetProfileIntW", 2, "lpKeyName"); // LPCWSTR
	ADD_PARAM_NAME("GetProfileIntW", 3, "nDefault"); // INT
	ADD_PARAM_NAME("GetProfileSectionA", 1, "lpAppName"); // LPCSTR
	ADD_PARAM_NAME("GetProfileSectionA", 2, "lpReturnedString"); // LPSTR
	ADD_PARAM_NAME("GetProfileSectionA", 3, "nSize"); // DWORD
	ADD_PARAM_NAME("GetProfileSectionW", 1, "lpAppName"); // LPCWSTR
	ADD_PARAM_NAME("GetProfileSectionW", 2, "lpReturnedString"); // LPWSTR
	ADD_PARAM_NAME("GetProfileSectionW", 3, "nSize"); // DWORD
	ADD_PARAM_NAME("GetProfileStringA", 1, "lpAppName"); // LPCSTR
	ADD_PARAM_NAME("GetProfileStringA", 2, "lpKeyName"); // LPCSTR
	ADD_PARAM_NAME("GetProfileStringA", 3, "lpDefault"); // LPCSTR
	ADD_PARAM_NAME("GetProfileStringA", 4, "lpReturnedString"); // LPSTR
	ADD_PARAM_NAME("GetProfileStringA", 5, "nSize"); // DWORD
	ADD_PARAM_NAME("GetProfileStringW", 1, "lpAppName"); // LPCWSTR
	ADD_PARAM_NAME("GetProfileStringW", 2, "lpKeyName"); // LPCWSTR
	ADD_PARAM_NAME("GetProfileStringW", 3, "lpDefault"); // LPCWSTR
	ADD_PARAM_NAME("GetProfileStringW", 4, "lpReturnedString"); // LPWSTR
	ADD_PARAM_NAME("GetProfileStringW", 5, "nSize"); // DWORD
	ADD_PARAM_NAME("GetPropA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetPropA", 2, "lpString"); // LPCSTR
	ADD_PARAM_NAME("GetPropW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetPropW", 2, "lpString"); // LPCWSTR
	ADD_PARAM_NAME("GetQueueStatus", 1, "flags"); // UINT
	ADD_PARAM_NAME("GetQueuedCompletionStatus", 1, "CompletionPort"); // HANDLE
	ADD_PARAM_NAME("GetQueuedCompletionStatus", 2, "lpNumberOfBytesTransferred"); // LPDWORD
	ADD_PARAM_NAME("GetQueuedCompletionStatus", 3, "lpCompletionKey"); // PULONG_PTR
	ADD_PARAM_NAME("GetQueuedCompletionStatus", 4, "lpOverlapped"); // LPOVERLAPPED *
	ADD_PARAM_NAME("GetQueuedCompletionStatus", 5, "dwMilliseconds"); // DWORD
	ADD_PARAM_NAME("GetQueuedCompletionStatusEx", 1, "CompletionPort"); // HANDLE
	ADD_PARAM_NAME("GetQueuedCompletionStatusEx", 2, "lpCompletionPortEntries"); // LPOVERLAPPED_ENTRY
	ADD_PARAM_NAME("GetQueuedCompletionStatusEx", 3, "ulCount"); // ULONG
	ADD_PARAM_NAME("GetQueuedCompletionStatusEx", 4, "ulNumEntriesRemoved"); // PULONG
	ADD_PARAM_NAME("GetQueuedCompletionStatusEx", 5, "dwMilliseconds"); // DWORD
	ADD_PARAM_NAME("GetQueuedCompletionStatusEx", 6, "fAlertable"); // WINBOOL
	ADD_PARAM_NAME("GetROP2", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetRandomRgn", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetRandomRgn", 2, "hrgn"); // HRGN
	ADD_PARAM_NAME("GetRandomRgn", 3, "i"); // INT
	ADD_PARAM_NAME("GetRasterizerCaps", 1, "lpraststat"); // LPRASTERIZER_STATUS
	ADD_PARAM_NAME("GetRasterizerCaps", 2, "cjBytes"); // UINT
	ADD_PARAM_NAME("GetRawInputBuffer", 1, "pData"); // PRAWINPUT
	ADD_PARAM_NAME("GetRawInputBuffer", 2, "pcbSize"); // PUINT
	ADD_PARAM_NAME("GetRawInputBuffer", 3, "cbSizeHeader"); // UINT
	ADD_PARAM_NAME("GetRawInputData", 1, "hRawInput"); // HRAWINPUT
	ADD_PARAM_NAME("GetRawInputData", 2, "uiCommand"); // UINT
	ADD_PARAM_NAME("GetRawInputData", 3, "pData"); // LPVOID
	ADD_PARAM_NAME("GetRawInputData", 4, "pcbSize"); // PUINT
	ADD_PARAM_NAME("GetRawInputData", 5, "cbSizeHeader"); // UINT
	ADD_PARAM_NAME("GetRawInputDeviceInfoA", 1, "hDevice"); // HANDLE
	ADD_PARAM_NAME("GetRawInputDeviceInfoA", 2, "uiCommand"); // UINT
	ADD_PARAM_NAME("GetRawInputDeviceInfoA", 3, "pData"); // LPVOID
	ADD_PARAM_NAME("GetRawInputDeviceInfoA", 4, "pcbSize"); // PUINT
	ADD_PARAM_NAME("GetRawInputDeviceInfoW", 1, "hDevice"); // HANDLE
	ADD_PARAM_NAME("GetRawInputDeviceInfoW", 2, "uiCommand"); // UINT
	ADD_PARAM_NAME("GetRawInputDeviceInfoW", 3, "pData"); // LPVOID
	ADD_PARAM_NAME("GetRawInputDeviceInfoW", 4, "pcbSize"); // PUINT
	ADD_PARAM_NAME("GetRawInputDeviceList", 1, "pRawInputDeviceList"); // PRAWINPUTDEVICELIST
	ADD_PARAM_NAME("GetRawInputDeviceList", 2, "puiNumDevices"); // PUINT
	ADD_PARAM_NAME("GetRawInputDeviceList", 3, "cbSize"); // UINT
	ADD_PARAM_NAME("GetRegionData", 1, "hrgn"); // HRGN
	ADD_PARAM_NAME("GetRegionData", 2, "nCount"); // DWORD
	ADD_PARAM_NAME("GetRegionData", 3, "lpRgnData"); // LPRGNDATA
	ADD_PARAM_NAME("GetRegisteredRawInputDevices", 1, "pRawInputDevices"); // PRAWINPUTDEVICE
	ADD_PARAM_NAME("GetRegisteredRawInputDevices", 2, "puiNumDevices"); // PUINT
	ADD_PARAM_NAME("GetRegisteredRawInputDevices", 3, "cbSize"); // UINT
	ADD_PARAM_NAME("GetRgnBox", 1, "hrgn"); // HRGN
	ADD_PARAM_NAME("GetRgnBox", 2, "lprc"); // LPRECT
	ADD_PARAM_NAME("GetScrollBarInfo", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetScrollBarInfo", 2, "idObject"); // LONG
	ADD_PARAM_NAME("GetScrollBarInfo", 3, "psbi"); // PSCROLLBARINFO
	ADD_PARAM_NAME("GetScrollInfo", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetScrollInfo", 2, "nBar"); // int
	ADD_PARAM_NAME("GetScrollInfo", 3, "lpsi"); // LPSCROLLINFO
	ADD_PARAM_NAME("GetScrollPos", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetScrollPos", 2, "nBar"); // int
	ADD_PARAM_NAME("GetScrollRange", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetScrollRange", 2, "nBar"); // int
	ADD_PARAM_NAME("GetScrollRange", 3, "lpMinPos"); // LPINT
	ADD_PARAM_NAME("GetScrollRange", 4, "lpMaxPos"); // LPINT
	ADD_PARAM_NAME("GetSecurityDescriptorControl", 1, "pSecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("GetSecurityDescriptorControl", 2, "pControl"); // PSECURITY_DESCRIPTOR_CONTROL
	ADD_PARAM_NAME("GetSecurityDescriptorControl", 3, "lpdwRevision"); // LPDWORD
	ADD_PARAM_NAME("GetSecurityDescriptorDacl", 1, "pSecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("GetSecurityDescriptorDacl", 2, "lpbDaclPresent"); // LPBOOL
	ADD_PARAM_NAME("GetSecurityDescriptorDacl", 3, "pDacl"); // PACL *
	ADD_PARAM_NAME("GetSecurityDescriptorDacl", 4, "lpbDaclDefaulted"); // LPBOOL
	ADD_PARAM_NAME("GetSecurityDescriptorGroup", 1, "pSecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("GetSecurityDescriptorGroup", 2, "pGroup"); // PSID *
	ADD_PARAM_NAME("GetSecurityDescriptorGroup", 3, "lpbGroupDefaulted"); // LPBOOL
	ADD_PARAM_NAME("GetSecurityDescriptorLength", 1, "pSecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("GetSecurityDescriptorOwner", 1, "pSecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("GetSecurityDescriptorOwner", 2, "pOwner"); // PSID *
	ADD_PARAM_NAME("GetSecurityDescriptorOwner", 3, "lpbOwnerDefaulted"); // LPBOOL
	ADD_PARAM_NAME("GetSecurityDescriptorRMControl", 1, "SecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("GetSecurityDescriptorRMControl", 2, "RMControl"); // PUCHAR
	ADD_PARAM_NAME("GetSecurityDescriptorSacl", 1, "pSecurityDescriptor"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("GetSecurityDescriptorSacl", 2, "lpbSaclPresent"); // LPBOOL
	ADD_PARAM_NAME("GetSecurityDescriptorSacl", 3, "pSacl"); // PACL *
	ADD_PARAM_NAME("GetSecurityDescriptorSacl", 4, "lpbSaclDefaulted"); // LPBOOL
	ADD_PARAM_NAME("GetServiceDisplayNameA", 1, "hSCManager"); // SC_HANDLE
	ADD_PARAM_NAME("GetServiceDisplayNameA", 2, "lpServiceName"); // LPCSTR
	ADD_PARAM_NAME("GetServiceDisplayNameA", 3, "lpDisplayName"); // LPSTR
	ADD_PARAM_NAME("GetServiceDisplayNameA", 4, "lpcchBuffer"); // LPDWORD
	ADD_PARAM_NAME("GetServiceDisplayNameW", 1, "hSCManager"); // SC_HANDLE
	ADD_PARAM_NAME("GetServiceDisplayNameW", 2, "lpServiceName"); // LPCWSTR
	ADD_PARAM_NAME("GetServiceDisplayNameW", 3, "lpDisplayName"); // LPWSTR
	ADD_PARAM_NAME("GetServiceDisplayNameW", 4, "lpcchBuffer"); // LPDWORD
	ADD_PARAM_NAME("GetServiceKeyNameA", 1, "hSCManager"); // SC_HANDLE
	ADD_PARAM_NAME("GetServiceKeyNameA", 2, "lpDisplayName"); // LPCSTR
	ADD_PARAM_NAME("GetServiceKeyNameA", 3, "lpServiceName"); // LPSTR
	ADD_PARAM_NAME("GetServiceKeyNameA", 4, "lpcchBuffer"); // LPDWORD
	ADD_PARAM_NAME("GetServiceKeyNameW", 1, "hSCManager"); // SC_HANDLE
	ADD_PARAM_NAME("GetServiceKeyNameW", 2, "lpDisplayName"); // LPCWSTR
	ADD_PARAM_NAME("GetServiceKeyNameW", 3, "lpServiceName"); // LPWSTR
	ADD_PARAM_NAME("GetServiceKeyNameW", 4, "lpcchBuffer"); // LPDWORD
	ADD_PARAM_NAME("GetShortPathNameA", 1, "lpszLongPath"); // LPCSTR
	ADD_PARAM_NAME("GetShortPathNameA", 2, "lpszShortPath"); // LPSTR
	ADD_PARAM_NAME("GetShortPathNameA", 3, "cchBuffer"); // DWORD
	ADD_PARAM_NAME("GetShortPathNameW", 1, "lpszLongPath"); // LPCWSTR
	ADD_PARAM_NAME("GetShortPathNameW", 2, "lpszShortPath"); // LPWSTR
	ADD_PARAM_NAME("GetShortPathNameW", 3, "cchBuffer"); // DWORD
	ADD_PARAM_NAME("GetSidIdentifierAuthority", 1, "pSid"); // PSID
	ADD_PARAM_NAME("GetSidLengthRequired", 1, "nSubAuthorityCount"); // UCHAR
	ADD_PARAM_NAME("GetSidSubAuthority", 1, "pSid"); // PSID
	ADD_PARAM_NAME("GetSidSubAuthority", 2, "nSubAuthority"); // DWORD
	ADD_PARAM_NAME("GetSidSubAuthorityCount", 1, "pSid"); // PSID
	ADD_PARAM_NAME("GetSpoolFileHandleA", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("GetSpoolFileHandleW", 1, "hPrinter"); // HANDLE
	ADD_PARAM_NAME("GetStartupInfoA", 1, "lpStartupInfo"); // LPSTARTUPINFOA
	ADD_PARAM_NAME("GetStartupInfoW", 1, "lpStartupInfo"); // LPSTARTUPINFOW
	ADD_PARAM_NAME("GetStdHandle", 1, "nStdHandle"); // DWORD
	ADD_PARAM_NAME("GetStockObject", 1, "i"); // int
	ADD_PARAM_NAME("GetStretchBltMode", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetStringScripts", 1, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetStringScripts", 2, "lpString"); // LPCWSTR
	ADD_PARAM_NAME("GetStringScripts", 3, "cchString"); // int
	ADD_PARAM_NAME("GetStringScripts", 4, "lpScripts"); // LPWSTR
	ADD_PARAM_NAME("GetStringScripts", 5, "cchScripts"); // int
	ADD_PARAM_NAME("GetStringTypeA", 1, "Locale"); // LCID
	ADD_PARAM_NAME("GetStringTypeA", 2, "dwInfoType"); // DWORD
	ADD_PARAM_NAME("GetStringTypeA", 3, "lpSrcStr"); // LPCSTR
	ADD_PARAM_NAME("GetStringTypeA", 4, "cchSrc"); // int
	ADD_PARAM_NAME("GetStringTypeA", 5, "lpCharType"); // LPWORD
	ADD_PARAM_NAME("GetStringTypeExA", 1, "Locale"); // LCID
	ADD_PARAM_NAME("GetStringTypeExA", 2, "dwInfoType"); // DWORD
	ADD_PARAM_NAME("GetStringTypeExA", 3, "lpSrcStr"); // LPCSTR
	ADD_PARAM_NAME("GetStringTypeExA", 4, "cchSrc"); // int
	ADD_PARAM_NAME("GetStringTypeExA", 5, "lpCharType"); // LPWORD
	ADD_PARAM_NAME("GetStringTypeExW", 1, "Locale"); // LCID
	ADD_PARAM_NAME("GetStringTypeExW", 2, "dwInfoType"); // DWORD
	ADD_PARAM_NAME("GetStringTypeExW", 3, "lpSrcStr"); // LPCWSTR
	ADD_PARAM_NAME("GetStringTypeExW", 4, "cchSrc"); // int
	ADD_PARAM_NAME("GetStringTypeExW", 5, "lpCharType"); // LPWORD
	ADD_PARAM_NAME("GetStringTypeW", 1, "dwInfoType"); // DWORD
	ADD_PARAM_NAME("GetStringTypeW", 2, "lpSrcStr"); // LPCWSTR
	ADD_PARAM_NAME("GetStringTypeW", 3, "cchSrc"); // int
	ADD_PARAM_NAME("GetStringTypeW", 4, "lpCharType"); // LPWORD
	ADD_PARAM_NAME("GetSubMenu", 1, "hMenu"); // HMENU
	ADD_PARAM_NAME("GetSubMenu", 2, "nPos"); // int
	ADD_PARAM_NAME("GetSysColor", 1, "nIndex"); // int
	ADD_PARAM_NAME("GetSysColorBrush", 1, "nIndex"); // int
	ADD_PARAM_NAME("GetSystemDefaultLocaleName", 1, "lpLocaleName"); // LPWSTR
	ADD_PARAM_NAME("GetSystemDefaultLocaleName", 2, "cchLocaleName"); // int
	ADD_PARAM_NAME("GetSystemDirectoryA", 1, "lpBuffer"); // LPSTR
	ADD_PARAM_NAME("GetSystemDirectoryA", 2, "uSize"); // UINT
	ADD_PARAM_NAME("GetSystemDirectoryW", 1, "lpBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetSystemDirectoryW", 2, "uSize"); // UINT
	ADD_PARAM_NAME("GetSystemFileCacheSize", 1, "lpMinimumFileCacheSize"); // PSIZE_T
	ADD_PARAM_NAME("GetSystemFileCacheSize", 2, "lpMaximumFileCacheSize"); // PSIZE_T
	ADD_PARAM_NAME("GetSystemFileCacheSize", 3, "lpFlags"); // PDWORD
	ADD_PARAM_NAME("GetSystemFirmwareTable", 1, "FirmwareTableProviderSignature"); // DWORD
	ADD_PARAM_NAME("GetSystemFirmwareTable", 2, "FirmwareTableID"); // DWORD
	ADD_PARAM_NAME("GetSystemFirmwareTable", 3, "pFirmwareTableBuffer"); // PVOID
	ADD_PARAM_NAME("GetSystemFirmwareTable", 4, "BufferSize"); // DWORD
	ADD_PARAM_NAME("GetSystemInfo", 1, "lpSystemInfo"); // LPSYSTEM_INFO
	ADD_PARAM_NAME("GetSystemMenu", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetSystemMenu", 2, "bRevert"); // WINBOOL
	ADD_PARAM_NAME("GetSystemMetrics", 1, "nIndex"); // int
	ADD_PARAM_NAME("GetSystemPaletteEntries", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetSystemPaletteEntries", 2, "iStart"); // UINT
	ADD_PARAM_NAME("GetSystemPaletteEntries", 3, "cEntries"); // UINT
	ADD_PARAM_NAME("GetSystemPaletteEntries", 4, "pPalEntries"); // LPPALETTEENTRY
	ADD_PARAM_NAME("GetSystemPaletteUse", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetSystemPowerStatus", 1, "lpSystemPowerStatus"); // LPSYSTEM_POWER_STATUS
	ADD_PARAM_NAME("GetSystemPreferredUILanguages", 1, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetSystemPreferredUILanguages", 2, "pulNumLanguages"); // PULONG
	ADD_PARAM_NAME("GetSystemPreferredUILanguages", 3, "pwszLanguagesBuffer"); // PZZWSTR
	ADD_PARAM_NAME("GetSystemPreferredUILanguages", 4, "pcchLanguagesBuffer"); // PULONG
	ADD_PARAM_NAME("GetSystemRegistryQuota", 1, "pdwQuotaAllowed"); // PDWORD
	ADD_PARAM_NAME("GetSystemRegistryQuota", 2, "pdwQuotaUsed"); // PDWORD
	ADD_PARAM_NAME("GetSystemTime", 1, "lpSystemTime"); // LPSYSTEMTIME
	ADD_PARAM_NAME("GetSystemTimeAdjustment", 1, "lpTimeAdjustment"); // PDWORD
	ADD_PARAM_NAME("GetSystemTimeAdjustment", 2, "lpTimeIncrement"); // PDWORD
	ADD_PARAM_NAME("GetSystemTimeAdjustment", 3, "lpTimeAdjustmentDisabled"); // PBOOL
	ADD_PARAM_NAME("GetSystemTimeAsFileTime", 1, "lpSystemTimeAsFileTime"); // LPFILETIME
	ADD_PARAM_NAME("GetSystemTimes", 1, "lpIdleTime"); // LPFILETIME
	ADD_PARAM_NAME("GetSystemTimes", 2, "lpKernelTime"); // LPFILETIME
	ADD_PARAM_NAME("GetSystemTimes", 3, "lpUserTime"); // LPFILETIME
	ADD_PARAM_NAME("GetSystemWindowsDirectoryA", 1, "lpBuffer"); // LPSTR
	ADD_PARAM_NAME("GetSystemWindowsDirectoryA", 2, "uSize"); // UINT
	ADD_PARAM_NAME("GetSystemWindowsDirectoryW", 1, "lpBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetSystemWindowsDirectoryW", 2, "uSize"); // UINT
	ADD_PARAM_NAME("GetSystemWow64DirectoryA", 1, "lpBuffer"); // LPSTR
	ADD_PARAM_NAME("GetSystemWow64DirectoryA", 2, "uSize"); // UINT
	ADD_PARAM_NAME("GetSystemWow64DirectoryW", 1, "lpBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetSystemWow64DirectoryW", 2, "uSize"); // UINT
	ADD_PARAM_NAME("GetTabbedTextExtentA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetTabbedTextExtentA", 2, "lpString"); // LPCSTR
	ADD_PARAM_NAME("GetTabbedTextExtentA", 3, "chCount"); // int
	ADD_PARAM_NAME("GetTabbedTextExtentA", 4, "nTabPositions"); // int
	ADD_PARAM_NAME("GetTabbedTextExtentA", 5, "lpnTabStopPositions"); // CONST INT *
	ADD_PARAM_NAME("GetTabbedTextExtentW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetTabbedTextExtentW", 2, "lpString"); // LPCWSTR
	ADD_PARAM_NAME("GetTabbedTextExtentW", 3, "chCount"); // int
	ADD_PARAM_NAME("GetTabbedTextExtentW", 4, "nTabPositions"); // int
	ADD_PARAM_NAME("GetTabbedTextExtentW", 5, "lpnTabStopPositions"); // CONST INT *
	ADD_PARAM_NAME("GetTapeParameters", 1, "hDevice"); // HANDLE
	ADD_PARAM_NAME("GetTapeParameters", 2, "dwOperation"); // DWORD
	ADD_PARAM_NAME("GetTapeParameters", 3, "lpdwSize"); // LPDWORD
	ADD_PARAM_NAME("GetTapeParameters", 4, "lpTapeInformation"); // LPVOID
	ADD_PARAM_NAME("GetTapePosition", 1, "hDevice"); // HANDLE
	ADD_PARAM_NAME("GetTapePosition", 2, "dwPositionType"); // DWORD
	ADD_PARAM_NAME("GetTapePosition", 3, "lpdwPartition"); // LPDWORD
	ADD_PARAM_NAME("GetTapePosition", 4, "lpdwOffsetLow"); // LPDWORD
	ADD_PARAM_NAME("GetTapePosition", 5, "lpdwOffsetHigh"); // LPDWORD
	ADD_PARAM_NAME("GetTapeStatus", 1, "hDevice"); // HANDLE
	ADD_PARAM_NAME("GetTempFileNameA", 1, "lpPathName"); // LPCSTR
	ADD_PARAM_NAME("GetTempFileNameA", 2, "lpPrefixString"); // LPCSTR
	ADD_PARAM_NAME("GetTempFileNameA", 3, "uUnique"); // UINT
	ADD_PARAM_NAME("GetTempFileNameA", 4, "lpTempFileName"); // LPSTR
	ADD_PARAM_NAME("GetTempFileNameW", 1, "lpPathName"); // LPCWSTR
	ADD_PARAM_NAME("GetTempFileNameW", 2, "lpPrefixString"); // LPCWSTR
	ADD_PARAM_NAME("GetTempFileNameW", 3, "uUnique"); // UINT
	ADD_PARAM_NAME("GetTempFileNameW", 4, "lpTempFileName"); // LPWSTR
	ADD_PARAM_NAME("GetTempPathA", 1, "nBufferLength"); // DWORD
	ADD_PARAM_NAME("GetTempPathA", 2, "lpBuffer"); // LPSTR
	ADD_PARAM_NAME("GetTempPathW", 1, "nBufferLength"); // DWORD
	ADD_PARAM_NAME("GetTempPathW", 2, "lpBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetTextAlign", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetTextCharacterExtra", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetTextCharset", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetTextCharsetInfo", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetTextCharsetInfo", 2, "lpSig"); // LPFONTSIGNATURE
	ADD_PARAM_NAME("GetTextCharsetInfo", 3, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetTextColor", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetTextExtentExPointA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetTextExtentExPointA", 2, "lpszString"); // LPCSTR
	ADD_PARAM_NAME("GetTextExtentExPointA", 3, "cchString"); // int
	ADD_PARAM_NAME("GetTextExtentExPointA", 4, "nMaxExtent"); // int
	ADD_PARAM_NAME("GetTextExtentExPointA", 5, "lpnFit"); // LPINT
	ADD_PARAM_NAME("GetTextExtentExPointA", 6, "lpnDx"); // LPINT
	ADD_PARAM_NAME("GetTextExtentExPointA", 7, "lpSize"); // LPSIZE
	ADD_PARAM_NAME("GetTextExtentExPointI", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetTextExtentExPointI", 2, "lpwszString"); // LPWORD
	ADD_PARAM_NAME("GetTextExtentExPointI", 3, "cwchString"); // int
	ADD_PARAM_NAME("GetTextExtentExPointI", 4, "nMaxExtent"); // int
	ADD_PARAM_NAME("GetTextExtentExPointI", 5, "lpnFit"); // LPINT
	ADD_PARAM_NAME("GetTextExtentExPointI", 6, "lpnDx"); // LPINT
	ADD_PARAM_NAME("GetTextExtentExPointI", 7, "lpSize"); // LPSIZE
	ADD_PARAM_NAME("GetTextExtentExPointW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetTextExtentExPointW", 2, "lpszString"); // LPCWSTR
	ADD_PARAM_NAME("GetTextExtentExPointW", 3, "cchString"); // int
	ADD_PARAM_NAME("GetTextExtentExPointW", 4, "nMaxExtent"); // int
	ADD_PARAM_NAME("GetTextExtentExPointW", 5, "lpnFit"); // LPINT
	ADD_PARAM_NAME("GetTextExtentExPointW", 6, "lpnDx"); // LPINT
	ADD_PARAM_NAME("GetTextExtentExPointW", 7, "lpSize"); // LPSIZE
	ADD_PARAM_NAME("GetTextExtentPoint32A", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetTextExtentPoint32A", 2, "lpString"); // LPCSTR
	ADD_PARAM_NAME("GetTextExtentPoint32A", 3, "c"); // int
	ADD_PARAM_NAME("GetTextExtentPoint32A", 4, "psizl"); // LPSIZE
	ADD_PARAM_NAME("GetTextExtentPoint32W", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetTextExtentPoint32W", 2, "lpString"); // LPCWSTR
	ADD_PARAM_NAME("GetTextExtentPoint32W", 3, "c"); // int
	ADD_PARAM_NAME("GetTextExtentPoint32W", 4, "psizl"); // LPSIZE
	ADD_PARAM_NAME("GetTextExtentPointA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetTextExtentPointA", 2, "lpString"); // LPCSTR
	ADD_PARAM_NAME("GetTextExtentPointA", 3, "c"); // int
	ADD_PARAM_NAME("GetTextExtentPointA", 4, "lpsz"); // LPSIZE
	ADD_PARAM_NAME("GetTextExtentPointI", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetTextExtentPointI", 2, "pgiIn"); // LPWORD
	ADD_PARAM_NAME("GetTextExtentPointI", 3, "cgi"); // int
	ADD_PARAM_NAME("GetTextExtentPointI", 4, "psize"); // LPSIZE
	ADD_PARAM_NAME("GetTextExtentPointW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetTextExtentPointW", 2, "lpString"); // LPCWSTR
	ADD_PARAM_NAME("GetTextExtentPointW", 3, "c"); // int
	ADD_PARAM_NAME("GetTextExtentPointW", 4, "lpsz"); // LPSIZE
	ADD_PARAM_NAME("GetTextFaceA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetTextFaceA", 2, "c"); // int
	ADD_PARAM_NAME("GetTextFaceA", 3, "lpName"); // LPSTR
	ADD_PARAM_NAME("GetTextFaceW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetTextFaceW", 2, "c"); // int
	ADD_PARAM_NAME("GetTextFaceW", 3, "lpName"); // LPWSTR
	ADD_PARAM_NAME("GetTextMetricsA", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetTextMetricsA", 2, "lptm"); // LPTEXTMETRICA
	ADD_PARAM_NAME("GetTextMetricsW", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetTextMetricsW", 2, "lptm"); // LPTEXTMETRICW
	ADD_PARAM_NAME("GetThreadContext", 1, "hThread"); // HANDLE
	ADD_PARAM_NAME("GetThreadContext", 2, "lpContext"); // LPCONTEXT
	ADD_PARAM_NAME("GetThreadDesktop", 1, "dwThreadId"); // DWORD
	ADD_PARAM_NAME("GetThreadGroupAffinity", 1, "hThread"); // HANDLE
	ADD_PARAM_NAME("GetThreadGroupAffinity", 2, "GroupAffinity"); // PGROUP_AFFINITY
	ADD_PARAM_NAME("GetThreadIOPendingFlag", 1, "hThread"); // HANDLE
	ADD_PARAM_NAME("GetThreadIOPendingFlag", 2, "lpIOIsPending"); // PBOOL
	ADD_PARAM_NAME("GetThreadId", 1, "Thread"); // HANDLE
	ADD_PARAM_NAME("GetThreadIdealProcessorEx", 1, "hThread"); // HANDLE
	ADD_PARAM_NAME("GetThreadIdealProcessorEx", 2, "lpIdealProcessor"); // PPROCESSOR_NUMBER
	ADD_PARAM_NAME("GetThreadPreferredUILanguages", 1, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetThreadPreferredUILanguages", 2, "pulNumLanguages"); // PULONG
	ADD_PARAM_NAME("GetThreadPreferredUILanguages", 3, "pwszLanguagesBuffer"); // PZZWSTR
	ADD_PARAM_NAME("GetThreadPreferredUILanguages", 4, "pcchLanguagesBuffer"); // PULONG
	ADD_PARAM_NAME("GetThreadPriority", 1, "hThread"); // HANDLE
	ADD_PARAM_NAME("GetThreadPriorityBoost", 1, "hThread"); // HANDLE
	ADD_PARAM_NAME("GetThreadPriorityBoost", 2, "pDisablePriorityBoost"); // PBOOL
	ADD_PARAM_NAME("GetThreadSelectorEntry", 1, "hThread"); // HANDLE
	ADD_PARAM_NAME("GetThreadSelectorEntry", 2, "dwSelector"); // DWORD
	ADD_PARAM_NAME("GetThreadSelectorEntry", 3, "lpSelectorEntry"); // LPLDT_ENTRY
	ADD_PARAM_NAME("GetThreadTimes", 1, "hThread"); // HANDLE
	ADD_PARAM_NAME("GetThreadTimes", 2, "lpCreationTime"); // LPFILETIME
	ADD_PARAM_NAME("GetThreadTimes", 3, "lpExitTime"); // LPFILETIME
	ADD_PARAM_NAME("GetThreadTimes", 4, "lpKernelTime"); // LPFILETIME
	ADD_PARAM_NAME("GetThreadTimes", 5, "lpUserTime"); // LPFILETIME
	ADD_PARAM_NAME("GetTimeFormatA", 1, "Locale"); // LCID
	ADD_PARAM_NAME("GetTimeFormatA", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetTimeFormatA", 3, "lpTime"); // CONST SYSTEMTIME *
	ADD_PARAM_NAME("GetTimeFormatA", 4, "lpFormat"); // LPCSTR
	ADD_PARAM_NAME("GetTimeFormatA", 5, "lpTimeStr"); // LPSTR
	ADD_PARAM_NAME("GetTimeFormatA", 6, "cchTime"); // int
	ADD_PARAM_NAME("GetTimeFormatEx", 1, "lpLocaleName"); // LPCWSTR
	ADD_PARAM_NAME("GetTimeFormatEx", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetTimeFormatEx", 3, "lpTime"); // const SYSTEMTIME *
	ADD_PARAM_NAME("GetTimeFormatEx", 4, "lpFormat"); // LPCWSTR
	ADD_PARAM_NAME("GetTimeFormatEx", 5, "lpTimeStr"); // LPWSTR
	ADD_PARAM_NAME("GetTimeFormatEx", 6, "cchTime"); // int
	ADD_PARAM_NAME("GetTimeFormatW", 1, "Locale"); // LCID
	ADD_PARAM_NAME("GetTimeFormatW", 2, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetTimeFormatW", 3, "lpTime"); // CONST SYSTEMTIME *
	ADD_PARAM_NAME("GetTimeFormatW", 4, "lpFormat"); // LPCWSTR
	ADD_PARAM_NAME("GetTimeFormatW", 5, "lpTimeStr"); // LPWSTR
	ADD_PARAM_NAME("GetTimeFormatW", 6, "cchTime"); // int
	ADD_PARAM_NAME("GetTimeZoneInformation", 1, "lpTimeZoneInformation"); // LPTIME_ZONE_INFORMATION
	ADD_PARAM_NAME("GetTimeZoneInformationForYear", 1, "wYear"); // USHORT
	ADD_PARAM_NAME("GetTimeZoneInformationForYear", 2, "pdtzi"); // PDYNAMIC_TIME_ZONE_INFORMATION
	ADD_PARAM_NAME("GetTimeZoneInformationForYear", 3, "ptzi"); // LPTIME_ZONE_INFORMATION
	ADD_PARAM_NAME("GetTitleBarInfo", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetTitleBarInfo", 2, "pti"); // PTITLEBARINFO
	ADD_PARAM_NAME("GetTokenInformation", 1, "TokenHandle"); // HANDLE
	ADD_PARAM_NAME("GetTokenInformation", 2, "TokenInformationClass"); // TOKEN_INFORMATION_CLASS
	ADD_PARAM_NAME("GetTokenInformation", 3, "TokenInformation"); // LPVOID
	ADD_PARAM_NAME("GetTokenInformation", 4, "TokenInformationLength"); // DWORD
	ADD_PARAM_NAME("GetTokenInformation", 5, "ReturnLength"); // PDWORD
	ADD_PARAM_NAME("GetTopWindow", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetTouchInputInfo", 1, "hTouchInput"); // HANDLE
	ADD_PARAM_NAME("GetTouchInputInfo", 2, "cInputs"); // UINT
	ADD_PARAM_NAME("GetTouchInputInfo", 3, "pInputs"); // PTOUCHINPUT
	ADD_PARAM_NAME("GetTouchInputInfo", 4, "cbSize"); // int
	ADD_PARAM_NAME("GetUILanguageInfo", 1, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetUILanguageInfo", 2, "pwmszLanguage"); // PCZZWSTR
	ADD_PARAM_NAME("GetUILanguageInfo", 3, "pwszFallbackLanguages"); // PZZWSTR
	ADD_PARAM_NAME("GetUILanguageInfo", 4, "pcchFallbackLanguages"); // PDWORD
	ADD_PARAM_NAME("GetUILanguageInfo", 5, "pdwAttributes"); // PDWORD
	ADD_PARAM_NAME("GetUpdateRect", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetUpdateRect", 2, "lpRect"); // LPRECT
	ADD_PARAM_NAME("GetUpdateRect", 3, "bErase"); // WINBOOL
	ADD_PARAM_NAME("GetUpdateRgn", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetUpdateRgn", 2, "hRgn"); // HRGN
	ADD_PARAM_NAME("GetUpdateRgn", 3, "bErase"); // WINBOOL
	ADD_PARAM_NAME("GetUrlCacheConfigInfoA", 1, "lpCacheConfigInfo"); // LPINTERNET_CACHE_CONFIG_INFOA
	ADD_PARAM_NAME("GetUrlCacheConfigInfoA", 2, "lpcbCacheConfigInfo"); // LPDWORD
	ADD_PARAM_NAME("GetUrlCacheConfigInfoA", 3, "dwFieldControl"); // DWORD
	ADD_PARAM_NAME("GetUrlCacheConfigInfoW", 1, "lpCacheConfigInfo"); // LPINTERNET_CACHE_CONFIG_INFOW
	ADD_PARAM_NAME("GetUrlCacheConfigInfoW", 2, "lpcbCacheConfigInfo"); // LPDWORD
	ADD_PARAM_NAME("GetUrlCacheConfigInfoW", 3, "dwFieldControl"); // DWORD
	ADD_PARAM_NAME("GetUserDefaultLocaleName", 1, "lpLocaleName"); // LPWSTR
	ADD_PARAM_NAME("GetUserDefaultLocaleName", 2, "cchLocaleName"); // int
	ADD_PARAM_NAME("GetUserGeoID", 1, "GeoClass"); // GEOCLASS
	ADD_PARAM_NAME("GetUserNameA", 1, "lpBuffer"); // LPSTR
	ADD_PARAM_NAME("GetUserNameA", 2, "pcbBuffer"); // LPDWORD
	ADD_PARAM_NAME("GetUserNameW", 1, "lpBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetUserNameW", 2, "pcbBuffer"); // LPDWORD
	ADD_PARAM_NAME("GetUserObjectInformationA", 1, "hObj"); // HANDLE
	ADD_PARAM_NAME("GetUserObjectInformationA", 2, "nIndex"); // int
	ADD_PARAM_NAME("GetUserObjectInformationA", 3, "pvInfo"); // PVOID
	ADD_PARAM_NAME("GetUserObjectInformationA", 4, "nLength"); // DWORD
	ADD_PARAM_NAME("GetUserObjectInformationA", 5, "lpnLengthNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetUserObjectInformationW", 1, "hObj"); // HANDLE
	ADD_PARAM_NAME("GetUserObjectInformationW", 2, "nIndex"); // int
	ADD_PARAM_NAME("GetUserObjectInformationW", 3, "pvInfo"); // PVOID
	ADD_PARAM_NAME("GetUserObjectInformationW", 4, "nLength"); // DWORD
	ADD_PARAM_NAME("GetUserObjectInformationW", 5, "lpnLengthNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetUserObjectSecurity", 1, "hObj"); // HANDLE
	ADD_PARAM_NAME("GetUserObjectSecurity", 2, "pSIRequested"); // PSECURITY_INFORMATION
	ADD_PARAM_NAME("GetUserObjectSecurity", 3, "pSID"); // PSECURITY_DESCRIPTOR
	ADD_PARAM_NAME("GetUserObjectSecurity", 4, "nLength"); // DWORD
	ADD_PARAM_NAME("GetUserObjectSecurity", 5, "lpnLengthNeeded"); // LPDWORD
	ADD_PARAM_NAME("GetUserPreferredUILanguages", 1, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetUserPreferredUILanguages", 2, "pulNumLanguages"); // PULONG
	ADD_PARAM_NAME("GetUserPreferredUILanguages", 3, "pwszLanguagesBuffer"); // PZZWSTR
	ADD_PARAM_NAME("GetUserPreferredUILanguages", 4, "pcchLanguagesBuffer"); // PULONG
	ADD_PARAM_NAME("GetVersionExA", 1, "lpVersionInformation"); // LPOSVERSIONINFOA
	ADD_PARAM_NAME("GetVersionExW", 1, "lpVersionInformation"); // LPOSVERSIONINFOW
	ADD_PARAM_NAME("GetViewportExtEx", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetViewportExtEx", 2, "lpsize"); // LPSIZE
	ADD_PARAM_NAME("GetViewportOrgEx", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetViewportOrgEx", 2, "lppoint"); // LPPOINT
	ADD_PARAM_NAME("GetVolumeInformationA", 1, "lpRootPathName"); // LPCSTR
	ADD_PARAM_NAME("GetVolumeInformationA", 2, "lpVolumeNameBuffer"); // LPSTR
	ADD_PARAM_NAME("GetVolumeInformationA", 3, "nVolumeNameSize"); // DWORD
	ADD_PARAM_NAME("GetVolumeInformationA", 4, "lpVolumeSerialNumber"); // LPDWORD
	ADD_PARAM_NAME("GetVolumeInformationA", 5, "lpMaximumComponentLength"); // LPDWORD
	ADD_PARAM_NAME("GetVolumeInformationA", 6, "lpFileSystemFlags"); // LPDWORD
	ADD_PARAM_NAME("GetVolumeInformationA", 7, "lpFileSystemNameBuffer"); // LPSTR
	ADD_PARAM_NAME("GetVolumeInformationA", 8, "nFileSystemNameSize"); // DWORD
	ADD_PARAM_NAME("GetVolumeInformationByHandleW", 1, "hFile"); // HANDLE
	ADD_PARAM_NAME("GetVolumeInformationByHandleW", 2, "lpVolumeNameBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetVolumeInformationByHandleW", 3, "nVolumeNameSize"); // DWORD
	ADD_PARAM_NAME("GetVolumeInformationByHandleW", 4, "lpVolumeSerialNumber"); // LPDWORD
	ADD_PARAM_NAME("GetVolumeInformationByHandleW", 5, "lpMaximumComponentLength"); // LPDWORD
	ADD_PARAM_NAME("GetVolumeInformationByHandleW", 6, "lpFileSystemFlags"); // LPDWORD
	ADD_PARAM_NAME("GetVolumeInformationByHandleW", 7, "lpFileSystemNameBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetVolumeInformationByHandleW", 8, "nFileSystemNameSize"); // DWORD
	ADD_PARAM_NAME("GetVolumeInformationW", 1, "lpRootPathName"); // LPCWSTR
	ADD_PARAM_NAME("GetVolumeInformationW", 2, "lpVolumeNameBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetVolumeInformationW", 3, "nVolumeNameSize"); // DWORD
	ADD_PARAM_NAME("GetVolumeInformationW", 4, "lpVolumeSerialNumber"); // LPDWORD
	ADD_PARAM_NAME("GetVolumeInformationW", 5, "lpMaximumComponentLength"); // LPDWORD
	ADD_PARAM_NAME("GetVolumeInformationW", 6, "lpFileSystemFlags"); // LPDWORD
	ADD_PARAM_NAME("GetVolumeInformationW", 7, "lpFileSystemNameBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetVolumeInformationW", 8, "nFileSystemNameSize"); // DWORD
	ADD_PARAM_NAME("GetVolumeNameForVolumeMountPointA", 1, "lpszVolumeMountPoint"); // LPCSTR
	ADD_PARAM_NAME("GetVolumeNameForVolumeMountPointA", 2, "lpszVolumeName"); // LPSTR
	ADD_PARAM_NAME("GetVolumeNameForVolumeMountPointA", 3, "cchBufferLength"); // DWORD
	ADD_PARAM_NAME("GetVolumeNameForVolumeMountPointW", 1, "lpszVolumeMountPoint"); // LPCWSTR
	ADD_PARAM_NAME("GetVolumeNameForVolumeMountPointW", 2, "lpszVolumeName"); // LPWSTR
	ADD_PARAM_NAME("GetVolumeNameForVolumeMountPointW", 3, "cchBufferLength"); // DWORD
	ADD_PARAM_NAME("GetVolumePathNameA", 1, "lpszFileName"); // LPCSTR
	ADD_PARAM_NAME("GetVolumePathNameA", 2, "lpszVolumePathName"); // LPSTR
	ADD_PARAM_NAME("GetVolumePathNameA", 3, "cchBufferLength"); // DWORD
	ADD_PARAM_NAME("GetVolumePathNameW", 1, "lpszFileName"); // LPCWSTR
	ADD_PARAM_NAME("GetVolumePathNameW", 2, "lpszVolumePathName"); // LPWSTR
	ADD_PARAM_NAME("GetVolumePathNameW", 3, "cchBufferLength"); // DWORD
	ADD_PARAM_NAME("GetVolumePathNamesForVolumeNameA", 1, "lpszVolumeName"); // LPCSTR
	ADD_PARAM_NAME("GetVolumePathNamesForVolumeNameA", 2, "lpszVolumePathNames"); // LPCH
	ADD_PARAM_NAME("GetVolumePathNamesForVolumeNameA", 3, "cchBufferLength"); // DWORD
	ADD_PARAM_NAME("GetVolumePathNamesForVolumeNameA", 4, "lpcchReturnLength"); // PDWORD
	ADD_PARAM_NAME("GetVolumePathNamesForVolumeNameW", 1, "lpszVolumeName"); // LPCWSTR
	ADD_PARAM_NAME("GetVolumePathNamesForVolumeNameW", 2, "lpszVolumePathNames"); // LPWCH
	ADD_PARAM_NAME("GetVolumePathNamesForVolumeNameW", 3, "cchBufferLength"); // DWORD
	ADD_PARAM_NAME("GetVolumePathNamesForVolumeNameW", 4, "lpcchReturnLength"); // PDWORD
	ADD_PARAM_NAME("GetWinMetaFileBits", 1, "hemf"); // HENHMETAFILE
	ADD_PARAM_NAME("GetWinMetaFileBits", 2, "cbData16"); // UINT
	ADD_PARAM_NAME("GetWinMetaFileBits", 3, "pData16"); // LPBYTE
	ADD_PARAM_NAME("GetWinMetaFileBits", 4, "iMapMode"); // INT
	ADD_PARAM_NAME("GetWinMetaFileBits", 5, "hdcRef"); // HDC
	ADD_PARAM_NAME("GetWindow", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetWindow", 2, "uCmd"); // UINT
	ADD_PARAM_NAME("GetWindowContextHelpId", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetWindowDC", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetWindowExtEx", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetWindowExtEx", 2, "lpsize"); // LPSIZE
	ADD_PARAM_NAME("GetWindowInfo", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetWindowInfo", 2, "pwi"); // PWINDOWINFO
	ADD_PARAM_NAME("GetWindowLongA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetWindowLongA", 2, "nIndex"); // int
	ADD_PARAM_NAME("GetWindowLongPtrA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetWindowLongPtrA", 2, "nIndex"); // int
	ADD_PARAM_NAME("GetWindowLongPtrW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetWindowLongPtrW", 2, "nIndex"); // int
	ADD_PARAM_NAME("GetWindowLongW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetWindowLongW", 2, "nIndex"); // int
	ADD_PARAM_NAME("GetWindowModuleFileNameA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetWindowModuleFileNameA", 2, "pszFileName"); // LPSTR
	ADD_PARAM_NAME("GetWindowModuleFileNameA", 3, "cchFileNameMax"); // UINT
	ADD_PARAM_NAME("GetWindowModuleFileNameW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetWindowModuleFileNameW", 2, "pszFileName"); // LPWSTR
	ADD_PARAM_NAME("GetWindowModuleFileNameW", 3, "cchFileNameMax"); // UINT
	ADD_PARAM_NAME("GetWindowOrgEx", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetWindowOrgEx", 2, "lppoint"); // LPPOINT
	ADD_PARAM_NAME("GetWindowPlacement", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetWindowPlacement", 2, "lpwndpl"); // WINDOWPLACEMENT *
	ADD_PARAM_NAME("GetWindowRect", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetWindowRect", 2, "lpRect"); // LPRECT
	ADD_PARAM_NAME("GetWindowRgn", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetWindowRgn", 2, "hRgn"); // HRGN
	ADD_PARAM_NAME("GetWindowRgnBox", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetWindowRgnBox", 2, "lprc"); // LPRECT
	ADD_PARAM_NAME("GetWindowTextA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetWindowTextA", 2, "lpString"); // LPSTR
	ADD_PARAM_NAME("GetWindowTextA", 3, "nMaxCount"); // int
	ADD_PARAM_NAME("GetWindowTextLengthA", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetWindowTextLengthW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetWindowTextW", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetWindowTextW", 2, "lpString"); // LPWSTR
	ADD_PARAM_NAME("GetWindowTextW", 3, "nMaxCount"); // int
	ADD_PARAM_NAME("GetWindowThreadProcessId", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetWindowThreadProcessId", 2, "lpdwProcessId"); // LPDWORD
	ADD_PARAM_NAME("GetWindowWord", 1, "hWnd"); // HWND
	ADD_PARAM_NAME("GetWindowWord", 2, "nIndex"); // int
	ADD_PARAM_NAME("GetWindowsAccountDomainSid", 1, "pSid"); // PSID
	ADD_PARAM_NAME("GetWindowsAccountDomainSid", 2, "pDomainSid"); // PSID
	ADD_PARAM_NAME("GetWindowsAccountDomainSid", 3, "cbDomainSid"); // DWORD *
	ADD_PARAM_NAME("GetWindowsDirectoryA", 1, "lpBuffer"); // LPSTR
	ADD_PARAM_NAME("GetWindowsDirectoryA", 2, "uSize"); // UINT
	ADD_PARAM_NAME("GetWindowsDirectoryW", 1, "lpBuffer"); // LPWSTR
	ADD_PARAM_NAME("GetWindowsDirectoryW", 2, "uSize"); // UINT
	ADD_PARAM_NAME("GetWorldTransform", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GetWorldTransform", 2, "lpxf"); // LPXFORM
	ADD_PARAM_NAME("GetWriteWatch", 1, "dwFlags"); // DWORD
	ADD_PARAM_NAME("GetWriteWatch", 2, "lpBaseAddress"); // PVOID
	ADD_PARAM_NAME("GetWriteWatch", 3, "dwRegionSize"); // SIZE_T
	ADD_PARAM_NAME("GetWriteWatch", 4, "lpAddresses"); // PVOID *
	ADD_PARAM_NAME("GetWriteWatch", 5, "lpdwCount"); // ULONG_PTR *
	ADD_PARAM_NAME("GetWriteWatch", 6, "lpdwGranularity"); // PULONG
	ADD_PARAM_NAME("GlobalAddAtomA", 1, "lpString"); // LPCSTR
	ADD_PARAM_NAME("GlobalAddAtomW", 1, "lpString"); // LPCWSTR
	ADD_PARAM_NAME("GlobalAlloc", 1, "uFlags"); // UINT
	ADD_PARAM_NAME("GlobalAlloc", 2, "dwBytes"); // SIZE_T
	ADD_PARAM_NAME("GlobalCompact", 1, "dwMinFree"); // DWORD
	ADD_PARAM_NAME("GlobalDeleteAtom", 1, "nAtom"); // ATOM
	ADD_PARAM_NAME("GlobalFindAtomA", 1, "lpString"); // LPCSTR
	ADD_PARAM_NAME("GlobalFindAtomW", 1, "lpString"); // LPCWSTR
	ADD_PARAM_NAME("GlobalFix", 1, "hMem"); // HGLOBAL
	ADD_PARAM_NAME("GlobalFlags", 1, "hMem"); // HGLOBAL
	ADD_PARAM_NAME("GlobalFree", 1, "hMem"); // HGLOBAL
	ADD_PARAM_NAME("GlobalGetAtomNameA", 1, "nAtom"); // ATOM
	ADD_PARAM_NAME("GlobalGetAtomNameA", 2, "lpBuffer"); // LPSTR
	ADD_PARAM_NAME("GlobalGetAtomNameA", 3, "nSize"); // int
	ADD_PARAM_NAME("GlobalGetAtomNameW", 1, "nAtom"); // ATOM
	ADD_PARAM_NAME("GlobalGetAtomNameW", 2, "lpBuffer"); // LPWSTR
	ADD_PARAM_NAME("GlobalGetAtomNameW", 3, "nSize"); // int
	ADD_PARAM_NAME("GlobalHandle", 1, "pMem"); // LPCVOID
	ADD_PARAM_NAME("GlobalLock", 1, "hMem"); // HGLOBAL
	ADD_PARAM_NAME("GlobalMemoryStatus", 1, "lpBuffer"); // LPMEMORYSTATUS
	ADD_PARAM_NAME("GlobalMemoryStatusEx", 1, "lpBuffer"); // LPMEMORYSTATUSEX
	ADD_PARAM_NAME("GlobalReAlloc", 1, "hMem"); // HGLOBAL
	ADD_PARAM_NAME("GlobalReAlloc", 2, "dwBytes"); // SIZE_T
	ADD_PARAM_NAME("GlobalReAlloc", 3, "uFlags"); // UINT
	ADD_PARAM_NAME("GlobalSize", 1, "hMem"); // HGLOBAL
	ADD_PARAM_NAME("GlobalUnWire", 1, "hMem"); // HGLOBAL
	ADD_PARAM_NAME("GlobalUnfix", 1, "hMem"); // HGLOBAL
	ADD_PARAM_NAME("GlobalUnlock", 1, "hMem"); // HGLOBAL
	ADD_PARAM_NAME("GlobalWire", 1, "hMem"); // HGLOBAL
	ADD_PARAM_NAME("GradientFill", 1, "hdc"); // HDC
	ADD_PARAM_NAME("GradientFill", 2, "pVertex"); // PTRIVERTEX
	ADD_PARAM_NAME("GradientFill", 3, "nVertex"); // ULONG
	ADD_PARAM_NAME("GradientFill", 4, "pMesh"); // PVOID
	ADD_PARAM_NAME("GradientFill", 5, "nMesh"); // ULONG
	ADD_PARAM_NAME("GradientFill", 6, "ulMode"); // ULONG
	ADD_PARAM_NAME("GrayStringA", 1, "hDC"); // HDC
	ADD_PARAM_NAME("GrayStringA", 2, "hBrush"); // HBRUSH
	ADD_PARAM_NAME("GrayStringA", 3, "lpOutputFunc"); // GRAYSTRINGPROC
	ADD_PARAM_NAME("GrayStringA", 4, "lpData"); // LPARAM
	ADD_PARAM_NAME("GrayStringA", 5, "nCount"); // int
	ADD_PARAM_NAME("GrayStringA", 6, "X"); // int
	ADD_PARAM_NAME("GrayStringA", 7, "Y"); // int
	ADD_PARAM_NAME("GrayStringA", 8, "nWidth"); // int
	ADD_PARAM_NAME("GrayStringA", 9, "nHeight"); // int
	ADD_PARAM_NAME("GrayStringW", 1, "hDC"); // HDC
	ADD_PARAM_NAME("GrayStringW", 2, "hBrush"); // HBRUSH
	ADD_PARAM_NAME("GrayStringW", 3, "lpOutputFunc"); // GRAYSTRINGPROC
	ADD_PARAM_NAME("GrayStringW", 4, "lpData"); // LPARAM
	ADD_PARAM_NAME("GrayStringW", 5, "nCount"); // int
	ADD_PARAM_NAME("GrayStringW", 6, "X"); // int
	ADD_PARAM_NAME("GrayStringW", 7, "Y"); // int
	ADD_PARAM_NAME("GrayStringW", 8, "nWidth"); // int
	ADD_PARAM_NAME("GrayStringW", 9, "nHeight"); // int
}

} // namespace win_api
} // namespace semantics
} // namespace llvmir2hll
} // namespace retdec
