/*
 * Decompiled with CFR 0.152.
 */
package nb.deser;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import nb.deser.support.ClassDataDesc;
import nb.deser.support.ClassDetails;
import nb.deser.support.ClassField;

public class SerializationDumper {
    private final LinkedList<Byte> _data = new LinkedList();
    private String _indent = "";
    private int _handleValue = 0x7E0000;
    private final ArrayList<ClassDataDesc> _classDataDescriptions = new ArrayList();
    private boolean _enablePrinting = true;

    public static void main(String[] stringArray) throws Exception {
        SerializationDumper serializationDumper = new SerializationDumper();
        if (stringArray.length == 0 || stringArray.length > 3) {
            System.out.println("Usage:");
            System.out.println("\tSerializationDumper <hex-ascii-data>");
            System.out.println("\tSerializationDumper -f <file-containing-hex-ascii>");
            System.out.println("\tSerializationDumper -r <file-containing-raw-data>");
            System.out.println("");
            System.out.println("Rebuild a dumped stream:");
            System.out.println("\tSerializationDumper -b <input-file> <output-file>");
            return;
        }
        if (stringArray.length == 1) {
            if (stringArray[0].length() % 2 == 1) {
                System.out.println("Error: Data encoded as hex and passed on the command line must have a length that is a multiple of 2.");
                return;
            }
            for (int i = 0; i < stringArray[0].length() / 2; ++i) {
                if (Character.digit(stringArray[0].charAt(i * 2), 16) == -1 || Character.digit(stringArray[0].charAt(i * 2 + 1), 16) == -1) {
                    System.out.println("Error: Data encoded as hex and passed on the command line must only contain hex digits.");
                    return;
                }
                serializationDumper._data.add((byte)((Character.digit(stringArray[0].charAt(i * 2), 16) << 4) + Character.digit(stringArray[0].charAt(i * 2 + 1), 16)));
            }
        } else {
            if (stringArray.length == 3 && stringArray[0].toLowerCase().equals("-b")) {
                serializationDumper.rebuildStream(stringArray[1], stringArray[2]);
                return;
            }
            File file = new File(stringArray[1]);
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            if (stringArray[0].toLowerCase().equals("-f")) {
                for (int i = 0; i < byArray.length / 2; ++i) {
                    serializationDumper._data.add((byte)((Character.digit(byArray[i * 2], 16) << 4) + Character.digit(byArray[i * 2 + 1], 16)));
                }
            } else if (stringArray[0].toLowerCase().equals("-r")) {
                for (int i = 0; i < byArray.length; ++i) {
                    serializationDumper._data.add(byArray[i]);
                }
            } else if (stringArray[0].toLowerCase().equals("-b")) {
                System.out.println("Error: The -b option requires two parameters, the input file and the output file.");
                return;
            }
        }
        System.out.println("");
        serializationDumper.parseStream();
    }

    private void print(String string) {
        if (this._enablePrinting) {
            System.out.println(this._indent + string);
        }
    }

    private void increaseIndent() {
        this._indent = this._indent + "  ";
    }

    private void decreaseIndent() {
        if (this._indent.length() < 2) {
            throw new RuntimeException("Error: Illegal indentation decrease.");
        }
        this._indent = this._indent.substring(0, this._indent.length() - 2);
    }

    private String byteToHex(byte by) {
        return String.format("%02x", by);
    }

    private byte[] hexStrToBytes(String string) {
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)((Character.digit(string.charAt(i * 2), 16) << 4) + Character.digit(string.charAt(i * 2 + 1), 16));
        }
        return byArray;
    }

    private String intToHex(int n) {
        return String.format("%02x", (n & 0xFF000000) >> 24) + String.format(" %02x", (n & 0xFF0000) >> 16) + String.format(" %02x", (n & 0xFF00) >> 8) + String.format(" %02x", n & 0xFF);
    }

    private int newHandle() {
        int n = this._handleValue++;
        this.print("newHandle 0x" + this.intToHex(n));
        return n;
    }

    private void rebuildStream(String string, String string2) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream;
        System.out.println("Rebuilding serialization stream from dump: " + string);
        try {
            String string3;
            byteArrayOutputStream = new ByteArrayOutputStream();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.trim().startsWith("newHandle ") || !string3.contains("0x")) continue;
                if ((string3 = string3.trim().startsWith("Value - ") ? string3.substring(string3.lastIndexOf("0x") + 2) : string3.split("0x", 2)[1]).contains(" - ")) {
                    string3 = string3.split("-", 2)[0];
                }
                string3 = string3.replace(" ", "");
                byteArrayOutputStream.write(this.hexStrToBytes(string3));
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error: input file not found (" + string + ").");
            System.out.println(fileNotFoundException.getMessage());
            return;
        }
        catch (IOException iOException) {
            System.out.println("Error: an exception occurred whilst reading the input file (" + string + ").");
            System.out.println(iOException.getMessage());
            return;
        }
        System.out.println("Stream rebuilt, attempting to parse...");
        this._enablePrinting = false;
        for (byte by : byArray = byteArrayOutputStream.toByteArray()) {
            this._data.add(by);
        }
        try {
            this.parseStream();
        }
        catch (Exception exception) {
            System.out.println("Warning: An exception was thrown whilst attempting to parse the rebuilt stream.");
            System.out.println(exception.getMessage());
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error: exception opening output file (" + string2 + ").");
            System.out.println(fileNotFoundException.getMessage());
            return;
        }
        catch (IOException iOException) {
            System.out.println("Error: an exception occurred whilst writing the output file (" + string2 + ").");
            System.out.println(iOException.getMessage());
            return;
        }
        System.out.println("Done, rebuilt stream written to " + string2);
    }

    private void parseStream() throws Exception {
        byte by;
        if (this._data.peek() != -84) {
            by = this._data.pop();
            switch (by) {
                case 80: {
                    this.print("RMI Call - 0x50");
                    break;
                }
                case 81: {
                    this.print("RMI ReturnData - 0x51");
                    break;
                }
                case 82: {
                    this.print("RMI Ping - 0x52");
                    break;
                }
                case 83: {
                    this.print("RMI PingAck - 0x53");
                    break;
                }
                case 84: {
                    this.print("RMI DgcAck - 0x54");
                    break;
                }
                default: {
                    this.print("Unknown RMI packet type - 0x" + this.byteToHex(by));
                }
            }
        }
        by = this._data.pop();
        byte by2 = this._data.pop();
        this.print("STREAM_MAGIC - 0x" + this.byteToHex(by) + " " + this.byteToHex(by2));
        if (by != -84 || by2 != -19) {
            this.print("Invalid STREAM_MAGIC, should be 0xac ed");
            return;
        }
        by = this._data.pop();
        by2 = this._data.pop();
        this.print("STREAM_VERSION - 0x" + this.byteToHex(by) + " " + this.byteToHex(by2));
        if (by != 0 || by2 != 5) {
            this.print("Invalid STREAM_VERSION, should be 0x00 05");
        }
        this.print("Contents");
        this.increaseIndent();
        while (this._data.size() > 0) {
            this.readContentElement();
        }
        this.decreaseIndent();
    }

    private void readContentElement() {
        switch (this._data.peek()) {
            case 115: {
                this.readNewObject();
                break;
            }
            case 118: {
                this.readNewClass();
                break;
            }
            case 117: {
                this.readNewArray();
                break;
            }
            case 116: 
            case 124: {
                this.readNewString();
                break;
            }
            case 126: {
                this.readNewEnum();
                break;
            }
            case 114: 
            case 125: {
                this.readNewClassDesc();
                break;
            }
            case 113: {
                this.readPrevObject();
                break;
            }
            case 112: {
                this.readNullReference();
                break;
            }
            case 119: {
                this.readBlockData();
                break;
            }
            case 122: {
                this.readLongBlockData();
                break;
            }
            default: {
                this.print("Invalid content element type 0x" + this.byteToHex(this._data.peek()));
                throw new RuntimeException("Error: Illegal content element type.");
            }
        }
    }

    private void readNewEnum() {
        byte by = this._data.pop();
        this.print("TC_ENUM - 0x" + this.byteToHex(by));
        if (by != 126) {
            throw new RuntimeException("Error: Illegal value for TC_ENUM (should be 0x7e)");
        }
        this.increaseIndent();
        this.readClassDesc();
        this.newHandle();
        this.readNewString();
        this.decreaseIndent();
    }

    private void readNewObject() {
        byte by = this._data.pop();
        this.print("TC_OBJECT - 0x" + this.byteToHex(by));
        if (by != 115) {
            throw new RuntimeException("Error: Illegal value for TC_OBJECT (should be 0x73)");
        }
        this.increaseIndent();
        ClassDataDesc classDataDesc = this.readClassDesc();
        this.newHandle();
        this.readClassData(classDataDesc);
        this.decreaseIndent();
    }

    private ClassDataDesc readClassDesc() {
        switch (this._data.peek()) {
            case 114: 
            case 125: {
                return this.readNewClassDesc();
            }
            case 112: {
                this.readNullReference();
                return null;
            }
            case 113: {
                int n = this.readPrevObject();
                for (ClassDataDesc classDataDesc : this._classDataDescriptions) {
                    for (int i = 0; i < classDataDesc.getClassCount(); ++i) {
                        if (classDataDesc.getClassDetails(i).getHandle() != n) continue;
                        return classDataDesc.buildClassDataDescFromIndex(i);
                    }
                }
                throw new RuntimeException("Error: Invalid classDesc reference (0x" + this.intToHex(n) + ")");
            }
        }
        this.print("Invalid classDesc type 0x" + this.byteToHex(this._data.peek()));
        throw new RuntimeException("Error illegal classDesc type.");
    }

    private ClassDataDesc readNewClassDesc() {
        switch (this._data.peek()) {
            case 114: {
                ClassDataDesc classDataDesc = this.readTC_CLASSDESC();
                this._classDataDescriptions.add(classDataDesc);
                return classDataDesc;
            }
            case 125: {
                ClassDataDesc classDataDesc = this.readTC_PROXYCLASSDESC();
                this._classDataDescriptions.add(classDataDesc);
                return classDataDesc;
            }
        }
        this.print("Invalid newClassDesc type 0x" + this.byteToHex(this._data.peek()));
        throw new RuntimeException("Error illegal newClassDesc type.");
    }

    private ClassDataDesc readTC_CLASSDESC() {
        ClassDataDesc classDataDesc = new ClassDataDesc();
        byte by = this._data.pop();
        this.print("TC_CLASSDESC - 0x" + this.byteToHex(by));
        if (by != 114) {
            throw new RuntimeException("Error: Illegal value for TC_CLASSDESC (should be 0x72)");
        }
        this.increaseIndent();
        this.print("className");
        this.increaseIndent();
        classDataDesc.addClass(this.readUtf());
        this.decreaseIndent();
        this.print("serialVersionUID - 0x" + this.byteToHex(this._data.pop()) + " " + this.byteToHex(this._data.pop()) + " " + this.byteToHex(this._data.pop()) + " " + this.byteToHex(this._data.pop()) + " " + this.byteToHex(this._data.pop()) + " " + this.byteToHex(this._data.pop()) + " " + this.byteToHex(this._data.pop()) + " " + this.byteToHex(this._data.pop()));
        classDataDesc.setLastClassHandle(this.newHandle());
        this.readClassDescInfo(classDataDesc);
        this.decreaseIndent();
        return classDataDesc;
    }

    private ClassDataDesc readTC_PROXYCLASSDESC() {
        ClassDataDesc classDataDesc = new ClassDataDesc();
        byte by = this._data.pop();
        this.print("TC_PROXYCLASSDESC - 0x" + this.byteToHex(by));
        if (by != 125) {
            throw new RuntimeException("Error: Illegal value for TC_PROXYCLASSDESC (should be 0x7d)");
        }
        this.increaseIndent();
        classDataDesc.addClass("<Dynamic Proxy Class>");
        classDataDesc.setLastClassHandle(this.newHandle());
        this.readProxyClassDescInfo(classDataDesc);
        this.decreaseIndent();
        return classDataDesc;
    }

    private void readClassDescInfo(ClassDataDesc classDataDesc) {
        Object object = "";
        byte by = this._data.pop();
        if ((by & 1) == 1) {
            object = (String)object + "SC_WRITE_METHOD | ";
        }
        if ((by & 2) == 2) {
            object = (String)object + "SC_SERIALIZABLE | ";
        }
        if ((by & 4) == 4) {
            object = (String)object + "SC_EXTERNALIZABLE | ";
        }
        if ((by & 8) == 8) {
            object = (String)object + "SC_BLOCK_DATA | ";
        }
        if (((String)object).length() > 0) {
            object = ((String)object).substring(0, ((String)object).length() - 3);
        }
        this.print("classDescFlags - 0x" + this.byteToHex(by) + " - " + (String)object);
        classDataDesc.setLastClassDescFlags(by);
        if ((by & 2) == 2) {
            if ((by & 4) == 4) {
                throw new RuntimeException("Error: Illegal classDescFlags, SC_SERIALIZABLE is not compatible with SC_EXTERNALIZABLE.");
            }
            if ((by & 8) == 8) {
                throw new RuntimeException("Error: Illegal classDescFlags, SC_SERIALIZABLE is not compatible with SC_BLOCK_DATA.");
            }
        } else if ((by & 4) == 4) {
            if ((by & 1) == 1) {
                throw new RuntimeException("Error: Illegal classDescFlags, SC_EXTERNALIZABLE is not compatible with SC_WRITE_METHOD.");
            }
        } else if (by != 0) {
            throw new RuntimeException("Error: Illegal classDescFlags, must include either SC_SERIALIZABLE or SC_EXTERNALIZABLE.");
        }
        this.readFields(classDataDesc);
        this.readClassAnnotation();
        classDataDesc.addSuperClassDesc(this.readSuperClassDesc());
    }

    private void readProxyClassDescInfo(ClassDataDesc classDataDesc) {
        byte by = this._data.pop();
        byte by2 = this._data.pop();
        byte by3 = this._data.pop();
        byte by4 = this._data.pop();
        int n = (by << 24 & 0xFF000000) + (by2 << 16 & 0xFF0000) + (by3 << 8 & 0xFF00) + (by4 & 0xFF);
        this.print("Interface count - " + n + " - 0x" + this.byteToHex(by) + " " + this.byteToHex(by2) + " " + this.byteToHex(by3) + " " + this.byteToHex(by4));
        this.print("proxyInterfaceNames");
        this.increaseIndent();
        for (int i = 0; i < n; ++i) {
            this.print(i + ":");
            this.increaseIndent();
            this.readUtf();
            this.decreaseIndent();
        }
        this.decreaseIndent();
        this.readClassAnnotation();
        classDataDesc.addSuperClassDesc(this.readSuperClassDesc());
    }

    private void readClassAnnotation() {
        this.print("classAnnotations");
        this.increaseIndent();
        while (this._data.peek() != 120) {
            this.readContentElement();
        }
        this._data.pop();
        this.print("TC_ENDBLOCKDATA - 0x78");
        this.decreaseIndent();
    }

    private ClassDataDesc readSuperClassDesc() {
        this.print("superClassDesc");
        this.increaseIndent();
        ClassDataDesc classDataDesc = this.readClassDesc();
        this.decreaseIndent();
        return classDataDesc;
    }

    private void readFields(ClassDataDesc classDataDesc) {
        byte by = this._data.pop();
        byte by2 = this._data.pop();
        int n = (by << 8 & 0xFF00) + (by2 & 0xFF);
        this.print("fieldCount - " + (short)n + " - 0x" + this.byteToHex(by) + " " + this.byteToHex(by2));
        if (n > 0) {
            this.print("Fields");
            this.increaseIndent();
            for (int i = 0; i < n; ++i) {
                this.print(i + ":");
                this.increaseIndent();
                this.readFieldDesc(classDataDesc);
                this.decreaseIndent();
            }
            this.decreaseIndent();
        }
    }

    private void readFieldDesc(ClassDataDesc classDataDesc) {
        byte by = this._data.pop();
        classDataDesc.addFieldToLastClass(by);
        switch ((char)by) {
            case 'B': {
                this.print("Byte - B - 0x" + this.byteToHex(by));
                break;
            }
            case 'C': {
                this.print("Char - C - 0x" + this.byteToHex(by));
                break;
            }
            case 'D': {
                this.print("Double - D - 0x" + this.byteToHex(by));
                break;
            }
            case 'F': {
                this.print("Float - F - 0x" + this.byteToHex(by));
                break;
            }
            case 'I': {
                this.print("Int - I - 0x" + this.byteToHex(by));
                break;
            }
            case 'J': {
                this.print("Long - L - 0x" + this.byteToHex(by));
                break;
            }
            case 'S': {
                this.print("Short - S - 0x" + this.byteToHex(by));
                break;
            }
            case 'Z': {
                this.print("Boolean - Z - 0x" + this.byteToHex(by));
                break;
            }
            case '[': {
                this.print("Array - [ - 0x" + this.byteToHex(by));
                break;
            }
            case 'L': {
                this.print("Object - L - 0x" + this.byteToHex(by));
                break;
            }
            default: {
                throw new RuntimeException("Error: Illegal field type code ('" + (char)by + "', 0x" + this.byteToHex(by) + ")");
            }
        }
        this.print("fieldName");
        this.increaseIndent();
        classDataDesc.setLastFieldName(this.readUtf());
        this.decreaseIndent();
        if ((char)by == '[' || (char)by == 'L') {
            this.print("className1");
            this.increaseIndent();
            classDataDesc.setLastFieldClassName1(this.readNewString());
            this.decreaseIndent();
        }
    }

    private void readClassData(ClassDataDesc classDataDesc) {
        this.print("classdata");
        this.increaseIndent();
        if (classDataDesc != null) {
            for (int i = classDataDesc.getClassCount() - 1; i >= 0; --i) {
                boolean bl;
                ClassDetails classDetails = classDataDesc.getClassDetails(i);
                this.print(classDetails.getClassName());
                this.increaseIndent();
                if (classDetails.isSC_SERIALIZABLE()) {
                    this.print("values");
                    this.increaseIndent();
                    for (ClassField classField : classDetails.getFields()) {
                        this.readClassDataField(classField);
                    }
                    this.decreaseIndent();
                }
                boolean bl2 = bl = classDetails.isSC_SERIALIZABLE() && classDetails.isSC_WRITE_METHOD();
                if (classDetails.isSC_EXTERNALIZABLE()) {
                    if (classDetails.isSC_BLOCK_DATA()) {
                        bl = true;
                    } else {
                        this.increaseIndent();
                        this.print("Unable to parse externalContents for protocol version 1.");
                        throw new RuntimeException("Error: Unable to parse externalContents element.");
                    }
                }
                if (bl) {
                    this.print("objectAnnotation");
                    this.increaseIndent();
                    while (this._data.peek() != 120) {
                        this.readContentElement();
                    }
                    this._data.pop();
                    this.print("TC_ENDBLOCKDATA - 0x78");
                    this.decreaseIndent();
                }
                this.decreaseIndent();
            }
        } else {
            this.print("N/A");
        }
        this.decreaseIndent();
    }

    private void readClassDataField(ClassField classField) {
        this.print(classField.getName());
        this.increaseIndent();
        this.readFieldValue(classField.getTypeCode());
        this.decreaseIndent();
    }

    private void readFieldValue(byte by) {
        switch ((char)by) {
            case 'B': {
                this.readByteField();
                break;
            }
            case 'C': {
                this.readCharField();
                break;
            }
            case 'D': {
                this.readDoubleField();
                break;
            }
            case 'F': {
                this.readFloatField();
                break;
            }
            case 'I': {
                this.readIntField();
                break;
            }
            case 'J': {
                this.readLongField();
                break;
            }
            case 'S': {
                this.readShortField();
                break;
            }
            case 'Z': {
                this.readBooleanField();
                break;
            }
            case '[': {
                this.readArrayField();
                break;
            }
            case 'L': {
                this.readObjectField();
                break;
            }
            default: {
                throw new RuntimeException("Error: Illegal field type code ('" + by + "', 0x" + this.byteToHex(by) + ")");
            }
        }
    }

    private void readNewArray() {
        byte by = this._data.pop();
        this.print("TC_ARRAY - 0x" + this.byteToHex(by));
        if (by != 117) {
            throw new RuntimeException("Error: Illegal value for TC_ARRAY (should be 0x75)");
        }
        this.increaseIndent();
        ClassDataDesc classDataDesc = this.readClassDesc();
        if (classDataDesc.getClassCount() != 1) {
            throw new RuntimeException("Error: Array class description made up of more than one class.");
        }
        ClassDetails classDetails = classDataDesc.getClassDetails(0);
        if (classDetails.getClassName().charAt(0) != '[') {
            throw new RuntimeException("Error: Array class name does not begin with '['.");
        }
        this.newHandle();
        by = this._data.pop();
        byte by2 = this._data.pop();
        byte by3 = this._data.pop();
        byte by4 = this._data.pop();
        int n = (by << 24 & 0xFF000000) + (by2 << 16 & 0xFF0000) + (by3 << 8 & 0xFF00) + (by4 & 0xFF);
        this.print("Array size - " + n + " - 0x" + this.byteToHex(by) + " " + this.byteToHex(by2) + " " + this.byteToHex(by3) + " " + this.byteToHex(by4));
        this.print("Values");
        this.increaseIndent();
        for (int i = 0; i < n; ++i) {
            this.print("Index " + i + ":");
            this.increaseIndent();
            this.readFieldValue((byte)classDetails.getClassName().charAt(1));
            this.decreaseIndent();
        }
        this.decreaseIndent();
        this.decreaseIndent();
    }

    private void readNewClass() {
        byte by = this._data.pop();
        this.print("TC_CLASS - 0x" + this.byteToHex(by));
        if (by != 118) {
            throw new RuntimeException("Error: Illegal value for TC_CLASS (should be 0x76)");
        }
        this.increaseIndent();
        this.readClassDesc();
        this.decreaseIndent();
        this.newHandle();
    }

    private int readPrevObject() {
        byte by = this._data.pop();
        this.print("TC_REFERENCE - 0x" + this.byteToHex(by));
        if (by != 113) {
            throw new RuntimeException("Error: Illegal value for TC_REFERENCE (should be 0x71)");
        }
        this.increaseIndent();
        by = this._data.pop();
        byte by2 = this._data.pop();
        byte by3 = this._data.pop();
        byte by4 = this._data.pop();
        int n = (by << 24 & 0xFF000000) + (by2 << 16 & 0xFF0000) + (by3 << 8 & 0xFF00) + (by4 & 0xFF);
        this.print("Handle - " + n + " - 0x" + this.byteToHex(by) + " " + this.byteToHex(by2) + " " + this.byteToHex(by3) + " " + this.byteToHex(by4));
        this.decreaseIndent();
        return n;
    }

    private void readNullReference() {
        byte by = this._data.pop();
        this.print("TC_NULL - 0x" + this.byteToHex(by));
        if (by != 112) {
            throw new RuntimeException("Error: Illegal value for TC_NULL (should be 0x70)");
        }
    }

    private void readBlockData() {
        Object object = "";
        byte by = this._data.pop();
        this.print("TC_BLOCKDATA - 0x" + this.byteToHex(by));
        if (by != 119) {
            throw new RuntimeException("Error: Illegal value for TC_BLOCKDATA (should be 0x77)");
        }
        this.increaseIndent();
        int n = this._data.pop() & 0xFF;
        this.print("Length - " + n + " - 0x" + this.byteToHex((byte)(n & 0xFF)));
        for (int i = 0; i < n; ++i) {
            object = (String)object + this.byteToHex(this._data.pop());
        }
        this.print("Contents - 0x" + (String)object);
        this.decreaseIndent();
    }

    private void readLongBlockData() {
        Object object = "";
        byte by = this._data.pop();
        this.print("TC_BLOCKDATALONG - 0x" + this.byteToHex(by));
        if (by != 122) {
            throw new RuntimeException("Error: Illegal value for TC_BLOCKDATA (should be 0x77)");
        }
        this.increaseIndent();
        by = this._data.pop();
        byte by2 = this._data.pop();
        byte by3 = this._data.pop();
        byte by4 = this._data.pop();
        long l = (by << 24 & 0xFF000000) + (by2 << 16 & 0xFF0000) + (by3 << 8 & 0xFF00) + (by4 & 0xFF);
        this.print("Length - " + l + " - 0x" + this.byteToHex(by) + " " + this.byteToHex(by2) + " " + this.byteToHex(by3) + " " + this.byteToHex(by4));
        for (long i = 0L; i < l; ++i) {
            object = (String)object + this.byteToHex(this._data.pop());
        }
        this.print("Contents - 0x" + (String)object);
        this.decreaseIndent();
    }

    private String readNewString() {
        switch (this._data.peek()) {
            case 116: {
                return this.readTC_STRING();
            }
            case 124: {
                return this.readTC_LONGSTRING();
            }
            case 113: {
                this.readPrevObject();
                return "[TC_REF]";
            }
        }
        this.print("Invalid newString type 0x" + this.byteToHex(this._data.peek()));
        throw new RuntimeException("Error illegal newString type.");
    }

    private String readTC_STRING() {
        byte by = this._data.pop();
        this.print("TC_STRING - 0x" + this.byteToHex(by));
        if (by != 116) {
            throw new RuntimeException("Error: Illegal value for TC_STRING (should be 0x74)");
        }
        this.increaseIndent();
        this.newHandle();
        String string = this.readUtf();
        this.decreaseIndent();
        return string;
    }

    private String readTC_LONGSTRING() {
        byte by = this._data.pop();
        this.print("TC_LONGSTRING - 0x" + this.byteToHex(by));
        if (by != 124) {
            throw new RuntimeException("Error: Illegal value for TC_LONGSTRING (should be 0x7c)");
        }
        this.increaseIndent();
        this.newHandle();
        String string = this.readLongUtf();
        this.decreaseIndent();
        return string;
    }

    private String readUtf() {
        Object object = "";
        Object object2 = "";
        byte by = this._data.pop();
        byte by2 = this._data.pop();
        int n = (by << 8 & 0xFF00) + (by2 & 0xFF);
        this.print("Length - " + n + " - 0x" + this.byteToHex(by) + " " + this.byteToHex(by2));
        for (int i = 0; i < n; ++i) {
            by = this._data.pop();
            object = (String)object + (char)by;
            object2 = (String)object2 + this.byteToHex(by);
        }
        this.print("Value - " + (String)object + " - 0x" + (String)object2);
        return object;
    }

    private String readLongUtf() {
        Object object = "";
        Object object2 = "";
        byte by = this._data.pop();
        byte by2 = this._data.pop();
        byte by3 = this._data.pop();
        byte by4 = this._data.pop();
        byte by5 = this._data.pop();
        byte by6 = this._data.pop();
        byte by7 = this._data.pop();
        byte by8 = this._data.pop();
        long l = ((long)(by << 56) & 0xFF00000000000000L) + ((long)(by2 << 48) & 0xFF000000000000L) + ((long)(by3 << 40) & 0xFF0000000000L) + ((long)(by4 << 32) & 0xFF00000000L) + (long)(by5 << 24 & 0xFF000000) + (long)(by6 << 16 & 0xFF0000) + (long)(by7 << 8 & 0xFF00) + (long)(by8 & 0xFF);
        this.print("Length - " + l + " - 0x" + this.byteToHex(by) + " " + this.byteToHex(by2) + " " + this.byteToHex(by3) + " " + this.byteToHex(by4) + " " + this.byteToHex(by5) + " " + this.byteToHex(by6) + " " + this.byteToHex(by7) + " " + this.byteToHex(by8));
        for (long i = 0L; i < l; ++i) {
            by = this._data.pop();
            object = (String)object + (char)by;
            object2 = (String)object2 + this.byteToHex(by);
        }
        this.print("Value - " + (String)object + " - 0x" + (String)object2);
        return object;
    }

    private void readByteField() {
        byte by = this._data.pop();
        if (by >= 32 && by <= 126) {
            this.print("(byte)" + by + " (ASCII: " + (char)by + ") - 0x" + this.byteToHex(by));
        } else {
            this.print("(byte)" + by + " - 0x" + this.byteToHex(by));
        }
    }

    private void readCharField() {
        byte by = this._data.pop();
        byte by2 = this._data.pop();
        char c = (char)((by << 8 & 0xFF00) + (by2 & 0xFF));
        this.print("(char)" + c + " - 0x" + this.byteToHex(by) + " " + this.byteToHex(by2));
    }

    private void readDoubleField() {
        byte by = this._data.pop();
        byte by2 = this._data.pop();
        byte by3 = this._data.pop();
        byte by4 = this._data.pop();
        byte by5 = this._data.pop();
        byte by6 = this._data.pop();
        byte by7 = this._data.pop();
        byte by8 = this._data.pop();
        this.print("(double)" + Double.longBitsToDouble(((long)by << 56 & 0xFF00000000000000L) + ((long)by2 << 48 & 0xFF000000000000L) + ((long)by3 << 40 & 0xFF0000000000L) + ((long)by4 << 32 & 0xFF00000000L) + (long)(by5 << 24 & 0xFF000000) + (long)(by6 << 16 & 0xFF0000) + (long)(by7 << 8 & 0xFF00) + (long)(by8 & 0xFF)) + " - 0x" + this.byteToHex(by) + " " + this.byteToHex(by2) + " " + this.byteToHex(by3) + " " + this.byteToHex(by4) + " " + this.byteToHex(by5) + " " + this.byteToHex(by6) + " " + this.byteToHex(by7) + " " + this.byteToHex(by8));
    }

    private void readFloatField() {
        byte by = this._data.pop();
        byte by2 = this._data.pop();
        byte by3 = this._data.pop();
        byte by4 = this._data.pop();
        this.print("(float)" + Float.intBitsToFloat((by << 24 & 0xFF000000) + (by2 << 16 & 0xFF0000) + (by3 << 8 & 0xFF00) + (by4 & 0xFF)) + " - 0x" + this.byteToHex(by) + " " + this.byteToHex(by2) + " " + this.byteToHex(by3) + " " + this.byteToHex(by4));
    }

    private void readIntField() {
        byte by = this._data.pop();
        byte by2 = this._data.pop();
        byte by3 = this._data.pop();
        byte by4 = this._data.pop();
        this.print("(int)" + ((by << 24 & 0xFF000000) + (by2 << 16 & 0xFF0000) + (by3 << 8 & 0xFF00) + (by4 & 0xFF)) + " - 0x" + this.byteToHex(by) + " " + this.byteToHex(by2) + " " + this.byteToHex(by3) + " " + this.byteToHex(by4));
    }

    private void readLongField() {
        byte by = this._data.pop();
        byte by2 = this._data.pop();
        byte by3 = this._data.pop();
        byte by4 = this._data.pop();
        byte by5 = this._data.pop();
        byte by6 = this._data.pop();
        byte by7 = this._data.pop();
        byte by8 = this._data.pop();
        this.print("(long)" + (((long)(by << 56) & 0xFF00000000000000L) + ((long)(by2 << 48) & 0xFF000000000000L) + ((long)(by3 << 40) & 0xFF0000000000L) + ((long)(by4 << 32) & 0xFF00000000L) + (long)(by5 << 24 & 0xFF000000) + (long)(by6 << 16 & 0xFF0000) + (long)(by7 << 8 & 0xFF00) + (long)(by8 & 0xFF)) + " - 0x" + this.byteToHex(by) + " " + this.byteToHex(by2) + " " + this.byteToHex(by3) + " " + this.byteToHex(by4) + " " + this.byteToHex(by5) + " " + this.byteToHex(by6) + " " + this.byteToHex(by7) + " " + this.byteToHex(by8));
    }

    private void readShortField() {
        byte by = this._data.pop();
        byte by2 = this._data.pop();
        this.print("(short)" + (short)((by << 8 & 0xFF00) + (by2 & 0xFF)) + " - 0x" + this.byteToHex(by) + " " + this.byteToHex(by2));
    }

    private void readBooleanField() {
        byte by = this._data.pop();
        this.print("(boolean)" + (by == 0 ? "false" : "true") + " - 0x" + this.byteToHex(by));
    }

    private void readArrayField() {
        this.print("(array)");
        this.increaseIndent();
        switch (this._data.peek()) {
            case 112: {
                this.readNullReference();
                break;
            }
            case 117: {
                this.readNewArray();
                break;
            }
            case 113: {
                this.readPrevObject();
                break;
            }
            default: {
                throw new RuntimeException("Error: Unexpected array field value type (0x" + this.byteToHex(this._data.peek()));
            }
        }
        this.decreaseIndent();
    }

    private void readObjectField() {
        this.print("(object)");
        this.increaseIndent();
        switch (this._data.peek()) {
            case 115: {
                this.readNewObject();
                break;
            }
            case 113: {
                this.readPrevObject();
                break;
            }
            case 112: {
                this.readNullReference();
                break;
            }
            case 116: {
                this.readTC_STRING();
                break;
            }
            case 118: {
                this.readNewClass();
                break;
            }
            case 117: {
                this.readNewArray();
                break;
            }
            case 126: {
                this.readNewEnum();
                break;
            }
            default: {
                throw new RuntimeException("Error: Unexpected identifier for object field value 0x" + this.byteToHex(this._data.peek()));
            }
        }
        this.decreaseIndent();
    }
}

