#!/usr/bin/perl

package eBay::API::XML::Call::GetAttributesCS::GetAttributesCSRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetAttributesCSRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetAttributesCS::GetAttributesCSRequestType

=head1 DESCRIPTION

Retrieves an XML string that describes how to present Item
Specifics to a seller who is creating a new listing.
Use this information to present users with
the equivalent of the Item Specifics portion of the eBay Title
and Description pages and to validate selected eBay attributes on
the client before including them in an AddItem call or related
calls. The XML string contains a list of all the attributes that
are applicable for one or more requested categories, along with
related meta-data. The meta-data specifies all the possible
values of each attribute, the logic for presenting the attributes
to a user, and rules for validating the user's selections. <br>
<br>
See the eBay Web Services Guide for an overview of Item Specifics and
details about the eBay attribute model.<br>
<br>
Item Specifics are optional when listing in most categories;
however, some categories (such as Real Estate, US Tickets, and
US eBay Motors) require Item Specifics.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetAttributesCS::GetAttributesCSRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");



my @gaProperties = ( [ 'AttributeSetID', 'xs:int', '1', '', '' ]
	, [ 'AttributeSystemVersion', 'xs:string', '', '', '' ]
	, [ 'IncludeCategoryMappingDetails', 'xs:boolean', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAttributeSetID()

An array of characteristic setIDs (which always correspond to
attribute set IDs).
Each characteristic setcorresponds to a level in the eBay
category hierarchy at
which all items share common characteristics.
Multiple categories can be mapped to the same characteristic set.
AttributeSetIDs is an optional input. When IDs are specified,
the call only returns meta-data for the corresponding
characteristic sets.
When no IDs are specified, the call returns all the current
attribute meta-data in the system.

  RequiredInput: No
#    Argument: reference to an array  
                      of 'xs:int'

=cut

sub setAttributeSetID {
  my $self = shift;
  $self->{'AttributeSetID'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getAttributeSetID()

#    Returns: reference to an array  
                      of 'xs:int'

=cut

sub getAttributeSetID {
  my $self = shift;
  return $self->_getDataTypeArray('AttributeSetID');
}


=head2 setAttributeSystemVersion()

A version of the Item Specifics definitions (attribute meta-data)
for the site.
Typically, an application passes the version value that was
returned the last time the application executed this call.
Filter that causes the call to return only the characteristic sets
for which the attribute meta-data has changed since the specified
version. If not specified, all characteristics sets are returned.
The latest version value is not necessarily greater than the
previous value that was returned. Therefore, when comparing
versions, only compare whether the value has changed.

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setAttributeSystemVersion {
  my $self = shift;
  $self->{'AttributeSystemVersion'} = shift
}

=head2 getAttributeSystemVersion()

#    Returns: 'xs:string'

=cut

sub getAttributeSystemVersion {
  my $self = shift;
  return $self->{'AttributeSystemVersion'};
}


=head2 setIncludeCategoryMappingDetails()

If true, includes a list of CategoryMapping nodes in the response.
Each CategoryMapping node specifies category information as well as
attributes and values that your application can auto-fill for
items listed in that category. See the eBay Web Services Guide for more
information about options for maintaining category data and
auto-filling Item Specifics.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setIncludeCategoryMappingDetails {
  my $self = shift;
  $self->{'IncludeCategoryMappingDetails'} = shift
}

=head2 isIncludeCategoryMappingDetails()

#    Returns: 'xs:boolean'

=cut

sub isIncludeCategoryMappingDetails {
  my $self = shift;
  return $self->{'IncludeCategoryMappingDetails'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
