#!/usr/bin/perl

package eBay::API::XML::DataType::Enum::GiftServicesCodeType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GiftServicesCodeType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::Enum::GiftServicesCodeType

=head1 DESCRIPTION

Each code identifies an optional service that the seller is offering if the buyer
chooses to purchase the item as a gift. Not applicable for eBay Store Inventory
listings.



=head1 SYNOPSIS

=cut



=head1 Enums:

=cut


=head2 GiftExpressShipping

The seller is offering to ship the item via
an express shipping method as explained in the item description.



=cut


use constant GiftExpressShipping => scalar('GiftExpressShipping');


=head2 GiftShipToRecipient

The seller is offering to ship to the gift recipient
(instead of to the buyer) after payment clears.



=cut


use constant GiftShipToRecipient => scalar('GiftShipToRecipient');


=head2 GiftWrap

The seller is offering to wrap the item (and optionally include a
card) as explained in the item description.



=cut


use constant GiftWrap => scalar('GiftWrap');


=head2 CustomCode

Reserved for internal or future use



=cut


use constant CustomCode => scalar('CustomCode');







1;   
