#!/usr/bin/perl

package eBay::API::XML::DataType::ListingTipType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ListingTipType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ListingTipType

=head1 DESCRIPTION

A tip on improving a listing's details. Tips are returned from the Listing Analyzer engine.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ListingTipType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ListingTipFieldType;
use eBay::API::XML::DataType::ListingTipMessageType;


my @gaProperties = ( [ 'Field', 'ns:ListingTipFieldType', ''
	     ,'eBay::API::XML::DataType::ListingTipFieldType', '1' ]
	, [ 'ListingTipID', 'xs:string', '', '', '' ]
	, [ 'Message', 'ns:ListingTipMessageType', ''
	     ,'eBay::API::XML::DataType::ListingTipMessageType', '1' ]
	, [ 'Priority', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setField()

The item field that is associated with the tip.

#    Argument: 'ns:ListingTipFieldType'

=cut

sub setField {
  my $self = shift;
  $self->{'Field'} = shift
}

=head2 getField()

  Calls: GetItemRecommendations
  Returned: Conditionally

#    Returns: 'ns:ListingTipFieldType'

=cut

sub getField {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Field'
		,'eBay::API::XML::DataType::ListingTipFieldType');
}


=head2 setListingTipID()

Identifier for the tip. Primarily for internal use. This value may change over time.

#    Argument: 'xs:string'

=cut

sub setListingTipID {
  my $self = shift;
  $self->{'ListingTipID'} = shift
}

=head2 getListingTipID()

  Calls: GetItemRecommendations
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getListingTipID {
  my $self = shift;
  return $self->{'ListingTipID'};
}


=head2 setMessage()

The tip's message content.

#    Argument: 'ns:ListingTipMessageType'

=cut

sub setMessage {
  my $self = shift;
  $self->{'Message'} = shift
}

=head2 getMessage()

  Calls: GetItemRecommendations
  Returned: Conditionally

#    Returns: 'ns:ListingTipMessageType'

=cut

sub getMessage {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Message'
		,'eBay::API::XML::DataType::ListingTipMessageType');
}


=head2 setPriority()

The rank of the tip. All tips are ranked by importance. Ranking varies for each site.
The rank is always greater than 0.

#    Argument: 'xs:int'

=cut

sub setPriority {
  my $self = shift;
  $self->{'Priority'} = shift
}

=head2 getPriority()

  Calls: GetItemRecommendations
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getPriority {
  my $self = shift;
  return $self->{'Priority'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
