# Generated by default/object.tt
package Paws::CloudWatchEvents::ApiDestination;
  use Moose;
  has ApiDestinationArn => (is => 'ro', isa => 'Str');
  has ApiDestinationState => (is => 'ro', isa => 'Str');
  has ConnectionArn => (is => 'ro', isa => 'Str');
  has CreationTime => (is => 'ro', isa => 'Str');
  has HttpMethod => (is => 'ro', isa => 'Str');
  has InvocationEndpoint => (is => 'ro', isa => 'Str');
  has InvocationRateLimitPerSecond => (is => 'ro', isa => 'Int');
  has LastModifiedTime => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatchEvents::ApiDestination

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudWatchEvents::ApiDestination object:

  $service_obj->Method(Att1 => { ApiDestinationArn => $value, ..., Name => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudWatchEvents::ApiDestination object:

  $result = $service_obj->Method(...);
  $result->Att1->ApiDestinationArn

=head1 DESCRIPTION

Contains details about an API destination.

=head1 ATTRIBUTES


=head2 ApiDestinationArn => Str

The ARN of the API destination.


=head2 ApiDestinationState => Str

The state of the API destination.


=head2 ConnectionArn => Str

The ARN of the connection specified for the API destination.


=head2 CreationTime => Str

A time stamp for the time that the API destination was created.


=head2 HttpMethod => Str

The method to use to connect to the HTTP endpoint.


=head2 InvocationEndpoint => Str

The URL to the endpoint for the API destination.


=head2 InvocationRateLimitPerSecond => Int

The maximum number of invocations per second to send to the HTTP
endpoint.


=head2 LastModifiedTime => Str

A time stamp for the time that the API destination was last modified.


=head2 Name => Str

The name of the API destination.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudWatchEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

