# Generated by default/object.tt
package Paws::DevOpsGuru::Event;
  use Moose;
  has DataSource => (is => 'ro', isa => 'Str');
  has EventClass => (is => 'ro', isa => 'Str');
  has EventSource => (is => 'ro', isa => 'Str');
  has Id => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has ResourceCollection => (is => 'ro', isa => 'Paws::DevOpsGuru::ResourceCollection');
  has Resources => (is => 'ro', isa => 'ArrayRef[Paws::DevOpsGuru::EventResource]');
  has Time => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DevOpsGuru::Event

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DevOpsGuru::Event object:

  $service_obj->Method(Att1 => { DataSource => $value, ..., Time => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DevOpsGuru::Event object:

  $result = $service_obj->Method(...);
  $result->Att1->DataSource

=head1 DESCRIPTION

An AWS resource event. AWS resource events and metrics are analyzed by
DevOps Guru to find anomalous behavior and provide recommendations to
improve your operational solutions.

=head1 ATTRIBUTES


=head2 DataSource => Str

The source, C<AWS_CLOUD_TRAIL> or C<AWS_CODE_DEPLOY>, where DevOps Guru
analysis found the event.


=head2 EventClass => Str

The class of the event. The class specifies what the event is related
to, such as an infrastructure change, a deployment, or a schema change.


=head2 EventSource => Str

The AWS source that emitted the event.


=head2 Id => Str

The ID of the event.


=head2 Name => Str

The name of the event.


=head2 ResourceCollection => L<Paws::DevOpsGuru::ResourceCollection>




=head2 Resources => ArrayRef[L<Paws::DevOpsGuru::EventResource>]

An C<EventResource> object that contains information about the resource
that emitted the event.


=head2 Time => Str

A C<Timestamp> that specifies the time the event occurred.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DevOpsGuru>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

