# Generated by default/object.tt
package Paws::Synthetics::CanaryCodeInput;
  use Moose;
  has Handler => (is => 'ro', isa => 'Str', required => 1);
  has S3Bucket => (is => 'ro', isa => 'Str');
  has S3Key => (is => 'ro', isa => 'Str');
  has S3Version => (is => 'ro', isa => 'Str');
  has ZipFile => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Synthetics::CanaryCodeInput

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Synthetics::CanaryCodeInput object:

  $service_obj->Method(Att1 => { Handler => $value, ..., ZipFile => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Synthetics::CanaryCodeInput object:

  $result = $service_obj->Method(...);
  $result->Att1->Handler

=head1 DESCRIPTION

Use this structure to input your script code for the canary. This
structure contains the Lambda handler with the location where the
canary should start running the script. If the script is stored in an
S3 bucket, the bucket name, key, and version are also included. If the
script was passed into the canary directly, the script code is
contained in the value of C<Zipfile>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Handler => Str

The entry point to use for the source code when running the canary.
This value must end with the string C<.handler>.


=head2 S3Bucket => Str

If your canary script is located in S3, specify the full bucket name
here. The bucket must already exist. Specify the full bucket name,
including C<s3://> as the start of the bucket name.


=head2 S3Key => Str

The S3 key of your script. For more information, see Working with
Amazon S3 Objects
(https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html).


=head2 S3Version => Str

The S3 version ID of your script.


=head2 ZipFile => Str

If you input your canary script directly into the canary instead of
referring to an S3 location, the value of this parameter is the .zip
file that contains the script. It can be up to 5 MB.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Synthetics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

