# Generated by default/object.tt
package Paws::WAFV2::LoggingFilter;
  use Moose;
  has DefaultBehavior => (is => 'ro', isa => 'Str', required => 1);
  has Filters => (is => 'ro', isa => 'ArrayRef[Paws::WAFV2::Filter]', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::LoggingFilter

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::LoggingFilter object:

  $service_obj->Method(Att1 => { DefaultBehavior => $value, ..., Filters => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::LoggingFilter object:

  $result = $service_obj->Method(...);
  $result->Att1->DefaultBehavior

=head1 DESCRIPTION

Filtering that specifies which web requests are kept in the logs and
which are dropped, defined for a web ACL's LoggingConfiguration.

You can filter on the rule action and on the web request labels that
were applied by matching rules during web ACL evaluation.

=head1 ATTRIBUTES


=head2 B<REQUIRED> DefaultBehavior => Str

Default handling for logs that don't match any of the specified
filtering conditions.


=head2 B<REQUIRED> Filters => ArrayRef[L<Paws::WAFV2::Filter>]

The filters that you want to apply to the logs.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

