# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl ExpectedValue.t'

######################### We start with some black magic to print on failure.

BEGIN { $| = 1; print "1..61\n"; }
END {print "not ok 1\n" unless $loaded;}
use Carp;
use lib 't';
use strict;
use TestMAGE qw(result is_object);
use vars qw($i $loaded);
# use blib;
use Bio::MAGE;
use Bio::MAGE::Association;
use Bio::MAGE::QuantitationType::ExpectedValue;
use Bio::MAGE::QuantitationType::ConfidenceIndicator;
use Bio::MAGE::BioAssayData::QuantitationTypeMap;
use Bio::MAGE::Description::OntologyEntry;
use Bio::MAGE::NameValueType;
use Bio::MAGE::BioAssay::Channel;
use Bio::MAGE::AuditAndSecurity::Audit;
use Bio::MAGE::AuditAndSecurity::Security;
use Bio::MAGE::Description::Description;
use Bio::MAGE::QuantitationType::QuantitationType;

$loaded = 1;
$i = 1;
result($i);

######################### End of black magic.

# we test the new() method
my $expectedvalue;
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $expectedvalue = Bio::MAGE::QuantitationType::ExpectedValue->new();
}
result($expectedvalue->isa('Bio::MAGE::QuantitationType::ExpectedValue'));

# test the package class method
result($expectedvalue->package() eq q[QuantitationType]);

# test the class_name class method
result($expectedvalue->class_name() eq q[Bio::MAGE::QuantitationType::ExpectedValue]);

# set the attribute values in the call to new()
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $expectedvalue = Bio::MAGE::QuantitationType::ExpectedValue->new(isBackground => 1,
identifier => 2,
name => 3);
}
# testing attribute isBackground
result ($expectedvalue->getIsBackground() == 1);
$expectedvalue->setIsBackground(1);
result ($expectedvalue->getIsBackground() == 1);

# testing attribute identifier
result ($expectedvalue->getIdentifier() == 2);
$expectedvalue->setIdentifier(2);
result ($expectedvalue->getIdentifier() == 2);

# testing attribute name
result ($expectedvalue->getName() == 3);
$expectedvalue->setName(3);
result ($expectedvalue->getName() == 3);

# retrieve the list of association meta-data
my %assns = Bio::MAGE::QuantitationType::ExpectedValue->associations();
my $assn;

# set the association values in the call to new()
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $expectedvalue = Bio::MAGE::QuantitationType::ExpectedValue->new(targetQuantitationType => Bio::MAGE::QuantitationType::QuantitationType->new(),
channel => Bio::MAGE::BioAssay::Channel->new(),
quantitationTypeMaps => [Bio::MAGE::BioAssayData::QuantitationTypeMap->new()],
dataType => Bio::MAGE::Description::OntologyEntry->new(),
scale => Bio::MAGE::Description::OntologyEntry->new(),
confidenceIndicators => [Bio::MAGE::QuantitationType::ConfidenceIndicator->new()],
security => Bio::MAGE::AuditAndSecurity::Security->new(),
auditTrail => [Bio::MAGE::AuditAndSecurity::Audit->new()],
descriptions => [Bio::MAGE::Description::Description->new()],
propertySets => [Bio::MAGE::NameValueType->new()]);
}
# testing association targetQuantitationType
my $targetquantitationtype_assn;
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $targetquantitationtype_assn = Bio::MAGE::QuantitationType::QuantitationType->new();
}
result (UNIVERSAL::isa($expectedvalue->getTargetQuantitationType,q[Bio::MAGE::QuantitationType::QuantitationType]));
result ($expectedvalue->setTargetQuantitationType($targetquantitationtype_assn) == $targetquantitationtype_assn);
result ($expectedvalue->getTargetQuantitationType() == $targetquantitationtype_assn);



# test the meta-data for the assoication
($assn) = $assns{targetQuantitationType};
result(is_object($assn)
       and $assn->isa('Bio::MAGE::Association')
       and defined $assn->description(),
       and defined $assn->cardinality(),
       and grep {$_ eq $assn->cardinality} ('0..1','1','1..N','0..N'),
       and defined $assn->is_ref(),
       and ($assn->is_ref() == 0 or $assn->is_ref() == 1),
       and defined $assn->rank(),
       and $assn->rank(),
       and defined $assn->ordered(),
       and ($assn->ordered() == 0 or $assn->ordered() == 1),
       and defined $assn->class_name(),
       and $assn->class_name(),
       and defined $assn->name(),
       and $assn->name(),
      );
# testing association channel
my $channel_assn;
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $channel_assn = Bio::MAGE::BioAssay::Channel->new();
}
result (UNIVERSAL::isa($expectedvalue->getChannel,q[Bio::MAGE::BioAssay::Channel]));
result ($expectedvalue->setChannel($channel_assn) == $channel_assn);
result ($expectedvalue->getChannel() == $channel_assn);



# test the meta-data for the assoication
($assn) = $assns{channel};
result(is_object($assn)
       and $assn->isa('Bio::MAGE::Association')
       and defined $assn->description(),
       and defined $assn->cardinality(),
       and grep {$_ eq $assn->cardinality} ('0..1','1','1..N','0..N'),
       and defined $assn->is_ref(),
       and ($assn->is_ref() == 0 or $assn->is_ref() == 1),
       and defined $assn->rank(),
       and $assn->rank(),
       and defined $assn->ordered(),
       and ($assn->ordered() == 0 or $assn->ordered() == 1),
       and defined $assn->class_name(),
       and $assn->class_name(),
       and defined $assn->name(),
       and $assn->name(),
      );
# testing association quantitationTypeMaps
my $quantitationtypemaps_assn;
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $quantitationtypemaps_assn = Bio::MAGE::BioAssayData::QuantitationTypeMap->new();
}
result (UNIVERSAL::isa($expectedvalue->getQuantitationTypeMaps->[0],q[Bio::MAGE::BioAssayData::QuantitationTypeMap]));
result ($expectedvalue->setQuantitationTypeMaps([$quantitationtypemaps_assn]));
result (UNIVERSAL::isa($expectedvalue->getQuantitationTypeMaps,'ARRAY')
 and scalar @{$expectedvalue->getQuantitationTypeMaps()} == 1
 and $expectedvalue->getQuantitationTypeMaps->[0] == $quantitationtypemaps_assn);
$expectedvalue->addQuantitationTypeMaps($quantitationtypemaps_assn);
result (UNIVERSAL::isa($expectedvalue->getQuantitationTypeMaps,'ARRAY')
 and scalar @{$expectedvalue->getQuantitationTypeMaps()} == 2
 and $expectedvalue->getQuantitationTypeMaps->[0] == $quantitationtypemaps_assn
 and $expectedvalue->getQuantitationTypeMaps->[1] == $quantitationtypemaps_assn);


# test the meta-data for the assoication
($assn) = $assns{quantitationTypeMaps};
result(is_object($assn)
       and $assn->isa('Bio::MAGE::Association')
       and defined $assn->description(),
       and defined $assn->cardinality(),
       and grep {$_ eq $assn->cardinality} ('0..1','1','1..N','0..N'),
       and defined $assn->is_ref(),
       and ($assn->is_ref() == 0 or $assn->is_ref() == 1),
       and defined $assn->rank(),
       and $assn->rank(),
       and defined $assn->ordered(),
       and ($assn->ordered() == 0 or $assn->ordered() == 1),
       and defined $assn->class_name(),
       and $assn->class_name(),
       and defined $assn->name(),
       and $assn->name(),
      );
# testing association dataType
my $datatype_assn;
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $datatype_assn = Bio::MAGE::Description::OntologyEntry->new();
}
result (UNIVERSAL::isa($expectedvalue->getDataType,q[Bio::MAGE::Description::OntologyEntry]));
result ($expectedvalue->setDataType($datatype_assn) == $datatype_assn);
result ($expectedvalue->getDataType() == $datatype_assn);



# test the meta-data for the assoication
($assn) = $assns{dataType};
result(is_object($assn)
       and $assn->isa('Bio::MAGE::Association')
       and defined $assn->description(),
       and defined $assn->cardinality(),
       and grep {$_ eq $assn->cardinality} ('0..1','1','1..N','0..N'),
       and defined $assn->is_ref(),
       and ($assn->is_ref() == 0 or $assn->is_ref() == 1),
       and defined $assn->rank(),
       and $assn->rank(),
       and defined $assn->ordered(),
       and ($assn->ordered() == 0 or $assn->ordered() == 1),
       and defined $assn->class_name(),
       and $assn->class_name(),
       and defined $assn->name(),
       and $assn->name(),
      );
# testing association scale
my $scale_assn;
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $scale_assn = Bio::MAGE::Description::OntologyEntry->new();
}
result (UNIVERSAL::isa($expectedvalue->getScale,q[Bio::MAGE::Description::OntologyEntry]));
result ($expectedvalue->setScale($scale_assn) == $scale_assn);
result ($expectedvalue->getScale() == $scale_assn);



# test the meta-data for the assoication
($assn) = $assns{scale};
result(is_object($assn)
       and $assn->isa('Bio::MAGE::Association')
       and defined $assn->description(),
       and defined $assn->cardinality(),
       and grep {$_ eq $assn->cardinality} ('0..1','1','1..N','0..N'),
       and defined $assn->is_ref(),
       and ($assn->is_ref() == 0 or $assn->is_ref() == 1),
       and defined $assn->rank(),
       and $assn->rank(),
       and defined $assn->ordered(),
       and ($assn->ordered() == 0 or $assn->ordered() == 1),
       and defined $assn->class_name(),
       and $assn->class_name(),
       and defined $assn->name(),
       and $assn->name(),
      );
# testing association confidenceIndicators
my $confidenceindicators_assn;
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $confidenceindicators_assn = Bio::MAGE::QuantitationType::ConfidenceIndicator->new();
}
result (UNIVERSAL::isa($expectedvalue->getConfidenceIndicators->[0],q[Bio::MAGE::QuantitationType::ConfidenceIndicator]));
result ($expectedvalue->setConfidenceIndicators([$confidenceindicators_assn]));
result (UNIVERSAL::isa($expectedvalue->getConfidenceIndicators,'ARRAY')
 and scalar @{$expectedvalue->getConfidenceIndicators()} == 1
 and $expectedvalue->getConfidenceIndicators->[0] == $confidenceindicators_assn);
$expectedvalue->addConfidenceIndicators($confidenceindicators_assn);
result (UNIVERSAL::isa($expectedvalue->getConfidenceIndicators,'ARRAY')
 and scalar @{$expectedvalue->getConfidenceIndicators()} == 2
 and $expectedvalue->getConfidenceIndicators->[0] == $confidenceindicators_assn
 and $expectedvalue->getConfidenceIndicators->[1] == $confidenceindicators_assn);


# test the meta-data for the assoication
($assn) = $assns{confidenceIndicators};
result(is_object($assn)
       and $assn->isa('Bio::MAGE::Association')
       and defined $assn->description(),
       and defined $assn->cardinality(),
       and grep {$_ eq $assn->cardinality} ('0..1','1','1..N','0..N'),
       and defined $assn->is_ref(),
       and ($assn->is_ref() == 0 or $assn->is_ref() == 1),
       and defined $assn->rank(),
       and $assn->rank(),
       and defined $assn->ordered(),
       and ($assn->ordered() == 0 or $assn->ordered() == 1),
       and defined $assn->class_name(),
       and $assn->class_name(),
       and defined $assn->name(),
       and $assn->name(),
      );
# testing association security
my $security_assn;
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $security_assn = Bio::MAGE::AuditAndSecurity::Security->new();
}
result (UNIVERSAL::isa($expectedvalue->getSecurity,q[Bio::MAGE::AuditAndSecurity::Security]));
result ($expectedvalue->setSecurity($security_assn) == $security_assn);
result ($expectedvalue->getSecurity() == $security_assn);



# test the meta-data for the assoication
($assn) = $assns{security};
result(is_object($assn)
       and $assn->isa('Bio::MAGE::Association')
       and defined $assn->description(),
       and defined $assn->cardinality(),
       and grep {$_ eq $assn->cardinality} ('0..1','1','1..N','0..N'),
       and defined $assn->is_ref(),
       and ($assn->is_ref() == 0 or $assn->is_ref() == 1),
       and defined $assn->rank(),
       and $assn->rank(),
       and defined $assn->ordered(),
       and ($assn->ordered() == 0 or $assn->ordered() == 1),
       and defined $assn->class_name(),
       and $assn->class_name(),
       and defined $assn->name(),
       and $assn->name(),
      );
# testing association auditTrail
my $audittrail_assn;
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $audittrail_assn = Bio::MAGE::AuditAndSecurity::Audit->new();
}
result (UNIVERSAL::isa($expectedvalue->getAuditTrail->[0],q[Bio::MAGE::AuditAndSecurity::Audit]));
result ($expectedvalue->setAuditTrail([$audittrail_assn]));
result (UNIVERSAL::isa($expectedvalue->getAuditTrail,'ARRAY')
 and scalar @{$expectedvalue->getAuditTrail()} == 1
 and $expectedvalue->getAuditTrail->[0] == $audittrail_assn);
$expectedvalue->addAuditTrail($audittrail_assn);
result (UNIVERSAL::isa($expectedvalue->getAuditTrail,'ARRAY')
 and scalar @{$expectedvalue->getAuditTrail()} == 2
 and $expectedvalue->getAuditTrail->[0] == $audittrail_assn
 and $expectedvalue->getAuditTrail->[1] == $audittrail_assn);


# test the meta-data for the assoication
($assn) = $assns{auditTrail};
result(is_object($assn)
       and $assn->isa('Bio::MAGE::Association')
       and defined $assn->description(),
       and defined $assn->cardinality(),
       and grep {$_ eq $assn->cardinality} ('0..1','1','1..N','0..N'),
       and defined $assn->is_ref(),
       and ($assn->is_ref() == 0 or $assn->is_ref() == 1),
       and defined $assn->rank(),
       and $assn->rank(),
       and defined $assn->ordered(),
       and ($assn->ordered() == 0 or $assn->ordered() == 1),
       and defined $assn->class_name(),
       and $assn->class_name(),
       and defined $assn->name(),
       and $assn->name(),
      );
# testing association descriptions
my $descriptions_assn;
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $descriptions_assn = Bio::MAGE::Description::Description->new();
}
result (UNIVERSAL::isa($expectedvalue->getDescriptions->[0],q[Bio::MAGE::Description::Description]));
result ($expectedvalue->setDescriptions([$descriptions_assn]));
result (UNIVERSAL::isa($expectedvalue->getDescriptions,'ARRAY')
 and scalar @{$expectedvalue->getDescriptions()} == 1
 and $expectedvalue->getDescriptions->[0] == $descriptions_assn);
$expectedvalue->addDescriptions($descriptions_assn);
result (UNIVERSAL::isa($expectedvalue->getDescriptions,'ARRAY')
 and scalar @{$expectedvalue->getDescriptions()} == 2
 and $expectedvalue->getDescriptions->[0] == $descriptions_assn
 and $expectedvalue->getDescriptions->[1] == $descriptions_assn);


# test the meta-data for the assoication
($assn) = $assns{descriptions};
result(is_object($assn)
       and $assn->isa('Bio::MAGE::Association')
       and defined $assn->description(),
       and defined $assn->cardinality(),
       and grep {$_ eq $assn->cardinality} ('0..1','1','1..N','0..N'),
       and defined $assn->is_ref(),
       and ($assn->is_ref() == 0 or $assn->is_ref() == 1),
       and defined $assn->rank(),
       and $assn->rank(),
       and defined $assn->ordered(),
       and ($assn->ordered() == 0 or $assn->ordered() == 1),
       and defined $assn->class_name(),
       and $assn->class_name(),
       and defined $assn->name(),
       and $assn->name(),
      );
# testing association propertySets
my $propertysets_assn;
{
  # silence the abstract class warnings
  local $SIG{__WARN__} = sub {'IGNORE'};
  $propertysets_assn = Bio::MAGE::NameValueType->new();
}
result (UNIVERSAL::isa($expectedvalue->getPropertySets->[0],q[Bio::MAGE::NameValueType]));
result ($expectedvalue->setPropertySets([$propertysets_assn]));
result (UNIVERSAL::isa($expectedvalue->getPropertySets,'ARRAY')
 and scalar @{$expectedvalue->getPropertySets()} == 1
 and $expectedvalue->getPropertySets->[0] == $propertysets_assn);
$expectedvalue->addPropertySets($propertysets_assn);
result (UNIVERSAL::isa($expectedvalue->getPropertySets,'ARRAY')
 and scalar @{$expectedvalue->getPropertySets()} == 2
 and $expectedvalue->getPropertySets->[0] == $propertysets_assn
 and $expectedvalue->getPropertySets->[1] == $propertysets_assn);


# test the meta-data for the assoication
($assn) = $assns{propertySets};
result(is_object($assn)
       and $assn->isa('Bio::MAGE::Association')
       and defined $assn->description(),
       and defined $assn->cardinality(),
       and grep {$_ eq $assn->cardinality} ('0..1','1','1..N','0..N'),
       and defined $assn->is_ref(),
       and ($assn->is_ref() == 0 or $assn->is_ref() == 1),
       and defined $assn->rank(),
       and $assn->rank(),
       and defined $assn->ordered(),
       and ($assn->ordered() == 0 or $assn->ordered() == 1),
       and defined $assn->class_name(),
       and $assn->class_name(),
       and defined $assn->name(),
       and $assn->name(),
      );
# testing superclass Bio::MAGE::QuantitationType::ConfidenceIndicator
result ($expectedvalue->isa(q[Bio::MAGE::QuantitationType::ConfidenceIndicator]));

# testing superclass Bio::MAGE::QuantitationType::StandardQuantitationType
result ($expectedvalue->isa(q[Bio::MAGE::QuantitationType::StandardQuantitationType]));

# testing superclass Bio::MAGE::QuantitationType::QuantitationType
result ($expectedvalue->isa(q[Bio::MAGE::QuantitationType::QuantitationType]));

# testing superclass Bio::MAGE::Identifiable
result ($expectedvalue->isa(q[Bio::MAGE::Identifiable]));

# testing superclass Bio::MAGE::Describable
result ($expectedvalue->isa(q[Bio::MAGE::Describable]));

# testing superclass Bio::MAGE::Extendable
result ($expectedvalue->isa(q[Bio::MAGE::Extendable]));

