# Generated by default/object.tt
package Paws::ApplicationMigration::NetworkInterface;
  use Moose;
  has Ips => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'ips', traits => ['NameInRequest']);
  has IsPrimary => (is => 'ro', isa => 'Bool', request_name => 'isPrimary', traits => ['NameInRequest']);
  has MacAddress => (is => 'ro', isa => 'Str', request_name => 'macAddress', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ApplicationMigration::NetworkInterface

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ApplicationMigration::NetworkInterface object:

  $service_obj->Method(Att1 => { Ips => $value, ..., MacAddress => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ApplicationMigration::NetworkInterface object:

  $result = $service_obj->Method(...);
  $result->Att1->Ips

=head1 DESCRIPTION

Network interface.

=head1 ATTRIBUTES


=head2 Ips => ArrayRef[Str|Undef]

Network interface IPs.


=head2 IsPrimary => Bool

Network interface primary IP.


=head2 MacAddress => Str

Network interface Mac address.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ApplicationMigration>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

