# Generated by default/object.tt
package Paws::AuditManager::ManualEvidence;
  use Moose;
  has S3ResourcePath => (is => 'ro', isa => 'Str', request_name => 's3ResourcePath', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::ManualEvidence

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::ManualEvidence object:

  $service_obj->Method(Att1 => { S3ResourcePath => $value, ..., S3ResourcePath => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::ManualEvidence object:

  $result = $service_obj->Method(...);
  $result->Att1->S3ResourcePath

=head1 DESCRIPTION

Evidence that is uploaded to AWS Audit Manager manually.

=head1 ATTRIBUTES


=head2 S3ResourcePath => Str

The Amazon S3 URL that points to a manual evidence object.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

