# Generated by default/object.tt
package Paws::Glue::GluePolicy;
  use Moose;
  has CreateTime => (is => 'ro', isa => 'Str');
  has PolicyHash => (is => 'ro', isa => 'Str');
  has PolicyInJson => (is => 'ro', isa => 'Str');
  has UpdateTime => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Glue::GluePolicy

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Glue::GluePolicy object:

  $service_obj->Method(Att1 => { CreateTime => $value, ..., UpdateTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Glue::GluePolicy object:

  $result = $service_obj->Method(...);
  $result->Att1->CreateTime

=head1 DESCRIPTION

A structure for returning a resource policy.

=head1 ATTRIBUTES


=head2 CreateTime => Str

The date and time at which the policy was created.


=head2 PolicyHash => Str

Contains the hash value associated with this policy.


=head2 PolicyInJson => Str

Contains the requested policy document, in JSON format.


=head2 UpdateTime => Str

The date and time at which the policy was last updated.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Glue>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

