# Generated by default/object.tt
package Paws::IoTEvents::AlarmModelVersionSummary;
  use Moose;
  has AlarmModelArn => (is => 'ro', isa => 'Str', request_name => 'alarmModelArn', traits => ['NameInRequest']);
  has AlarmModelName => (is => 'ro', isa => 'Str', request_name => 'alarmModelName', traits => ['NameInRequest']);
  has AlarmModelVersion => (is => 'ro', isa => 'Str', request_name => 'alarmModelVersion', traits => ['NameInRequest']);
  has CreationTime => (is => 'ro', isa => 'Str', request_name => 'creationTime', traits => ['NameInRequest']);
  has LastUpdateTime => (is => 'ro', isa => 'Str', request_name => 'lastUpdateTime', traits => ['NameInRequest']);
  has RoleArn => (is => 'ro', isa => 'Str', request_name => 'roleArn', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);
  has StatusMessage => (is => 'ro', isa => 'Str', request_name => 'statusMessage', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEvents::AlarmModelVersionSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEvents::AlarmModelVersionSummary object:

  $service_obj->Method(Att1 => { AlarmModelArn => $value, ..., StatusMessage => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEvents::AlarmModelVersionSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->AlarmModelArn

=head1 DESCRIPTION

Contains a summary of an alarm model version.

=head1 ATTRIBUTES


=head2 AlarmModelArn => Str

The ARN of the alarm model. For more information, see Amazon Resource
Names (ARNs)
(https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
in the I<AWS General Reference>.


=head2 AlarmModelName => Str

The name of the alarm model.


=head2 AlarmModelVersion => Str

The version of the alarm model.


=head2 CreationTime => Str

The time the alarm model was created, in the Unix epoch format.


=head2 LastUpdateTime => Str

The time the alarm model was last updated, in the Unix epoch format.


=head2 RoleArn => Str

The ARN of the IAM role that allows the alarm to perform actions and
access AWS resources. For more information, see Amazon Resource Names
(ARNs)
(https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
in the I<AWS General Reference>.


=head2 Status => Str

The status of the alarm model. The status can be one of the following
values:

=over

=item *

C<ACTIVE> - The alarm model is active and it's ready to evaluate data.

=item *

C<ACTIVATING> - AWS IoT Events is activating your alarm model.
Activating an alarm model can take up to a few minutes.

=item *

C<INACTIVE> - The alarm model is inactive, so it isn't ready to
evaluate data. Check your alarm model information and update the alarm
model.

=item *

C<FAILED> - You couldn't create or update the alarm model. Check your
alarm model information and try again.

=back



=head2 StatusMessage => Str

Contains information about the status of the alarm model version.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

