# Generated by default/object.tt
package Paws::Organizations::DelegatedAdministrator;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str');
  has DelegationEnabledDate => (is => 'ro', isa => 'Str');
  has Email => (is => 'ro', isa => 'Str');
  has Id => (is => 'ro', isa => 'Str');
  has JoinedMethod => (is => 'ro', isa => 'Str');
  has JoinedTimestamp => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Organizations::DelegatedAdministrator

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Organizations::DelegatedAdministrator object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Organizations::DelegatedAdministrator object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Contains information about the delegated administrator.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the delegated administrator's
account.


=head2 DelegationEnabledDate => Str

The date when the account was made a delegated administrator.


=head2 Email => Str

The email address that is associated with the delegated administrator's
AWS account.


=head2 Id => Str

The unique identifier (ID) of the delegated administrator's account.


=head2 JoinedMethod => Str

The method by which the delegated administrator's account joined the
organization.


=head2 JoinedTimestamp => Str

The date when the delegated administrator's account became a part of
the organization.


=head2 Name => Str

The friendly name of the delegated administrator's account.


=head2 Status => Str

The status of the delegated administrator's account in the
organization.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Organizations>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

