package OpenInteract::SQLInstall::Page;

# $Id: Page.pm,v 1.6 2002/05/02 12:12:14 lachoy Exp $

# Do installation of SQL for this package

use strict;
use vars qw( %HANDLERS );
use base qw( OpenInteract::SQLInstall );

my @TABLES = ( 'page.sql', 'page_content.sql',
               'content_type.sql', 'page_directory.sql' );

my %files = (
  tables        => \@TABLES,
  tables_oracle => [ 'page_oracle.sql', 'page_content_oracle.sql',
                     'content_type_oracle.sql', 'content_type_sequence.sql',
                     'page_directory_oracle.sql' ],
  tables_pg     => [ @TABLES, 'content_type_sequence.sql' ],
  tables_ib     => [ 'page_interbase.sql', 'page_content_interbase.sql',
                     'content_type.sql', 'page_directory.sql',
                     'content_type_generator.sql' ],
  data          => [ 'content_types.dat', 'page.dat', 'page_directory.dat' ],
  security      => [ 'install_security.dat' ],
);

%HANDLERS = (
  create_structure => { '_default_' => [ 'create_structure',
                                         { table_file_list => $files{tables} } ],
                        'Oracle'    => [ 'create_structure',
                                         { table_file_list => $files{tables_oracle} } ],
                        'Pg'        => [ 'create_structure',
                                         { table_file_list => $files{tables_pg} } ],
                        'InterBase' => [ 'create_structure',
                                         { table_file_list => $files{tables_ib} } ],
  },
  install_data     => { '_default_' => [ 'install_data',
                                         { data_file_list => $files{data} } ] },
  install_security => { '_default_' => [ 'install_data',
                                         { data_file_list => $files{security} } ] },
);

1;
