package OpenInteract::Handler::Fruit;

use strict;

$OpenInteract::Handler::Fruit::VERSION = '0.02';
$OpenInteract::Handler::Fruit::author = 'chris@cwinters.com';

sub handler {
  my ( $class, $p ) = @_;
  my $R = OpenInteract::Request->instance;
  my ( $error_msg );
  my $fruits = eval { $R->fruit->fetch_group({ 'order' => 'name' }) };
  if ( $@ ) {
      $error_msg = "Found error when trying to fetch fruit: " .
                   SPOPS::Error->get->{system_msg};
  }
  my $params = { fruits_in_store => $fruits, error_msg => $error_msg };
  $R->{page}{title} = 'All Fruit in Store';
  return $R->template->handler( {}, $params,
                                { name => 'fruit::fruit-display' } );
}

1;
