#!/usr/bin/perl
# based on fl5.mpg
# http://bmrc.berkeley.edu/ftp/pub/multimedia/mpeg/mpeg2/conformance-bitstreams/audio/mpeg1/compliance/

use strict;
use integer;

my $n;
use Test::More tests => ($n = 49) * 8 + 2;
BEGIN { use_ok("MPEG::Audio::Frame") };

for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame");
	ok($frame->mpeg1, "frame is MPEG1");
	ok($frame->layer1, "frame is layer I");
	ok($frame->has_crc, "frame has CRC");
	ok(!$frame->broken, "frame isn't broken");
	is($frame->bitrate, 448, "bitrate");
	is($frame->sample, 48000, "sample rate");
	ok($frame->dual_channel, "dual channel");
}
is(MPEG::Audio::Frame->read(*DATA), undef, "nothing else in the file");

__DATA__
hevWfUfUfUeDUDUDUUDU33          $<DIUQeUmVu}Z}Ǜ}}ȟ}߾}~߾ھ{߾~߾{}}{}~߿}}~{{ﻻڰ ~{ڽڽz {y码ywu۰~^q"k0@<0<ډ0͚hϼDq(]ڊ(A@RڽdR"E-O9J|,ڌE؀q~Q8pӴ 0߾ ڻЁ[{sڅz@ڜ70 ͖"KEVڍD.<H^\ڄ"uau!w	˩>mڷ|c
ktD;`{ =z {yڂڠywt ]tڅvxggVfEE4#"            R@JTڢKڌ-گ00
1,* 
~ھ]:Ą~@."ۭh%Lڶl]ipw コ),w;gڮ@hڭ={h׳`E_/뀷ڐ;ںR'΢ ?ڭ/ڿ~B~o,`x7q\%8ڸ
Osmv5Q_~-pNp.ھ{vԉڨm|8ڟ߾7
W	B |7A.ڿ~xڂ0]7{6 TW߂{?ځݵ"w G'fw_ڀKڸ+/ߞ.ڡ?6aPڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 ڽڎsegUUTdFD3""             SOT|߾oھ=7=y㳍ڦTZڸStھڔ%ںRfm$'FZڒ?Lԋ

ٗX}9},(گ2E]|MĶ1 3 {
.!iEڍiڕa./ڀy?e	g .ڔy[l*0:ڏ}5"ڡ7ve(A_~
kEL W_(q-@ ڈZQc{8eE_07KOBY&mV
L"y/Nڤe#tHMݙu0CڪS-8U8dKn>  'X6QhWL
ړPrIڛw¬ڞKөjHo'3R,*x7f]b1ڿ,pڠfDTp=uڎ7۬ ψ 	(ڥ4 
