# Generated by default/object.tt
package Paws::GlobalAccelerator::CustomRoutingEndpointGroup;
  use Moose;
  has DestinationDescriptions => (is => 'ro', isa => 'ArrayRef[Paws::GlobalAccelerator::CustomRoutingDestinationDescription]');
  has EndpointDescriptions => (is => 'ro', isa => 'ArrayRef[Paws::GlobalAccelerator::CustomRoutingEndpointDescription]');
  has EndpointGroupArn => (is => 'ro', isa => 'Str');
  has EndpointGroupRegion => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlobalAccelerator::CustomRoutingEndpointGroup

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlobalAccelerator::CustomRoutingEndpointGroup object:

  $service_obj->Method(Att1 => { DestinationDescriptions => $value, ..., EndpointGroupRegion => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlobalAccelerator::CustomRoutingEndpointGroup object:

  $result = $service_obj->Method(...);
  $result->Att1->DestinationDescriptions

=head1 DESCRIPTION

A complex type for the endpoint group for a custom routing accelerator.
An AWS Region can have only one endpoint group for a specific listener.

=head1 ATTRIBUTES


=head2 DestinationDescriptions => ArrayRef[L<Paws::GlobalAccelerator::CustomRoutingDestinationDescription>]

For a custom routing accelerator, describes the port range and protocol
for all endpoints (virtual private cloud subnets) in an endpoint group
to accept client traffic on.


=head2 EndpointDescriptions => ArrayRef[L<Paws::GlobalAccelerator::CustomRoutingEndpointDescription>]

For a custom routing accelerator, describes the endpoints (virtual
private cloud subnets) in an endpoint group to accept client traffic
on.


=head2 EndpointGroupArn => Str

The Amazon Resource Name (ARN) of the endpoint group.


=head2 EndpointGroupRegion => Str

The AWS Region where the endpoint group is located.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlobalAccelerator>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

