# Generated by default/object.tt
package Paws::SecurityHub::AwsRdsDbSnapshotDetails;
  use Moose;
  has AllocatedStorage => (is => 'ro', isa => 'Int');
  has AvailabilityZone => (is => 'ro', isa => 'Str');
  has DbInstanceIdentifier => (is => 'ro', isa => 'Str');
  has DbiResourceId => (is => 'ro', isa => 'Str');
  has DbSnapshotIdentifier => (is => 'ro', isa => 'Str');
  has Encrypted => (is => 'ro', isa => 'Bool');
  has Engine => (is => 'ro', isa => 'Str');
  has EngineVersion => (is => 'ro', isa => 'Str');
  has IamDatabaseAuthenticationEnabled => (is => 'ro', isa => 'Bool');
  has InstanceCreateTime => (is => 'ro', isa => 'Str');
  has Iops => (is => 'ro', isa => 'Int');
  has KmsKeyId => (is => 'ro', isa => 'Str');
  has LicenseModel => (is => 'ro', isa => 'Str');
  has MasterUsername => (is => 'ro', isa => 'Str');
  has OptionGroupName => (is => 'ro', isa => 'Str');
  has PercentProgress => (is => 'ro', isa => 'Int');
  has Port => (is => 'ro', isa => 'Int');
  has ProcessorFeatures => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsRdsDbProcessorFeature]');
  has SnapshotCreateTime => (is => 'ro', isa => 'Str');
  has SnapshotType => (is => 'ro', isa => 'Str');
  has SourceDbSnapshotIdentifier => (is => 'ro', isa => 'Str');
  has SourceRegion => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has StorageType => (is => 'ro', isa => 'Str');
  has TdeCredentialArn => (is => 'ro', isa => 'Str');
  has Timezone => (is => 'ro', isa => 'Str');
  has VpcId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsRdsDbSnapshotDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsRdsDbSnapshotDetails object:

  $service_obj->Method(Att1 => { AllocatedStorage => $value, ..., VpcId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsRdsDbSnapshotDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->AllocatedStorage

=head1 DESCRIPTION

Provides details about an Amazon RDS DB cluster snapshot.

=head1 ATTRIBUTES


=head2 AllocatedStorage => Int

The amount of storage (in gigabytes) to be initially allocated for the
database instance.


=head2 AvailabilityZone => Str

Specifies the name of the Availability Zone in which the DB instance
was located at the time of the DB snapshot.


=head2 DbInstanceIdentifier => Str

A name for the DB instance.


=head2 DbiResourceId => Str

The identifier for the source DB instance.


=head2 DbSnapshotIdentifier => Str

The name or ARN of the DB snapshot that is used to restore the DB
instance.


=head2 Encrypted => Bool

Whether the DB snapshot is encrypted.


=head2 Engine => Str

The name of the database engine to use for this DB instance.


=head2 EngineVersion => Str

The version of the database engine.


=head2 IamDatabaseAuthenticationEnabled => Bool

Whether mapping of IAM accounts to database accounts is enabled.


=head2 InstanceCreateTime => Str

Specifies the time in Coordinated Universal Time (UTC) when the DB
instance, from which the snapshot was taken, was created.


=head2 Iops => Int

The provisioned IOPS (I/O operations per second) value of the DB
instance at the time of the snapshot.


=head2 KmsKeyId => Str

If C<Encrypted> is C<true>, the AWS KMS key identifier for the
encrypted DB snapshot.


=head2 LicenseModel => Str

License model information for the restored DB instance.


=head2 MasterUsername => Str

The master user name for the DB snapshot.


=head2 OptionGroupName => Str

The option group name for the DB snapshot.


=head2 PercentProgress => Int

The percentage of the estimated data that has been transferred.


=head2 Port => Int

The port that the database engine was listening on at the time of the
snapshot.


=head2 ProcessorFeatures => ArrayRef[L<Paws::SecurityHub::AwsRdsDbProcessorFeature>]

The number of CPU cores and the number of threads per core for the DB
instance class of the DB instance.


=head2 SnapshotCreateTime => Str

When the snapshot was taken in Coordinated Universal Time (UTC).


=head2 SnapshotType => Str

The type of the DB snapshot.


=head2 SourceDbSnapshotIdentifier => Str

The DB snapshot ARN that the DB snapshot was copied from.


=head2 SourceRegion => Str

The AWS Region that the DB snapshot was created in or copied from.


=head2 Status => Str

The status of this DB snapshot.


=head2 StorageType => Str

The storage type associated with the DB snapshot.


=head2 TdeCredentialArn => Str

The ARN from the key store with which to associate the instance for TDE
encryption.


=head2 Timezone => Str

The time zone of the DB snapshot.


=head2 VpcId => Str

The VPC ID associated with the DB snapshot.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

