package OpenInteract::SQLInstall::Lookup;

# $Id: Lookup.pm,v 1.1 2001/09/17 15:54:53 lachoy Exp $

use strict;
use vars qw( %HANDLERS );

@OpenInteract::SQLInstall::Lookup::ISA = qw( OpenInteract::SQLInstall );

my %files = (
 tables   => [],
 data     => [],
 security => [ 'install_security.dat' ],
);

%HANDLERS = (

 create_structure => { '_default_' => [ 'create_structure',
                                        { table_file_list => $files{tables} } ] },

 install_data     => { '_default_' => [ 'install_data',
                                        { data_file_list => $files{data} } ] },

 install_security => { '_default_' => [ 'install_data',
                                        { data_file_list => $files{security} } ] },

);

1;
