# This file was automatically generated by SWIG
package XML::Xerces;
require Exporter;
require DynaLoader;
@ISA = qw(Exporter DynaLoader);
package XML::Xercesc;
bootstrap XML::Xerces;

use strict;

INIT {
  # NOTICE: We are automatically calling XMLPlatformUtils::Initialize()
  #   when the module is loaded. Don't bother calling it on your own.
  #
  #
  XML::Xerces::XMLPlatformUtils::Initialize();
}

END {
  # NOTICE: We are automatically calling XMLPlatformUtils::Terminate()
  #   when the module is unloaded. Don't bother calling it on your own.
  #
  #
  XML::Xerces::XMLPlatformUtils::Terminate();
}

package XML::Xerces;
use Carp;
use vars qw(@EXPORT_OK);
@EXPORT_OK = qw(error);
sub error {
  my $error = shift;
  print STDERR "Error in eval: ";
  if (ref $error) {
    if ($error->isa('XML::Xerces::DOMException')) {
      croak "Message: <", $error->getMessage(), 
	"> Code: ", $XML::Xerces::DOMException::CODES[$error->getCode];
    } else {
      croak $error->getMessage();
    }
  } else {
    croak $error;
  }
}

package XML::Xerces::DOMException;
use vars qw(@CODES);
@CODES = qw(__NONEXISTENT__
	    INDEX_SIZE_ERR
	    DOMSTRING_SIZE_ERR
	    HIERARCHY_REQUEST_ERR
	    WRONG_DOCUMENT_ERR
	    INVALID_CHARACTER_ERR
	    NO_DATA_ALLOWED_ERR
	    NO_MODIFICATION_ALLOWED_ERR
	    NOT_FOUND_ERR
	    NOT_SUPPORTED_ERR
	    INUSE_ATTRIBUTE_ERR
	    INVALID_STATE_ERR
	    SYNTAX_ERR
	    INVALID_MODIFICATION_ERR
	    NAMESPACE_ERR
	    INVALID_ACCESS_ERR
	   );

############# Class : XML::Xerces::PerlContentHandler ##############
package XML::Xerces::PerlContentHandler;
use vars qw(@ISA);
@ISA = qw();
sub new {
  my $class = shift;
  return bless {}, $class;
}

sub start_element {}
sub end_element {}
sub start_prefix_mapping {}
sub end_prefix_mapping {}
sub skipped_entity {}
sub start_document {}
sub end_document {}
sub reset_document {}
sub characters {}
sub processing_instruction {}
sub set_document_locator {}
sub ignorable_whitespace {}


############# Class : XML::Xerces::PerlDocumentHandler ##############
package XML::Xerces::PerlDocumentHandler;
use vars qw(@ISA);
@ISA = qw();
sub new {
  my $class = shift;
  return bless {}, $class;
}

sub start_element {}
sub end_element {}
sub start_document {}
sub end_document {}
sub reset_document {}
sub characters {}
sub processing_instruction {}
sub set_document_locator {}
sub ignorable_whitespace {}


############# Class : XML::Xerces::PerlEntityResolver ##############
package XML::Xerces::PerlEntityResolver;
use vars qw(@ISA);
@ISA = qw();
sub new {
  my $class = shift;
  return bless {}, $class;
}

sub resolve_entity {
  return undef;
}


############# Class : XML::Xerces::PerlNodeFilter ##############
package XML::Xerces::PerlNodeFilter;
use vars qw(@ISA);
@ISA = qw();
sub new {
  my $class = shift;
  return bless {}, $class;
}

sub acceptNode {
  return undef;
}


############# Class : XML::Xerces::PerlErrorHandler ##############
package XML::Xerces::PerlErrorHandler;
use Carp;
use vars qw(@ISA);
@ISA = qw();
sub new {
  my $class = shift;
  return bless {}, $class;
}

sub warning {
  my $system_id = $_[1]->getSystemId;
  my $line_num = $_[1]->getLineNumber;
  my $col_num = $_[1]->getColumnNumber;
  my $msg = $_[1]->getMessage;
  carp(<<EOT);
WARNING:
FILE:    $system_id
LINE:    $line_num
COLUMN:  $col_num
MESSAGE: $msg
EOT
}

sub error {
  my $system_id = $_[1]->getSystemId;
  my $line_num = $_[1]->getLineNumber;
  my $col_num = $_[1]->getColumnNumber;
  my $msg = $_[1]->getMessage;
  croak(<<EOT);
ERROR:
FILE:    $system_id
LINE:    $line_num
COLUMN:  $col_num
MESSAGE: $msg
EOT
}

sub fatal_error {
  my $system_id = $_[1]->getSystemId;
  my $line_num = $_[1]->getLineNumber;
  my $col_num = $_[1]->getColumnNumber;
  my $msg = $_[1]->getMessage;
  croak(<<EOT);
FATAL ERROR:
FILE:    $system_id
LINE:    $line_num
COLUMN:  $col_num
MESSAGE: $msg
EOT
}


sub reset_errors {}

package XML::Xerces::DOMNodeList;
# convert the NodeList to a perl list
sub to_list {
  my $self = shift;
  my @list;
  for (my $i=0;$i<$self->getLength();$i++) {
    push(@list,$self->item($i));
  }
  return @list;
}

package XML::Xerces::Attributes;
sub to_hash {
  my $self = shift;
  my %hash;
  for (my $i=0; $i < $self->getLength(); $i++) {
    my $qname = $self->getQName($i);
    $hash{$qname}->{localName} = $self->getLocalName($i);
    $hash{$qname}->{URI} = $self->getURI($i);
    $hash{$qname}->{value} = $self->getValue($i);
    $hash{$qname}->{type} = $self->getType($i);
  }
  return %hash;
}

package XML::Xerces::AttributeList;
sub to_hash {
  my $self = shift;
  my %hash;
  for (my $i=0;$i<$self->getLength();$i++) {
    $hash{$self->getName($i)} = $self->getValue($i)
  }
  return %hash;
}

package XML::Xerces::DOMNamedNodeMap;
# convert the NamedNodeMap to a perl hash
sub to_hash {
  my $self = shift;
  my @list;
  for (my $i=0;$i<$self->getLength();$i++) {
    my $node = $self->item($i);
    push(@list, $node->to_hash());
  }
  return @list;
}

package XML::Xerces::DOMNode;
sub to_hash {
  my $self = shift;
  return ($self->getNodeName,$self->getNodeValue);
}

sub quote_content {
  my ($self,$node_value) = @_;

  $node_value =~ s/&/&amp;/g;
  $node_value =~ s/</&lt;/g;
  $node_value =~ s/>/&gt;/g;
  $node_value =~ s/\"/&quot;/g;
  $node_value =~ s/\'/&apos;/g;

  return $node_value;
}

package XML::Xerces::DOMEntity;
sub to_hash {
  my $self = shift;
  if ($self->hasChildNodes) {
    return ($self->getNodeName(),
            $self->getFirstChild->getNodeValue());
  } else {
    return ($self->getNodeName(), '');
  }
}

package XML::Xerces::DOMText;
sub serialize {
  return $_[0]->quote_content($_[0]->getNodeValue);
}

package XML::Xerces::DOMProcessingInstruction;
sub serialize {
  my $output .= '<?' . $_[0]->getNodeName;
  if (length(my $str = $_[0]->getNodeValue)) {
    $output .= " $str"; 
  }
  $output .= '?>';
  return $output;
}

package XML::Xerces::DOMDocument;
sub serialize {
  my $output;
  my $indent = 2;
  for(my $child = $_[0]->getFirstChild() ;
     defined $child ;
     $child = $child->getNextSibling())
  {
    $output .= $child->serialize($indent);
  }
  return "$output\n";
}

package XML::Xerces::DOMElement;
sub serialize {
  my ($self,$indent) = @_;
  my $output;
  ELEMENT: {
    my $node_name = $self->getNodeName;
    $output .= "<$node_name";

    my $attributes = $self->getAttributes;
    my $attribute_count = $attributes->getLength;

    for(my $ix = 0 ; $ix < $attribute_count ; ++$ix) {
      my $attribute = $attributes->item($ix);
      $output .= ' ' . $attribute->getNodeName . '="' . $self->quote_content($attribute->getNodeValue) . '"';
    }

    my $child = $self->getFirstChild();
    if (!defined $child) {
      $output .= '/>';
      last ELEMENT;
    }

    $output .= '>';
    while (defined $child) {
      $output .= $child->serialize($indent+2);
      $child = $child->getNextSibling();
    }
    $output .= "</$node_name>";
  }
  return $output;
}

package XML::Xerces::DOMEntityReference;
sub serialize {
  my ($self) = @_;
  my $output;
  for(my $child = $self->getFirstChild() ;
     defined $child;
     $child = $child->getNextSibling())
  {
    $output .= $child->serialize();
  }
  return $output;
}

package XML::Xerces::DOMCDATASection;
sub serialize {
  return '<![CDATA[' . $_[0]->getNodeValue . ']]>';
}

package XML::Xerces::DOMComment;
sub serialize {
  return '<!--' . $_[0]->getNodeValue . "-->\n";
}

package XML::Xerces::DOMDocumentType;
sub serialize {
  my $output;
  $output .= '<!DOCTYPE ' . $_[0]->getNodeName;

  my $id;
  if ($id = $_[0]->getPublicId) {
    $output .= qq[ PUBLIC "$id"];
    if ($id = $_[0]->getSystemId) {
      $output .= qq[ "$id"];
    }
  } elsif ($id = $_[0]->getSystemId) {
    $output .= qq[ SYSTEM "$id"];
  }

  if ($id = $_[0]->getInternalSubset) {
    $output .= " [$id]";
  }

  $output .= ">\n";
  return $output;
}

package XML::Xerces::DOMEntity;
sub serialize {
  my $output;
  $output .= '<!ENTITY ' . $_[0]->getNodeName;

  my $id;
  if ($id = $_[0]->getPublicId) { $output .= qq[ PUBLIC "$id"]; }
  if ($id = $_[0]->getSystemId) { $output .= qq[ SYSTEM "$id"]; }
  if ($id = $_[0]->getNotationName) { $output .= qq[ NDATA "$id"]; }

  $output .= '>';
  return $output;
}

package XML::Xerces::DOMException;
sub getMessage {
  return shift->{msg};
}

sub getCode {
  return shift->{code};
}

package XML::Xerces::DOMElement;
sub get_text {
  my $node = shift;
  my @nodes = $node->getChildNodes();
  my $text;
  foreach (@nodes) {
    $text .= $_->getNodeValue()
      if $_->isa('XML::Xerces::DOMText');
  }
  return $text;
}
package XML::Xerces; 
use vars qw($VERSION @EXPORT);
$VERSION = q[2.3.0-1];
package XML::Xerces;
@EXPORT = qw( );

# ---------- BASE METHODS -------------

package XML::Xerces;

sub TIEHASH {
    my ($classname,$obj) = @_;
    return bless $obj, $classname;
}

sub CLEAR { }

sub FIRSTKEY { }

sub NEXTKEY { }

sub this {
    my $ptr = shift;
    return tied(%$ptr);
}


############# Class : XML::Xerces::XMLDeleter ##############

package XML::Xerces::XMLDeleter;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::XMLPlatformUtils ##############

package XML::Xerces::XMLPlatformUtils;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();
*Initialize = *XML::Xercesc::XMLPlatformUtils_Initialize;
*Terminate = *XML::Xercesc::XMLPlatformUtils_Terminate;
*panic = *XML::Xercesc::XMLPlatformUtils_panic;
*curFilePos = *XML::Xercesc::XMLPlatformUtils_curFilePos;
*closeFile = *XML::Xercesc::XMLPlatformUtils_closeFile;
*fileSize = *XML::Xercesc::XMLPlatformUtils_fileSize;
*openFile = *XML::Xercesc::XMLPlatformUtils_openFile;
*openFileToWrite = *XML::Xercesc::XMLPlatformUtils_openFileToWrite;
*openStdInHandle = *XML::Xercesc::XMLPlatformUtils_openStdInHandle;
*readFileBuffer = *XML::Xercesc::XMLPlatformUtils_readFileBuffer;
*writeBufferToFile = *XML::Xercesc::XMLPlatformUtils_writeBufferToFile;
*resetFile = *XML::Xercesc::XMLPlatformUtils_resetFile;
*getFullPath = *XML::Xercesc::XMLPlatformUtils_getFullPath;
*getCurrentDirectory = *XML::Xercesc::XMLPlatformUtils_getCurrentDirectory;
*removeDotSlash = *XML::Xercesc::XMLPlatformUtils_removeDotSlash;
*removeDotDotSlash = *XML::Xercesc::XMLPlatformUtils_removeDotDotSlash;
*isRelative = *XML::Xercesc::XMLPlatformUtils_isRelative;
*weavePaths = *XML::Xercesc::XMLPlatformUtils_weavePaths;
*getCurrentMillis = *XML::Xercesc::XMLPlatformUtils_getCurrentMillis;
*closeMutex = *XML::Xercesc::XMLPlatformUtils_closeMutex;
*lockMutex = *XML::Xercesc::XMLPlatformUtils_lockMutex;
*makeMutex = *XML::Xercesc::XMLPlatformUtils_makeMutex;
*unlockMutex = *XML::Xercesc::XMLPlatformUtils_unlockMutex;
*loadMsgSet = *XML::Xercesc::XMLPlatformUtils_loadMsgSet;
*compareAndSwap = *XML::Xercesc::XMLPlatformUtils_compareAndSwap;
*atomicIncrement = *XML::Xercesc::XMLPlatformUtils_atomicIncrement;
*atomicDecrement = *XML::Xercesc::XMLPlatformUtils_atomicDecrement;
*recognizeNEL = *XML::Xercesc::XMLPlatformUtils_recognizeNEL;
*isNELRecognized = *XML::Xercesc::XMLPlatformUtils_isNELRecognized;
*strictIANAEncoding = *XML::Xercesc::XMLPlatformUtils_strictIANAEncoding;
*isStrictIANAEncoding = *XML::Xercesc::XMLPlatformUtils_isStrictIANAEncoding;
*alignPointerForNewBlockAllocation = *XML::Xercesc::XMLPlatformUtils_alignPointerForNewBlockAllocation;
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_XMLPlatformUtils(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::XMLPlatformUtils", $self;
    return bless \%retval, $pkg;
}


sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::XMLURL ##############

package XML::Xerces::XMLURL;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
use overload
    "==" => sub { $_[0]->operator_equal_to($_[1])},
    "!=" => sub { $_[0]->operator_not_equal_to($_[1])},
    "=" => sub { $_[0]->operator_assignment($_[1])},
    "fallback" => 1;
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();
*File = *XML::Xercesc::XMLURL_File;
*HTTP = *XML::Xercesc::XMLURL_HTTP;
*FTP = *XML::Xercesc::XMLURL_FTP;
*Protocols_Count = *XML::Xercesc::XMLURL_Protocols_Count;
*Unknown = *XML::Xercesc::XMLURL_Unknown;
*lookupByName = *XML::Xercesc::XMLURL_lookupByName;
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_XMLURL(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::XMLURL", $self;
    return bless \%retval, $pkg;
}


sub operator_assignment {
    my @args = @_;
    my $result = XML::Xercesc::XMLURL_operator_assignment(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*operator_equal_to = *XML::Xercesc::XMLURL_operator_equal_to;
*operator_not_equal_to = *XML::Xercesc::XMLURL_operator_not_equal_to;
*getFragment = *XML::Xercesc::XMLURL_getFragment;
*getHost = *XML::Xercesc::XMLURL_getHost;
*getPassword = *XML::Xercesc::XMLURL_getPassword;
*getPath = *XML::Xercesc::XMLURL_getPath;
*getPortNum = *XML::Xercesc::XMLURL_getPortNum;
*getProtocol = *XML::Xercesc::XMLURL_getProtocol;
*getProtocolName = *XML::Xercesc::XMLURL_getProtocolName;
*getQuery = *XML::Xercesc::XMLURL_getQuery;
*getURLText = *XML::Xercesc::XMLURL_getURLText;
*getUser = *XML::Xercesc::XMLURL_getUser;
*getMemoryManager = *XML::Xercesc::XMLURL_getMemoryManager;
*setURL = *XML::Xercesc::XMLURL_setURL;
*isRelative = *XML::Xercesc::XMLURL_isRelative;
*hasInvalidChar = *XML::Xercesc::XMLURL_hasInvalidChar;
*makeNewStream = *XML::Xercesc::XMLURL_makeNewStream;
*makeRelativeTo = *XML::Xercesc::XMLURL_makeRelativeTo;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::XMLUri ##############

package XML::Xerces::XMLUri;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
use overload
    "=" => sub { $_[0]->operator_assignment($_[1])},
    "fallback" => 1;
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_XMLUri(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::XMLUri", $self;
    return bless \%retval, $pkg;
}

sub operator_assignment {
    my @args = @_;
    my $result = XML::Xercesc::XMLUri_operator_assignment(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}

*getUriText = *XML::Xercesc::XMLUri_getUriText;
*getScheme = *XML::Xercesc::XMLUri_getScheme;
*getUserInfo = *XML::Xercesc::XMLUri_getUserInfo;
*getHost = *XML::Xercesc::XMLUri_getHost;
*getPort = *XML::Xercesc::XMLUri_getPort;
*getPath = *XML::Xercesc::XMLUri_getPath;
*getQueryString = *XML::Xercesc::XMLUri_getQueryString;
*getFragment = *XML::Xercesc::XMLUri_getFragment;
*setScheme = *XML::Xercesc::XMLUri_setScheme;
*setUserInfo = *XML::Xercesc::XMLUri_setUserInfo;
*setHost = *XML::Xercesc::XMLUri_setHost;
*setPort = *XML::Xercesc::XMLUri_setPort;
*setPath = *XML::Xercesc::XMLUri_setPath;
*setQueryString = *XML::Xercesc::XMLUri_setQueryString;
*setFragment = *XML::Xercesc::XMLUri_setFragment;
*isURIString = *XML::Xercesc::XMLUri_isURIString;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::QName ##############

package XML::Xerces::QName;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
use overload
    "==" => sub { $_[0]->operator_equal_to($_[1])},
    "fallback" => 1;
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_QName(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::QName", $self;
    return bless \%retval, $pkg;
}


*getPrefix = *XML::Xercesc::QName_getPrefix;
*getLocalPart = *XML::Xercesc::QName_getLocalPart;
*getRawName = *XML::Xercesc::QName_getRawName;
*getMemoryManager = *XML::Xercesc::QName_getMemoryManager;
*setName = *XML::Xercesc::QName_setName;
*setPrefix = *XML::Xercesc::QName_setPrefix;
*setLocalPart = *XML::Xercesc::QName_setLocalPart;
*setNPrefix = *XML::Xercesc::QName_setNPrefix;
*setNLocalPart = *XML::Xercesc::QName_setNLocalPart;
*setURI = *XML::Xercesc::QName_setURI;
*setValues = *XML::Xercesc::QName_setValues;
*operator_equal_to = *XML::Xercesc::QName_operator_equal_to;
*cleanUp = *XML::Xercesc::QName_cleanUp;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::HexBin ##############

package XML::Xerces::HexBin;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();
*getDataLength = *XML::Xercesc::HexBin_getDataLength;
*isArrayByteHex = *XML::Xercesc::HexBin_isArrayByteHex;

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::Base64 ##############

package XML::Xerces::Base64;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();
*encode = *XML::Xercesc::Base64_encode;
*decode = *XML::Xercesc::Base64_decode;
*getDataLength = *XML::Xercesc::Base64_getDataLength;

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::XMLExcepts ##############

package XML::Xerces::XMLExcepts;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();
*NoError = *XML::Xercesc::XMLExcepts_NoError;
*W_LowBounds = *XML::Xercesc::XMLExcepts_W_LowBounds;
*Scan_CouldNotOpenSource_Warning = *XML::Xercesc::XMLExcepts_Scan_CouldNotOpenSource_Warning;
*GC_ExistingGrammar = *XML::Xercesc::XMLExcepts_GC_ExistingGrammar;
*W_HighBounds = *XML::Xercesc::XMLExcepts_W_HighBounds;
*F_LowBounds = *XML::Xercesc::XMLExcepts_F_LowBounds;
*Array_BadIndex = *XML::Xercesc::XMLExcepts_Array_BadIndex;
*Array_BadNewSize = *XML::Xercesc::XMLExcepts_Array_BadNewSize;
*AttrList_BadIndex = *XML::Xercesc::XMLExcepts_AttrList_BadIndex;
*AttDef_BadAttType = *XML::Xercesc::XMLExcepts_AttDef_BadAttType;
*AttDef_BadDefAttType = *XML::Xercesc::XMLExcepts_AttDef_BadDefAttType;
*Bitset_BadIndex = *XML::Xercesc::XMLExcepts_Bitset_BadIndex;
*Bitset_NotEqualSize = *XML::Xercesc::XMLExcepts_Bitset_NotEqualSize;
*BufMgr_NoMoreBuffers = *XML::Xercesc::XMLExcepts_BufMgr_NoMoreBuffers;
*BufMgr_BufferNotInPool = *XML::Xercesc::XMLExcepts_BufMgr_BufferNotInPool;
*CPtr_PointerIsZero = *XML::Xercesc::XMLExcepts_CPtr_PointerIsZero;
*CM_BinOpHadUnaryType = *XML::Xercesc::XMLExcepts_CM_BinOpHadUnaryType;
*CM_MustBeMixedOrChildren = *XML::Xercesc::XMLExcepts_CM_MustBeMixedOrChildren;
*CM_NoPCDATAHere = *XML::Xercesc::XMLExcepts_CM_NoPCDATAHere;
*CM_NotValidForSpecType = *XML::Xercesc::XMLExcepts_CM_NotValidForSpecType;
*CM_UnaryOpHadBinType = *XML::Xercesc::XMLExcepts_CM_UnaryOpHadBinType;
*CM_UnknownCMType = *XML::Xercesc::XMLExcepts_CM_UnknownCMType;
*CM_UnknownCMSpecType = *XML::Xercesc::XMLExcepts_CM_UnknownCMSpecType;
*CM_NoParentCSN = *XML::Xercesc::XMLExcepts_CM_NoParentCSN;
*CM_NotValidSpecTypeForNode = *XML::Xercesc::XMLExcepts_CM_NotValidSpecTypeForNode;
*DTD_UnknownCreateReason = *XML::Xercesc::XMLExcepts_DTD_UnknownCreateReason;
*ElemStack_EmptyStack = *XML::Xercesc::XMLExcepts_ElemStack_EmptyStack;
*ElemStack_BadIndex = *XML::Xercesc::XMLExcepts_ElemStack_BadIndex;
*ElemStack_StackUnderflow = *XML::Xercesc::XMLExcepts_ElemStack_StackUnderflow;
*ElemStack_NoParentPushed = *XML::Xercesc::XMLExcepts_ElemStack_NoParentPushed;
*Enum_NoMoreElements = *XML::Xercesc::XMLExcepts_Enum_NoMoreElements;
*File_CouldNotOpenFile = *XML::Xercesc::XMLExcepts_File_CouldNotOpenFile;
*File_CouldNotGetCurPos = *XML::Xercesc::XMLExcepts_File_CouldNotGetCurPos;
*File_CouldNotCloseFile = *XML::Xercesc::XMLExcepts_File_CouldNotCloseFile;
*File_CouldNotSeekToEnd = *XML::Xercesc::XMLExcepts_File_CouldNotSeekToEnd;
*File_CouldNotSeekToPos = *XML::Xercesc::XMLExcepts_File_CouldNotSeekToPos;
*File_CouldNotDupHandle = *XML::Xercesc::XMLExcepts_File_CouldNotDupHandle;
*File_CouldNotReadFromFile = *XML::Xercesc::XMLExcepts_File_CouldNotReadFromFile;
*File_CouldNotWriteToFile = *XML::Xercesc::XMLExcepts_File_CouldNotWriteToFile;
*File_CouldNotResetFile = *XML::Xercesc::XMLExcepts_File_CouldNotResetFile;
*File_CouldNotGetSize = *XML::Xercesc::XMLExcepts_File_CouldNotGetSize;
*File_CouldNotGetBasePathName = *XML::Xercesc::XMLExcepts_File_CouldNotGetBasePathName;
*File_BasePathUnderflow = *XML::Xercesc::XMLExcepts_File_BasePathUnderflow;
*Gen_ParseInProgress = *XML::Xercesc::XMLExcepts_Gen_ParseInProgress;
*Gen_NoDTDValidator = *XML::Xercesc::XMLExcepts_Gen_NoDTDValidator;
*Gen_CouldNotOpenDTD = *XML::Xercesc::XMLExcepts_Gen_CouldNotOpenDTD;
*Gen_CouldNotOpenExtEntity = *XML::Xercesc::XMLExcepts_Gen_CouldNotOpenExtEntity;
*Gen_UnexpectedEOF = *XML::Xercesc::XMLExcepts_Gen_UnexpectedEOF;
*HshTbl_ZeroModulus = *XML::Xercesc::XMLExcepts_HshTbl_ZeroModulus;
*HshTbl_BadHashFromKey = *XML::Xercesc::XMLExcepts_HshTbl_BadHashFromKey;
*HshTbl_NoSuchKeyExists = *XML::Xercesc::XMLExcepts_HshTbl_NoSuchKeyExists;
*Mutex_CouldNotCreate = *XML::Xercesc::XMLExcepts_Mutex_CouldNotCreate;
*Mutex_CouldNotClose = *XML::Xercesc::XMLExcepts_Mutex_CouldNotClose;
*Mutex_CouldNotLock = *XML::Xercesc::XMLExcepts_Mutex_CouldNotLock;
*Mutex_CouldNotUnlock = *XML::Xercesc::XMLExcepts_Mutex_CouldNotUnlock;
*Mutex_CouldNotDestroy = *XML::Xercesc::XMLExcepts_Mutex_CouldNotDestroy;
*NetAcc_InternalError = *XML::Xercesc::XMLExcepts_NetAcc_InternalError;
*NetAcc_LengthError = *XML::Xercesc::XMLExcepts_NetAcc_LengthError;
*NetAcc_InitFailed = *XML::Xercesc::XMLExcepts_NetAcc_InitFailed;
*NetAcc_TargetResolution = *XML::Xercesc::XMLExcepts_NetAcc_TargetResolution;
*NetAcc_CreateSocket = *XML::Xercesc::XMLExcepts_NetAcc_CreateSocket;
*NetAcc_ConnSocket = *XML::Xercesc::XMLExcepts_NetAcc_ConnSocket;
*NetAcc_WriteSocket = *XML::Xercesc::XMLExcepts_NetAcc_WriteSocket;
*NetAcc_ReadSocket = *XML::Xercesc::XMLExcepts_NetAcc_ReadSocket;
*Pool_ElemAlreadyExists = *XML::Xercesc::XMLExcepts_Pool_ElemAlreadyExists;
*Pool_BadHashFromKey = *XML::Xercesc::XMLExcepts_Pool_BadHashFromKey;
*Pool_InvalidId = *XML::Xercesc::XMLExcepts_Pool_InvalidId;
*Pool_ZeroModulus = *XML::Xercesc::XMLExcepts_Pool_ZeroModulus;
*RdrMgr_ReaderIdNotFound = *XML::Xercesc::XMLExcepts_RdrMgr_ReaderIdNotFound;
*Reader_BadAutoEncoding = *XML::Xercesc::XMLExcepts_Reader_BadAutoEncoding;
*Reader_CouldNotDecodeFirstLine = *XML::Xercesc::XMLExcepts_Reader_CouldNotDecodeFirstLine;
*Reader_EOIInMultiSeq = *XML::Xercesc::XMLExcepts_Reader_EOIInMultiSeq;
*Reader_SrcOfsNotSupported = *XML::Xercesc::XMLExcepts_Reader_SrcOfsNotSupported;
*Reader_EncodingStrRequired = *XML::Xercesc::XMLExcepts_Reader_EncodingStrRequired;
*Scan_CouldNotOpenSource = *XML::Xercesc::XMLExcepts_Scan_CouldNotOpenSource;
*Scan_UnbalancedStartEnd = *XML::Xercesc::XMLExcepts_Scan_UnbalancedStartEnd;
*Scan_BadPScanToken = *XML::Xercesc::XMLExcepts_Scan_BadPScanToken;
*Stack_BadIndex = *XML::Xercesc::XMLExcepts_Stack_BadIndex;
*Stack_EmptyStack = *XML::Xercesc::XMLExcepts_Stack_EmptyStack;
*Str_ZeroSizedTargetBuf = *XML::Xercesc::XMLExcepts_Str_ZeroSizedTargetBuf;
*Str_UnknownRadix = *XML::Xercesc::XMLExcepts_Str_UnknownRadix;
*Str_TargetBufTooSmall = *XML::Xercesc::XMLExcepts_Str_TargetBufTooSmall;
*Str_StartIndexPastEnd = *XML::Xercesc::XMLExcepts_Str_StartIndexPastEnd;
*Str_ConvertOverflow = *XML::Xercesc::XMLExcepts_Str_ConvertOverflow;
*Strm_StdErrWriteFailure = *XML::Xercesc::XMLExcepts_Strm_StdErrWriteFailure;
*Strm_StdOutWriteFailure = *XML::Xercesc::XMLExcepts_Strm_StdOutWriteFailure;
*Strm_ConWriteFailure = *XML::Xercesc::XMLExcepts_Strm_ConWriteFailure;
*StrPool_IllegalId = *XML::Xercesc::XMLExcepts_StrPool_IllegalId;
*Trans_CouldNotCreateDefCvtr = *XML::Xercesc::XMLExcepts_Trans_CouldNotCreateDefCvtr;
*Trans_InvalidSizeReq = *XML::Xercesc::XMLExcepts_Trans_InvalidSizeReq;
*Trans_Unrepresentable = *XML::Xercesc::XMLExcepts_Trans_Unrepresentable;
*Trans_NotValidForEncoding = *XML::Xercesc::XMLExcepts_Trans_NotValidForEncoding;
*Trans_BadBlockSize = *XML::Xercesc::XMLExcepts_Trans_BadBlockSize;
*Trans_BadSrcSeq = *XML::Xercesc::XMLExcepts_Trans_BadSrcSeq;
*Trans_BadSrcCP = *XML::Xercesc::XMLExcepts_Trans_BadSrcCP;
*Trans_BadTrailingSurrogate = *XML::Xercesc::XMLExcepts_Trans_BadTrailingSurrogate;
*Trans_CantCreateCvtrFor = *XML::Xercesc::XMLExcepts_Trans_CantCreateCvtrFor;
*URL_MalformedURL = *XML::Xercesc::XMLExcepts_URL_MalformedURL;
*URL_UnsupportedProto = *XML::Xercesc::XMLExcepts_URL_UnsupportedProto;
*URL_UnsupportedProto1 = *XML::Xercesc::XMLExcepts_URL_UnsupportedProto1;
*URL_OnlyLocalHost = *XML::Xercesc::XMLExcepts_URL_OnlyLocalHost;
*URL_NoProtocolPresent = *XML::Xercesc::XMLExcepts_URL_NoProtocolPresent;
*URL_ExpectingTwoSlashes = *XML::Xercesc::XMLExcepts_URL_ExpectingTwoSlashes;
*URL_IncorrectEscapedCharRef = *XML::Xercesc::XMLExcepts_URL_IncorrectEscapedCharRef;
*URL_UnterminatedHostComponent = *XML::Xercesc::XMLExcepts_URL_UnterminatedHostComponent;
*URL_RelativeBaseURL = *XML::Xercesc::XMLExcepts_URL_RelativeBaseURL;
*URL_BaseUnderflow = *XML::Xercesc::XMLExcepts_URL_BaseUnderflow;
*URL_BadPortField = *XML::Xercesc::XMLExcepts_URL_BadPortField;
*UTF8_FormatError = *XML::Xercesc::XMLExcepts_UTF8_FormatError;
*Vector_BadIndex = *XML::Xercesc::XMLExcepts_Vector_BadIndex;
*Val_InvalidElemId = *XML::Xercesc::XMLExcepts_Val_InvalidElemId;
*Val_CantHaveIntSS = *XML::Xercesc::XMLExcepts_Val_CantHaveIntSS;
*XMLRec_UnknownEncoding = *XML::Xercesc::XMLExcepts_XMLRec_UnknownEncoding;
*Parser_Parse1 = *XML::Xercesc::XMLExcepts_Parser_Parse1;
*Parser_Parse2 = *XML::Xercesc::XMLExcepts_Parser_Parse2;
*Parser_Next1 = *XML::Xercesc::XMLExcepts_Parser_Next1;
*Parser_Next2 = *XML::Xercesc::XMLExcepts_Parser_Next2;
*Parser_Next3 = *XML::Xercesc::XMLExcepts_Parser_Next3;
*Parser_Next4 = *XML::Xercesc::XMLExcepts_Parser_Next4;
*Parser_Factor1 = *XML::Xercesc::XMLExcepts_Parser_Factor1;
*Parser_Factor2 = *XML::Xercesc::XMLExcepts_Parser_Factor2;
*Parser_Factor3 = *XML::Xercesc::XMLExcepts_Parser_Factor3;
*Parser_Factor4 = *XML::Xercesc::XMLExcepts_Parser_Factor4;
*Parser_Factor5 = *XML::Xercesc::XMLExcepts_Parser_Factor5;
*Parser_Factor6 = *XML::Xercesc::XMLExcepts_Parser_Factor6;
*Parser_Atom1 = *XML::Xercesc::XMLExcepts_Parser_Atom1;
*Parser_Atom2 = *XML::Xercesc::XMLExcepts_Parser_Atom2;
*Parser_Atom3 = *XML::Xercesc::XMLExcepts_Parser_Atom3;
*Parser_Atom4 = *XML::Xercesc::XMLExcepts_Parser_Atom4;
*Parser_Atom5 = *XML::Xercesc::XMLExcepts_Parser_Atom5;
*Parser_CC1 = *XML::Xercesc::XMLExcepts_Parser_CC1;
*Parser_CC2 = *XML::Xercesc::XMLExcepts_Parser_CC2;
*Parser_CC3 = *XML::Xercesc::XMLExcepts_Parser_CC3;
*Parser_CC4 = *XML::Xercesc::XMLExcepts_Parser_CC4;
*Parser_CC5 = *XML::Xercesc::XMLExcepts_Parser_CC5;
*Parser_CC6 = *XML::Xercesc::XMLExcepts_Parser_CC6;
*Parser_Ope1 = *XML::Xercesc::XMLExcepts_Parser_Ope1;
*Parser_Ope2 = *XML::Xercesc::XMLExcepts_Parser_Ope2;
*Parser_Ope3 = *XML::Xercesc::XMLExcepts_Parser_Ope3;
*Parser_Descape1 = *XML::Xercesc::XMLExcepts_Parser_Descape1;
*Parser_Descape2 = *XML::Xercesc::XMLExcepts_Parser_Descape2;
*Parser_Descape3 = *XML::Xercesc::XMLExcepts_Parser_Descape3;
*Parser_Descape4 = *XML::Xercesc::XMLExcepts_Parser_Descape4;
*Parser_Descape5 = *XML::Xercesc::XMLExcepts_Parser_Descape5;
*Parser_Process1 = *XML::Xercesc::XMLExcepts_Parser_Process1;
*Parser_Process2 = *XML::Xercesc::XMLExcepts_Parser_Process2;
*Parser_Quantifier1 = *XML::Xercesc::XMLExcepts_Parser_Quantifier1;
*Parser_Quantifier2 = *XML::Xercesc::XMLExcepts_Parser_Quantifier2;
*Parser_Quantifier3 = *XML::Xercesc::XMLExcepts_Parser_Quantifier3;
*Parser_Quantifier4 = *XML::Xercesc::XMLExcepts_Parser_Quantifier4;
*Parser_Quantifier5 = *XML::Xercesc::XMLExcepts_Parser_Quantifier5;
*Gen_NoSchemaValidator = *XML::Xercesc::XMLExcepts_Gen_NoSchemaValidator;
*XUTIL_UnCopyableNodeType = *XML::Xercesc::XMLExcepts_XUTIL_UnCopyableNodeType;
*SubGrpComparator_NGR = *XML::Xercesc::XMLExcepts_SubGrpComparator_NGR;
*FACET_Invalid_Len = *XML::Xercesc::XMLExcepts_FACET_Invalid_Len;
*FACET_Invalid_maxLen = *XML::Xercesc::XMLExcepts_FACET_Invalid_maxLen;
*FACET_Invalid_minLen = *XML::Xercesc::XMLExcepts_FACET_Invalid_minLen;
*FACET_NonNeg_Len = *XML::Xercesc::XMLExcepts_FACET_NonNeg_Len;
*FACET_NonNeg_maxLen = *XML::Xercesc::XMLExcepts_FACET_NonNeg_maxLen;
*FACET_NonNeg_minLen = *XML::Xercesc::XMLExcepts_FACET_NonNeg_minLen;
*FACET_Len_maxLen = *XML::Xercesc::XMLExcepts_FACET_Len_maxLen;
*FACET_Len_minLen = *XML::Xercesc::XMLExcepts_FACET_Len_minLen;
*FACET_maxLen_minLen = *XML::Xercesc::XMLExcepts_FACET_maxLen_minLen;
*FACET_bool_Pattern = *XML::Xercesc::XMLExcepts_FACET_bool_Pattern;
*FACET_Invalid_Tag = *XML::Xercesc::XMLExcepts_FACET_Invalid_Tag;
*FACET_Len_baseLen = *XML::Xercesc::XMLExcepts_FACET_Len_baseLen;
*FACET_minLen_baseminLen = *XML::Xercesc::XMLExcepts_FACET_minLen_baseminLen;
*FACET_minLen_basemaxLen = *XML::Xercesc::XMLExcepts_FACET_minLen_basemaxLen;
*FACET_maxLen_basemaxLen = *XML::Xercesc::XMLExcepts_FACET_maxLen_basemaxLen;
*FACET_maxLen_baseminLen = *XML::Xercesc::XMLExcepts_FACET_maxLen_baseminLen;
*FACET_Len_baseMinLen = *XML::Xercesc::XMLExcepts_FACET_Len_baseMinLen;
*FACET_Len_baseMaxLen = *XML::Xercesc::XMLExcepts_FACET_Len_baseMaxLen;
*FACET_minLen_baseLen = *XML::Xercesc::XMLExcepts_FACET_minLen_baseLen;
*FACET_maxLen_baseLen = *XML::Xercesc::XMLExcepts_FACET_maxLen_baseLen;
*FACET_enum_base = *XML::Xercesc::XMLExcepts_FACET_enum_base;
*FACET_Invalid_WS = *XML::Xercesc::XMLExcepts_FACET_Invalid_WS;
*FACET_WS_collapse = *XML::Xercesc::XMLExcepts_FACET_WS_collapse;
*FACET_WS_replace = *XML::Xercesc::XMLExcepts_FACET_WS_replace;
*FACET_Invalid_MaxIncl = *XML::Xercesc::XMLExcepts_FACET_Invalid_MaxIncl;
*FACET_Invalid_MaxExcl = *XML::Xercesc::XMLExcepts_FACET_Invalid_MaxExcl;
*FACET_Invalid_MinIncl = *XML::Xercesc::XMLExcepts_FACET_Invalid_MinIncl;
*FACET_Invalid_MinExcl = *XML::Xercesc::XMLExcepts_FACET_Invalid_MinExcl;
*FACET_Invalid_TotalDigit = *XML::Xercesc::XMLExcepts_FACET_Invalid_TotalDigit;
*FACET_Invalid_FractDigit = *XML::Xercesc::XMLExcepts_FACET_Invalid_FractDigit;
*FACET_PosInt_TotalDigit = *XML::Xercesc::XMLExcepts_FACET_PosInt_TotalDigit;
*FACET_NonNeg_FractDigit = *XML::Xercesc::XMLExcepts_FACET_NonNeg_FractDigit;
*FACET_max_Incl_Excl = *XML::Xercesc::XMLExcepts_FACET_max_Incl_Excl;
*FACET_min_Incl_Excl = *XML::Xercesc::XMLExcepts_FACET_min_Incl_Excl;
*FACET_maxExcl_minExcl = *XML::Xercesc::XMLExcepts_FACET_maxExcl_minExcl;
*FACET_maxExcl_minIncl = *XML::Xercesc::XMLExcepts_FACET_maxExcl_minIncl;
*FACET_maxIncl_minExcl = *XML::Xercesc::XMLExcepts_FACET_maxIncl_minExcl;
*FACET_maxIncl_minIncl = *XML::Xercesc::XMLExcepts_FACET_maxIncl_minIncl;
*FACET_TotDigit_FractDigit = *XML::Xercesc::XMLExcepts_FACET_TotDigit_FractDigit;
*FACET_maxIncl_base_maxExcl = *XML::Xercesc::XMLExcepts_FACET_maxIncl_base_maxExcl;
*FACET_maxIncl_base_maxIncl = *XML::Xercesc::XMLExcepts_FACET_maxIncl_base_maxIncl;
*FACET_maxIncl_base_minIncl = *XML::Xercesc::XMLExcepts_FACET_maxIncl_base_minIncl;
*FACET_maxIncl_base_minExcl = *XML::Xercesc::XMLExcepts_FACET_maxIncl_base_minExcl;
*FACET_maxExcl_base_maxExcl = *XML::Xercesc::XMLExcepts_FACET_maxExcl_base_maxExcl;
*FACET_maxExcl_base_maxIncl = *XML::Xercesc::XMLExcepts_FACET_maxExcl_base_maxIncl;
*FACET_maxExcl_base_minIncl = *XML::Xercesc::XMLExcepts_FACET_maxExcl_base_minIncl;
*FACET_maxExcl_base_minExcl = *XML::Xercesc::XMLExcepts_FACET_maxExcl_base_minExcl;
*FACET_minExcl_base_maxExcl = *XML::Xercesc::XMLExcepts_FACET_minExcl_base_maxExcl;
*FACET_minExcl_base_maxIncl = *XML::Xercesc::XMLExcepts_FACET_minExcl_base_maxIncl;
*FACET_minExcl_base_minIncl = *XML::Xercesc::XMLExcepts_FACET_minExcl_base_minIncl;
*FACET_minExcl_base_minExcl = *XML::Xercesc::XMLExcepts_FACET_minExcl_base_minExcl;
*FACET_minIncl_base_maxExcl = *XML::Xercesc::XMLExcepts_FACET_minIncl_base_maxExcl;
*FACET_minIncl_base_maxIncl = *XML::Xercesc::XMLExcepts_FACET_minIncl_base_maxIncl;
*FACET_minIncl_base_minIncl = *XML::Xercesc::XMLExcepts_FACET_minIncl_base_minIncl;
*FACET_minIncl_base_minExcl = *XML::Xercesc::XMLExcepts_FACET_minIncl_base_minExcl;
*FACET_maxIncl_notFromBase = *XML::Xercesc::XMLExcepts_FACET_maxIncl_notFromBase;
*FACET_maxExcl_notFromBase = *XML::Xercesc::XMLExcepts_FACET_maxExcl_notFromBase;
*FACET_minIncl_notFromBase = *XML::Xercesc::XMLExcepts_FACET_minIncl_notFromBase;
*FACET_minExcl_notFromBase = *XML::Xercesc::XMLExcepts_FACET_minExcl_notFromBase;
*FACET_totalDigit_base_totalDigit = *XML::Xercesc::XMLExcepts_FACET_totalDigit_base_totalDigit;
*FACET_fractDigit_base_totalDigit = *XML::Xercesc::XMLExcepts_FACET_fractDigit_base_totalDigit;
*FACET_fractDigit_base_fractDigit = *XML::Xercesc::XMLExcepts_FACET_fractDigit_base_fractDigit;
*FACET_maxIncl_base_fixed = *XML::Xercesc::XMLExcepts_FACET_maxIncl_base_fixed;
*FACET_maxExcl_base_fixed = *XML::Xercesc::XMLExcepts_FACET_maxExcl_base_fixed;
*FACET_minIncl_base_fixed = *XML::Xercesc::XMLExcepts_FACET_minIncl_base_fixed;
*FACET_minExcl_base_fixed = *XML::Xercesc::XMLExcepts_FACET_minExcl_base_fixed;
*FACET_totalDigit_base_fixed = *XML::Xercesc::XMLExcepts_FACET_totalDigit_base_fixed;
*FACET_fractDigit_base_fixed = *XML::Xercesc::XMLExcepts_FACET_fractDigit_base_fixed;
*FACET_maxLen_base_fixed = *XML::Xercesc::XMLExcepts_FACET_maxLen_base_fixed;
*FACET_minLen_base_fixed = *XML::Xercesc::XMLExcepts_FACET_minLen_base_fixed;
*FACET_len_base_fixed = *XML::Xercesc::XMLExcepts_FACET_len_base_fixed;
*FACET_whitespace_base_fixed = *XML::Xercesc::XMLExcepts_FACET_whitespace_base_fixed;
*FACET_internalError_fixed = *XML::Xercesc::XMLExcepts_FACET_internalError_fixed;
*FACET_List_Null_baseValidator = *XML::Xercesc::XMLExcepts_FACET_List_Null_baseValidator;
*FACET_Union_Null_memberTypeValidators = *XML::Xercesc::XMLExcepts_FACET_Union_Null_memberTypeValidators;
*FACET_Union_Null_baseValidator = *XML::Xercesc::XMLExcepts_FACET_Union_Null_baseValidator;
*FACET_Union_invalid_baseValidatorType = *XML::Xercesc::XMLExcepts_FACET_Union_invalid_baseValidatorType;
*VALUE_NotMatch_Pattern = *XML::Xercesc::XMLExcepts_VALUE_NotMatch_Pattern;
*VALUE_Not_Base64 = *XML::Xercesc::XMLExcepts_VALUE_Not_Base64;
*VALUE_Not_HexBin = *XML::Xercesc::XMLExcepts_VALUE_Not_HexBin;
*VALUE_GT_maxLen = *XML::Xercesc::XMLExcepts_VALUE_GT_maxLen;
*VALUE_LT_minLen = *XML::Xercesc::XMLExcepts_VALUE_LT_minLen;
*VALUE_NE_Len = *XML::Xercesc::XMLExcepts_VALUE_NE_Len;
*VALUE_NotIn_Enumeration = *XML::Xercesc::XMLExcepts_VALUE_NotIn_Enumeration;
*VALUE_exceed_totalDigit = *XML::Xercesc::XMLExcepts_VALUE_exceed_totalDigit;
*VALUE_exceed_fractDigit = *XML::Xercesc::XMLExcepts_VALUE_exceed_fractDigit;
*VALUE_exceed_maxIncl = *XML::Xercesc::XMLExcepts_VALUE_exceed_maxIncl;
*VALUE_exceed_maxExcl = *XML::Xercesc::XMLExcepts_VALUE_exceed_maxExcl;
*VALUE_exceed_minIncl = *XML::Xercesc::XMLExcepts_VALUE_exceed_minIncl;
*VALUE_exceed_minExcl = *XML::Xercesc::XMLExcepts_VALUE_exceed_minExcl;
*VALUE_WS_replaced = *XML::Xercesc::XMLExcepts_VALUE_WS_replaced;
*VALUE_WS_collapsed = *XML::Xercesc::XMLExcepts_VALUE_WS_collapsed;
*VALUE_Invalid_NCName = *XML::Xercesc::XMLExcepts_VALUE_Invalid_NCName;
*VALUE_Invalid_Name = *XML::Xercesc::XMLExcepts_VALUE_Invalid_Name;
*VALUE_ID_Not_Unique = *XML::Xercesc::XMLExcepts_VALUE_ID_Not_Unique;
*VALUE_ENTITY_Invalid = *XML::Xercesc::XMLExcepts_VALUE_ENTITY_Invalid;
*VALUE_QName_Invalid = *XML::Xercesc::XMLExcepts_VALUE_QName_Invalid;
*VALUE_NOTATION_Invalid = *XML::Xercesc::XMLExcepts_VALUE_NOTATION_Invalid;
*VALUE_no_match_memberType = *XML::Xercesc::XMLExcepts_VALUE_no_match_memberType;
*VALUE_URI_Malformed = *XML::Xercesc::XMLExcepts_VALUE_URI_Malformed;
*XMLNUM_emptyString = *XML::Xercesc::XMLExcepts_XMLNUM_emptyString;
*XMLNUM_WSString = *XML::Xercesc::XMLExcepts_XMLNUM_WSString;
*XMLNUM_2ManyDecPoint = *XML::Xercesc::XMLExcepts_XMLNUM_2ManyDecPoint;
*XMLNUM_Inv_chars = *XML::Xercesc::XMLExcepts_XMLNUM_Inv_chars;
*XMLNUM_null_ptr = *XML::Xercesc::XMLExcepts_XMLNUM_null_ptr;
*XMLNUM_URI_Component_Empty = *XML::Xercesc::XMLExcepts_XMLNUM_URI_Component_Empty;
*XMLNUM_URI_Component_for_GenURI_Only = *XML::Xercesc::XMLExcepts_XMLNUM_URI_Component_for_GenURI_Only;
*XMLNUM_URI_Component_Invalid_EscapeSequence = *XML::Xercesc::XMLExcepts_XMLNUM_URI_Component_Invalid_EscapeSequence;
*XMLNUM_URI_Component_Invalid_Char = *XML::Xercesc::XMLExcepts_XMLNUM_URI_Component_Invalid_Char;
*XMLNUM_URI_Component_Set_Null = *XML::Xercesc::XMLExcepts_XMLNUM_URI_Component_Set_Null;
*XMLNUM_URI_Component_Not_Conformant = *XML::Xercesc::XMLExcepts_XMLNUM_URI_Component_Not_Conformant;
*XMLNUM_URI_No_Scheme = *XML::Xercesc::XMLExcepts_XMLNUM_URI_No_Scheme;
*XMLNUM_URI_NullHost = *XML::Xercesc::XMLExcepts_XMLNUM_URI_NullHost;
*XMLNUM_URI_NullPath = *XML::Xercesc::XMLExcepts_XMLNUM_URI_NullPath;
*XMLNUM_URI_Component_inPath = *XML::Xercesc::XMLExcepts_XMLNUM_URI_Component_inPath;
*XMLNUM_URI_PortNo_Invalid = *XML::Xercesc::XMLExcepts_XMLNUM_URI_PortNo_Invalid;
*XMLNUM_DBL_FLT_maxNeg = *XML::Xercesc::XMLExcepts_XMLNUM_DBL_FLT_maxNeg;
*XMLNUM_DBL_FLT_maxPos = *XML::Xercesc::XMLExcepts_XMLNUM_DBL_FLT_maxPos;
*XMLNUM_DBL_FLT_minNegPos = *XML::Xercesc::XMLExcepts_XMLNUM_DBL_FLT_minNegPos;
*XMLNUM_DBL_FLT_InvalidType = *XML::Xercesc::XMLExcepts_XMLNUM_DBL_FLT_InvalidType;
*XMLNUM_DBL_FLT_No_Exponent = *XML::Xercesc::XMLExcepts_XMLNUM_DBL_FLT_No_Exponent;
*Regex_Result_Not_Set = *XML::Xercesc::XMLExcepts_Regex_Result_Not_Set;
*Regex_CompactRangesError = *XML::Xercesc::XMLExcepts_Regex_CompactRangesError;
*Regex_MergeRangesTypeMismatch = *XML::Xercesc::XMLExcepts_Regex_MergeRangesTypeMismatch;
*Regex_SubtractRangesError = *XML::Xercesc::XMLExcepts_Regex_SubtractRangesError;
*Regex_IntersectRangesError = *XML::Xercesc::XMLExcepts_Regex_IntersectRangesError;
*Regex_ComplementRangesInvalidArg = *XML::Xercesc::XMLExcepts_Regex_ComplementRangesInvalidArg;
*Regex_InvalidCategoryName = *XML::Xercesc::XMLExcepts_Regex_InvalidCategoryName;
*Regex_KeywordNotFound = *XML::Xercesc::XMLExcepts_Regex_KeywordNotFound;
*Regex_BadRefNo = *XML::Xercesc::XMLExcepts_Regex_BadRefNo;
*Regex_UnknownOption = *XML::Xercesc::XMLExcepts_Regex_UnknownOption;
*Regex_UnknownTokenType = *XML::Xercesc::XMLExcepts_Regex_UnknownTokenType;
*Regex_RangeTokenGetError = *XML::Xercesc::XMLExcepts_Regex_RangeTokenGetError;
*Regex_NotSupported = *XML::Xercesc::XMLExcepts_Regex_NotSupported;
*Regex_InvalidChildIndex = *XML::Xercesc::XMLExcepts_Regex_InvalidChildIndex;
*Regex_RepPatMatchesZeroString = *XML::Xercesc::XMLExcepts_Regex_RepPatMatchesZeroString;
*Regex_InvalidRepPattern = *XML::Xercesc::XMLExcepts_Regex_InvalidRepPattern;
*NEL_RepeatedCalls = *XML::Xercesc::XMLExcepts_NEL_RepeatedCalls;
*RethrowError = *XML::Xercesc::XMLExcepts_RethrowError;
*Out_Of_Memory = *XML::Xercesc::XMLExcepts_Out_Of_Memory;
*DV_InvalidOperation = *XML::Xercesc::XMLExcepts_DV_InvalidOperation;
*XPath_NoAttrSelector = *XML::Xercesc::XMLExcepts_XPath_NoAttrSelector;
*XPath_NoUnionAtStart = *XML::Xercesc::XMLExcepts_XPath_NoUnionAtStart;
*XPath_NoMultipleUnion = *XML::Xercesc::XMLExcepts_XPath_NoMultipleUnion;
*XPath_MissingAttr = *XML::Xercesc::XMLExcepts_XPath_MissingAttr;
*XPath_ExpectedToken1 = *XML::Xercesc::XMLExcepts_XPath_ExpectedToken1;
*XPath_PrefixNoURI = *XML::Xercesc::XMLExcepts_XPath_PrefixNoURI;
*XPath_NoDoubleColon = *XML::Xercesc::XMLExcepts_XPath_NoDoubleColon;
*XPath_ExpectedStep1 = *XML::Xercesc::XMLExcepts_XPath_ExpectedStep1;
*XPath_ExpectedStep2 = *XML::Xercesc::XMLExcepts_XPath_ExpectedStep2;
*XPath_ExpectedStep3 = *XML::Xercesc::XMLExcepts_XPath_ExpectedStep3;
*XPath_NoForwardSlash = *XML::Xercesc::XMLExcepts_XPath_NoForwardSlash;
*XPath_NoDoubleForwardSlash = *XML::Xercesc::XMLExcepts_XPath_NoDoubleForwardSlash;
*XPath_NoForwardSlashAtStart = *XML::Xercesc::XMLExcepts_XPath_NoForwardSlashAtStart;
*XPath_NoSelectionOfRoot = *XML::Xercesc::XMLExcepts_XPath_NoSelectionOfRoot;
*XPath_EmptyExpr = *XML::Xercesc::XMLExcepts_XPath_EmptyExpr;
*XPath_NoUnionAtEnd = *XML::Xercesc::XMLExcepts_XPath_NoUnionAtEnd;
*XPath_InvalidChar = *XML::Xercesc::XMLExcepts_XPath_InvalidChar;
*XPath_TokenNotSupported = *XML::Xercesc::XMLExcepts_XPath_TokenNotSupported;
*XPath_FindSolution = *XML::Xercesc::XMLExcepts_XPath_FindSolution;
*DateTime_Assert_Buffer_Fail = *XML::Xercesc::XMLExcepts_DateTime_Assert_Buffer_Fail;
*DateTime_dt_missingT = *XML::Xercesc::XMLExcepts_DateTime_dt_missingT;
*DateTime_gDay_invalid = *XML::Xercesc::XMLExcepts_DateTime_gDay_invalid;
*DateTime_gMth_invalid = *XML::Xercesc::XMLExcepts_DateTime_gMth_invalid;
*DateTime_gMthDay_invalid = *XML::Xercesc::XMLExcepts_DateTime_gMthDay_invalid;
*DateTime_dur_Start_dashP = *XML::Xercesc::XMLExcepts_DateTime_dur_Start_dashP;
*DateTime_dur_noP = *XML::Xercesc::XMLExcepts_DateTime_dur_noP;
*DateTime_dur_DashNotFirst = *XML::Xercesc::XMLExcepts_DateTime_dur_DashNotFirst;
*DateTime_dur_inv_b4T = *XML::Xercesc::XMLExcepts_DateTime_dur_inv_b4T;
*DateTime_dur_NoTimeAfterT = *XML::Xercesc::XMLExcepts_DateTime_dur_NoTimeAfterT;
*DateTime_dur_NoElementAtAll = *XML::Xercesc::XMLExcepts_DateTime_dur_NoElementAtAll;
*DateTime_dur_inv_seconds = *XML::Xercesc::XMLExcepts_DateTime_dur_inv_seconds;
*DateTime_date_incomplete = *XML::Xercesc::XMLExcepts_DateTime_date_incomplete;
*DateTime_date_invalid = *XML::Xercesc::XMLExcepts_DateTime_date_invalid;
*DateTime_time_incomplete = *XML::Xercesc::XMLExcepts_DateTime_time_incomplete;
*DateTime_time_invalid = *XML::Xercesc::XMLExcepts_DateTime_time_invalid;
*DateTime_ms_noDigit = *XML::Xercesc::XMLExcepts_DateTime_ms_noDigit;
*DateTime_ym_incomplete = *XML::Xercesc::XMLExcepts_DateTime_ym_incomplete;
*DateTime_ym_invalid = *XML::Xercesc::XMLExcepts_DateTime_ym_invalid;
*DateTime_year_tooShort = *XML::Xercesc::XMLExcepts_DateTime_year_tooShort;
*DateTime_year_leadingZero = *XML::Xercesc::XMLExcepts_DateTime_year_leadingZero;
*DateTime_ym_noMonth = *XML::Xercesc::XMLExcepts_DateTime_ym_noMonth;
*DateTime_tz_noUTCsign = *XML::Xercesc::XMLExcepts_DateTime_tz_noUTCsign;
*DateTime_tz_stuffAfterZ = *XML::Xercesc::XMLExcepts_DateTime_tz_stuffAfterZ;
*DateTime_tz_invalid = *XML::Xercesc::XMLExcepts_DateTime_tz_invalid;
*DateTime_year_zero = *XML::Xercesc::XMLExcepts_DateTime_year_zero;
*DateTime_mth_invalid = *XML::Xercesc::XMLExcepts_DateTime_mth_invalid;
*DateTime_day_invalid = *XML::Xercesc::XMLExcepts_DateTime_day_invalid;
*DateTime_hour_invalid = *XML::Xercesc::XMLExcepts_DateTime_hour_invalid;
*DateTime_min_invalid = *XML::Xercesc::XMLExcepts_DateTime_min_invalid;
*DateTime_second_invalid = *XML::Xercesc::XMLExcepts_DateTime_second_invalid;
*DateTime_tz_hh_invalid = *XML::Xercesc::XMLExcepts_DateTime_tz_hh_invalid;
*PD_EmptyBase = *XML::Xercesc::XMLExcepts_PD_EmptyBase;
*PD_NSCompat1 = *XML::Xercesc::XMLExcepts_PD_NSCompat1;
*PD_OccurRangeE = *XML::Xercesc::XMLExcepts_PD_OccurRangeE;
*PD_NameTypeOK1 = *XML::Xercesc::XMLExcepts_PD_NameTypeOK1;
*PD_NameTypeOK2 = *XML::Xercesc::XMLExcepts_PD_NameTypeOK2;
*PD_NameTypeOK3 = *XML::Xercesc::XMLExcepts_PD_NameTypeOK3;
*PD_NameTypeOK4 = *XML::Xercesc::XMLExcepts_PD_NameTypeOK4;
*PD_NameTypeOK5 = *XML::Xercesc::XMLExcepts_PD_NameTypeOK5;
*PD_NameTypeOK6 = *XML::Xercesc::XMLExcepts_PD_NameTypeOK6;
*PD_NameTypeOK7 = *XML::Xercesc::XMLExcepts_PD_NameTypeOK7;
*PD_RecurseAsIfGroup = *XML::Xercesc::XMLExcepts_PD_RecurseAsIfGroup;
*PD_Recurse1 = *XML::Xercesc::XMLExcepts_PD_Recurse1;
*PD_Recurse2 = *XML::Xercesc::XMLExcepts_PD_Recurse2;
*PD_ForbiddenRes1 = *XML::Xercesc::XMLExcepts_PD_ForbiddenRes1;
*PD_ForbiddenRes2 = *XML::Xercesc::XMLExcepts_PD_ForbiddenRes2;
*PD_ForbiddenRes3 = *XML::Xercesc::XMLExcepts_PD_ForbiddenRes3;
*PD_ForbiddenRes4 = *XML::Xercesc::XMLExcepts_PD_ForbiddenRes4;
*PD_NSSubset1 = *XML::Xercesc::XMLExcepts_PD_NSSubset1;
*PD_NSSubset2 = *XML::Xercesc::XMLExcepts_PD_NSSubset2;
*PD_NSRecurseCheckCardinality1 = *XML::Xercesc::XMLExcepts_PD_NSRecurseCheckCardinality1;
*PD_RecurseUnordered = *XML::Xercesc::XMLExcepts_PD_RecurseUnordered;
*PD_MapAndSum = *XML::Xercesc::XMLExcepts_PD_MapAndSum;
*PD_InvalidContentType = *XML::Xercesc::XMLExcepts_PD_InvalidContentType;
*NodeIDMap_GrowErr = *XML::Xercesc::XMLExcepts_NodeIDMap_GrowErr;
*F_HighBounds = *XML::Xercesc::XMLExcepts_F_HighBounds;
*E_LowBounds = *XML::Xercesc::XMLExcepts_E_LowBounds;
*E_HighBounds = *XML::Xercesc::XMLExcepts_E_HighBounds;
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_XMLExcepts(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::XMLExcepts", $self;
    return bless \%retval, $pkg;
}


sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::XMLException ##############

package XML::Xerces::XMLException;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
use overload
    "=" => sub { $_[0]->operator_assignment($_[1])},
    "fallback" => 1;
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*getType = *XML::Xercesc::XMLException_getType;
*getCode = *XML::Xercesc::XMLException_getCode;
*getMessage = *XML::Xercesc::XMLException_getMessage;
*getSrcFile = *XML::Xercesc::XMLException_getSrcFile;
*getSrcLine = *XML::Xercesc::XMLException_getSrcLine;
*getErrorType = *XML::Xercesc::XMLException_getErrorType;
*setPosition = *XML::Xercesc::XMLException_setPosition;
sub operator_assignment {
    my @args = @_;
    my $result = XML::Xercesc::XMLException_operator_assignment(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*reinitMsgMutex = *XML::Xercesc::XMLException_reinitMsgMutex;
*reinitMsgLoader = *XML::Xercesc::XMLException_reinitMsgLoader;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::XMLValidator ##############

package XML::Xerces::XMLValidator;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*checkContent = *XML::Xercesc::XMLValidator_checkContent;
*faultInAttr = *XML::Xercesc::XMLValidator_faultInAttr;
*preContentValidation = *XML::Xercesc::XMLValidator_preContentValidation;
*postParseValidation = *XML::Xercesc::XMLValidator_postParseValidation;
*reset = *XML::Xercesc::XMLValidator_reset;
*requiresNamespaces = *XML::Xercesc::XMLValidator_requiresNamespaces;
*validateAttrValue = *XML::Xercesc::XMLValidator_validateAttrValue;
*validateElement = *XML::Xercesc::XMLValidator_validateElement;
sub getGrammar {
    my @args = @_;
    my $result = XML::Xercesc::XMLValidator_getGrammar(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*setGrammar = *XML::Xercesc::XMLValidator_setGrammar;
*handlesDTD = *XML::Xercesc::XMLValidator_handlesDTD;
*handlesSchema = *XML::Xercesc::XMLValidator_handlesSchema;
*setScannerInfo = *XML::Xercesc::XMLValidator_setScannerInfo;
*setErrorReporter = *XML::Xercesc::XMLValidator_setErrorReporter;
*emitError = *XML::Xercesc::XMLValidator_emitError;
*checkRootElement = *XML::Xercesc::XMLValidator_checkRootElement;
*reinitMsgMutex = *XML::Xercesc::XMLValidator_reinitMsgMutex;
*reinitMsgLoader = *XML::Xercesc::XMLValidator_reinitMsgLoader;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::SAXException ##############

package XML::Xerces::SAXException;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
use overload
    "=" => sub { $_[0]->operator_assignment($_[1])},
    "fallback" => 1;
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_SAXException(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::SAXException", $self;
    return bless \%retval, $pkg;
}


sub operator_assignment {
    my @args = @_;
    my $result = XML::Xercesc::SAXException_operator_assignment(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getMessage = *XML::Xercesc::SAXException_getMessage;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::SAXNotSupportedException ##############

package XML::Xerces::SAXNotSupportedException;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::SAXException );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_SAXNotSupportedException(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::SAXNotSupportedException", $self;
    return bless \%retval, $pkg;
}


sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::SAXNotRecognizedException ##############

package XML::Xerces::SAXNotRecognizedException;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::SAXException );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_SAXNotRecognizedException(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::SAXNotRecognizedException", $self;
    return bless \%retval, $pkg;
}


sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::SAXParseException ##############

package XML::Xerces::SAXParseException;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
use overload
    "=" => sub { $_[0]->operator_assignment($_[1])},
    "fallback" => 1;
@ISA = qw( XML::Xerces XML::Xerces::SAXException );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_SAXParseException(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::SAXParseException", $self;
    return bless \%retval, $pkg;
}


sub operator_assignment {
    my @args = @_;
    my $result = XML::Xercesc::SAXParseException_operator_assignment(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getColumnNumber = *XML::Xercesc::SAXParseException_getColumnNumber;
*getLineNumber = *XML::Xercesc::SAXParseException_getLineNumber;
*getPublicId = *XML::Xercesc::SAXParseException_getPublicId;
*getSystemId = *XML::Xercesc::SAXParseException_getSystemId;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::ErrorHandler ##############

package XML::Xerces::ErrorHandler;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*warning = *XML::Xercesc::ErrorHandler_warning;
*error = *XML::Xercesc::ErrorHandler_error;
*fatalError = *XML::Xercesc::ErrorHandler_fatalError;
*resetErrors = *XML::Xercesc::ErrorHandler_resetErrors;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DTDHandler ##############

package XML::Xerces::DTDHandler;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*notationDecl = *XML::Xercesc::DTDHandler_notationDecl;
*unparsedEntityDecl = *XML::Xercesc::DTDHandler_unparsedEntityDecl;
*resetDocType = *XML::Xercesc::DTDHandler_resetDocType;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DocumentHandler ##############

package XML::Xerces::DocumentHandler;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*characters = *XML::Xercesc::DocumentHandler_characters;
*endDocument = *XML::Xercesc::DocumentHandler_endDocument;
*endElement = *XML::Xercesc::DocumentHandler_endElement;
*ignorableWhitespace = *XML::Xercesc::DocumentHandler_ignorableWhitespace;
*processingInstruction = *XML::Xercesc::DocumentHandler_processingInstruction;
*resetDocument = *XML::Xercesc::DocumentHandler_resetDocument;
*setDocumentLocator = *XML::Xercesc::DocumentHandler_setDocumentLocator;
*startDocument = *XML::Xercesc::DocumentHandler_startDocument;
*startElement = *XML::Xercesc::DocumentHandler_startElement;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::EntityResolver ##############

package XML::Xerces::EntityResolver;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

sub resolveEntity {
    my @args = @_;
    my $result = XML::Xercesc::EntityResolver_resolveEntity(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::AttributeList ##############

package XML::Xerces::AttributeList;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*getLength = *XML::Xercesc::AttributeList_getLength;
*getName = *XML::Xercesc::AttributeList_getName;
*getType = *XML::Xercesc::AttributeList_getType;
*getType__overload__name = *XML::Xercesc::AttributeList_getType__overload__name;
*getValue__overload__name = *XML::Xercesc::AttributeList_getValue__overload__name;
*getValue = *XML::Xercesc::AttributeList_getValue;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::HandlerBase ##############

package XML::Xerces::HandlerBase;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::EntityResolver XML::Xerces::DTDHandler XML::Xerces::DocumentHandler XML::Xerces::ErrorHandler );
%OWNER = ();
%ITERATORS = ();
*characters = *XML::Xercesc::HandlerBase_characters;
*endDocument = *XML::Xercesc::HandlerBase_endDocument;
*endElement = *XML::Xercesc::HandlerBase_endElement;
*ignorableWhitespace = *XML::Xercesc::HandlerBase_ignorableWhitespace;
*processingInstruction = *XML::Xercesc::HandlerBase_processingInstruction;
*resetDocument = *XML::Xercesc::HandlerBase_resetDocument;
*setDocumentLocator = *XML::Xercesc::HandlerBase_setDocumentLocator;
*startDocument = *XML::Xercesc::HandlerBase_startDocument;
*startElement = *XML::Xercesc::HandlerBase_startElement;
sub resolveEntity {
    my @args = @_;
    my $result = XML::Xercesc::HandlerBase_resolveEntity(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*error = *XML::Xercesc::HandlerBase_error;
*fatalError = *XML::Xercesc::HandlerBase_fatalError;
*warning = *XML::Xercesc::HandlerBase_warning;
*resetErrors = *XML::Xercesc::HandlerBase_resetErrors;
*notationDecl = *XML::Xercesc::HandlerBase_notationDecl;
*resetDocType = *XML::Xercesc::HandlerBase_resetDocType;
*unparsedEntityDecl = *XML::Xercesc::HandlerBase_unparsedEntityDecl;
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_HandlerBase(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::HandlerBase", $self;
    return bless \%retval, $pkg;
}


sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::Locator ##############

package XML::Xerces::Locator;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*getPublicId = *XML::Xercesc::Locator_getPublicId;
*getSystemId = *XML::Xercesc::Locator_getSystemId;
*getLineNumber = *XML::Xercesc::Locator_getLineNumber;
*getColumnNumber = *XML::Xercesc::Locator_getColumnNumber;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::Attributes ##############

package XML::Xerces::Attributes;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*getLength = *XML::Xercesc::Attributes_getLength;
*getURI = *XML::Xercesc::Attributes_getURI;
*getLocalName = *XML::Xercesc::Attributes_getLocalName;
*getQName = *XML::Xercesc::Attributes_getQName;
*getIndex = *XML::Xercesc::Attributes_getIndex;
*getType = *XML::Xercesc::Attributes_getType;
*getType__overload__name = *XML::Xercesc::Attributes_getType__overload__name;
*getValue = *XML::Xercesc::Attributes_getValue;
*getValue__overload__name = *XML::Xercesc::Attributes_getValue__overload__name;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::ContentHandler ##############

package XML::Xerces::ContentHandler;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*characters = *XML::Xercesc::ContentHandler_characters;
*endDocument = *XML::Xercesc::ContentHandler_endDocument;
*endElement = *XML::Xercesc::ContentHandler_endElement;
*ignorableWhitespace = *XML::Xercesc::ContentHandler_ignorableWhitespace;
*processingInstruction = *XML::Xercesc::ContentHandler_processingInstruction;
*setDocumentLocator = *XML::Xercesc::ContentHandler_setDocumentLocator;
*startDocument = *XML::Xercesc::ContentHandler_startDocument;
*startElement = *XML::Xercesc::ContentHandler_startElement;
*startPrefixMapping = *XML::Xercesc::ContentHandler_startPrefixMapping;
*endPrefixMapping = *XML::Xercesc::ContentHandler_endPrefixMapping;
*skippedEntity = *XML::Xercesc::ContentHandler_skippedEntity;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::LexicalHandler ##############

package XML::Xerces::LexicalHandler;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*comment = *XML::Xercesc::LexicalHandler_comment;
*endCDATA = *XML::Xercesc::LexicalHandler_endCDATA;
*endDTD = *XML::Xercesc::LexicalHandler_endDTD;
*endEntity = *XML::Xercesc::LexicalHandler_endEntity;
*startCDATA = *XML::Xercesc::LexicalHandler_startCDATA;
*startDTD = *XML::Xercesc::LexicalHandler_startDTD;
*startEntity = *XML::Xercesc::LexicalHandler_startEntity;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DeclHandler ##############

package XML::Xerces::DeclHandler;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*elementDecl = *XML::Xercesc::DeclHandler_elementDecl;
*attributeDecl = *XML::Xercesc::DeclHandler_attributeDecl;
*internalEntityDecl = *XML::Xercesc::DeclHandler_internalEntityDecl;
*externalEntityDecl = *XML::Xercesc::DeclHandler_externalEntityDecl;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DefaultHandler ##############

package XML::Xerces::DefaultHandler;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::EntityResolver XML::Xerces::DTDHandler XML::Xerces::ContentHandler XML::Xerces::ErrorHandler XML::Xerces::LexicalHandler XML::Xerces::DeclHandler );
%OWNER = ();
%ITERATORS = ();
*characters = *XML::Xercesc::DefaultHandler_characters;
*endDocument = *XML::Xercesc::DefaultHandler_endDocument;
*endElement = *XML::Xercesc::DefaultHandler_endElement;
*ignorableWhitespace = *XML::Xercesc::DefaultHandler_ignorableWhitespace;
*processingInstruction = *XML::Xercesc::DefaultHandler_processingInstruction;
*resetDocument = *XML::Xercesc::DefaultHandler_resetDocument;
*setDocumentLocator = *XML::Xercesc::DefaultHandler_setDocumentLocator;
*startDocument = *XML::Xercesc::DefaultHandler_startDocument;
*startElement = *XML::Xercesc::DefaultHandler_startElement;
*startPrefixMapping = *XML::Xercesc::DefaultHandler_startPrefixMapping;
*endPrefixMapping = *XML::Xercesc::DefaultHandler_endPrefixMapping;
*skippedEntity = *XML::Xercesc::DefaultHandler_skippedEntity;
sub resolveEntity {
    my @args = @_;
    my $result = XML::Xercesc::DefaultHandler_resolveEntity(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*error = *XML::Xercesc::DefaultHandler_error;
*fatalError = *XML::Xercesc::DefaultHandler_fatalError;
*warning = *XML::Xercesc::DefaultHandler_warning;
*resetErrors = *XML::Xercesc::DefaultHandler_resetErrors;
*notationDecl = *XML::Xercesc::DefaultHandler_notationDecl;
*resetDocType = *XML::Xercesc::DefaultHandler_resetDocType;
*unparsedEntityDecl = *XML::Xercesc::DefaultHandler_unparsedEntityDecl;
*comment = *XML::Xercesc::DefaultHandler_comment;
*endCDATA = *XML::Xercesc::DefaultHandler_endCDATA;
*endDTD = *XML::Xercesc::DefaultHandler_endDTD;
*endEntity = *XML::Xercesc::DefaultHandler_endEntity;
*startCDATA = *XML::Xercesc::DefaultHandler_startCDATA;
*startDTD = *XML::Xercesc::DefaultHandler_startDTD;
*startEntity = *XML::Xercesc::DefaultHandler_startEntity;
*elementDecl = *XML::Xercesc::DefaultHandler_elementDecl;
*attributeDecl = *XML::Xercesc::DefaultHandler_attributeDecl;
*internalEntityDecl = *XML::Xercesc::DefaultHandler_internalEntityDecl;
*externalEntityDecl = *XML::Xercesc::DefaultHandler_externalEntityDecl;
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_DefaultHandler(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::DefaultHandler", $self;
    return bless \%retval, $pkg;
}


sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::InputSource ##############

package XML::Xerces::InputSource;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*makeStream = *XML::Xercesc::InputSource_makeStream;
*getEncoding = *XML::Xercesc::InputSource_getEncoding;
*getPublicId = *XML::Xercesc::InputSource_getPublicId;
*getSystemId = *XML::Xercesc::InputSource_getSystemId;
*getIssueFatalErrorIfNotFound = *XML::Xercesc::InputSource_getIssueFatalErrorIfNotFound;
*getMemoryManager = *XML::Xercesc::InputSource_getMemoryManager;
*setEncoding = *XML::Xercesc::InputSource_setEncoding;
*setPublicId = *XML::Xercesc::InputSource_setPublicId;
*setSystemId = *XML::Xercesc::InputSource_setSystemId;
*setIssueFatalErrorIfNotFound = *XML::Xercesc::InputSource_setIssueFatalErrorIfNotFound;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::MemBufInputSource ##############

package XML::Xerces::MemBufInputSource;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::InputSource );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my @args = @_;
    # SYSTEM ID is *optional*
    if (scalar @args == 1) {
      push(@args,'FAKE_SYSTEM_ID');
    }
    my $self = XML::Xercesc::new_MemBufInputSource(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::MemBufInputSource", $self;
    return bless \%retval, $pkg;
}


*makeStream = *XML::Xercesc::MemBufInputSource_makeStream;
*setCopyBufToStream = *XML::Xercesc::MemBufInputSource_setCopyBufToStream;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::StdInInputSource ##############

package XML::Xerces::StdInInputSource;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::InputSource );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_StdInInputSource(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::StdInInputSource", $self;
    return bless \%retval, $pkg;
}


*makeStream = *XML::Xercesc::StdInInputSource_makeStream;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::LocalFileInputSource ##############

package XML::Xerces::LocalFileInputSource;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::InputSource );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_LocalFileInputSource(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::LocalFileInputSource", $self;
    return bless \%retval, $pkg;
}


*makeStream = *XML::Xercesc::LocalFileInputSource_makeStream;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::URLInputSource ##############

package XML::Xerces::URLInputSource;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::InputSource );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_URLInputSource(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::URLInputSource", $self;
    return bless \%retval, $pkg;
}


*makeStream = *XML::Xercesc::URLInputSource_makeStream;
sub urlSrc {
    my @args = @_;
    my $result = XML::Xercesc::URLInputSource_urlSrc(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::XMLFormatter ##############

package XML::Xerces::XMLFormatter;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();
*NoEscapes = *XML::Xercesc::XMLFormatter_NoEscapes;
*StdEscapes = *XML::Xercesc::XMLFormatter_StdEscapes;
*AttrEscapes = *XML::Xercesc::XMLFormatter_AttrEscapes;
*CharEscapes = *XML::Xercesc::XMLFormatter_CharEscapes;
*EscapeFlags_Count = *XML::Xercesc::XMLFormatter_EscapeFlags_Count;
*DefaultEscape = *XML::Xercesc::XMLFormatter_DefaultEscape;
*UnRep_Fail = *XML::Xercesc::XMLFormatter_UnRep_Fail;
*UnRep_CharRef = *XML::Xercesc::XMLFormatter_UnRep_CharRef;
*UnRep_Replace = *XML::Xercesc::XMLFormatter_UnRep_Replace;
*DefaultUnRep = *XML::Xercesc::XMLFormatter_DefaultUnRep;
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_XMLFormatter(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::XMLFormatter", $self;
    return bless \%retval, $pkg;
}


*formatBuf = *XML::Xercesc::XMLFormatter_formatBuf;
*writeBOM = *XML::Xercesc::XMLFormatter_writeBOM;
*getEncodingName = *XML::Xercesc::XMLFormatter_getEncodingName;
*getTranscoder = *XML::Xercesc::XMLFormatter_getTranscoder;
*setEscapeFlags = *XML::Xercesc::XMLFormatter_setEscapeFlags;
*setUnRepFlags = *XML::Xercesc::XMLFormatter_setUnRepFlags;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::XMLFormatTarget ##############

package XML::Xerces::XMLFormatTarget;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*writeChars = *XML::Xercesc::XMLFormatTarget_writeChars;
*flush = *XML::Xercesc::XMLFormatTarget_flush;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::MemBufFormatTarget ##############

package XML::Xerces::MemBufFormatTarget;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::XMLFormatTarget );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_MemBufFormatTarget(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::MemBufFormatTarget", $self;
    return bless \%retval, $pkg;
}


*writeChars = *XML::Xercesc::MemBufFormatTarget_writeChars;
*getRawBuffer = *XML::Xercesc::MemBufFormatTarget_getRawBuffer;
*getLen = *XML::Xercesc::MemBufFormatTarget_getLen;
*reset = *XML::Xercesc::MemBufFormatTarget_reset;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::StdOutFormatTarget ##############

package XML::Xerces::StdOutFormatTarget;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::XMLFormatTarget );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_StdOutFormatTarget(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::StdOutFormatTarget", $self;
    return bless \%retval, $pkg;
}


*writeChars = *XML::Xercesc::StdOutFormatTarget_writeChars;
*flush = *XML::Xercesc::StdOutFormatTarget_flush;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::XMLUni ##############

package XML::Xerces::XMLUni;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();
*fgAnyString = *XML::Xercesc::XMLUni_fgAnyString;
*fgAttListString = *XML::Xercesc::XMLUni_fgAttListString;
*fgCommentString = *XML::Xercesc::XMLUni_fgCommentString;
*fgCDATAString = *XML::Xercesc::XMLUni_fgCDATAString;
*fgDefaultString = *XML::Xercesc::XMLUni_fgDefaultString;
*fgDocTypeString = *XML::Xercesc::XMLUni_fgDocTypeString;
*fgEBCDICEncodingString = *XML::Xercesc::XMLUni_fgEBCDICEncodingString;
*fgElemString = *XML::Xercesc::XMLUni_fgElemString;
*fgEmptyString = *XML::Xercesc::XMLUni_fgEmptyString;
*fgEncodingString = *XML::Xercesc::XMLUni_fgEncodingString;
*fgEntitString = *XML::Xercesc::XMLUni_fgEntitString;
*fgEntityString = *XML::Xercesc::XMLUni_fgEntityString;
*fgEntitiesString = *XML::Xercesc::XMLUni_fgEntitiesString;
*fgEnumerationString = *XML::Xercesc::XMLUni_fgEnumerationString;
*fgExceptDomain = *XML::Xercesc::XMLUni_fgExceptDomain;
*fgFixedString = *XML::Xercesc::XMLUni_fgFixedString;
*fgIBM037EncodingString = *XML::Xercesc::XMLUni_fgIBM037EncodingString;
*fgIBM037EncodingString2 = *XML::Xercesc::XMLUni_fgIBM037EncodingString2;
*fgIBM1140EncodingString = *XML::Xercesc::XMLUni_fgIBM1140EncodingString;
*fgIBM1140EncodingString2 = *XML::Xercesc::XMLUni_fgIBM1140EncodingString2;
*fgIBM1140EncodingString3 = *XML::Xercesc::XMLUni_fgIBM1140EncodingString3;
*fgIBM1140EncodingString4 = *XML::Xercesc::XMLUni_fgIBM1140EncodingString4;
*fgIESString = *XML::Xercesc::XMLUni_fgIESString;
*fgIDString = *XML::Xercesc::XMLUni_fgIDString;
*fgIDRefString = *XML::Xercesc::XMLUni_fgIDRefString;
*fgIDRefsString = *XML::Xercesc::XMLUni_fgIDRefsString;
*fgImpliedString = *XML::Xercesc::XMLUni_fgImpliedString;
*fgIgnoreString = *XML::Xercesc::XMLUni_fgIgnoreString;
*fgIncludeString = *XML::Xercesc::XMLUni_fgIncludeString;
*fgISO88591EncodingString = *XML::Xercesc::XMLUni_fgISO88591EncodingString;
*fgISO88591EncodingString2 = *XML::Xercesc::XMLUni_fgISO88591EncodingString2;
*fgISO88591EncodingString3 = *XML::Xercesc::XMLUni_fgISO88591EncodingString3;
*fgISO88591EncodingString4 = *XML::Xercesc::XMLUni_fgISO88591EncodingString4;
*fgISO88591EncodingString5 = *XML::Xercesc::XMLUni_fgISO88591EncodingString5;
*fgISO88591EncodingString6 = *XML::Xercesc::XMLUni_fgISO88591EncodingString6;
*fgISO88591EncodingString7 = *XML::Xercesc::XMLUni_fgISO88591EncodingString7;
*fgISO88591EncodingString8 = *XML::Xercesc::XMLUni_fgISO88591EncodingString8;
*fgISO88591EncodingString9 = *XML::Xercesc::XMLUni_fgISO88591EncodingString9;
*fgISO88591EncodingString10 = *XML::Xercesc::XMLUni_fgISO88591EncodingString10;
*fgISO88591EncodingString11 = *XML::Xercesc::XMLUni_fgISO88591EncodingString11;
*fgISO88591EncodingString12 = *XML::Xercesc::XMLUni_fgISO88591EncodingString12;
*fgLocalHostString = *XML::Xercesc::XMLUni_fgLocalHostString;
*fgNoString = *XML::Xercesc::XMLUni_fgNoString;
*fgNotationString = *XML::Xercesc::XMLUni_fgNotationString;
*fgNDATAString = *XML::Xercesc::XMLUni_fgNDATAString;
*fgNmTokenString = *XML::Xercesc::XMLUni_fgNmTokenString;
*fgNmTokensString = *XML::Xercesc::XMLUni_fgNmTokensString;
*fgPCDATAString = *XML::Xercesc::XMLUni_fgPCDATAString;
*fgPIString = *XML::Xercesc::XMLUni_fgPIString;
*fgPubIDString = *XML::Xercesc::XMLUni_fgPubIDString;
*fgRefString = *XML::Xercesc::XMLUni_fgRefString;
*fgRequiredString = *XML::Xercesc::XMLUni_fgRequiredString;
*fgStandaloneString = *XML::Xercesc::XMLUni_fgStandaloneString;
*fgVersion1_0 = *XML::Xercesc::XMLUni_fgVersion1_0;
*fgVersion1_1 = *XML::Xercesc::XMLUni_fgVersion1_1;
*fgSysIDString = *XML::Xercesc::XMLUni_fgSysIDString;
*fgUnknownURIName = *XML::Xercesc::XMLUni_fgUnknownURIName;
*fgUCS4EncodingString = *XML::Xercesc::XMLUni_fgUCS4EncodingString;
*fgUCS4EncodingString2 = *XML::Xercesc::XMLUni_fgUCS4EncodingString2;
*fgUCS4EncodingString3 = *XML::Xercesc::XMLUni_fgUCS4EncodingString3;
*fgUCS4BEncodingString = *XML::Xercesc::XMLUni_fgUCS4BEncodingString;
*fgUCS4BEncodingString2 = *XML::Xercesc::XMLUni_fgUCS4BEncodingString2;
*fgUCS4LEncodingString = *XML::Xercesc::XMLUni_fgUCS4LEncodingString;
*fgUCS4LEncodingString2 = *XML::Xercesc::XMLUni_fgUCS4LEncodingString2;
*fgUSASCIIEncodingString = *XML::Xercesc::XMLUni_fgUSASCIIEncodingString;
*fgUSASCIIEncodingString2 = *XML::Xercesc::XMLUni_fgUSASCIIEncodingString2;
*fgUSASCIIEncodingString3 = *XML::Xercesc::XMLUni_fgUSASCIIEncodingString3;
*fgUSASCIIEncodingString4 = *XML::Xercesc::XMLUni_fgUSASCIIEncodingString4;
*fgUTF8EncodingString = *XML::Xercesc::XMLUni_fgUTF8EncodingString;
*fgUTF8EncodingString2 = *XML::Xercesc::XMLUni_fgUTF8EncodingString2;
*fgUTF16EncodingString = *XML::Xercesc::XMLUni_fgUTF16EncodingString;
*fgUTF16EncodingString2 = *XML::Xercesc::XMLUni_fgUTF16EncodingString2;
*fgUTF16EncodingString3 = *XML::Xercesc::XMLUni_fgUTF16EncodingString3;
*fgUTF16EncodingString4 = *XML::Xercesc::XMLUni_fgUTF16EncodingString4;
*fgUTF16EncodingString5 = *XML::Xercesc::XMLUni_fgUTF16EncodingString5;
*fgUTF16BEncodingString = *XML::Xercesc::XMLUni_fgUTF16BEncodingString;
*fgUTF16BEncodingString2 = *XML::Xercesc::XMLUni_fgUTF16BEncodingString2;
*fgUTF16LEncodingString = *XML::Xercesc::XMLUni_fgUTF16LEncodingString;
*fgUTF16LEncodingString2 = *XML::Xercesc::XMLUni_fgUTF16LEncodingString2;
*fgVersionString = *XML::Xercesc::XMLUni_fgVersionString;
*fgValidityDomain = *XML::Xercesc::XMLUni_fgValidityDomain;
*fgWin1252EncodingString = *XML::Xercesc::XMLUni_fgWin1252EncodingString;
*fgXMLChEncodingString = *XML::Xercesc::XMLUni_fgXMLChEncodingString;
*fgXMLDOMMsgDomain = *XML::Xercesc::XMLUni_fgXMLDOMMsgDomain;
*fgXMLString = *XML::Xercesc::XMLUni_fgXMLString;
*fgXMLStringSpace = *XML::Xercesc::XMLUni_fgXMLStringSpace;
*fgXMLStringHTab = *XML::Xercesc::XMLUni_fgXMLStringHTab;
*fgXMLStringCR = *XML::Xercesc::XMLUni_fgXMLStringCR;
*fgXMLStringLF = *XML::Xercesc::XMLUni_fgXMLStringLF;
*fgXMLStringSpaceU = *XML::Xercesc::XMLUni_fgXMLStringSpaceU;
*fgXMLStringHTabU = *XML::Xercesc::XMLUni_fgXMLStringHTabU;
*fgXMLStringCRU = *XML::Xercesc::XMLUni_fgXMLStringCRU;
*fgXMLStringLFU = *XML::Xercesc::XMLUni_fgXMLStringLFU;
*fgXMLDeclString = *XML::Xercesc::XMLUni_fgXMLDeclString;
*fgXMLDeclStringSpace = *XML::Xercesc::XMLUni_fgXMLDeclStringSpace;
*fgXMLDeclStringHTab = *XML::Xercesc::XMLUni_fgXMLDeclStringHTab;
*fgXMLDeclStringLF = *XML::Xercesc::XMLUni_fgXMLDeclStringLF;
*fgXMLDeclStringCR = *XML::Xercesc::XMLUni_fgXMLDeclStringCR;
*fgXMLDeclStringSpaceU = *XML::Xercesc::XMLUni_fgXMLDeclStringSpaceU;
*fgXMLDeclStringHTabU = *XML::Xercesc::XMLUni_fgXMLDeclStringHTabU;
*fgXMLDeclStringLFU = *XML::Xercesc::XMLUni_fgXMLDeclStringLFU;
*fgXMLDeclStringCRU = *XML::Xercesc::XMLUni_fgXMLDeclStringCRU;
*fgXMLNSString = *XML::Xercesc::XMLUni_fgXMLNSString;
*fgXMLNSColonString = *XML::Xercesc::XMLUni_fgXMLNSColonString;
*fgXMLNSURIName = *XML::Xercesc::XMLUni_fgXMLNSURIName;
*fgXMLErrDomain = *XML::Xercesc::XMLUni_fgXMLErrDomain;
*fgXMLURIName = *XML::Xercesc::XMLUni_fgXMLURIName;
*fgYesString = *XML::Xercesc::XMLUni_fgYesString;
*fgZeroLenString = *XML::Xercesc::XMLUni_fgZeroLenString;
*fgDTDEntityString = *XML::Xercesc::XMLUni_fgDTDEntityString;
*fgAmp = *XML::Xercesc::XMLUni_fgAmp;
*fgLT = *XML::Xercesc::XMLUni_fgLT;
*fgGT = *XML::Xercesc::XMLUni_fgGT;
*fgQuot = *XML::Xercesc::XMLUni_fgQuot;
*fgApos = *XML::Xercesc::XMLUni_fgApos;
*fgWFXMLScanner = *XML::Xercesc::XMLUni_fgWFXMLScanner;
*fgIGXMLScanner = *XML::Xercesc::XMLUni_fgIGXMLScanner;
*fgSGXMLScanner = *XML::Xercesc::XMLUni_fgSGXMLScanner;
*fgDGXMLScanner = *XML::Xercesc::XMLUni_fgDGXMLScanner;
*fgArrayIndexOutOfBoundsException_Name = *XML::Xercesc::XMLUni_fgArrayIndexOutOfBoundsException_Name;
*fgEmptyStackException_Name = *XML::Xercesc::XMLUni_fgEmptyStackException_Name;
*fgIllegalArgumentException_Name = *XML::Xercesc::XMLUni_fgIllegalArgumentException_Name;
*fgInvalidCastException_Name = *XML::Xercesc::XMLUni_fgInvalidCastException_Name;
*fgIOException_Name = *XML::Xercesc::XMLUni_fgIOException_Name;
*fgNoSuchElementException_Name = *XML::Xercesc::XMLUni_fgNoSuchElementException_Name;
*fgNullPointerException_Name = *XML::Xercesc::XMLUni_fgNullPointerException_Name;
*fgXMLPlatformUtilsException_Name = *XML::Xercesc::XMLUni_fgXMLPlatformUtilsException_Name;
*fgRuntimeException_Name = *XML::Xercesc::XMLUni_fgRuntimeException_Name;
*fgTranscodingException_Name = *XML::Xercesc::XMLUni_fgTranscodingException_Name;
*fgUnexpectedEOFException_Name = *XML::Xercesc::XMLUni_fgUnexpectedEOFException_Name;
*fgUnsupportedEncodingException_Name = *XML::Xercesc::XMLUni_fgUnsupportedEncodingException_Name;
*fgUTFDataFormatException_Name = *XML::Xercesc::XMLUni_fgUTFDataFormatException_Name;
*fgNetAccessorException_Name = *XML::Xercesc::XMLUni_fgNetAccessorException_Name;
*fgMalformedURLException_Name = *XML::Xercesc::XMLUni_fgMalformedURLException_Name;
*fgNumberFormatException_Name = *XML::Xercesc::XMLUni_fgNumberFormatException_Name;
*fgParseException_Name = *XML::Xercesc::XMLUni_fgParseException_Name;
*fgInvalidDatatypeFacetException_Name = *XML::Xercesc::XMLUni_fgInvalidDatatypeFacetException_Name;
*fgInvalidDatatypeValueException_Name = *XML::Xercesc::XMLUni_fgInvalidDatatypeValueException_Name;
*fgSchemaDateTimeException_Name = *XML::Xercesc::XMLUni_fgSchemaDateTimeException_Name;
*fgXPathException_Name = *XML::Xercesc::XMLUni_fgXPathException_Name;
*fgNegINFString = *XML::Xercesc::XMLUni_fgNegINFString;
*fgNegZeroString = *XML::Xercesc::XMLUni_fgNegZeroString;
*fgPosZeroString = *XML::Xercesc::XMLUni_fgPosZeroString;
*fgPosINFString = *XML::Xercesc::XMLUni_fgPosINFString;
*fgNaNString = *XML::Xercesc::XMLUni_fgNaNString;
*fgEString = *XML::Xercesc::XMLUni_fgEString;
*fgZeroString = *XML::Xercesc::XMLUni_fgZeroString;
*fgNullString = *XML::Xercesc::XMLUni_fgNullString;
*fgXercesDynamic = *XML::Xercesc::XMLUni_fgXercesDynamic;
*fgXercesSchema = *XML::Xercesc::XMLUni_fgXercesSchema;
*fgXercesSchemaFullChecking = *XML::Xercesc::XMLUni_fgXercesSchemaFullChecking;
*fgXercesSchemaExternalSchemaLocation = *XML::Xercesc::XMLUni_fgXercesSchemaExternalSchemaLocation;
*fgXercesSchemaExternalNoNameSpaceSchemaLocation = *XML::Xercesc::XMLUni_fgXercesSchemaExternalNoNameSpaceSchemaLocation;
*fgXercesSecurityManager = *XML::Xercesc::XMLUni_fgXercesSecurityManager;
*fgXercesLoadExternalDTD = *XML::Xercesc::XMLUni_fgXercesLoadExternalDTD;
*fgXercesContinueAfterFatalError = *XML::Xercesc::XMLUni_fgXercesContinueAfterFatalError;
*fgXercesValidationErrorAsFatal = *XML::Xercesc::XMLUni_fgXercesValidationErrorAsFatal;
*fgXercesUserAdoptsDOMDocument = *XML::Xercesc::XMLUni_fgXercesUserAdoptsDOMDocument;
*fgXercesCacheGrammarFromParse = *XML::Xercesc::XMLUni_fgXercesCacheGrammarFromParse;
*fgXercesUseCachedGrammarInParse = *XML::Xercesc::XMLUni_fgXercesUseCachedGrammarInParse;
*fgXercesScannerName = *XML::Xercesc::XMLUni_fgXercesScannerName;
*fgXercesCalculateSrcOfs = *XML::Xercesc::XMLUni_fgXercesCalculateSrcOfs;
*fgXercesStandardUriConformant = *XML::Xercesc::XMLUni_fgXercesStandardUriConformant;
*fgSAX2CoreValidation = *XML::Xercesc::XMLUni_fgSAX2CoreValidation;
*fgSAX2CoreNameSpaces = *XML::Xercesc::XMLUni_fgSAX2CoreNameSpaces;
*fgSAX2CoreNameSpacePrefixes = *XML::Xercesc::XMLUni_fgSAX2CoreNameSpacePrefixes;
*fgDOMCanonicalForm = *XML::Xercesc::XMLUni_fgDOMCanonicalForm;
*fgDOMCDATASections = *XML::Xercesc::XMLUni_fgDOMCDATASections;
*fgDOMComments = *XML::Xercesc::XMLUni_fgDOMComments;
*fgDOMCharsetOverridesXMLEncoding = *XML::Xercesc::XMLUni_fgDOMCharsetOverridesXMLEncoding;
*fgDOMDatatypeNormalization = *XML::Xercesc::XMLUni_fgDOMDatatypeNormalization;
*fgDOMEntities = *XML::Xercesc::XMLUni_fgDOMEntities;
*fgDOMInfoset = *XML::Xercesc::XMLUni_fgDOMInfoset;
*fgDOMNamespaces = *XML::Xercesc::XMLUni_fgDOMNamespaces;
*fgDOMNamespaceDeclarations = *XML::Xercesc::XMLUni_fgDOMNamespaceDeclarations;
*fgDOMSupportedMediatypesOnly = *XML::Xercesc::XMLUni_fgDOMSupportedMediatypesOnly;
*fgDOMValidateIfSchema = *XML::Xercesc::XMLUni_fgDOMValidateIfSchema;
*fgDOMValidation = *XML::Xercesc::XMLUni_fgDOMValidation;
*fgDOMWhitespaceInElementContent = *XML::Xercesc::XMLUni_fgDOMWhitespaceInElementContent;
*fgDOMWRTCanonicalForm = *XML::Xercesc::XMLUni_fgDOMWRTCanonicalForm;
*fgDOMWRTDiscardDefaultContent = *XML::Xercesc::XMLUni_fgDOMWRTDiscardDefaultContent;
*fgDOMWRTEntities = *XML::Xercesc::XMLUni_fgDOMWRTEntities;
*fgDOMWRTFormatPrettyPrint = *XML::Xercesc::XMLUni_fgDOMWRTFormatPrettyPrint;
*fgDOMWRTNormalizeCharacters = *XML::Xercesc::XMLUni_fgDOMWRTNormalizeCharacters;
*fgDOMWRTSplitCdataSections = *XML::Xercesc::XMLUni_fgDOMWRTSplitCdataSections;
*fgDOMWRTValidation = *XML::Xercesc::XMLUni_fgDOMWRTValidation;
*fgDOMWRTWhitespaceInElementContent = *XML::Xercesc::XMLUni_fgDOMWRTWhitespaceInElementContent;
*fgDOMWRTBOM = *XML::Xercesc::XMLUni_fgDOMWRTBOM;
*fgXercescDefaultLocale = *XML::Xercesc::XMLUni_fgXercescDefaultLocale;
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_XMLUni(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::XMLUni", $self;
    return bless \%retval, $pkg;
}


sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::XMLScanner ##############

package XML::Xerces::XMLScanner;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();
*Decl_Text = *XML::Xercesc::XMLScanner_Decl_Text;
*Decl_XML = *XML::Xercesc::XMLScanner_Decl_XML;
*EntityExp_Pushed = *XML::Xercesc::XMLScanner_EntityExp_Pushed;
*EntityExp_Returned = *XML::Xercesc::XMLScanner_EntityExp_Returned;
*EntityExp_Failed = *XML::Xercesc::XMLScanner_EntityExp_Failed;
*Token_CData = *XML::Xercesc::XMLScanner_Token_CData;
*Token_CharData = *XML::Xercesc::XMLScanner_Token_CharData;
*Token_Comment = *XML::Xercesc::XMLScanner_Token_Comment;
*Token_EndTag = *XML::Xercesc::XMLScanner_Token_EndTag;
*Token_EOF = *XML::Xercesc::XMLScanner_Token_EOF;
*Token_PI = *XML::Xercesc::XMLScanner_Token_PI;
*Token_StartTag = *XML::Xercesc::XMLScanner_Token_StartTag;
*Token_Unknown = *XML::Xercesc::XMLScanner_Token_Unknown;
*Val_Never = *XML::Xercesc::XMLScanner_Val_Never;
*Val_Always = *XML::Xercesc::XMLScanner_Val_Always;
*Val_Auto = *XML::Xercesc::XMLScanner_Val_Auto;

*getName = *XML::Xercesc::XMLScanner_getName;
*resolveQName = *XML::Xercesc::XMLScanner_resolveQName;
*scanNext = *XML::Xercesc::XMLScanner_scanNext;
sub getErrorHandler {
    my @args = @_;
    my $result = XML::Xercesc::XMLScanner_getErrorHandler(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getReaderMgr = *XML::Xercesc::XMLScanner_getReaderMgr;
*getSrcOffset = *XML::Xercesc::XMLScanner_getSrcOffset;
*getSecurityManager = *XML::Xercesc::XMLScanner_getSecurityManager;
*getLoadExternalDTD = *XML::Xercesc::XMLScanner_getLoadExternalDTD;
*getNormalizeData = *XML::Xercesc::XMLScanner_getNormalizeData;
*isCachingGrammarFromParse = *XML::Xercesc::XMLScanner_isCachingGrammarFromParse;
*isUsingCachedGrammarInParse = *XML::Xercesc::XMLScanner_isUsingCachedGrammarInParse;
*getCalculateSrcOfs = *XML::Xercesc::XMLScanner_getCalculateSrcOfs;
sub getRootGrammar {
    my @args = @_;
    my $result = XML::Xercesc::XMLScanner_getRootGrammar(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getXMLVersion = *XML::Xercesc::XMLScanner_getXMLVersion;
*getMemoryManager = *XML::Xercesc::XMLScanner_getMemoryManager;
*getEmptyNamespaceId = *XML::Xercesc::XMLScanner_getEmptyNamespaceId;
*getUnknownNamespaceId = *XML::Xercesc::XMLScanner_getUnknownNamespaceId;
*getXMLNamespaceId = *XML::Xercesc::XMLScanner_getXMLNamespaceId;
*getXMLNSNamespaceId = *XML::Xercesc::XMLScanner_getXMLNSNamespaceId;
*isValidatorFromUser = *XML::Xercesc::XMLScanner_isValidatorFromUser;
*getStandardUriConformant = *XML::Xercesc::XMLScanner_getStandardUriConformant;
*setDocHandler = *XML::Xercesc::XMLScanner_setDocHandler;
*setDocTypeHandler = *XML::Xercesc::XMLScanner_setDocTypeHandler;
*setDoNamespaces = *XML::Xercesc::XMLScanner_setDoNamespaces;
*setEntityHandler = *XML::Xercesc::XMLScanner_setEntityHandler;
*setErrorReporter = *XML::Xercesc::XMLScanner_setErrorReporter;
sub setErrorHandler {
  my ($self,$handler) = @_;
  my $retval;
  my $callback = $XML::Xerces::XMLScanner::OWNER{$self}->{__ERROR_HANDLER};
  if (defined $callback) {
    $retval = $callback->set_callback_obj($handler);
  } else {
    $callback = XML::Xerces::PerlErrorCallbackHandler->new($handler);
    $XML::Xerces::XMLScanner::OWNER{$self}->{__ERROR_HANDLER} = $callback;
  }
  XML::Xercesc::XMLScanner_setErrorHandler($self,$callback);
  return $retval;
}
*setGrammarResolver = *XML::Xercesc::XMLScanner_setGrammarResolver;
*setURIStringPool = *XML::Xercesc::XMLScanner_setURIStringPool;
*setExitOnFirstFatal = *XML::Xercesc::XMLScanner_setExitOnFirstFatal;
*setValidationConstraintFatal = *XML::Xercesc::XMLScanner_setValidationConstraintFatal;
*setValidationScheme = *XML::Xercesc::XMLScanner_setValidationScheme;
*setValidator = *XML::Xercesc::XMLScanner_setValidator;
*setDoSchema = *XML::Xercesc::XMLScanner_setDoSchema;
*setValidationSchemaFullChecking = *XML::Xercesc::XMLScanner_setValidationSchemaFullChecking;
*setHasNoDTD = *XML::Xercesc::XMLScanner_setHasNoDTD;
*cacheGrammarFromParse = *XML::Xercesc::XMLScanner_cacheGrammarFromParse;
*useCachedGrammarInParse = *XML::Xercesc::XMLScanner_useCachedGrammarInParse;
*setRootElemName = *XML::Xercesc::XMLScanner_setRootElemName;
*setSecurityManager = *XML::Xercesc::XMLScanner_setSecurityManager;
*setLoadExternalDTD = *XML::Xercesc::XMLScanner_setLoadExternalDTD;
*setNormalizeData = *XML::Xercesc::XMLScanner_setNormalizeData;
*setCalculateSrcOfs = *XML::Xercesc::XMLScanner_setCalculateSrcOfs;
*setParseSettings = *XML::Xercesc::XMLScanner_setParseSettings;
*setStandardUriConformant = *XML::Xercesc::XMLScanner_setStandardUriConformant;
*incrementErrorCount = *XML::Xercesc::XMLScanner_incrementErrorCount;
*getDoValidation = *XML::Xercesc::XMLScanner_getDoValidation;
*setDoValidation = *XML::Xercesc::XMLScanner_setDoValidation;
*scanReset = *XML::Xercesc::XMLScanner_scanReset;
*checkXMLDecl = *XML::Xercesc::XMLScanner_checkXMLDecl;
sub loadGrammar {
    my @args = @_;
    my $result = XML::Xercesc::XMLScanner_loadGrammar(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*reinitScannerMutex = *XML::Xercesc::XMLScanner_reinitScannerMutex;
*reinitMsgLoader = *XML::Xercesc::XMLScanner_reinitMsgLoader;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::XMLPScanToken ##############

package XML::Xerces::XMLPScanToken;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
use overload
    "=" => sub { $_[0]->operator_assignment($_[1])},
    "fallback" => 1;
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_XMLPScanToken(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::XMLPScanToken", $self;
    return bless \%retval, $pkg;
}


sub operator_assignment {
    my @args = @_;
    my $result = XML::Xercesc::XMLPScanToken_operator_assignment(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::Parser ##############

package XML::Xerces::Parser;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

sub setEntityResolver {
  my ($self,$handler) = @_;
  my $callback = $XML::Xerces::Parser::OWNER{$self}->{__ENTITY_RESOLVER};
  if (defined $callback) {
    $callback->set_callback_obj($handler);
  } else {
    $callback = XML::Xerces::PerlEntityResolverHandler->new($handler);
    $XML::Xerces::Parser::OWNER{$self}->{__ENTITY_RESOLVER} = $callback;
  }
  return XML::Xercesc::Parser_setEntityResolver($self,$callback);
}
*setDTDHandler = *XML::Xercesc::Parser_setDTDHandler;
*setDocumentHandler = *XML::Xercesc::Parser_setDocumentHandler;
sub setErrorHandler {
  my ($self,$handler) = @_;
  my $retval;
  my $callback = $XML::Xerces::Parser::OWNER{$self}->{__ERROR_HANDLER};
  if (defined $callback) {
    $retval = $callback->set_callback_obj($handler);
  } else {
    $callback = XML::Xerces::PerlErrorCallbackHandler->new($handler);
    $XML::Xerces::Parser::OWNER{$self}->{__ERROR_HANDLER} = $callback;
  }
  XML::Xercesc::Parser_setErrorHandler($self,$callback);
  return $retval;
}
*parse = *XML::Xercesc::Parser_parse;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::XMLDocumentHandler ##############

package XML::Xerces::XMLDocumentHandler;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::XMLErrorReporter ##############

package XML::Xerces::XMLErrorReporter;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();
*ErrType_Warning = *XML::Xercesc::XMLErrorReporter_ErrType_Warning;
*ErrType_Error = *XML::Xercesc::XMLErrorReporter_ErrType_Error;
*ErrType_Fatal = *XML::Xercesc::XMLErrorReporter_ErrType_Fatal;
*ErrTypes_Unknown = *XML::Xercesc::XMLErrorReporter_ErrTypes_Unknown;

*error = *XML::Xercesc::XMLErrorReporter_error;
*resetErrors = *XML::Xercesc::XMLErrorReporter_resetErrors;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::XMLEntityHandler ##############

package XML::Xerces::XMLEntityHandler;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DocTypeHandler ##############

package XML::Xerces::DocTypeHandler;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::SAX2XMLReader ##############

package XML::Xerces::SAX2XMLReader;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();
*Val_Never = *XML::Xercesc::SAX2XMLReader_Val_Never;
*Val_Always = *XML::Xercesc::SAX2XMLReader_Val_Always;
*Val_Auto = *XML::Xercesc::SAX2XMLReader_Val_Auto;
sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        XML::Xercesc::delete_SAX2XMLReader($self);
        delete $OWNER{$self};
    }
}

sub getContentHandler {
    my @args = @_;
    my $result = XML::Xercesc::SAX2XMLReader_getContentHandler(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getDTDHandler {
    my @args = @_;
    my $result = XML::Xercesc::SAX2XMLReader_getDTDHandler(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getEntityResolver {
    my @args = @_;
    my $result = XML::Xercesc::SAX2XMLReader_getEntityResolver(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getErrorHandler {
    my @args = @_;
    my $result = XML::Xercesc::SAX2XMLReader_getErrorHandler(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getFeature = *XML::Xercesc::SAX2XMLReader_getFeature;
*getProperty = *XML::Xercesc::SAX2XMLReader_getProperty;
sub setContentHandler {
  my ($self,$handler) = @_;
  my $callback = $XML::Xerces::SAX2XMLReader::OWNER{$self}->{__CONTENT_HANDLER};
  if (defined $callback) {
    $callback->set_callback_obj($handler);
  } else {
    $callback = XML::Xerces::PerlContentCallbackHandler->new($handler);
    $XML::Xerces::SAX2XMLReader::OWNER{$self}->{__CONTENT_HANDLER} = $callback;
  }
  return XML::Xercesc::SAX2XMLReader_setContentHandler($self,$callback);
}
*setDTDHandler = *XML::Xercesc::SAX2XMLReader_setDTDHandler;
sub setEntityResolver {
  my ($self,$handler) = @_;
  my $callback = $XML::Xerces::SAX2XMLReader::OWNER{$self}->{__ENTITY_RESOLVER};
  if (defined $callback) {
    $callback->set_callback_obj($handler);
  } else {
    $callback = XML::Xerces::PerlEntityResolverHandler->new($handler);
    $XML::Xerces::SAX2XMLReader::OWNER{$self}->{__ENTITY_RESOLVER} = $callback;
  }
  return XML::Xercesc::SAX2XMLReader_setEntityResolver($self,$callback);
}
sub setErrorHandler {
  my ($self,$handler) = @_;
  my $retval;
  my $callback = $XML::Xerces::SAX2XMLReader::OWNER{$self}->{__ERROR_HANDLER};
  if (defined $callback) {
    $retval = $callback->set_callback_obj($handler);
  } else {
    $callback = XML::Xerces::PerlErrorCallbackHandler->new($handler);
    $XML::Xerces::SAX2XMLReader::OWNER{$self}->{__ERROR_HANDLER} = $callback;
  }
  XML::Xercesc::SAX2XMLReader_setErrorHandler($self,$callback);
  return $retval;
}
*setFeature = *XML::Xercesc::SAX2XMLReader_setFeature;
*setProperty = *XML::Xercesc::SAX2XMLReader_setProperty;
*parse = *XML::Xercesc::SAX2XMLReader_parse;
sub getDeclarationHandler {
    my @args = @_;
    my $result = XML::Xercesc::SAX2XMLReader_getDeclarationHandler(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getLexicalHandler {
    my @args = @_;
    my $result = XML::Xercesc::SAX2XMLReader_getLexicalHandler(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*setDeclarationHandler = *XML::Xercesc::SAX2XMLReader_setDeclarationHandler;
*setLexicalHandler = *XML::Xercesc::SAX2XMLReader_setLexicalHandler;
sub getValidator {
    my @args = @_;
    my $result = XML::Xercesc::SAX2XMLReader_getValidator(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getErrorCount = *XML::Xercesc::SAX2XMLReader_getErrorCount;
*getExitOnFirstFatalError = *XML::Xercesc::SAX2XMLReader_getExitOnFirstFatalError;
*getValidationConstraintFatal = *XML::Xercesc::SAX2XMLReader_getValidationConstraintFatal;
sub getGrammar {
    my @args = @_;
    my $result = XML::Xercesc::SAX2XMLReader_getGrammar(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getRootGrammar {
    my @args = @_;
    my $result = XML::Xercesc::SAX2XMLReader_getRootGrammar(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getURIText = *XML::Xercesc::SAX2XMLReader_getURIText;
*getSrcOffset = *XML::Xercesc::SAX2XMLReader_getSrcOffset;
*setValidator = *XML::Xercesc::SAX2XMLReader_setValidator;
*setExitOnFirstFatalError = *XML::Xercesc::SAX2XMLReader_setExitOnFirstFatalError;
*setValidationConstraintFatal = *XML::Xercesc::SAX2XMLReader_setValidationConstraintFatal;
*parseFirst = *XML::Xercesc::SAX2XMLReader_parseFirst;
*parseNext = *XML::Xercesc::SAX2XMLReader_parseNext;
*parseReset = *XML::Xercesc::SAX2XMLReader_parseReset;
sub loadGrammar {
    my @args = @_;
    my $result = XML::Xercesc::SAX2XMLReader_loadGrammar(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*resetCachedGrammarPool = *XML::Xercesc::SAX2XMLReader_resetCachedGrammarPool;
*installAdvDocHandler = *XML::Xercesc::SAX2XMLReader_installAdvDocHandler;
*removeAdvDocHandler = *XML::Xercesc::SAX2XMLReader_removeAdvDocHandler;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::XMLReaderFactory ##############

package XML::Xerces::XMLReaderFactory;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
sub createXMLReader {
    my @args = @_;
    my $result = XML::Xercesc::XMLReaderFactory_createXMLReader(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::SAXParser ##############

package XML::Xerces::SAXParser;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::Parser XML::Xerces::XMLDocumentHandler XML::Xerces::XMLErrorReporter XML::Xerces::XMLEntityHandler XML::Xerces::DocTypeHandler );
%OWNER = ();
%ITERATORS = ();
*Val_Never = *XML::Xercesc::SAXParser_Val_Never;
*Val_Always = *XML::Xercesc::SAXParser_Val_Always;
*Val_Auto = *XML::Xercesc::SAXParser_Val_Auto;
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_SAXParser(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::SAXParser", $self;
    return bless \%retval, $pkg;
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        XML::Xercesc::delete_SAXParser($self);
        delete $OWNER{$self};
    }
}

sub getDocumentHandler {
    my @args = @_;
    my $result = XML::Xercesc::SAXParser_getDocumentHandler(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getEntityResolver {
    my @args = @_;
    my $result = XML::Xercesc::SAXParser_getEntityResolver(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getErrorHandler {
    my @args = @_;
    my $result = XML::Xercesc::SAXParser_getErrorHandler(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getValidator {
    my @args = @_;
    my $result = XML::Xercesc::SAXParser_getValidator(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getValidationScheme = *XML::Xercesc::SAXParser_getValidationScheme;
*getDoSchema = *XML::Xercesc::SAXParser_getDoSchema;
*getValidationSchemaFullChecking = *XML::Xercesc::SAXParser_getValidationSchemaFullChecking;
*getErrorCount = *XML::Xercesc::SAXParser_getErrorCount;
*getDoNamespaces = *XML::Xercesc::SAXParser_getDoNamespaces;
*getExitOnFirstFatalError = *XML::Xercesc::SAXParser_getExitOnFirstFatalError;
*getValidationConstraintFatal = *XML::Xercesc::SAXParser_getValidationConstraintFatal;
*getExternalSchemaLocation = *XML::Xercesc::SAXParser_getExternalSchemaLocation;
*getExternalNoNamespaceSchemaLocation = *XML::Xercesc::SAXParser_getExternalNoNamespaceSchemaLocation;
*getSecurityManager = *XML::Xercesc::SAXParser_getSecurityManager;
*getLoadExternalDTD = *XML::Xercesc::SAXParser_getLoadExternalDTD;
*isCachingGrammarFromParse = *XML::Xercesc::SAXParser_isCachingGrammarFromParse;
*isUsingCachedGrammarInParse = *XML::Xercesc::SAXParser_isUsingCachedGrammarInParse;
*getCalculateSrcOfs = *XML::Xercesc::SAXParser_getCalculateSrcOfs;
*getStandardUriConformant = *XML::Xercesc::SAXParser_getStandardUriConformant;
sub getGrammar {
    my @args = @_;
    my $result = XML::Xercesc::SAXParser_getGrammar(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getRootGrammar {
    my @args = @_;
    my $result = XML::Xercesc::SAXParser_getRootGrammar(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getURIText = *XML::Xercesc::SAXParser_getURIText;
*getSrcOffset = *XML::Xercesc::SAXParser_getSrcOffset;
*setDoNamespaces = *XML::Xercesc::SAXParser_setDoNamespaces;
*setValidationScheme = *XML::Xercesc::SAXParser_setValidationScheme;
*setDoSchema = *XML::Xercesc::SAXParser_setDoSchema;
*setValidationSchemaFullChecking = *XML::Xercesc::SAXParser_setValidationSchemaFullChecking;
*setExitOnFirstFatalError = *XML::Xercesc::SAXParser_setExitOnFirstFatalError;
*setValidationConstraintFatal = *XML::Xercesc::SAXParser_setValidationConstraintFatal;
*setExternalSchemaLocation = *XML::Xercesc::SAXParser_setExternalSchemaLocation;
*setExternalNoNamespaceSchemaLocation = *XML::Xercesc::SAXParser_setExternalNoNamespaceSchemaLocation;
*setSecurityManager = *XML::Xercesc::SAXParser_setSecurityManager;
*setLoadExternalDTD = *XML::Xercesc::SAXParser_setLoadExternalDTD;
*cacheGrammarFromParse = *XML::Xercesc::SAXParser_cacheGrammarFromParse;
*useCachedGrammarInParse = *XML::Xercesc::SAXParser_useCachedGrammarInParse;
*setCalculateSrcOfs = *XML::Xercesc::SAXParser_setCalculateSrcOfs;
*setStandardUriConformant = *XML::Xercesc::SAXParser_setStandardUriConformant;
*useScanner = *XML::Xercesc::SAXParser_useScanner;
*installAdvDocHandler = *XML::Xercesc::SAXParser_installAdvDocHandler;
*removeAdvDocHandler = *XML::Xercesc::SAXParser_removeAdvDocHandler;
*parseFirst = *XML::Xercesc::SAXParser_parseFirst;
*parseNext = *XML::Xercesc::SAXParser_parseNext;
*parseReset = *XML::Xercesc::SAXParser_parseReset;
sub loadGrammar {
    my @args = @_;
    my $result = XML::Xercesc::SAXParser_loadGrammar(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*resetCachedGrammarPool = *XML::Xercesc::SAXParser_resetCachedGrammarPool;
*parse = *XML::Xercesc::SAXParser_parse;
sub setDocumentHandler {
  my ($self,$handler) = @_;
  my $callback = $XML::Xerces::SAXParser::OWNER{$self}->{__DOCUMENT_HANDLER};
  if (defined $callback) {
    $callback->set_callback_obj($handler);
  } else {
    $callback = XML::Xerces::PerlDocumentCallbackHandler->new($handler);
    $XML::Xerces::SAXParser::OWNER{$self}->{__DOCUMENT_HANDLER} = $callback;
  }
  return XML::Xercesc::SAXParser_setDocumentHandler($self,$callback);
}
*setDTDHandler = *XML::Xercesc::SAXParser_setDTDHandler;
sub setErrorHandler {
  my ($self,$handler) = @_;
  my $retval;
  my $callback = $XML::Xerces::SAXParser::OWNER{$self}->{__ERROR_HANDLER};
  if (defined $callback) {
    $retval = $callback->set_callback_obj($handler);
  } else {
    $callback = XML::Xerces::PerlErrorCallbackHandler->new($handler);
    $XML::Xerces::SAXParser::OWNER{$self}->{__ERROR_HANDLER} = $callback;
  }
  XML::Xercesc::SAXParser_setErrorHandler($self,$callback);
  return $retval;
}
sub setEntityResolver {
  my ($self,$handler) = @_;
  my $callback = $XML::Xerces::SAXParser::OWNER{$self}->{__ENTITY_RESOLVER};
  if (defined $callback) {
    $callback->set_callback_obj($handler);
  } else {
    $callback = XML::Xerces::PerlEntityResolverHandler->new($handler);
    $XML::Xerces::SAXParser::OWNER{$self}->{__ENTITY_RESOLVER} = $callback;
  }
  return XML::Xercesc::SAXParser_setEntityResolver($self,$callback);
}
*error = *XML::Xercesc::SAXParser_error;
*resetErrors = *XML::Xercesc::SAXParser_resetErrors;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::Grammar ##############

package XML::Xerces::Grammar;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();
*DTDGrammarType = *XML::Xercesc::Grammar_DTDGrammarType;
*SchemaGrammarType = *XML::Xercesc::Grammar_SchemaGrammarType;
*UNKNOWN_SCOPE = *XML::Xercesc::Grammar_UNKNOWN_SCOPE;
*TOP_LEVEL_SCOPE = *XML::Xercesc::Grammar_TOP_LEVEL_SCOPE;

*getGrammarType = *XML::Xercesc::Grammar_getGrammarType;
*getTargetNamespace = *XML::Xercesc::Grammar_getTargetNamespace;
*getValidated = *XML::Xercesc::Grammar_getValidated;
*findOrAddElemDecl = *XML::Xercesc::Grammar_findOrAddElemDecl;
*getElemId = *XML::Xercesc::Grammar_getElemId;
*getElemDecl = *XML::Xercesc::Grammar_getElemDecl;
*getNotationDecl = *XML::Xercesc::Grammar_getNotationDecl;
*putElemDecl = *XML::Xercesc::Grammar_putElemDecl;
*putNotationDecl = *XML::Xercesc::Grammar_putNotationDecl;
*setValidated = *XML::Xercesc::Grammar_setValidated;
*reset = *XML::Xercesc::Grammar_reset;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMException ##############

package XML::Xerces::DOMException;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%BLESSEDMEMBERS = (
);

%ITERATORS = ();
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_DOMException(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::DOMException", $self;
    return bless \%retval, $pkg;
}


*INDEX_SIZE_ERR = *XML::Xercesc::DOMException_INDEX_SIZE_ERR;
*DOMSTRING_SIZE_ERR = *XML::Xercesc::DOMException_DOMSTRING_SIZE_ERR;
*HIERARCHY_REQUEST_ERR = *XML::Xercesc::DOMException_HIERARCHY_REQUEST_ERR;
*WRONG_DOCUMENT_ERR = *XML::Xercesc::DOMException_WRONG_DOCUMENT_ERR;
*INVALID_CHARACTER_ERR = *XML::Xercesc::DOMException_INVALID_CHARACTER_ERR;
*NO_DATA_ALLOWED_ERR = *XML::Xercesc::DOMException_NO_DATA_ALLOWED_ERR;
*NO_MODIFICATION_ALLOWED_ERR = *XML::Xercesc::DOMException_NO_MODIFICATION_ALLOWED_ERR;
*NOT_FOUND_ERR = *XML::Xercesc::DOMException_NOT_FOUND_ERR;
*NOT_SUPPORTED_ERR = *XML::Xercesc::DOMException_NOT_SUPPORTED_ERR;
*INUSE_ATTRIBUTE_ERR = *XML::Xercesc::DOMException_INUSE_ATTRIBUTE_ERR;
*INVALID_STATE_ERR = *XML::Xercesc::DOMException_INVALID_STATE_ERR;
*SYNTAX_ERR = *XML::Xercesc::DOMException_SYNTAX_ERR;
*INVALID_MODIFICATION_ERR = *XML::Xercesc::DOMException_INVALID_MODIFICATION_ERR;
*NAMESPACE_ERR = *XML::Xercesc::DOMException_NAMESPACE_ERR;
*INVALID_ACCESS_ERR = *XML::Xercesc::DOMException_INVALID_ACCESS_ERR;
*VALIDATION_ERR = *XML::Xercesc::DOMException_VALIDATION_ERR;
*swig_code_get = *XML::Xercesc::DOMException_code_get;
*swig_code_set = *XML::Xercesc::DOMException_code_set;
*swig_msg_get = *XML::Xercesc::DOMException_msg_get;
*swig_msg_set = *XML::Xercesc::DOMException_msg_set;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    my $val = $self->$member_func();
    if (exists $BLESSEDMEMBERS{$field}) {
        return undef if (!defined($val));
        my %retval;
        tie %retval,$BLESSEDMEMBERS{$field},$val;
        return bless \%retval, $BLESSEDMEMBERS{$field};
    }
    return $val;
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    if (exists $BLESSEDMEMBERS{$field}) {
        $self->$member_func(tied(%{$newval}));
    } else {
        $self->$member_func($newval);
    }
}


############# Class : XML::Xerces::DOMDocumentRange ##############

package XML::Xerces::DOMDocumentRange;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

sub createRange {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocumentRange_createRange(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMDocumentTraversal ##############

package XML::Xerces::DOMDocumentTraversal;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

sub createNodeIterator {
    my ($self,$root,$what,$filter,$expand) = @_;
    my $callback = $XML::Xerces::DOMNodeIterator::OWNER{$self}->{__NODE_FILTER};
    if (defined $callback) {
      $callback->set_callback_obj($filter);
    } else {
      $callback = XML::Xerces::PerlNodeFilterCallbackHandler->new($filter);
      $XML::Xerces::DOMNodeIterator::OWNER{$self}->{__NODE_FILTER} = $callback;
    }
    my @args = ($self,$root,$what,$callback,$expand);
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMDocumentTraversal();
    }

    my $result = XML::Xercesc::DOMDocumentTraversal_createNodeIterator(@args);
    return undef if (!defined($result));
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub createTreeWalker {
    my ($self,$root,$what,$filter,$expand) = @_;
    my $callback = $XML::Xerces::DOMTreeWalker::OWNER{$self}->{__NODE_FILTER};
    if (defined $callback) {
      $callback->set_callback_obj($filter);
    } else {
      $callback = XML::Xerces::PerlNodeFilterCallbackHandler->new($filter);
      $XML::Xerces::DOMTreeWalker::OWNER{$self}->{__NODE_FILTER} = $callback;
    }
    my @args = ($self,$root,$what,$callback,$expand);
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMDocumentTraversal();
    }

    my $result = XML::Xercesc::DOMDocumentTraversal_createTreeWalker(@args);
    return undef if (!defined($result));
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMNodeFilter ##############

package XML::Xerces::DOMNodeFilter;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*FILTER_ACCEPT = *XML::Xercesc::DOMNodeFilter_FILTER_ACCEPT;
*FILTER_REJECT = *XML::Xercesc::DOMNodeFilter_FILTER_REJECT;
*FILTER_SKIP = *XML::Xercesc::DOMNodeFilter_FILTER_SKIP;
*SHOW_ALL = *XML::Xercesc::DOMNodeFilter_SHOW_ALL;
*SHOW_ELEMENT = *XML::Xercesc::DOMNodeFilter_SHOW_ELEMENT;
*SHOW_ATTRIBUTE = *XML::Xercesc::DOMNodeFilter_SHOW_ATTRIBUTE;
*SHOW_TEXT = *XML::Xercesc::DOMNodeFilter_SHOW_TEXT;
*SHOW_CDATA_SECTION = *XML::Xercesc::DOMNodeFilter_SHOW_CDATA_SECTION;
*SHOW_ENTITY_REFERENCE = *XML::Xercesc::DOMNodeFilter_SHOW_ENTITY_REFERENCE;
*SHOW_ENTITY = *XML::Xercesc::DOMNodeFilter_SHOW_ENTITY;
*SHOW_PROCESSING_INSTRUCTION = *XML::Xercesc::DOMNodeFilter_SHOW_PROCESSING_INSTRUCTION;
*SHOW_COMMENT = *XML::Xercesc::DOMNodeFilter_SHOW_COMMENT;
*SHOW_DOCUMENT = *XML::Xercesc::DOMNodeFilter_SHOW_DOCUMENT;
*SHOW_DOCUMENT_TYPE = *XML::Xercesc::DOMNodeFilter_SHOW_DOCUMENT_TYPE;
*SHOW_DOCUMENT_FRAGMENT = *XML::Xercesc::DOMNodeFilter_SHOW_DOCUMENT_FRAGMENT;
*SHOW_NOTATION = *XML::Xercesc::DOMNodeFilter_SHOW_NOTATION;
*acceptNode = *XML::Xercesc::DOMNodeFilter_acceptNode;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMNodeIterator ##############

package XML::Xerces::DOMNodeIterator;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

sub getRoot {
    my @args = @_;
    my $result = XML::Xercesc::DOMNodeIterator_getRoot(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getWhatToShow = *XML::Xercesc::DOMNodeIterator_getWhatToShow;
sub getFilter {
    my @args = @_;
    my $result = XML::Xercesc::DOMNodeIterator_getFilter(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getExpandEntityReferences = *XML::Xercesc::DOMNodeIterator_getExpandEntityReferences;
sub nextNode {
    my @args = @_;
    my $result = XML::Xercesc::DOMNodeIterator_nextNode(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub previousNode {
    my @args = @_;
    my $result = XML::Xercesc::DOMNodeIterator_previousNode(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*detach = *XML::Xercesc::DOMNodeIterator_detach;
*release = *XML::Xercesc::DOMNodeIterator_release;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMRange ##############

package XML::Xerces::DOMRange;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*START_TO_START = *XML::Xercesc::DOMRange_START_TO_START;
*START_TO_END = *XML::Xercesc::DOMRange_START_TO_END;
*END_TO_END = *XML::Xercesc::DOMRange_END_TO_END;
*END_TO_START = *XML::Xercesc::DOMRange_END_TO_START;
sub getStartContainer {
    my @args = @_;
    my $result = XML::Xercesc::DOMRange_getStartContainer(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getStartOffset = *XML::Xercesc::DOMRange_getStartOffset;
sub getEndContainer {
    my @args = @_;
    my $result = XML::Xercesc::DOMRange_getEndContainer(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getEndOffset = *XML::Xercesc::DOMRange_getEndOffset;
*getCollapsed = *XML::Xercesc::DOMRange_getCollapsed;
sub getCommonAncestorContainer {
    my @args = @_;
    my $result = XML::Xercesc::DOMRange_getCommonAncestorContainer(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*setStart = *XML::Xercesc::DOMRange_setStart;
*setEnd = *XML::Xercesc::DOMRange_setEnd;
*setStartBefore = *XML::Xercesc::DOMRange_setStartBefore;
*setStartAfter = *XML::Xercesc::DOMRange_setStartAfter;
*setEndBefore = *XML::Xercesc::DOMRange_setEndBefore;
*setEndAfter = *XML::Xercesc::DOMRange_setEndAfter;
*collapse = *XML::Xercesc::DOMRange_collapse;
*selectNode = *XML::Xercesc::DOMRange_selectNode;
*selectNodeContents = *XML::Xercesc::DOMRange_selectNodeContents;
*compareBoundaryPoints = *XML::Xercesc::DOMRange_compareBoundaryPoints;
*deleteContents = *XML::Xercesc::DOMRange_deleteContents;
sub extractContents {
    my @args = @_;
    my $result = XML::Xercesc::DOMRange_extractContents(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub cloneContents {
    my @args = @_;
    my $result = XML::Xercesc::DOMRange_cloneContents(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*insertNode = *XML::Xercesc::DOMRange_insertNode;
*surroundContents = *XML::Xercesc::DOMRange_surroundContents;
sub cloneRange {
    my @args = @_;
    my $result = XML::Xercesc::DOMRange_cloneRange(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*toString = *XML::Xercesc::DOMRange_toString;
*detach = *XML::Xercesc::DOMRange_detach;
*release = *XML::Xercesc::DOMRange_release;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMRangeException ##############

package XML::Xerces::DOMRangeException;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::DOMException );
%OWNER = ();
%BLESSEDMEMBERS = (
);

%ITERATORS = ();
*BAD_BOUNDARYPOINTS_ERR = *XML::Xercesc::DOMRangeException_BAD_BOUNDARYPOINTS_ERR;
*INVALID_NODE_TYPE_ERR = *XML::Xercesc::DOMRangeException_INVALID_NODE_TYPE_ERR;
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_DOMRangeException(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::DOMRangeException", $self;
    return bless \%retval, $pkg;
}


*swig_code_get = *XML::Xercesc::DOMRangeException_code_get;
*swig_code_set = *XML::Xercesc::DOMRangeException_code_set;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };

sub FETCH {
    my ($self,$field) = @_;
    my $member_func = "swig_${field}_get";
    my $val = $self->$member_func();
    if (exists $BLESSEDMEMBERS{$field}) {
        return undef if (!defined($val));
        my %retval;
        tie %retval,$BLESSEDMEMBERS{$field},$val;
        return bless \%retval, $BLESSEDMEMBERS{$field};
    }
    return $val;
}

sub STORE {
    my ($self,$field,$newval) = @_;
    my $member_func = "swig_${field}_set";
    if (exists $BLESSEDMEMBERS{$field}) {
        $self->$member_func(tied(%{$newval}));
    } else {
        $self->$member_func($newval);
    }
}


############# Class : XML::Xerces::DOMTreeWalker ##############

package XML::Xerces::DOMTreeWalker;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

sub getRoot {
    my @args = @_;
    my $result = XML::Xercesc::DOMTreeWalker_getRoot(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getWhatToShow = *XML::Xercesc::DOMTreeWalker_getWhatToShow;
sub getFilter {
    my @args = @_;
    my $result = XML::Xercesc::DOMTreeWalker_getFilter(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getExpandEntityReferences = *XML::Xercesc::DOMTreeWalker_getExpandEntityReferences;
sub getCurrentNode {
    my @args = @_;
    my $result = XML::Xercesc::DOMTreeWalker_getCurrentNode(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub parentNode {
    my @args = @_;
    my $result = XML::Xercesc::DOMTreeWalker_parentNode(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub firstChild {
    my @args = @_;
    my $result = XML::Xercesc::DOMTreeWalker_firstChild(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub lastChild {
    my @args = @_;
    my $result = XML::Xercesc::DOMTreeWalker_lastChild(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub previousSibling {
    my @args = @_;
    my $result = XML::Xercesc::DOMTreeWalker_previousSibling(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub nextSibling {
    my @args = @_;
    my $result = XML::Xercesc::DOMTreeWalker_nextSibling(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub previousNode {
    my @args = @_;
    my $result = XML::Xercesc::DOMTreeWalker_previousNode(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub nextNode {
    my @args = @_;
    my $result = XML::Xercesc::DOMTreeWalker_nextNode(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*setCurrentNode = *XML::Xercesc::DOMTreeWalker_setCurrentNode;
*release = *XML::Xercesc::DOMTreeWalker_release;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMNode ##############

package XML::Xerces::DOMNode;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
use overload
    "==" => sub { $_[0]->operator_equal_to($_[1])},
    "!=" => sub { $_[0]->operator_not_equal_to($_[1])},
    "fallback" => 1;
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*ELEMENT_NODE = *XML::Xercesc::DOMNode_ELEMENT_NODE;
*ATTRIBUTE_NODE = *XML::Xercesc::DOMNode_ATTRIBUTE_NODE;
*TEXT_NODE = *XML::Xercesc::DOMNode_TEXT_NODE;
*CDATA_SECTION_NODE = *XML::Xercesc::DOMNode_CDATA_SECTION_NODE;
*ENTITY_REFERENCE_NODE = *XML::Xercesc::DOMNode_ENTITY_REFERENCE_NODE;
*ENTITY_NODE = *XML::Xercesc::DOMNode_ENTITY_NODE;
*PROCESSING_INSTRUCTION_NODE = *XML::Xercesc::DOMNode_PROCESSING_INSTRUCTION_NODE;
*COMMENT_NODE = *XML::Xercesc::DOMNode_COMMENT_NODE;
*DOCUMENT_NODE = *XML::Xercesc::DOMNode_DOCUMENT_NODE;
*DOCUMENT_TYPE_NODE = *XML::Xercesc::DOMNode_DOCUMENT_TYPE_NODE;
*DOCUMENT_FRAGMENT_NODE = *XML::Xercesc::DOMNode_DOCUMENT_FRAGMENT_NODE;
*NOTATION_NODE = *XML::Xercesc::DOMNode_NOTATION_NODE;
*TREE_POSITION_PRECEDING = *XML::Xercesc::DOMNode_TREE_POSITION_PRECEDING;
*TREE_POSITION_FOLLOWING = *XML::Xercesc::DOMNode_TREE_POSITION_FOLLOWING;
*TREE_POSITION_ANCESTOR = *XML::Xercesc::DOMNode_TREE_POSITION_ANCESTOR;
*TREE_POSITION_DESCENDANT = *XML::Xercesc::DOMNode_TREE_POSITION_DESCENDANT;
*TREE_POSITION_EQUIVALENT = *XML::Xercesc::DOMNode_TREE_POSITION_EQUIVALENT;
*TREE_POSITION_SAME_NODE = *XML::Xercesc::DOMNode_TREE_POSITION_SAME_NODE;
*TREE_POSITION_DISCONNECTED = *XML::Xercesc::DOMNode_TREE_POSITION_DISCONNECTED;
sub getNodeName {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_getNodeName(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getNodeValue {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_getNodeValue(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getNodeType {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_getNodeType(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getParentNode {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_getParentNode(@args);
    return undef if (!defined($result));
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getChildNodes {
    my @args = @_;
    my $result = XML::Xercesc::DOMNode_getChildNodes(@args);
    unless (defined $result) {
      return () if wantarray;
      return undef; # if *not* wantarray
    }
    return $result->to_list() if wantarray;
    $DOMNodeList::OWNER{$result} = 1; 

    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getFirstChild {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_getFirstChild(@args);
    return undef if (!defined($result));
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getLastChild {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_getLastChild(@args);
    return undef if (!defined($result));
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getPreviousSibling {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_getPreviousSibling(@args);
    return undef if (!defined($result));
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getNextSibling {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_getNextSibling(@args);
    return undef if (!defined($result));
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getAttributes {
    my @args = @_;
    my $result = XML::Xercesc::DOMNode_getAttributes(@args);
    unless (defined $result) {
      return () if wantarray;
      return undef; # if *not* wantarray
    }
    return $result->to_hash() if wantarray;
    $DOMNamedNodeMap::OWNER{$result} = 1;

    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getOwnerDocument {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_getOwnerDocument(@args);
    return undef if (!defined($result));
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub cloneNode {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_cloneNode(@args);
    return undef if (!defined($result));
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub insertBefore {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_insertBefore(@args);
    return undef if (!defined($result));
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub replaceChild {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_replaceChild(@args);
    return undef if (!defined($result));
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub removeChild {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_removeChild(@args);
    return undef if (!defined($result));
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub appendChild {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_appendChild(@args);
    return undef if (!defined($result));
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub hasChildNodes {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_hasChildNodes(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub setNodeValue {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_setNodeValue(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub normalize {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_normalize(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub isSupported {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_isSupported(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getNamespaceURI {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_getNamespaceURI(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getPrefix {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_getPrefix(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getLocalName {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_getLocalName(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub setPrefix {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_setPrefix(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub hasAttributes {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_hasAttributes(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub isSameNode {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_isSameNode(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub isEqualNode {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_isEqualNode(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub setUserData {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_setUserData(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getUserData {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_getUserData(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getBaseURI {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_getBaseURI(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub compareTreePosition {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_compareTreePosition(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getTextContent {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_getTextContent(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub setTextContent {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_setTextContent(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub lookupNamespacePrefix {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_lookupNamespacePrefix(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub isDefaultNamespace {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_isDefaultNamespace(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub lookupNamespaceURI {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_lookupNamespaceURI(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getInterface {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_getInterface(@args);
    return undef if (!defined($result));
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub release {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_release(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub operator_equal_to {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_operator_equal_to(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub operator_not_equal_to {
    my @args = @_;
    if ($args[0]->isa('XML::Xerces::DOMDocument')) {
      $args[0] = $args[0]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMNode_operator_not_equal_to(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMAttr ##############

package XML::Xerces::DOMAttr;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::DOMNode );
%OWNER = ();
%ITERATORS = ();

*getName = *XML::Xercesc::DOMAttr_getName;
*getSpecified = *XML::Xercesc::DOMAttr_getSpecified;
*getValue = *XML::Xercesc::DOMAttr_getValue;
*setValue = *XML::Xercesc::DOMAttr_setValue;
sub getOwnerElement {
    my @args = @_;
    my $result = XML::Xercesc::DOMAttr_getOwnerElement(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*isId = *XML::Xercesc::DOMAttr_isId;
*getTypeInfo = *XML::Xercesc::DOMAttr_getTypeInfo;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMCharacterData ##############

package XML::Xerces::DOMCharacterData;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::DOMNode );
%OWNER = ();
%ITERATORS = ();

*getData = *XML::Xercesc::DOMCharacterData_getData;
*getLength = *XML::Xercesc::DOMCharacterData_getLength;
*substringData = *XML::Xercesc::DOMCharacterData_substringData;
*appendData = *XML::Xercesc::DOMCharacterData_appendData;
*insertData = *XML::Xercesc::DOMCharacterData_insertData;
*deleteData = *XML::Xercesc::DOMCharacterData_deleteData;
*replaceData = *XML::Xercesc::DOMCharacterData_replaceData;
*setData = *XML::Xercesc::DOMCharacterData_setData;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMText ##############

package XML::Xerces::DOMText;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::DOMCharacterData );
%OWNER = ();
%ITERATORS = ();

sub splitText {
    my @args = @_;
    my $result = XML::Xercesc::DOMText_splitText(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getIsWhitespaceInElementContent = *XML::Xercesc::DOMText_getIsWhitespaceInElementContent;
*getWholeText = *XML::Xercesc::DOMText_getWholeText;
sub replaceWholeText {
    my @args = @_;
    my $result = XML::Xercesc::DOMText_replaceWholeText(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*isIgnorableWhitespace = *XML::Xercesc::DOMText_isIgnorableWhitespace;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMCDATASection ##############

package XML::Xerces::DOMCDATASection;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::DOMText );
%OWNER = ();
%ITERATORS = ();

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMComment ##############

package XML::Xerces::DOMComment;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::DOMCharacterData );
%OWNER = ();
%ITERATORS = ();

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMDocument ##############

package XML::Xerces::DOMDocument;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::DOMDocumentRange XML::Xerces::DOMDocumentTraversal XML::Xerces::DOMNode );
%OWNER = ();
%ITERATORS = ();
sub DESTROY {
    my $self = shift;
    # we remove an reference to the Parser that created us
    if (exists $OWNER{$self}->{__PARSER}) {
        undef $OWNER{$self}->{__PARSER};
    }
}

sub createElement {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_createElement(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub createDocumentFragment {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_createDocumentFragment(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub createTextNode {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_createTextNode(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub createComment {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_createComment(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub createCDATASection {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_createCDATASection(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub createProcessingInstruction {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_createProcessingInstruction(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub createAttribute {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_createAttribute(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub createEntityReference {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_createEntityReference(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getDoctype {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_getDoctype(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getImplementation {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_getImplementation(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getDocumentElement {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_getDocumentElement(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getElementsByTagName {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_getElementsByTagName(@args);
    unless (defined $result) {
      return () if wantarray;
      return undef; # if *not* wantarray
    }
    return $result->to_list() if wantarray;
    $DOMNodeList::OWNER{$result} = 1; 

    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub importNode {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_importNode(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub createAttributeNS {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_createAttributeNS(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getElementsByTagNameNS {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_getElementsByTagNameNS(@args);
    unless (defined $result) {
      return () if wantarray;
      return undef; # if *not* wantarray
    }
    return $result->to_list() if wantarray;
    $DOMNodeList::OWNER{$result} = 1; 

    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getElementById {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_getElementById(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getActualEncoding = *XML::Xercesc::DOMDocument_getActualEncoding;
*setActualEncoding = *XML::Xercesc::DOMDocument_setActualEncoding;
*getEncoding = *XML::Xercesc::DOMDocument_getEncoding;
*setEncoding = *XML::Xercesc::DOMDocument_setEncoding;
*getStandalone = *XML::Xercesc::DOMDocument_getStandalone;
*setStandalone = *XML::Xercesc::DOMDocument_setStandalone;
*getVersion = *XML::Xercesc::DOMDocument_getVersion;
*setVersion = *XML::Xercesc::DOMDocument_setVersion;
*getDocumentURI = *XML::Xercesc::DOMDocument_getDocumentURI;
*setDocumentURI = *XML::Xercesc::DOMDocument_setDocumentURI;
*getStrictErrorChecking = *XML::Xercesc::DOMDocument_getStrictErrorChecking;
*setStrictErrorChecking = *XML::Xercesc::DOMDocument_setStrictErrorChecking;
sub renameNode {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_renameNode(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub adoptNode {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_adoptNode(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*normalizeDocument = *XML::Xercesc::DOMDocument_normalizeDocument;
*getDOMConfiguration = *XML::Xercesc::DOMDocument_getDOMConfiguration;
sub createEntity {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_createEntity(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub createDocumentType {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_createDocumentType(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub createNotation {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_createNotation(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub createElementNS {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_createElementNS(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub toDOMNode {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_toDOMNode(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub toDOMDocumentTraversal {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocument_toDOMDocumentTraversal(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMDocumentFragment ##############

package XML::Xerces::DOMDocumentFragment;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::DOMNode );
%OWNER = ();
%ITERATORS = ();

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMDocumentType ##############

package XML::Xerces::DOMDocumentType;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::DOMNode );
%OWNER = ();
%ITERATORS = ();

*getName = *XML::Xercesc::DOMDocumentType_getName;
sub getEntities {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocumentType_getEntities(@args);
    unless (defined $result) {
      return () if wantarray;
      return undef; # if *not* wantarray
    }
    return $result->to_hash() if wantarray;
    $DOMNamedNodeMap::OWNER{$result} = 1;

    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getNotations {
    my @args = @_;
    my $result = XML::Xercesc::DOMDocumentType_getNotations(@args);
    unless (defined $result) {
      return () if wantarray;
      return undef; # if *not* wantarray
    }
    return $result->to_hash() if wantarray;
    $DOMNamedNodeMap::OWNER{$result} = 1;

    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getPublicId = *XML::Xercesc::DOMDocumentType_getPublicId;
*getSystemId = *XML::Xercesc::DOMDocumentType_getSystemId;
*getInternalSubset = *XML::Xercesc::DOMDocumentType_getInternalSubset;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMImplementationLS ##############

package XML::Xerces::DOMImplementationLS;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*MODE_SYNCHRONOUS = *XML::Xercesc::DOMImplementationLS_MODE_SYNCHRONOUS;
*MODE_ASYNCHRONOUS = *XML::Xercesc::DOMImplementationLS_MODE_ASYNCHRONOUS;
sub createDOMBuilder {
    my @args = @_;
    my $result = XML::Xercesc::DOMImplementationLS_createDOMBuilder(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub createDOMWriter {
    my @args = @_;
    my $result = XML::Xercesc::DOMImplementationLS_createDOMWriter(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub createDOMInputSource {
    my @args = @_;
    my $result = XML::Xercesc::DOMImplementationLS_createDOMInputSource(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMImplementation ##############

package XML::Xerces::DOMImplementation;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::DOMImplementationLS );
%OWNER = ();
%ITERATORS = ();

*hasFeature = *XML::Xercesc::DOMImplementation_hasFeature;
sub createDocumentType {
    my @args = @_;
    my $result = XML::Xercesc::DOMImplementation_createDocumentType(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getInterface {
    my @args = @_;
    my $result = XML::Xercesc::DOMImplementation_getInterface(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub createDocument {
    my @args = @_;
    my $result = XML::Xercesc::DOMImplementation_createDocument(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getImplementation {
    my @args = @_;
    my $result = XML::Xercesc::DOMImplementation_getImplementation(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMElement ##############

package XML::Xerces::DOMElement;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::DOMNode );
%OWNER = ();
%ITERATORS = ();

*getTagName = *XML::Xercesc::DOMElement_getTagName;
*getAttribute = *XML::Xercesc::DOMElement_getAttribute;
sub getAttributeNode {
    my @args = @_;
    my $result = XML::Xercesc::DOMElement_getAttributeNode(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getElementsByTagName {
    my @args = @_;
    my $result = XML::Xercesc::DOMElement_getElementsByTagName(@args);
    unless (defined $result) {
      return () if wantarray;
      return undef; # if *not* wantarray
    }
    return $result->to_list() if wantarray;
    $DOMNodeList::OWNER{$result} = 1; 

    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub setAttribute {
    my ($self,$attr,$val) = @_;
    return unless defined $attr and defined $val;
    my $result = XML::Xercesc::DOMElement_setAttribute(@_);
    return $result unless ref($result) =~ m[XML::Xerces];
    $XML::Xerces::DOMAttr::OWNER{$result} = 1; 
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub setAttributeNode {
    my @args = @_;
    my $result = XML::Xercesc::DOMElement_setAttributeNode(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub removeAttributeNode {
    my @args = @_;
    my $result = XML::Xercesc::DOMElement_removeAttributeNode(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*removeAttribute = *XML::Xercesc::DOMElement_removeAttribute;
*getAttributeNS = *XML::Xercesc::DOMElement_getAttributeNS;
*setAttributeNS = *XML::Xercesc::DOMElement_setAttributeNS;
*removeAttributeNS = *XML::Xercesc::DOMElement_removeAttributeNS;
sub getAttributeNodeNS {
    my @args = @_;
    my $result = XML::Xercesc::DOMElement_getAttributeNodeNS(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub setAttributeNodeNS {
    my @args = @_;
    my $result = XML::Xercesc::DOMElement_setAttributeNodeNS(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getElementsByTagNameNS {
    my @args = @_;
    my $result = XML::Xercesc::DOMElement_getElementsByTagNameNS(@args);
    unless (defined $result) {
      return () if wantarray;
      return undef; # if *not* wantarray
    }
    return $result->to_list() if wantarray;
    $DOMNodeList::OWNER{$result} = 1; 

    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*hasAttribute = *XML::Xercesc::DOMElement_hasAttribute;
*hasAttributeNS = *XML::Xercesc::DOMElement_hasAttributeNS;
*setIdAttribute = *XML::Xercesc::DOMElement_setIdAttribute;
*setIdAttributeNS = *XML::Xercesc::DOMElement_setIdAttributeNS;
*setIdAttributeNode = *XML::Xercesc::DOMElement_setIdAttributeNode;
*getTypeInfo = *XML::Xercesc::DOMElement_getTypeInfo;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMEntity ##############

package XML::Xerces::DOMEntity;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::DOMNode );
%OWNER = ();
%ITERATORS = ();

*getPublicId = *XML::Xercesc::DOMEntity_getPublicId;
*getSystemId = *XML::Xercesc::DOMEntity_getSystemId;
*getNotationName = *XML::Xercesc::DOMEntity_getNotationName;
*getActualEncoding = *XML::Xercesc::DOMEntity_getActualEncoding;
*setActualEncoding = *XML::Xercesc::DOMEntity_setActualEncoding;
*getEncoding = *XML::Xercesc::DOMEntity_getEncoding;
*setEncoding = *XML::Xercesc::DOMEntity_setEncoding;
*getVersion = *XML::Xercesc::DOMEntity_getVersion;
*setVersion = *XML::Xercesc::DOMEntity_setVersion;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMEntityReference ##############

package XML::Xerces::DOMEntityReference;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::DOMNode );
%OWNER = ();
%ITERATORS = ();

sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMNamedNodeMap ##############

package XML::Xerces::DOMNamedNodeMap;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

sub setNamedItem {
    my @args = @_;
    my $result = XML::Xercesc::DOMNamedNodeMap_setNamedItem(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub item {
    my @args = @_;
    my $result = XML::Xercesc::DOMNamedNodeMap_item(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getNamedItem {
    my @args = @_;
    my $result = XML::Xercesc::DOMNamedNodeMap_getNamedItem(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getLength = *XML::Xercesc::DOMNamedNodeMap_getLength;
sub removeNamedItem {
    my @args = @_;
    my $result = XML::Xercesc::DOMNamedNodeMap_removeNamedItem(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getNamedItemNS {
    my @args = @_;
    my $result = XML::Xercesc::DOMNamedNodeMap_getNamedItemNS(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub setNamedItemNS {
    my @args = @_;
    my $result = XML::Xercesc::DOMNamedNodeMap_setNamedItemNS(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub removeNamedItemNS {
    my @args = @_;
    my $result = XML::Xercesc::DOMNamedNodeMap_removeNamedItemNS(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMNodeList ##############

package XML::Xerces::DOMNodeList;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

sub item {
    my @args = @_;
    my $result = XML::Xercesc::DOMNodeList_item(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getLength = *XML::Xercesc::DOMNodeList_getLength;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMNotation ##############

package XML::Xerces::DOMNotation;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::DOMNode );
%OWNER = ();
%ITERATORS = ();

*getPublicId = *XML::Xercesc::DOMNotation_getPublicId;
*getSystemId = *XML::Xercesc::DOMNotation_getSystemId;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMProcessingInstruction ##############

package XML::Xerces::DOMProcessingInstruction;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::DOMNode );
%OWNER = ();
%ITERATORS = ();

*getTarget = *XML::Xercesc::DOMProcessingInstruction_getTarget;
*getData = *XML::Xercesc::DOMProcessingInstruction_getData;
*setData = *XML::Xercesc::DOMProcessingInstruction_setData;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMBuilder ##############

package XML::Xerces::DOMBuilder;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*ACTION_REPLACE = *XML::Xercesc::DOMBuilder_ACTION_REPLACE;
*ACTION_APPEND_AS_CHILDREN = *XML::Xercesc::DOMBuilder_ACTION_APPEND_AS_CHILDREN;
*ACTION_INSERT_AFTER = *XML::Xercesc::DOMBuilder_ACTION_INSERT_AFTER;
*ACTION_INSERT_BEFORE = *XML::Xercesc::DOMBuilder_ACTION_INSERT_BEFORE;
*getErrorHandler = *XML::Xercesc::DOMBuilder_getErrorHandler;
*getEntityResolver = *XML::Xercesc::DOMBuilder_getEntityResolver;
*getFilter = *XML::Xercesc::DOMBuilder_getFilter;
sub setErrorHandler {
  my ($self,$handler) = @_;
  my $retval;
  my $callback = $XML::Xerces::DOMBuilder::OWNER{$self}->{__ERROR_HANDLER};
  if (defined $callback) {
    $retval = $callback->set_callback_obj($handler);
  } else {
    $callback = XML::Xerces::PerlErrorCallbackHandler->new($handler);
    $XML::Xerces::DOMBuilder::OWNER{$self}->{__ERROR_HANDLER} = $callback;
  }
  XML::Xercesc::DOMBuilder_setErrorHandler($self,$callback);
  return $retval;
}
sub setEntityResolver {
  my ($self,$handler) = @_;
  my $callback = $XML::Xerces::DOMBuilder::OWNER{$self}->{__ENTITY_RESOLVER};
  if (defined $callback) {
    $callback->set_callback_obj($handler);
  } else {
    $callback = XML::Xerces::PerlEntityResolverHandler->new($handler);
    $XML::Xerces::DOMBuilder::OWNER{$self}->{__ENTITY_RESOLVER} = $callback;
  }
  return XML::Xercesc::DOMBuilder_setEntityResolver($self,$callback);
}
*setFilter = *XML::Xercesc::DOMBuilder_setFilter;
*setFeature = *XML::Xercesc::DOMBuilder_setFeature;
*getFeature = *XML::Xercesc::DOMBuilder_getFeature;
*canSetFeature = *XML::Xercesc::DOMBuilder_canSetFeature;
sub parse {
    my @args = @_;
    my $result = XML::Xercesc::DOMBuilder_parse(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub parseURI {
    my @args = @_;
    my $result = XML::Xercesc::DOMBuilder_parseURI(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*parseWithContext = *XML::Xercesc::DOMBuilder_parseWithContext;
*getProperty = *XML::Xercesc::DOMBuilder_getProperty;
*setProperty = *XML::Xercesc::DOMBuilder_setProperty;
*release = *XML::Xercesc::DOMBuilder_release;
*resetDocumentPool = *XML::Xercesc::DOMBuilder_resetDocumentPool;
sub loadGrammar {
    my @args = @_;
    my $result = XML::Xercesc::DOMBuilder_loadGrammar(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getGrammar {
    my @args = @_;
    my $result = XML::Xercesc::DOMBuilder_getGrammar(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getRootGrammar {
    my @args = @_;
    my $result = XML::Xercesc::DOMBuilder_getRootGrammar(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getURIText = *XML::Xercesc::DOMBuilder_getURIText;
*resetCachedGrammarPool = *XML::Xercesc::DOMBuilder_resetCachedGrammarPool;
*getSrcOffset = *XML::Xercesc::DOMBuilder_getSrcOffset;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMImplementationRegistry ##############

package XML::Xerces::DOMImplementationRegistry;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();
sub getDOMImplementation {
    my @args = @_;
    my $result = XML::Xercesc::DOMImplementationRegistry_getDOMImplementation(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*addSource = *XML::Xercesc::DOMImplementationRegistry_addSource;
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_DOMImplementationRegistry(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::DOMImplementationRegistry", $self;
    return bless \%retval, $pkg;
}


sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMImplementationSource ##############

package XML::Xerces::DOMImplementationSource;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

sub getDOMImplementation {
    my @args = @_;
    my $result = XML::Xercesc::DOMImplementationSource_getDOMImplementation(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMInputSource ##############

package XML::Xerces::DOMInputSource;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*getEncoding = *XML::Xercesc::DOMInputSource_getEncoding;
*getPublicId = *XML::Xercesc::DOMInputSource_getPublicId;
*getSystemId = *XML::Xercesc::DOMInputSource_getSystemId;
*getBaseURI = *XML::Xercesc::DOMInputSource_getBaseURI;
*setEncoding = *XML::Xercesc::DOMInputSource_setEncoding;
*setPublicId = *XML::Xercesc::DOMInputSource_setPublicId;
*setSystemId = *XML::Xercesc::DOMInputSource_setSystemId;
*setBaseURI = *XML::Xercesc::DOMInputSource_setBaseURI;
*makeStream = *XML::Xercesc::DOMInputSource_makeStream;
*setIssueFatalErrorIfNotFound = *XML::Xercesc::DOMInputSource_setIssueFatalErrorIfNotFound;
*getIssueFatalErrorIfNotFound = *XML::Xercesc::DOMInputSource_getIssueFatalErrorIfNotFound;
*release = *XML::Xercesc::DOMInputSource_release;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMLocator ##############

package XML::Xerces::DOMLocator;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*getLineNumber = *XML::Xercesc::DOMLocator_getLineNumber;
*getColumnNumber = *XML::Xercesc::DOMLocator_getColumnNumber;
*getOffset = *XML::Xercesc::DOMLocator_getOffset;
sub getErrorNode {
    my @args = @_;
    my $result = XML::Xercesc::DOMLocator_getErrorNode(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getURI = *XML::Xercesc::DOMLocator_getURI;
*setLineNumber = *XML::Xercesc::DOMLocator_setLineNumber;
*setColumnNumber = *XML::Xercesc::DOMLocator_setColumnNumber;
*setOffset = *XML::Xercesc::DOMLocator_setOffset;
*setErrorNode = *XML::Xercesc::DOMLocator_setErrorNode;
*setURI = *XML::Xercesc::DOMLocator_setURI;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMWriter ##############

package XML::Xerces::DOMWriter;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces );
%OWNER = ();
%ITERATORS = ();

*canSetFeature = *XML::Xercesc::DOMWriter_canSetFeature;
*setFeature = *XML::Xercesc::DOMWriter_setFeature;
*getFeature = *XML::Xercesc::DOMWriter_getFeature;
*setEncoding = *XML::Xercesc::DOMWriter_setEncoding;
*setNewLine = *XML::Xercesc::DOMWriter_setNewLine;
sub setErrorHandler {
  my ($self,$handler) = @_;
  my $retval;
  my $callback = $XML::Xerces::DOMWriter::OWNER{$self}->{__ERROR_HANDLER};
  if (defined $callback) {
    $retval = $callback->set_callback_obj($handler);
  } else {
    $callback = XML::Xerces::PerlErrorCallbackHandler->new($handler);
    $XML::Xerces::DOMWriter::OWNER{$self}->{__ERROR_HANDLER} = $callback;
  }
  XML::Xercesc::DOMWriter_setErrorHandler($self,$callback);
  return $retval;
}
*setFilter = *XML::Xercesc::DOMWriter_setFilter;
*getEncoding = *XML::Xercesc::DOMWriter_getEncoding;
*getNewLine = *XML::Xercesc::DOMWriter_getNewLine;
*getErrorHandler = *XML::Xercesc::DOMWriter_getErrorHandler;
sub getFilter {
    my @args = @_;
    my $result = XML::Xercesc::DOMWriter_getFilter(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub writeNode {
    my @args = @_;
    if ($args[2]->isa('XML::Xerces::DOMDocument')) {
      $args[2] = $args[2]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMWriter_writeNode(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub writeToString {
    my @args = @_;
    if ($args[1]->isa('XML::Xerces::DOMDocument')) {
      $args[1] = $args[1]->toDOMNode();
    }
    my $result = XML::Xercesc::DOMWriter_writeToString(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*release = *XML::Xercesc::DOMWriter_release;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::DOMWriterFilter ##############

package XML::Xerces::DOMWriterFilter;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::DOMNodeFilter );
%OWNER = ();
%ITERATORS = ();

*acceptNode = *XML::Xercesc::DOMWriterFilter_acceptNode;
*getWhatToShow = *XML::Xercesc::DOMWriterFilter_getWhatToShow;
*setWhatToShow = *XML::Xercesc::DOMWriterFilter_setWhatToShow;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::AbstractDOMParser ##############

package XML::Xerces::AbstractDOMParser;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::XMLDocumentHandler XML::Xerces::XMLErrorReporter XML::Xerces::XMLEntityHandler XML::Xerces::DocTypeHandler );
%OWNER = ();
%ITERATORS = ();
*Val_Never = *XML::Xercesc::AbstractDOMParser_Val_Never;
*Val_Always = *XML::Xercesc::AbstractDOMParser_Val_Always;
*Val_Auto = *XML::Xercesc::AbstractDOMParser_Val_Auto;

*reset = *XML::Xercesc::AbstractDOMParser_reset;
sub adoptDocument {
    my @args = @_;
    my $result = XML::Xercesc::AbstractDOMParser_adoptDocument(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getDocument {
    my @args = @_;
    my $result = XML::Xercesc::AbstractDOMParser_getDocument(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getValidator {
    my @args = @_;
    my $result = XML::Xercesc::AbstractDOMParser_getValidator(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getValidationScheme = *XML::Xercesc::AbstractDOMParser_getValidationScheme;
*getDoSchema = *XML::Xercesc::AbstractDOMParser_getDoSchema;
*getValidationSchemaFullChecking = *XML::Xercesc::AbstractDOMParser_getValidationSchemaFullChecking;
*getErrorCount = *XML::Xercesc::AbstractDOMParser_getErrorCount;
*getDoNamespaces = *XML::Xercesc::AbstractDOMParser_getDoNamespaces;
*getExitOnFirstFatalError = *XML::Xercesc::AbstractDOMParser_getExitOnFirstFatalError;
*getValidationConstraintFatal = *XML::Xercesc::AbstractDOMParser_getValidationConstraintFatal;
*getCreateEntityReferenceNodes = *XML::Xercesc::AbstractDOMParser_getCreateEntityReferenceNodes;
*getIncludeIgnorableWhitespace = *XML::Xercesc::AbstractDOMParser_getIncludeIgnorableWhitespace;
*getExternalSchemaLocation = *XML::Xercesc::AbstractDOMParser_getExternalSchemaLocation;
*getExternalNoNamespaceSchemaLocation = *XML::Xercesc::AbstractDOMParser_getExternalNoNamespaceSchemaLocation;
*getSecurityManager = *XML::Xercesc::AbstractDOMParser_getSecurityManager;
*getLoadExternalDTD = *XML::Xercesc::AbstractDOMParser_getLoadExternalDTD;
*getCreateCommentNodes = *XML::Xercesc::AbstractDOMParser_getCreateCommentNodes;
*getCalculateSrcOfs = *XML::Xercesc::AbstractDOMParser_getCalculateSrcOfs;
*getStandardUriConformant = *XML::Xercesc::AbstractDOMParser_getStandardUriConformant;
*setDoNamespaces = *XML::Xercesc::AbstractDOMParser_setDoNamespaces;
*setExitOnFirstFatalError = *XML::Xercesc::AbstractDOMParser_setExitOnFirstFatalError;
*setValidationConstraintFatal = *XML::Xercesc::AbstractDOMParser_setValidationConstraintFatal;
*setCreateEntityReferenceNodes = *XML::Xercesc::AbstractDOMParser_setCreateEntityReferenceNodes;
*setIncludeIgnorableWhitespace = *XML::Xercesc::AbstractDOMParser_setIncludeIgnorableWhitespace;
*setValidationScheme = *XML::Xercesc::AbstractDOMParser_setValidationScheme;
*setDoSchema = *XML::Xercesc::AbstractDOMParser_setDoSchema;
*setValidationSchemaFullChecking = *XML::Xercesc::AbstractDOMParser_setValidationSchemaFullChecking;
*setExternalSchemaLocation = *XML::Xercesc::AbstractDOMParser_setExternalSchemaLocation;
*setExternalNoNamespaceSchemaLocation = *XML::Xercesc::AbstractDOMParser_setExternalNoNamespaceSchemaLocation;
*setSecurityManager = *XML::Xercesc::AbstractDOMParser_setSecurityManager;
*setLoadExternalDTD = *XML::Xercesc::AbstractDOMParser_setLoadExternalDTD;
*setCreateCommentNodes = *XML::Xercesc::AbstractDOMParser_setCreateCommentNodes;
*setCalculateSrcOfs = *XML::Xercesc::AbstractDOMParser_setCalculateSrcOfs;
*setStandardUriConformant = *XML::Xercesc::AbstractDOMParser_setStandardUriConformant;
*useScanner = *XML::Xercesc::AbstractDOMParser_useScanner;
*parse = *XML::Xercesc::AbstractDOMParser_parse;
*parseFirst = *XML::Xercesc::AbstractDOMParser_parseFirst;
*parseNext = *XML::Xercesc::AbstractDOMParser_parseNext;
*parseReset = *XML::Xercesc::AbstractDOMParser_parseReset;
*getExpandEntityReferences = *XML::Xercesc::AbstractDOMParser_getExpandEntityReferences;
*setExpandEntityReferences = *XML::Xercesc::AbstractDOMParser_setExpandEntityReferences;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::XercesDOMParser ##############

package XML::Xerces::XercesDOMParser;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::AbstractDOMParser );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_XercesDOMParser(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::XercesDOMParser", $self;
    return bless \%retval, $pkg;
}

sub DESTROY {
    return unless $_[0]->isa('HASH');
    my $self = tied(%{$_[0]});
    return unless defined $self;
    return unless defined $self;
    delete $ITERATORS{$self};
    if (exists $OWNER{$self}) {
        XML::Xercesc::delete_XercesDOMParser($self);
        delete $OWNER{$self};
    }
}

sub getErrorHandler {
    my @args = @_;
    my $result = XML::Xercesc::XercesDOMParser_getErrorHandler(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getEntityResolver {
    my @args = @_;
    my $result = XML::Xercesc::XercesDOMParser_getEntityResolver(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*isCachingGrammarFromParse = *XML::Xercesc::XercesDOMParser_isCachingGrammarFromParse;
*isUsingCachedGrammarInParse = *XML::Xercesc::XercesDOMParser_isUsingCachedGrammarInParse;
sub getGrammar {
    my @args = @_;
    my $result = XML::Xercesc::XercesDOMParser_getGrammar(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
sub getRootGrammar {
    my @args = @_;
    my $result = XML::Xercesc::XercesDOMParser_getRootGrammar(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*getURIText = *XML::Xercesc::XercesDOMParser_getURIText;
*getSrcOffset = *XML::Xercesc::XercesDOMParser_getSrcOffset;
sub setErrorHandler {
  my ($self,$handler) = @_;
  my $retval;
  my $callback = $XML::Xerces::XercesDOMParser::OWNER{$self}->{__ERROR_HANDLER};
  if (defined $callback) {
    $retval = $callback->set_callback_obj($handler);
  } else {
    $callback = XML::Xerces::PerlErrorCallbackHandler->new($handler);
    $XML::Xerces::XercesDOMParser::OWNER{$self}->{__ERROR_HANDLER} = $callback;
  }
  XML::Xercesc::XercesDOMParser_setErrorHandler($self,$callback);
  return $retval;
}
sub setEntityResolver {
  my ($self,$handler) = @_;
  my $callback = $XML::Xerces::XercesDOMParser::OWNER{$self}->{__ENTITY_RESOLVER};
  if (defined $callback) {
    $callback->set_callback_obj($handler);
  } else {
    $callback = XML::Xerces::PerlEntityResolverHandler->new($handler);
    $XML::Xerces::XercesDOMParser::OWNER{$self}->{__ENTITY_RESOLVER} = $callback;
  }
  return XML::Xercesc::XercesDOMParser_setEntityResolver($self,$callback);
}
*cacheGrammarFromParse = *XML::Xercesc::XercesDOMParser_cacheGrammarFromParse;
*useCachedGrammarInParse = *XML::Xercesc::XercesDOMParser_useCachedGrammarInParse;
*resetDocumentPool = *XML::Xercesc::XercesDOMParser_resetDocumentPool;
*error = *XML::Xercesc::XercesDOMParser_error;
*resetErrors = *XML::Xercesc::XercesDOMParser_resetErrors;
sub loadGrammar {
    my @args = @_;
    my $result = XML::Xercesc::XercesDOMParser_loadGrammar(@args);
    return $result unless UNIVERSAL::isa($result,'XML::Xerces');
    my %resulthash;
    tie %resulthash, ref($result), $result;
    return bless \%resulthash, ref($result);
}
*resetCachedGrammarPool = *XML::Xercesc::XercesDOMParser_resetCachedGrammarPool;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::PerlErrorCallbackHandler ##############

package XML::Xerces::PerlErrorCallbackHandler;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::ErrorHandler );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_PerlErrorCallbackHandler(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::PerlErrorCallbackHandler", $self;
    return bless \%retval, $pkg;
}


*set_callback_obj = *XML::Xercesc::PerlErrorCallbackHandler_set_callback_obj;
*resetErrors = *XML::Xercesc::PerlErrorCallbackHandler_resetErrors;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::PerlDocumentCallbackHandler ##############

package XML::Xerces::PerlDocumentCallbackHandler;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::DocumentHandler );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_PerlDocumentCallbackHandler(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::PerlDocumentCallbackHandler", $self;
    return bless \%retval, $pkg;
}


*set_callback_obj = *XML::Xercesc::PerlDocumentCallbackHandler_set_callback_obj;
*characters = *XML::Xercesc::PerlDocumentCallbackHandler_characters;
*processingInstruction = *XML::Xercesc::PerlDocumentCallbackHandler_processingInstruction;
*setDocumentLocator = *XML::Xercesc::PerlDocumentCallbackHandler_setDocumentLocator;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::PerlContentCallbackHandler ##############

package XML::Xerces::PerlContentCallbackHandler;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::ContentHandler );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_PerlContentCallbackHandler(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::PerlContentCallbackHandler", $self;
    return bless \%retval, $pkg;
}


*set_callback_obj = *XML::Xercesc::PerlContentCallbackHandler_set_callback_obj;
*characters = *XML::Xercesc::PerlContentCallbackHandler_characters;
*processingInstruction = *XML::Xercesc::PerlContentCallbackHandler_processingInstruction;
*setDocumentLocator = *XML::Xercesc::PerlContentCallbackHandler_setDocumentLocator;
*startPrefixMapping = *XML::Xercesc::PerlContentCallbackHandler_startPrefixMapping;
*endPrefixMapping = *XML::Xercesc::PerlContentCallbackHandler_endPrefixMapping;
*skippedEntity = *XML::Xercesc::PerlContentCallbackHandler_skippedEntity;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::PerlEntityResolverHandler ##############

package XML::Xerces::PerlEntityResolverHandler;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::EntityResolver );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_PerlEntityResolverHandler(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::PerlEntityResolverHandler", $self;
    return bless \%retval, $pkg;
}


*set_callback_obj = *XML::Xercesc::PerlEntityResolverHandler_set_callback_obj;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


############# Class : XML::Xerces::PerlNodeFilterCallbackHandler ##############

package XML::Xerces::PerlNodeFilterCallbackHandler;
use vars qw(@ISA %OWNER %ITERATORS %BLESSEDMEMBERS);
@ISA = qw( XML::Xerces XML::Xerces::DOMNodeFilter );
%OWNER = ();
%ITERATORS = ();
sub new {
    my $pkg = shift;
    my @args = @_;
    my $self = XML::Xercesc::new_PerlNodeFilterCallbackHandler(@args);
    return undef if (!defined($self));
    $OWNER{$self} = 1;
    my %retval;
    tie %retval, "XML::Xerces::PerlNodeFilterCallbackHandler", $self;
    return bless \%retval, $pkg;
}


*set_callback_obj = *XML::Xercesc::PerlNodeFilterCallbackHandler_set_callback_obj;
sub DISOWN {
    my $self = shift;
    my $ptr = tied(%$self);
    delete $OWNER{$ptr};
    };

sub ACQUIRE {
    my $self = shift;
    my $ptr = tied(%$self);
    $OWNER{$ptr} = 1;
    };


# ------- VARIABLE STUBS --------

package XML::Xerces;

*DEBUG_UTF8_OUT = *XML::Xercesc::DEBUG_UTF8_OUT;
*DEBUG_UTF8_IN = *XML::Xercesc::DEBUG_UTF8_IN;
*XMLUni_fgAnyString = *XML::Xercesc::XMLUni_fgAnyString;
*XMLUni_fgAttListString = *XML::Xercesc::XMLUni_fgAttListString;
*XMLUni_fgCommentString = *XML::Xercesc::XMLUni_fgCommentString;
*XMLUni_fgCDATAString = *XML::Xercesc::XMLUni_fgCDATAString;
*XMLUni_fgDefaultString = *XML::Xercesc::XMLUni_fgDefaultString;
*XMLUni_fgDocTypeString = *XML::Xercesc::XMLUni_fgDocTypeString;
*XMLUni_fgEBCDICEncodingString = *XML::Xercesc::XMLUni_fgEBCDICEncodingString;
*XMLUni_fgElemString = *XML::Xercesc::XMLUni_fgElemString;
*XMLUni_fgEmptyString = *XML::Xercesc::XMLUni_fgEmptyString;
*XMLUni_fgEncodingString = *XML::Xercesc::XMLUni_fgEncodingString;
*XMLUni_fgEntitString = *XML::Xercesc::XMLUni_fgEntitString;
*XMLUni_fgEntityString = *XML::Xercesc::XMLUni_fgEntityString;
*XMLUni_fgEntitiesString = *XML::Xercesc::XMLUni_fgEntitiesString;
*XMLUni_fgEnumerationString = *XML::Xercesc::XMLUni_fgEnumerationString;
*XMLUni_fgExceptDomain = *XML::Xercesc::XMLUni_fgExceptDomain;
*XMLUni_fgFixedString = *XML::Xercesc::XMLUni_fgFixedString;
*XMLUni_fgIBM037EncodingString = *XML::Xercesc::XMLUni_fgIBM037EncodingString;
*XMLUni_fgIBM037EncodingString2 = *XML::Xercesc::XMLUni_fgIBM037EncodingString2;
*XMLUni_fgIBM1140EncodingString = *XML::Xercesc::XMLUni_fgIBM1140EncodingString;
*XMLUni_fgIBM1140EncodingString2 = *XML::Xercesc::XMLUni_fgIBM1140EncodingString2;
*XMLUni_fgIBM1140EncodingString3 = *XML::Xercesc::XMLUni_fgIBM1140EncodingString3;
*XMLUni_fgIBM1140EncodingString4 = *XML::Xercesc::XMLUni_fgIBM1140EncodingString4;
*XMLUni_fgIESString = *XML::Xercesc::XMLUni_fgIESString;
*XMLUni_fgIDString = *XML::Xercesc::XMLUni_fgIDString;
*XMLUni_fgIDRefString = *XML::Xercesc::XMLUni_fgIDRefString;
*XMLUni_fgIDRefsString = *XML::Xercesc::XMLUni_fgIDRefsString;
*XMLUni_fgImpliedString = *XML::Xercesc::XMLUni_fgImpliedString;
*XMLUni_fgIgnoreString = *XML::Xercesc::XMLUni_fgIgnoreString;
*XMLUni_fgIncludeString = *XML::Xercesc::XMLUni_fgIncludeString;
*XMLUni_fgISO88591EncodingString = *XML::Xercesc::XMLUni_fgISO88591EncodingString;
*XMLUni_fgISO88591EncodingString2 = *XML::Xercesc::XMLUni_fgISO88591EncodingString2;
*XMLUni_fgISO88591EncodingString3 = *XML::Xercesc::XMLUni_fgISO88591EncodingString3;
*XMLUni_fgISO88591EncodingString4 = *XML::Xercesc::XMLUni_fgISO88591EncodingString4;
*XMLUni_fgISO88591EncodingString5 = *XML::Xercesc::XMLUni_fgISO88591EncodingString5;
*XMLUni_fgISO88591EncodingString6 = *XML::Xercesc::XMLUni_fgISO88591EncodingString6;
*XMLUni_fgISO88591EncodingString7 = *XML::Xercesc::XMLUni_fgISO88591EncodingString7;
*XMLUni_fgISO88591EncodingString8 = *XML::Xercesc::XMLUni_fgISO88591EncodingString8;
*XMLUni_fgISO88591EncodingString9 = *XML::Xercesc::XMLUni_fgISO88591EncodingString9;
*XMLUni_fgISO88591EncodingString10 = *XML::Xercesc::XMLUni_fgISO88591EncodingString10;
*XMLUni_fgISO88591EncodingString11 = *XML::Xercesc::XMLUni_fgISO88591EncodingString11;
*XMLUni_fgISO88591EncodingString12 = *XML::Xercesc::XMLUni_fgISO88591EncodingString12;
*XMLUni_fgLocalHostString = *XML::Xercesc::XMLUni_fgLocalHostString;
*XMLUni_fgNoString = *XML::Xercesc::XMLUni_fgNoString;
*XMLUni_fgNotationString = *XML::Xercesc::XMLUni_fgNotationString;
*XMLUni_fgNDATAString = *XML::Xercesc::XMLUni_fgNDATAString;
*XMLUni_fgNmTokenString = *XML::Xercesc::XMLUni_fgNmTokenString;
*XMLUni_fgNmTokensString = *XML::Xercesc::XMLUni_fgNmTokensString;
*XMLUni_fgPCDATAString = *XML::Xercesc::XMLUni_fgPCDATAString;
*XMLUni_fgPIString = *XML::Xercesc::XMLUni_fgPIString;
*XMLUni_fgPubIDString = *XML::Xercesc::XMLUni_fgPubIDString;
*XMLUni_fgRefString = *XML::Xercesc::XMLUni_fgRefString;
*XMLUni_fgRequiredString = *XML::Xercesc::XMLUni_fgRequiredString;
*XMLUni_fgStandaloneString = *XML::Xercesc::XMLUni_fgStandaloneString;
*XMLUni_fgVersion1_0 = *XML::Xercesc::XMLUni_fgVersion1_0;
*XMLUni_fgVersion1_1 = *XML::Xercesc::XMLUni_fgVersion1_1;
*XMLUni_fgSysIDString = *XML::Xercesc::XMLUni_fgSysIDString;
*XMLUni_fgUnknownURIName = *XML::Xercesc::XMLUni_fgUnknownURIName;
*XMLUni_fgUCS4EncodingString = *XML::Xercesc::XMLUni_fgUCS4EncodingString;
*XMLUni_fgUCS4EncodingString2 = *XML::Xercesc::XMLUni_fgUCS4EncodingString2;
*XMLUni_fgUCS4EncodingString3 = *XML::Xercesc::XMLUni_fgUCS4EncodingString3;
*XMLUni_fgUCS4BEncodingString = *XML::Xercesc::XMLUni_fgUCS4BEncodingString;
*XMLUni_fgUCS4BEncodingString2 = *XML::Xercesc::XMLUni_fgUCS4BEncodingString2;
*XMLUni_fgUCS4LEncodingString = *XML::Xercesc::XMLUni_fgUCS4LEncodingString;
*XMLUni_fgUCS4LEncodingString2 = *XML::Xercesc::XMLUni_fgUCS4LEncodingString2;
*XMLUni_fgUSASCIIEncodingString = *XML::Xercesc::XMLUni_fgUSASCIIEncodingString;
*XMLUni_fgUSASCIIEncodingString2 = *XML::Xercesc::XMLUni_fgUSASCIIEncodingString2;
*XMLUni_fgUSASCIIEncodingString3 = *XML::Xercesc::XMLUni_fgUSASCIIEncodingString3;
*XMLUni_fgUSASCIIEncodingString4 = *XML::Xercesc::XMLUni_fgUSASCIIEncodingString4;
*XMLUni_fgUTF8EncodingString = *XML::Xercesc::XMLUni_fgUTF8EncodingString;
*XMLUni_fgUTF8EncodingString2 = *XML::Xercesc::XMLUni_fgUTF8EncodingString2;
*XMLUni_fgUTF16EncodingString = *XML::Xercesc::XMLUni_fgUTF16EncodingString;
*XMLUni_fgUTF16EncodingString2 = *XML::Xercesc::XMLUni_fgUTF16EncodingString2;
*XMLUni_fgUTF16EncodingString3 = *XML::Xercesc::XMLUni_fgUTF16EncodingString3;
*XMLUni_fgUTF16EncodingString4 = *XML::Xercesc::XMLUni_fgUTF16EncodingString4;
*XMLUni_fgUTF16EncodingString5 = *XML::Xercesc::XMLUni_fgUTF16EncodingString5;
*XMLUni_fgUTF16BEncodingString = *XML::Xercesc::XMLUni_fgUTF16BEncodingString;
*XMLUni_fgUTF16BEncodingString2 = *XML::Xercesc::XMLUni_fgUTF16BEncodingString2;
*XMLUni_fgUTF16LEncodingString = *XML::Xercesc::XMLUni_fgUTF16LEncodingString;
*XMLUni_fgUTF16LEncodingString2 = *XML::Xercesc::XMLUni_fgUTF16LEncodingString2;
*XMLUni_fgVersionString = *XML::Xercesc::XMLUni_fgVersionString;
*XMLUni_fgValidityDomain = *XML::Xercesc::XMLUni_fgValidityDomain;
*XMLUni_fgWin1252EncodingString = *XML::Xercesc::XMLUni_fgWin1252EncodingString;
*XMLUni_fgXMLChEncodingString = *XML::Xercesc::XMLUni_fgXMLChEncodingString;
*XMLUni_fgXMLDOMMsgDomain = *XML::Xercesc::XMLUni_fgXMLDOMMsgDomain;
*XMLUni_fgXMLString = *XML::Xercesc::XMLUni_fgXMLString;
*XMLUni_fgXMLStringSpace = *XML::Xercesc::XMLUni_fgXMLStringSpace;
*XMLUni_fgXMLStringHTab = *XML::Xercesc::XMLUni_fgXMLStringHTab;
*XMLUni_fgXMLStringCR = *XML::Xercesc::XMLUni_fgXMLStringCR;
*XMLUni_fgXMLStringLF = *XML::Xercesc::XMLUni_fgXMLStringLF;
*XMLUni_fgXMLStringSpaceU = *XML::Xercesc::XMLUni_fgXMLStringSpaceU;
*XMLUni_fgXMLStringHTabU = *XML::Xercesc::XMLUni_fgXMLStringHTabU;
*XMLUni_fgXMLStringCRU = *XML::Xercesc::XMLUni_fgXMLStringCRU;
*XMLUni_fgXMLStringLFU = *XML::Xercesc::XMLUni_fgXMLStringLFU;
*XMLUni_fgXMLDeclString = *XML::Xercesc::XMLUni_fgXMLDeclString;
*XMLUni_fgXMLDeclStringSpace = *XML::Xercesc::XMLUni_fgXMLDeclStringSpace;
*XMLUni_fgXMLDeclStringHTab = *XML::Xercesc::XMLUni_fgXMLDeclStringHTab;
*XMLUni_fgXMLDeclStringLF = *XML::Xercesc::XMLUni_fgXMLDeclStringLF;
*XMLUni_fgXMLDeclStringCR = *XML::Xercesc::XMLUni_fgXMLDeclStringCR;
*XMLUni_fgXMLDeclStringSpaceU = *XML::Xercesc::XMLUni_fgXMLDeclStringSpaceU;
*XMLUni_fgXMLDeclStringHTabU = *XML::Xercesc::XMLUni_fgXMLDeclStringHTabU;
*XMLUni_fgXMLDeclStringLFU = *XML::Xercesc::XMLUni_fgXMLDeclStringLFU;
*XMLUni_fgXMLDeclStringCRU = *XML::Xercesc::XMLUni_fgXMLDeclStringCRU;
*XMLUni_fgXMLNSString = *XML::Xercesc::XMLUni_fgXMLNSString;
*XMLUni_fgXMLNSColonString = *XML::Xercesc::XMLUni_fgXMLNSColonString;
*XMLUni_fgXMLNSURIName = *XML::Xercesc::XMLUni_fgXMLNSURIName;
*XMLUni_fgXMLErrDomain = *XML::Xercesc::XMLUni_fgXMLErrDomain;
*XMLUni_fgXMLURIName = *XML::Xercesc::XMLUni_fgXMLURIName;
*XMLUni_fgYesString = *XML::Xercesc::XMLUni_fgYesString;
*XMLUni_fgZeroLenString = *XML::Xercesc::XMLUni_fgZeroLenString;
*XMLUni_fgDTDEntityString = *XML::Xercesc::XMLUni_fgDTDEntityString;
*XMLUni_fgAmp = *XML::Xercesc::XMLUni_fgAmp;
*XMLUni_fgLT = *XML::Xercesc::XMLUni_fgLT;
*XMLUni_fgGT = *XML::Xercesc::XMLUni_fgGT;
*XMLUni_fgQuot = *XML::Xercesc::XMLUni_fgQuot;
*XMLUni_fgApos = *XML::Xercesc::XMLUni_fgApos;
*XMLUni_fgWFXMLScanner = *XML::Xercesc::XMLUni_fgWFXMLScanner;
*XMLUni_fgIGXMLScanner = *XML::Xercesc::XMLUni_fgIGXMLScanner;
*XMLUni_fgSGXMLScanner = *XML::Xercesc::XMLUni_fgSGXMLScanner;
*XMLUni_fgDGXMLScanner = *XML::Xercesc::XMLUni_fgDGXMLScanner;
*XMLUni_fgArrayIndexOutOfBoundsException_Name = *XML::Xercesc::XMLUni_fgArrayIndexOutOfBoundsException_Name;
*XMLUni_fgEmptyStackException_Name = *XML::Xercesc::XMLUni_fgEmptyStackException_Name;
*XMLUni_fgIllegalArgumentException_Name = *XML::Xercesc::XMLUni_fgIllegalArgumentException_Name;
*XMLUni_fgInvalidCastException_Name = *XML::Xercesc::XMLUni_fgInvalidCastException_Name;
*XMLUni_fgIOException_Name = *XML::Xercesc::XMLUni_fgIOException_Name;
*XMLUni_fgNoSuchElementException_Name = *XML::Xercesc::XMLUni_fgNoSuchElementException_Name;
*XMLUni_fgNullPointerException_Name = *XML::Xercesc::XMLUni_fgNullPointerException_Name;
*XMLUni_fgXMLPlatformUtilsException_Name = *XML::Xercesc::XMLUni_fgXMLPlatformUtilsException_Name;
*XMLUni_fgRuntimeException_Name = *XML::Xercesc::XMLUni_fgRuntimeException_Name;
*XMLUni_fgTranscodingException_Name = *XML::Xercesc::XMLUni_fgTranscodingException_Name;
*XMLUni_fgUnexpectedEOFException_Name = *XML::Xercesc::XMLUni_fgUnexpectedEOFException_Name;
*XMLUni_fgUnsupportedEncodingException_Name = *XML::Xercesc::XMLUni_fgUnsupportedEncodingException_Name;
*XMLUni_fgUTFDataFormatException_Name = *XML::Xercesc::XMLUni_fgUTFDataFormatException_Name;
*XMLUni_fgNetAccessorException_Name = *XML::Xercesc::XMLUni_fgNetAccessorException_Name;
*XMLUni_fgMalformedURLException_Name = *XML::Xercesc::XMLUni_fgMalformedURLException_Name;
*XMLUni_fgNumberFormatException_Name = *XML::Xercesc::XMLUni_fgNumberFormatException_Name;
*XMLUni_fgParseException_Name = *XML::Xercesc::XMLUni_fgParseException_Name;
*XMLUni_fgInvalidDatatypeFacetException_Name = *XML::Xercesc::XMLUni_fgInvalidDatatypeFacetException_Name;
*XMLUni_fgInvalidDatatypeValueException_Name = *XML::Xercesc::XMLUni_fgInvalidDatatypeValueException_Name;
*XMLUni_fgSchemaDateTimeException_Name = *XML::Xercesc::XMLUni_fgSchemaDateTimeException_Name;
*XMLUni_fgXPathException_Name = *XML::Xercesc::XMLUni_fgXPathException_Name;
*XMLUni_fgNegINFString = *XML::Xercesc::XMLUni_fgNegINFString;
*XMLUni_fgNegZeroString = *XML::Xercesc::XMLUni_fgNegZeroString;
*XMLUni_fgPosZeroString = *XML::Xercesc::XMLUni_fgPosZeroString;
*XMLUni_fgPosINFString = *XML::Xercesc::XMLUni_fgPosINFString;
*XMLUni_fgNaNString = *XML::Xercesc::XMLUni_fgNaNString;
*XMLUni_fgEString = *XML::Xercesc::XMLUni_fgEString;
*XMLUni_fgZeroString = *XML::Xercesc::XMLUni_fgZeroString;
*XMLUni_fgNullString = *XML::Xercesc::XMLUni_fgNullString;
*XMLUni_fgXercesDynamic = *XML::Xercesc::XMLUni_fgXercesDynamic;
*XMLUni_fgXercesSchema = *XML::Xercesc::XMLUni_fgXercesSchema;
*XMLUni_fgXercesSchemaFullChecking = *XML::Xercesc::XMLUni_fgXercesSchemaFullChecking;
*XMLUni_fgXercesSchemaExternalSchemaLocation = *XML::Xercesc::XMLUni_fgXercesSchemaExternalSchemaLocation;
*XMLUni_fgXercesSchemaExternalNoNameSpaceSchemaLocation = *XML::Xercesc::XMLUni_fgXercesSchemaExternalNoNameSpaceSchemaLocation;
*XMLUni_fgXercesSecurityManager = *XML::Xercesc::XMLUni_fgXercesSecurityManager;
*XMLUni_fgXercesLoadExternalDTD = *XML::Xercesc::XMLUni_fgXercesLoadExternalDTD;
*XMLUni_fgXercesContinueAfterFatalError = *XML::Xercesc::XMLUni_fgXercesContinueAfterFatalError;
*XMLUni_fgXercesValidationErrorAsFatal = *XML::Xercesc::XMLUni_fgXercesValidationErrorAsFatal;
*XMLUni_fgXercesUserAdoptsDOMDocument = *XML::Xercesc::XMLUni_fgXercesUserAdoptsDOMDocument;
*XMLUni_fgXercesCacheGrammarFromParse = *XML::Xercesc::XMLUni_fgXercesCacheGrammarFromParse;
*XMLUni_fgXercesUseCachedGrammarInParse = *XML::Xercesc::XMLUni_fgXercesUseCachedGrammarInParse;
*XMLUni_fgXercesScannerName = *XML::Xercesc::XMLUni_fgXercesScannerName;
*XMLUni_fgXercesCalculateSrcOfs = *XML::Xercesc::XMLUni_fgXercesCalculateSrcOfs;
*XMLUni_fgXercesStandardUriConformant = *XML::Xercesc::XMLUni_fgXercesStandardUriConformant;
*XMLUni_fgSAX2CoreValidation = *XML::Xercesc::XMLUni_fgSAX2CoreValidation;
*XMLUni_fgSAX2CoreNameSpaces = *XML::Xercesc::XMLUni_fgSAX2CoreNameSpaces;
*XMLUni_fgSAX2CoreNameSpacePrefixes = *XML::Xercesc::XMLUni_fgSAX2CoreNameSpacePrefixes;
*XMLUni_fgDOMCanonicalForm = *XML::Xercesc::XMLUni_fgDOMCanonicalForm;
*XMLUni_fgDOMCDATASections = *XML::Xercesc::XMLUni_fgDOMCDATASections;
*XMLUni_fgDOMComments = *XML::Xercesc::XMLUni_fgDOMComments;
*XMLUni_fgDOMCharsetOverridesXMLEncoding = *XML::Xercesc::XMLUni_fgDOMCharsetOverridesXMLEncoding;
*XMLUni_fgDOMDatatypeNormalization = *XML::Xercesc::XMLUni_fgDOMDatatypeNormalization;
*XMLUni_fgDOMEntities = *XML::Xercesc::XMLUni_fgDOMEntities;
*XMLUni_fgDOMInfoset = *XML::Xercesc::XMLUni_fgDOMInfoset;
*XMLUni_fgDOMNamespaces = *XML::Xercesc::XMLUni_fgDOMNamespaces;
*XMLUni_fgDOMNamespaceDeclarations = *XML::Xercesc::XMLUni_fgDOMNamespaceDeclarations;
*XMLUni_fgDOMSupportedMediatypesOnly = *XML::Xercesc::XMLUni_fgDOMSupportedMediatypesOnly;
*XMLUni_fgDOMValidateIfSchema = *XML::Xercesc::XMLUni_fgDOMValidateIfSchema;
*XMLUni_fgDOMValidation = *XML::Xercesc::XMLUni_fgDOMValidation;
*XMLUni_fgDOMWhitespaceInElementContent = *XML::Xercesc::XMLUni_fgDOMWhitespaceInElementContent;
*XMLUni_fgDOMWRTCanonicalForm = *XML::Xercesc::XMLUni_fgDOMWRTCanonicalForm;
*XMLUni_fgDOMWRTDiscardDefaultContent = *XML::Xercesc::XMLUni_fgDOMWRTDiscardDefaultContent;
*XMLUni_fgDOMWRTEntities = *XML::Xercesc::XMLUni_fgDOMWRTEntities;
*XMLUni_fgDOMWRTFormatPrettyPrint = *XML::Xercesc::XMLUni_fgDOMWRTFormatPrettyPrint;
*XMLUni_fgDOMWRTNormalizeCharacters = *XML::Xercesc::XMLUni_fgDOMWRTNormalizeCharacters;
*XMLUni_fgDOMWRTSplitCdataSections = *XML::Xercesc::XMLUni_fgDOMWRTSplitCdataSections;
*XMLUni_fgDOMWRTValidation = *XML::Xercesc::XMLUni_fgDOMWRTValidation;
*XMLUni_fgDOMWRTWhitespaceInElementContent = *XML::Xercesc::XMLUni_fgDOMWRTWhitespaceInElementContent;
*XMLUni_fgDOMWRTBOM = *XML::Xercesc::XMLUni_fgDOMWRTBOM;
*XMLUni_fgXercescDefaultLocale = *XML::Xercesc::XMLUni_fgXercescDefaultLocale;
1;
