#!/usr/bin/perl -w
#
#    calendar.pl
#
#    $Id: calendar.pl,v 1.11 2002/06/30 04:22:21 bstell Exp $
#
#    Copyright (c) 2000 Brian Stell and James
#
#    This package is free software and is provided ``as is'' without
#    express or implied warranty. It may be used, redistributed and/or
#    modified under the terms of the Perl Artistic License
#    (see http://www.perl.com/perl/misc/Artistic.html)
#

require 5.6.0;
use strict;

use POSIX qw(locale_h errno);
use utf8;

use ExtUtils::testlib;

use ICU qw( U_ZERO_ERROR U_USING_DEFAULT_ERROR );
use ICU::Locale;
use ICU::TimeZone;
use ICU::DateFormat qw( :EStyle :EField);
use ICU::Calendar qw( :EDateFields :EDaysOfWeek :EMonths :EAmpm );
use ICU::Locale;
 
   print "Calendar class sample program\n\n";

#   ICU::DateFormat::setDebugLevel(155);
#   ICU::Calendar::setDebugLevel(155);

print "U_ZERO_ERROR = ", &U_ZERO_ERROR, "\n";
print "U_USING_DEFAULT_ERROR = ", &U_USING_DEFAULT_ERROR, "\n";

   my $s = ICU::U_SUCCESS(-1);
print "U_SUCCESS(-1) = ", $s, "\n";
print "U_SUCCESS( 1) = ", ICU::U_SUCCESS( 1), "\n";

#
# Make sure we always use the same fallback locale
#
my $default_locale = new ICU::Locale('en_US');
ICU::Locale->setDefault($default_locale);

   my $status = U_ZERO_ERROR;

   my $tz_pst = ICU::TimeZone->createTimeZone('PST');
   my $tz_est = ICU::TimeZone->createTimeZone('EST');
   ICU::TimeZone->setDefault($tz_pst);    

   my $cal = ICU::Calendar->createInstance(\$status);
   print "Calendar::createInstance status = $status\n";

   $cal->setTimeZone($tz_pst);
   my $tz = $cal->getTimeZone();
   print "tz=", $tz->getDisplayName,"\n";

   print "initializing calendar with 2001-07-02 23:56 PST\n";

   $cal->set(YEAR,2000);
   $cal->set(2001,7,2);
   $cal->set(2001,7,2,23,56);
   $cal->set(2001,7,2,23,56,3);

   print sprintf("%4d-%02d-%02d %02d:%02d PST\n",
                  $cal->get(YEAR,\$status),
                  $cal->get(MONTH,\$status),
                  $cal->get(DAY_OF_MONTH,\$status),
                  $cal->get(HOUR,\$status),
                  $cal->get(MINUTE,\$status));

   my $tm_end_pst = $cal->getTime(\$status);
   print "tm_end_pst after set = $tm_end_pst\n";

   $cal->setTimeZone($tz_est);
   my $tz2 = $cal->getTimeZone();
   print "tz2=", $tz2->getDisplayName,"\n";

   print sprintf("%4d-%02d-%02d %02d:%02d EST\n",
                  $cal->get(YEAR,\$status),
                  $cal->get(MONTH,\$status),
                  $cal->get(DAY_OF_MONTH,\$status),
                  $cal->get(HOUR,\$status),
                  $cal->get(MINUTE,\$status));

   my $tm_end_est = $cal->getTime(\$status);
   print "tm_end_est after set = $tm_end_est\n";

   $cal->clear();
