# Generated by default/object.tt
package Paws::SecurityHub::AwsApiGatewayMethodSettings;
  use Moose;
  has CacheDataEncrypted => (is => 'ro', isa => 'Bool');
  has CacheTtlInSeconds => (is => 'ro', isa => 'Int');
  has CachingEnabled => (is => 'ro', isa => 'Bool');
  has DataTraceEnabled => (is => 'ro', isa => 'Bool');
  has HttpMethod => (is => 'ro', isa => 'Str');
  has LoggingLevel => (is => 'ro', isa => 'Str');
  has MetricsEnabled => (is => 'ro', isa => 'Bool');
  has RequireAuthorizationForCacheControl => (is => 'ro', isa => 'Bool');
  has ResourcePath => (is => 'ro', isa => 'Str');
  has ThrottlingBurstLimit => (is => 'ro', isa => 'Int');
  has ThrottlingRateLimit => (is => 'ro', isa => 'Num');
  has UnauthorizedCacheControlHeaderStrategy => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsApiGatewayMethodSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsApiGatewayMethodSettings object:

  $service_obj->Method(Att1 => { CacheDataEncrypted => $value, ..., UnauthorizedCacheControlHeaderStrategy => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsApiGatewayMethodSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->CacheDataEncrypted

=head1 DESCRIPTION

Defines settings for a method for the stage.

=head1 ATTRIBUTES


=head2 CacheDataEncrypted => Bool

Indicates whether the cached responses are encrypted.


=head2 CacheTtlInSeconds => Int

Specifies the time to live (TTL), in seconds, for cached responses. The
higher the TTL, the longer the response is cached.


=head2 CachingEnabled => Bool

Indicates whether responses are cached and returned for requests. For
responses to be cached, a cache cluster must be enabled on the stage.


=head2 DataTraceEnabled => Bool

Indicates whether data trace logging is enabled for the method. Data
trace logging affects the log entries that are pushed to CloudWatch
Logs.


=head2 HttpMethod => Str

The HTTP method. You can use an asterisk (*) as a wildcard to apply
method settings to multiple methods.


=head2 LoggingLevel => Str

The logging level for this method. The logging level affects the log
entries that are pushed to CloudWatch Logs.

If the logging level is C<ERROR>, then the logs only include
error-level entries.

If the logging level is C<INFO>, then the logs include both C<ERROR>
events and extra informational events.

Valid values: C<OFF> | C<ERROR> | C<INFO>


=head2 MetricsEnabled => Bool

Indicates whether CloudWatch metrics are enabled for the method.


=head2 RequireAuthorizationForCacheControl => Bool

Indicates whether authorization is required for a cache invalidation
request.


=head2 ResourcePath => Str

The resource path for this method. Forward slashes (/) are encoded as
~1 . The initial slash must include a forward slash.

For example, the path value C</resource/subresource> must be encoded as
C</~1resource~1subresource>.

To specify the root path, use only a slash (/). You can use an asterisk
(*) as a wildcard to apply method settings to multiple methods.


=head2 ThrottlingBurstLimit => Int

The throttling burst limit for the method.


=head2 ThrottlingRateLimit => Num

The throttling rate limit for the method.


=head2 UnauthorizedCacheControlHeaderStrategy => Str

Indicates how to handle unauthorized requests for cache invalidation.

Valid values: C<FAIL_WITH_403> | C<SUCCEED_WITH_RESPONSE_HEADER> |
C<SUCCEED_WITHOUT_RESPONSE_HEADER>



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

