# Generated by default/object.tt
package Paws::CloudFormation::TypeVersionSummary;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str');
  has Description => (is => 'ro', isa => 'Str');
  has IsDefaultVersion => (is => 'ro', isa => 'Bool');
  has PublicVersionNumber => (is => 'ro', isa => 'Str');
  has TimeCreated => (is => 'ro', isa => 'Str');
  has Type => (is => 'ro', isa => 'Str');
  has TypeName => (is => 'ro', isa => 'Str');
  has VersionId => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFormation::TypeVersionSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFormation::TypeVersionSummary object:

  $service_obj->Method(Att1 => { Arn => $value, ..., VersionId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFormation::TypeVersionSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Contains summary information about a specific version of a
CloudFormation extension.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the extension version.


=head2 Description => Str

The description of the extension version.


=head2 IsDefaultVersion => Bool

Whether the specified extension version is set as the default version.

This applies only to private extensions you have registered in your
account, and extensions published by Amazon. For public third-party
extensions, whether or not they are activated in your account,
CloudFormation returns C<null>.


=head2 PublicVersionNumber => Str

For public extensions that have been activated for this account and
region, the version of the public extension to be used for
CloudFormation operations in this account and region. For any
extensions other than activated third-arty extensions, CloudFormation
returns C<null>.

How you specified C<AutoUpdate> when enabling the extension affects
whether CloudFormation automatically updates the extention in this
account and region when a new version is released. For more
information, see Setting CloudFormation to automatically use new
versions of extensions
(https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-public.html#registry-public-enable-auto)
in the I<CloudFormation User Guide>.


=head2 TimeCreated => Str

When the version was registered.


=head2 Type => Str

The kind of extension.


=head2 TypeName => Str

The name of the extension.


=head2 VersionId => Str

The ID of a specific version of the extension. The version ID is the
value at the end of the Amazon Resource Name (ARN) assigned to the
extension version when it is registered.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFormation>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

