# Generated by default/object.tt
package Paws::LexModelsV2::IntentSummary;
  use Moose;
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has InputContexts => (is => 'ro', isa => 'ArrayRef[Paws::LexModelsV2::InputContext]', request_name => 'inputContexts', traits => ['NameInRequest']);
  has IntentId => (is => 'ro', isa => 'Str', request_name => 'intentId', traits => ['NameInRequest']);
  has IntentName => (is => 'ro', isa => 'Str', request_name => 'intentName', traits => ['NameInRequest']);
  has LastUpdatedDateTime => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedDateTime', traits => ['NameInRequest']);
  has OutputContexts => (is => 'ro', isa => 'ArrayRef[Paws::LexModelsV2::OutputContext]', request_name => 'outputContexts', traits => ['NameInRequest']);
  has ParentIntentSignature => (is => 'ro', isa => 'Str', request_name => 'parentIntentSignature', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::IntentSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::IntentSummary object:

  $service_obj->Method(Att1 => { Description => $value, ..., ParentIntentSignature => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::IntentSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Description

=head1 DESCRIPTION

Summary information about an intent returned by the C<ListIntents>
operation.

=head1 ATTRIBUTES


=head2 Description => Str

The description of the intent.


=head2 InputContexts => ArrayRef[L<Paws::LexModelsV2::InputContext>]

The input contexts that must be active for this intent to be considered
for recognition.


=head2 IntentId => Str

The unique identifier assigned to the intent. Use this ID to get
detailed information about the intent with the C<DescribeIntent>
operation.


=head2 IntentName => Str

The name of the intent.


=head2 LastUpdatedDateTime => Str

The timestamp of the date and time that the intent was last updated.


=head2 OutputContexts => ArrayRef[L<Paws::LexModelsV2::OutputContext>]

The output contexts that are activated when this intent is fulfilled.


=head2 ParentIntentSignature => Str

If this intent is derived from a built-in intent, the name of the
parent intent.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

