# Generated by default/object.tt
package Paws::SecurityHub::AwsApiGatewayV2ApiDetails;
  use Moose;
  has ApiEndpoint => (is => 'ro', isa => 'Str');
  has ApiId => (is => 'ro', isa => 'Str');
  has ApiKeySelectionExpression => (is => 'ro', isa => 'Str');
  has CorsConfiguration => (is => 'ro', isa => 'Paws::SecurityHub::AwsCorsConfiguration');
  has CreatedDate => (is => 'ro', isa => 'Str');
  has Description => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str');
  has ProtocolType => (is => 'ro', isa => 'Str');
  has RouteSelectionExpression => (is => 'ro', isa => 'Str');
  has Version => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsApiGatewayV2ApiDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsApiGatewayV2ApiDetails object:

  $service_obj->Method(Att1 => { ApiEndpoint => $value, ..., Version => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsApiGatewayV2ApiDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->ApiEndpoint

=head1 DESCRIPTION

Contains information about a version 2 API in Amazon API Gateway.

=head1 ATTRIBUTES


=head2 ApiEndpoint => Str

The URI of the API.

Uses the format C<
I<E<lt>api-idE<gt>>.execute-api.I<E<lt>regionE<gt>>.amazonaws.com>

The stage name is typically appended to the URI to form a complete path
to a deployed API stage.


=head2 ApiId => Str

The identifier of the API.


=head2 ApiKeySelectionExpression => Str

An API key selection expression. Supported only for WebSocket APIs.


=head2 CorsConfiguration => L<Paws::SecurityHub::AwsCorsConfiguration>

A cross-origin resource sharing (CORS) configuration. Supported only
for HTTP APIs.


=head2 CreatedDate => Str

Indicates when the API was created.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 Description => Str

A description of the API.


=head2 Name => Str

The name of the API.


=head2 ProtocolType => Str

The API protocol for the API.

Valid values: C<WEBSOCKET> | C<HTTP>


=head2 RouteSelectionExpression => Str

The route selection expression for the API.

For HTTP APIs, must be C<${request.method} ${request.path}>. This is
the default value for HTTP APIs.

For WebSocket APIs, there is no default value.


=head2 Version => Str

The version identifier for the API.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

