# Generated by default/object.tt
package Paws::SecurityHub::AwsIamRoleDetails;
  use Moose;
  has AssumeRolePolicyDocument => (is => 'ro', isa => 'Str');
  has AttachedManagedPolicies => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsIamAttachedManagedPolicy]');
  has CreateDate => (is => 'ro', isa => 'Str');
  has InstanceProfileList => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsIamInstanceProfile]');
  has MaxSessionDuration => (is => 'ro', isa => 'Int');
  has Path => (is => 'ro', isa => 'Str');
  has PermissionsBoundary => (is => 'ro', isa => 'Paws::SecurityHub::AwsIamPermissionsBoundary');
  has RoleId => (is => 'ro', isa => 'Str');
  has RoleName => (is => 'ro', isa => 'Str');
  has RolePolicyList => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsIamRolePolicy]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsIamRoleDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsIamRoleDetails object:

  $service_obj->Method(Att1 => { AssumeRolePolicyDocument => $value, ..., RolePolicyList => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsIamRoleDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->AssumeRolePolicyDocument

=head1 DESCRIPTION

Contains information about an IAM role, including all of the role's
policies.

=head1 ATTRIBUTES


=head2 AssumeRolePolicyDocument => Str

The trust policy that grants permission to assume the role.


=head2 AttachedManagedPolicies => ArrayRef[L<Paws::SecurityHub::AwsIamAttachedManagedPolicy>]

The list of the managed policies that are attached to the role.


=head2 CreateDate => Str

Indicates when the role was created.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 InstanceProfileList => ArrayRef[L<Paws::SecurityHub::AwsIamInstanceProfile>]

The list of instance profiles that contain this role.


=head2 MaxSessionDuration => Int

The maximum session duration (in seconds) that you want to set for the
specified role.


=head2 Path => Str

The path to the role.


=head2 PermissionsBoundary => L<Paws::SecurityHub::AwsIamPermissionsBoundary>




=head2 RoleId => Str

The stable and unique string identifying the role.


=head2 RoleName => Str

The friendly name that identifies the role.


=head2 RolePolicyList => ArrayRef[L<Paws::SecurityHub::AwsIamRolePolicy>]

The list of inline policies that are embedded in the role.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

