package Date::Namedays::Simple::Hungarian;
use strict;
use bytes;	# we are in ISO-8859-2 !

use base 'Date::Namedays::Simple';

sub processNames {
	my $self = shift;

	return <<__THIS__;
1.1.Fruzsina
1.2.bel
1.3.Genovva,Benjmin
1.4.Titusz,Leona
1.5.Simon
1.6.Boldizsr
1.7.Attila,Ramna
1.8.Gyngyvr
1.9.Marcell
1.10.Melnia
1.11.gota
1.12.Ern
1.13.Veronika
1.14.Bdog
1.15.Lrnt,Lornd
1.16.Gusztv
1.17.Antal,Antnia
1.18.Piroska
1.19.Sra,Mri
1.20.Fbin,Sebestyn
1.21.gnes
1.22.Vince,Artr
1.23.Zelma,Rajmund
1.24.Timt
1.25.Pl
1.26.Vanda,Paula
1.27.Angelika
1.28.Kroly,Karola
1.29.Adl
1.30.Martina,Gerda
1.31.Marcella
2.1.Ignc
2.2.Karolina,Aida
2.3.Balzs
2.4.Rhel,Csenge
2.5.gota,Ingrid
2.6.Dorottya,Dra
2.7.Tdor,Rme
2.8.Aranka
2.9.Abigl,Alex
2.10.Elvira
2.11.Bertold,Marietta
2.12.Ldia,Lvia
2.13.Ella,Linda
2.14.Blint,Valentin
2.15.Kolos,Georgina
2.16.Julianna,Lilla
2.17.Dont
2.18.Bernadett
2.19.Zsuzsanna
2.20.Aladr,lmos
2.21.Elenonra
2.22.Gerzson
2.23.Alfrd
2.24.Mtys
2.25.Gza
2.26.Edina
2.27.kos,Btor
2.28.Elemr
2.29.Szknap
3.1.Albin
3.2.Lujza
3.3.Kornlia
3.4.Kzmr
3.5.Adorjn,Adrin
3.6.Leonra,Inez
3.7.Tams
3.8.Zoltn
3.9.Franciska,Fanni
3.10.Ildik
3.11.Szilrd
3.12.Gergely
3.13.Krisztin,Ajtony
3.14.Matild
3.15.Kristf
3.16.Henrietta
3.17.Gertrd
3.18.Sndor,Ede
3.19.Jzsef,Bnk
3.20.Klaudia
3.21.Benedek
3.22.Beta,Izolda
3.23.Emke
3.24.Gbor,Karina
3.25.Irn,risz
3.26.Emnuel
3.27.Hajnalka
3.28.Gedeon,Johanna
3.29.Auguszta
3.30.Zaln
3.31.rpd
4.1.Hug
4.2.ron
4.3.Buda,Richrd
4.4.Izidor
4.5.Vince
4.6.Vilmos,Bborka
4.7.Herman
4.8.Dnes
4.9.Erhard
4.10.Zsolt
4.11.Le,Szaniszl
4.12.Gyula
4.13.Ida
4.14.Tibor
4.15.Anasztzia,Tas
4.16.Csongor
4.17.Rudolf
4.18.Andrea,Ilma
4.19.Emma
4.20.Tivadar
4.21.Konrd
4.22.Csilla,Nomi
4.23.Bla
4.24.Gyrgy
4.25.Mrk
4.26.Ervin
4.27.Zita
4.28.Valria
4.29.Pter
4.30.Katalin,Kitti
5.1.Flp,Jakab
5.2.Zsigmond
5.3.Tmea,Irma
5.4.Mnika,Flrin
5.5.Gyryi
5.6.Ivett,Frida
5.7.Gizella
5.8.Mihly
5.9.Gergely
5.10.rmin,Plma
5.11.Ferenc
5.12.Pongrc
5.13.Szervc,Imola
5.14.Bonifc
5.15.Zsfia,Szonja
5.16.Mzes,Botond
5.17.Paszkl
5.18.Erik,Alexandra
5.19.Iv,Miln
5.20.Bernt,Felcia
5.21.Konstantin
5.22.Jlia,Rita
5.23.Dezs
5.24.Eszter,Eliza
5.25.Orbn
5.26.Flp,Evelin
5.27.Hella
5.28.Emil,Csand
5.29.Magdolna
5.30.Janka,Zsanett
5.31.Angla,Petronella
6.1.Tnde
6.2.Krmen,Anita
6.3.Klotild
6.4.Bulcs
6.5.Fatime
6.6.Norbert,Cintia
6.7.Rbert
6.8.Medrd
6.9.Flix
6.10.Margit,Grta
6.11.Barnabs
6.12.Vill
6.13.Antal,Anett
6.14.Vazul
6.15.Joln,Vid
6.16.Jusztin
6.17.Laura,Alida
6.18.Arnold,Levente
6.19.Gyrfs
6.20.Rafael
6.21.Alajos,Leila
6.22.Paulina
6.23.Zoltn
6.24.Ivn
6.25.Vilmos
6.26.Jnos,Pl
6.27.Lszl
6.28.Levente,Irn
6.29.Pter,Pl
6.30.Pl
7.1.Tihamr,Annamria
7.2.Ott
7.3.Kornl,Soma
7.4.Ulrik
7.5.Emese,Sarolta
7.6.Csaba
7.7.Apollnia
7.8.Ellk
7.9.Lukrcia
7.10.Amlia
7.11.Nra,Lili
7.12.Izabella,Dalma
7.13.Jen
7.14.rs,Stella
7.15.Henrik,Roland
7.16.Valter
7.17.Endre,Elek
7.18.Frigyes
7.19.Emlia
7.20.Ills
7.21.Dniel,Daniella
7.22.Magdolna
7.23.Lenke
7.24.Kinga,Kincs
7.25.Kristf,Jakab
7.26.Anna,Anik
7.27.Olga,Lilina
7.28.Szabolcs
7.29.Mrta,Flra
7.30.Judit,Xnia
7.31.Oszkr
8.1.Boglrka
8.2.Lehel
8.3.Hermina
8.4.Domonkos,Dominika
8.5.Krisztina
8.6.Berta,Bettina
8.7.Ibolya
8.8.Lszl
8.9.Emd
8.10.Lrinc
8.11.Zsuzsanna,Tiborc
8.12.Klra
8.13.Ipoly
8.14.Marcell
8.15.Mria
8.16.brahm
8.17.Jcint
8.18.Ilona
8.19.Huba
8.20.Szt.Istvn
8.21.Smuel,Hajna
8.22.Menyhrt,Mirjam
8.23.Bence
8.24.Bertalan
8.25.Lajos,Patrcia
8.26.Izs
8.27.Gspr
8.28.goston
8.29.Beatrix,Erna
8.30.Rzsa
8.31.Erika,Bella
9.1.Egyed,Egon
9.2.Rebeka,Dorina
9.3.Hilda
9.4.Rozlia
9.5.Viktor,Lrinc
9.6.Zakaris
9.7.Regina
9.8.Mria,Adrienn
9.9.dm
9.10.Nikolett,Hunor
9.11.Teodra
9.12.Mria
9.13.Kornl
9.14.Szerna,Roxna
9.15.Enik,Melitta
9.16.Edit
9.17.Zsfia
9.18.Dina
9.19.Vilhelmina
9.20.Friderika
9.21.Mt,Mirella
9.22.Mric
9.23.Tekla
9.24.Gellrt,Mercdesz
9.25.Eufrozina,Kende
9.26.Jusztina
9.27.Adalbert
9.28.Vencel
9.29.Mihly
9.30.Jeromos
10.1.Malvin
10.2.Petra
10.3.Helga
10.4.Ferenc
10.5.Aurl
10.6.Brn,Renta
10.7.Amlia
10.8.Koppny
10.9.Dnes
10.10.Gedeon
10.11.Brigitta,Gitta
10.12.Miksa
10.13.Klmn,Ede
10.14.Heln
10.15.Terz
10.16.Gl
10.17.Hedvig
10.18.Lukcs
10.19.Nndor
10.20.Vendel
10.21.Orsolya
10.22.Eld
10.23.Gyngyi
10.24.Salamon
10.25.Blanka,Bianka
10.26.Dmtr
10.27.Szabina
10.28.Simon,Szimonetta
10.29.Nrcisz
10.30.Alfonz
10.31.Farkas
11.1.Marianna
11.2.Achilles
11.3.Gyz
11.4.Kroly
11.5.Imre
11.6.Lnrd
11.7.Rezs
11.8.Zsombor
11.9.Tivadar
11.10.Rka
11.11.Mrton
11.12.Jns,Rent
11.13.Szilvia
11.14.Aliz
11.15.Albert,Lipt
11.16.dn
11.17.Hortenzia,Gerg
11.18.Jen
11.19.Erzsbet
11.20.Joln
11.21.Olivr
11.22.Ceclia
11.23.Kelemen,Klementina
11.24.Emma
11.25.Katalin
11.26.Virg
11.27.Virgil
11.28.Stefnia
11.29.Taksony
11.30.Andrs,Andor
12.1.Elza
12.2.Melinda,Vivien
12.3.Ferenc,Olvia
12.4.Borbla,Barbara
12.5.Vilma
12.6.Mikls
12.7.Ambrus
12.8.Mria
12.9.Natlia
12.10.Judit
12.11.rpd
12.12.Gabriella
12.13.Luca,Otlia
12.14.Szilrda
12.15.Valr
12.16.Etelka,Aletta
12.17.Lzr,Olimpia
12.18.Auguszta
12.19.Viola
12.20.Teofil
12.21.Tams
12.22.Zn
12.23.Viktria
12.24.dm,va
12.25.Karcsony,Eugnia
12.26.Karcsony,Istvn
12.27.Jnos
12.28.Kamilla
12.29.Tams,Tamara
12.30.Dvid
12.31.Szilveszter
__THIS__
}

##################################################################
# We used to have this, but now I commented it out. It was insane
# anyways! See the POD for more info.
##################################################################
#sub leapYear {
#	my ($self, $month, $day) = @_;
#
#	if ($day == 24) {
#		return ($month,29);		# "leap year day"
#        } elsif ($day > 24) {
#                return ($month,$day-1);
#        }
#
#	return ($month, $day);		# do not change otherwise	
#}

########################################### main pod documentation begin ##

=head1 NAME

Date::Namedays::Simple::Hungarian - Simple nameday handling class for Hungarian namedays.

=head1 SYNOPSIS

For usage, please see: Date::Namedays::Simple !!

=head1 DESCRIPTION

This is a subclass of Date::Namedays::Simple. This module only provides 
a list of Hungarian namedays. See Date::Namedays::Simple for usage and
examples!

Please see the "BUGS" section also!


=head1 USAGE

See: Date::Namedays::Simple.

=head1 BUGS

According to some calendars, in case of leapyears, 24th of February becomes 
"LeapYear" ("Szknap" in Hungarian), while other names shift. Some other
calendars denote the 29th of February the as "LeapYear", and to not shift.

The first implementation shifted the namedays - then I though this is 
totally insane, so now I have that commented out, and use the second 
approach.

Send bugreports!

=head1 SUPPORT

Send an e-mail to the author. Only concerning this particular module,
please! Comments are also welcome!

=head1 AUTHOR

	Csongor Fagyal
	co-NOSPAM-ncept@conceptonline.hu
	http://www.conceptonline.com/

=head1 COPYRIGHT

This program is free software; you can redistribute
it and/or modify it under the same terms as Perl itself.

The full text of the license can be found in the
LICENSE file included with this module.


=head1 SEE ALSO

perl(1).

=cut


1;
__END__


