package Rope::Object;

use strict;
use warnings;

sub TIEHASH {
        my ($class, $obj) = @_;
        my $self = $obj || {};
        bless $self, $class;
}
 
sub STORE {
        my ($self, $key, $value) = @_;
        my $k = $self->{properties}->{$key};
        if ($k) {
		if ($k->{writable}) {
                	$k->{value} = $value;
		} elsif ($k->{configurable}) {
			if ((ref($value) || "") eq (ref($k->{value}) || "")) {
				$k->{value} = $value;
			} else {
				die "Cannot change Object ($self->{name}) property ($key) type";
			}
		} else {
			die "Cannot set Object ($self->{name}) property ($key) it is only readable";
		}
        } elsif (! $self->{locked}) {
                $self->{properties}->{$key} = {
                        value => $value,
			writable => 1,
			configurable => 1,
			enumerable => 1
                };
        } else {
		die "Object ($self->{name}) is locked you cannot extend with new properties";
	}
        return $self;
}
 
sub FETCH {
        my ($self, $key) = @_;
        my $k = $self->{properties}->{$key};
        return $k ? $k->{value} : undef;
}
 
sub FIRSTKEY {
        my ($key, $value) = each %{$_[0]->{properties}};
	if ($key && !$_[0]->{properties}->{$key}->{enumerable}) {
		return &NEXTKEY;
	}
	return $key;
}
 
sub NEXTKEY { 
        my ($key, $value) = each %{$_[0]->{properties}};
	if ($key && !$_[0]->{properties}->{$key}->{enumerable}) {
		return &NEXTKEY;
	}
	return $key;
}
 
sub EXISTS {
       	exists $_[0]->{properties}->{$_[1]};
}
 
sub DELETE { 
        my $k = $_[0]->{properties}->{$_[1]};
        !$_[0]->{locked} && $k->{writeable} ? delete $_[0]->{properties}->{$_[1]} : undef;
}
 
sub CLEAR {
	return;
        #%{$_[0]->{properties}} = () 
}
 
sub SCALAR { 
        scalar keys %{$_[0]->{properties}}
}

1;

__END__ 
