package WordList::Char::ZH::HSK;

our $DATE = '2016-02-04'; # DATE
our $VERSION = '0.01'; # VERSION

use utf8;

use WordList;
our @ISA = qw(WordList);

our %STATS = ("shortest_word_len",1,"longest_word_len",1,"avg_word_len",1,"num_words_contains_nonword_chars",0,"num_words_contains_whitespace",0,"num_words_contains_unicode",2660,"num_words",2660); # STATS

1;
# ABSTRACT: HSK (levels 1-6) characters

=pod

=encoding UTF-8

=head1 NAME

WordList::Char::ZH::HSK - HSK (levels 1-6) characters

=head1 VERSION

This document describes version 0.01 of WordList::Char::ZH::HSK (from Perl distribution WordList-ZH-HSK), released on 2016-02-04.

=head1 SYNOPSIS

 use WordList::Char::ZH::HSK;

 my $wl = WordList::Char::ZH::HSK->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

This is the list of characters for the Hanyu Shuiping Kaoshi (Chinese
Proficiency Test), as of September 2012, sorted alphabetically.

For per-level characters, see: L<WordList::Char::ZH::HSK1> to
L<WordList::Char::ZH::HSK6>.

For list of words, see L<WordList::ZH::HSK>.

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 1     |
 | longest_word_len                 | 1     |
 | num_words                        | 2660  |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 2660  |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 1     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordList-ZH-HSK>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordList-ZH-HSK>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordList-ZH-HSK>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

Hanban which administers the test and publishes the list,
L<http://chinesetest.cn>

About HSK, L<https://en.wikipedia.org/wiki/Hanyu_Shuiping_Kaoshi>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
一
丁
七
万
丈
三
上
下
不
与
丐
丑
专
且
世
丘
丙
业
丛
东
丝
丢
两
严
丧
个
中
丰
串
临
丸
为
主
丽
举
久
么
义
之
乌
乎
乏
乐
乒
乓
乖
乘
乙
九
乞
也
习
乡
书
买
乱
乳
了
予
争
事
二
于
亏
云
互
五
井
亚
些
亡
交
亦
产
享
京
亭
亮
亲
人
亿
什
仁
仅
仇
今
介
仍
从
仓
仔
他
仗
付
仙
代
令
以
仪
们
仰
件
价
任
份
仿
企
伍
伏
伐
休
众
优
伙
会
伞
伟
传
伤
伦
伪
伯
估
伴
伶
伸
伺
似
但
位
低
住
体
何
余
佛
作
你
佣
佩
佳
使
侃
侄
侈
例
供
依
侠
侣
侥
侦
侧
侨
侮
侵
便
促
俊
俐
俗
俘
保
信
俩
俭
修
俯
俱
倍
倒
倔
倘
候
借
倡
倦
债
值
倾
假
偏
做
停
健
偶
偷
偿
傅
傍
储
催
傲
傻
像
僵
僻
儒
儿
允
元
兄
充
兆
先
光
克
免
兑
兔
党
兜
兢
入
全
八
公
六
共
关
兴
兵
其
具
典
养
兼
兽
内
册
再
冒
写
军
农
冠
冤
冬
冰
冲
决
况
冷
冻
净
凄
准
凉
凌
减
凑
凝
几
凡
凭
凶
凸
凹
出
击
刀
分
切
刊
刑
划
列
则
刚
创
初
删
判
利
别
刮
到
制
刷
券
刹
刺
刻
剂
削
前
剑
剔
剖
剥
剧
剩
剪
副
割
劈
力
劝
办
功
加
务
劣
动
助
努
劫
励
劲
劳
势
勃
勇
勉
勘
勤
勺
勾
勿
匀
包
匆
化
北
匙
匹
区
医
十
千
升
午
半
华
协
卑
卓
单
卖
南
博
占
卡
卧
卫
印
危
即
却
卷
卸
厂
厅
历
厉
压
厌
厕
厘
厚
原
厢
厦
厨
去
县
参
又
叉
及
友
双
反
发
叔
取
受
变
叙
叛
叠
口
古
句
另
叨
只
叫
召
叭
叮
可
台
史
右
叶
号
司
叹
叼
吁
吃
各
合
吉
吊
同
名
后
吐
向
吓
吗
君
吝
吞
吟
否
吧
吨
吩
含
听
启
吵
吸
吹
吻
吼
呀
呆
呈
告
呕
员
呢
周
味
呵
呻
呼
命
咀
咋
和
咐
咖
咙
咨
咬
咱
咳
咸
咽
哀
品
哄
哆
哇
哈
响
哑
哗
哥
哦
哨
哪
哭
哲
哺
哼
唆
唇
唉
唐
唠
唤
售
唯
唱
唾
啃
商
啊
啡
啤
啥
啦
啬
啰
啸
喂
善
喇
喉
喊
喘
喜
喝
喧
喷
喻
嗅
嗓
嗦
嗨
嗯
嗽
嘈
嘉
嘛
嘱
嘲
嘴
嘿
器
噪
嚏
嚷
嚼
四
回
因
团
园
困
围
固
国
图
圆
圈
土
圣
在
地
场
圾
址
均
坏
坐
坑
块
坚
坛
坝
坟
坠
坡
坦
垂
垃
垄
型
垫
埋
城
域
培
基
堂
堆
堕
堡
堤
堪
堵
塌
塑
塔
塘
塞
填
境
墅
墓
墙
增
墟
墨
壁
壤
士
壮
声
壳
壶
处
备
复
夏
夕
外
多
夜
够
大
天
太
夫
央
失
头
夸
夹
夺
奇
奈
奉
奋
奏
奔
奖
套
奠
奢
奥
女
奴
奶
她
好
如
妄
妆
妇
妈
妒
妙
妥
妨
妹
妻
姆
始
姐
姑
姓
委
姥
姨
姻
姿
威
娃
娇
娘
娱
娶
婆
婚
婪
婴
媒
媳
嫁
嫂
嫉
嫌
嫩
子
孔
孕
字
存
孙
孝
季
孤
学
孩
宁
它
宅
宇
守
安
完
宏
宗
官
宙
定
宜
宝
实
宠
审
客
宣
室
宪
宫
宰
害
宴
宵
家
容
宽
宾
宿
寂
寄
密
富
寒
寓
寝
寞
察
寸
对
寺
寻
导
寿
封
射
将
尊
小
少
尔
尖
尘
尚
尝
尤
尬
就
尴
尸
尺
尽
尾
局
屁
层
居
屈
屉
届
屋
屏
屑
展
属
屡
履
山
屿
岁
岂
岔
岗
岛
岩
岳
岸
峡
峭
峰
峻
崇
崖
崩
崭
嵌
川
州
巡
巢
工
左
巧
巨
巩
差
己
已
巴
巷
巾
币
市
布
帅
帆
师
希
帐
帖
帘
帜
帝
带
席
帮
常
帽
幅
幕
幢
干
平
年
并
幸
幻
幼
幽
广
庄
庆
庇
床
序
库
应
底
店
庙
府
庞
废
度
座
庭
康
庸
廉
廊
廓
延
建
开
异
弃
弄
弊
式
引
弟
张
弥
弦
弯
弱
弹
强
归
当
录
形
彩
彰
影
役
彻
彼
往
征
径
待
很
徊
律
徒
得
徘
徙
御
循
微
德
心
必
忆
忌
忍
志
忘
忙
忠
忧
快
念
忽
怀
态
怎
怒
怕
怖
怜
思
怠
急
性
怨
怪
怯
总
恋
恍
恐
恒
恕
恢
恨
恩
恭
息
恰
恳
恶
恼
悄
悉
悔
悟
悠
患
悦
您
悬
悲
悼
情
惊
惋
惑
惕
惜
惠
惦
惧
惨
惩
惫
惭
惮
惯
惰
想
惹
愁
愈
愉
意
愚
感
愣
愤
愧
愿
慈
慌
慎
慕
慢
慧
慨
慰
慷
憋
憾
懂
懒
戏
成
我
戒
或
战
戚
截
戴
户
房
所
扁
扇
手
才
扎
扑
扒
打
扔
托
扛
扣
执
扩
扫
扬
扭
扮
扯
扰
扶
批
找
承
技
抄
把
抑
抒
抓
投
抖
抗
折
抚
抛
抢
护
报
披
抬
抱
抵
抹
押
抽
拄
担
拆
拉
拌
拍
拐
拒
拓
拔
拖
拘
拙
招
拜
拟
拢
拣
拥
拦
拧
拨
择
括
拳
拼
拽
拾
拿
持
挂
指
按
挎
挑
挖
挚
挠
挡
挣
挤
挥
挪
挫
振
挺
挽
捆
捉
捍
捎
捏
捐
捕
捞
损
捡
换
捣
捧
据
捷
掀
授
掉
掌
掏
掐
排
掘
掠
探
接
控
推
掩
措
掰
掷
揉
揍
描
提
插
握
揭
援
搀
搁
搂
搅
搏
搓
搜
搞
搬
搭
携
摄
摆
摇
摊
摔
摘
摧
摩
摸
撇
撑
撒
撕
撞
撤
播
撼
擅
操
擎
擦
攀
攒
支
收
改
攻
放
政
故
效
敌
敏
救
教
敞
敢
散
敬
数
敲
整
敷
文
斑
斗
料
斜
斟
斤
斥
斩
断
斯
新
方
施
旁
旅
旋
族
旗
无
既
日
旦
旧
旨
早
旬
旱
时
旷
旺
昂
昆
昌
明
昏
易
昔
星
映
春
昧
昨
是
昼
显
晃
晋
晒
晓
晕
晚
晤
晨
普
景
晰
晴
晶
智
晾
暂
暄
暑
暖
暗
暧
暴
曝
曲
更
曾
替
最
月
有
朋
服
朗
望
朝
期
木
未
末
本
术
朴
朵
机
朽
杀
杂
权
杆
李
材
村
杖
杜
束
杠
条
来
杯
杰
松
板
极
构
枉
析
枕
林
枚
果
枝
枪
枯
架
某
染
柔
柜
查
柬
柱
柴
柿
标
栋
栏
树
校
株
样
核
根
格
栽
桃
框
案
桌
桑
桔
档
桥
桨
桶
梁
梢
梦
梨
梯
械
梳
检
棉
棋
棍
棒
棕
森
棵
椅
植
椎
椒
椭
楚
楼
概
榜
榨
模
横
橙
橡
欠
次
欢
欣
欧
欲
欺
款
歇
歉
歌
止
正
此
步
武
歧
歪
歹
死
殃
殊
残
殖
殴
段
殿
毁
毅
母
每
毒
比
毕
毛
毫
毯
氏
民
氓
气
氛
氧
水
永
汁
求
汇
汉
汗
江
池
污
汤
汰
汹
汽
沃
沉
沐
沙
沛
沟
没
沧
沫
沮
河
沸
油
治
沼
沾
沿
泄
泉
泊
泌
法
泛
泡
波
泣
泥
注
泪
泰
泳
泻
泼
泽
洁
洋
洒
洗
洞
津
洪
洲
活
洽
派
流
浅
浇
浊
测
济
浏
浑
浓
浪
浮
浴
海
浸
涂
消
涉
涌
涕
涛
润
涨
涩
涮
液
涵
淀
淆
淋
淘
淡
深
混
淹
添
清
渐
渔
渗
渠
渡
渣
温
港
渴
游
渺
湖
湾
湿
溃
溅
溉
源
溜
溪
溶
滋
滑
滔
滚
滞
满
滤
滥
滨
滩
滴
漂
漆
漏
演
漠
漫
潇
潜
潮
澄
澈
澡
激
濒
瀑
灌
火
灭
灯
灰
灵
灶
灾
灿
炉
炊
炎
炒
炫
炭
炮
炸
点
炼
烁
烂
烈
烘
烛
烟
烤
烦
烧
烫
热
烹
焦
焰
然
煌
煎
煤
照
煮
熄
熊
熏
熟
熨
熬
燃
燥
爆
爬
爱
父
爷
爸
爽
片
版
牌
牙
牛
牢
牧
物
牲
牵
特
牺
犬
犯
状
犹
狂
狈
狗
狠
狡
独
狭
狮
狱
狼
猎
猛
猜
猪
猫
献
猴
猾
率
玉
王
玩
环
现
玻
珍
珠
班
球
理
琢
琴
璃
瓜
瓣
瓦
瓶
瓷
甘
甚
甜
生
用
甩
甭
田
由
甲
申
电
男
画
畅
界
畏
畔
留
畜
略
番
畴
疆
疏
疑
疗
疙
疤
疫
疯
疲
疼
疾
病
症
痒
痕
痛
痪
痹
瘤
瘦
瘩
瘫
瘸
瘾
癌
登
白
百
皂
的
皆
皇
皮
皱
盆
盈
益
盐
监
盒
盖
盗
盘
盛
盟
目
盯
盲
直
相
盼
盾
省
眉
看
真
眠
眨
眯
眶
眼
着
睁
睛
睡
督
睦
睬
睹
瞄
瞎
瞒
瞧
瞩
瞪
瞬
瞻
矛
知
矩
短
矮
石
矿
码
砍
研
砖
破
砸
础
硕
硬
确
碌
碍
碎
碑
碗
碰
碳
磁
磅
磋
磕
磨
示
礼
社
祖
祝
神
祥
票
祸
禁
福
离
禽
秀
私
秃
秋
种
科
秒
秘
租
秤
秩
积
称
移
稀
程
稍
税
稚
稠
稳
稻
稼
稿
穴
究
穷
空
穿
突
窃
窄
窍
窗
窜
窝
立
竖
站
竞
竟
章
童
竭
端
竹
笑
笔
符
笨
第
笼
等
筋
筐
筑
筒
答
策
筛
筷
筹
签
简
算
管
箭
箱
篇
篮
篷
簸
籍
米
类
粉
粒
粗
粘
粥
粮
粹
精
糊
糕
糖
糙
糟
系
紊
素
索
紧
紫
累
繁
纠
红
纤
约
级
纪
纬
纯
纲
纳
纵
纷
纸
纹
纺
纽
线
练
组
绅
细
织
终
绍
绎
经
绑
绒
结
绕
绘
给
络
绝
统
绣
继
绩
绪
续
绳
维
绸
综
绿
缀
缉
缓
缔
编
缘
缚
缝
缠
缩
缴
缺
罐
网
罕
罚
罢
罩
罪
置
署
羊
美
羞
羡
群
羽
翅
翔
翘
翻
翼
耀
老
考
者
而
耍
耐
耕
耗
耳
耸
耻
耽
聊
聋
职
联
聘
聚
聪
肃
肆
肉
肌
肖
肚
肠
股
肢
肤
肥
肩
肪
肯
育
肴
肺
肿
胀
胁
胃
胆
背
胎
胖
胜
胞
胡
胳
胶
胸
能
脂
脆
脉
脏
脑
脖
脚
脱
脸
脾
腐
腔
腥
腰
腹
腻
腾
腿
膀
膊
膏
膛
膜
膝
膨
臂
臣
自
臭
至
致
舅
舆
舌
舍
舒
舔
舞
舟
航
般
舰
舱
舶
船
艇
艘
良
艰
色
艳
艺
节
芒
花
芽
苍
苏
苗
苟
若
苦
英
苹
茂
范
茎
茫
茶
草
荐
荒
荡
荣
荤
药
莫
获
菌
菜
萄
萌
萎
营
落
著
葡
董
葬
蒂
蒙
蒸
蓄
蓝
蓬
蔑
蔓
蔚
蔬
蔼
蔽
蕉
蕴
蕾
薄
薪
藏
藐
虎
虏
虐
虑
虚
虫
虹
虽
蚀
蚁
蚂
蛇
蛋
蛮
蜂
蜜
蜡
蝴
蝶
融
蠢
血
衅
行
衍
衔
街
衡
衣
补
表
衫
衬
衰
衷
袋
袍
袖
袜
被
袭
袱
裁
裂
装
裔
裕
裙
裤
裳
裹
西
要
覆
见
观
规
觅
视
览
觉
角
解
触
言
誉
誓
警
譬
计
订
认
讥
讨
让
训
议
讯
记
讲
讳
讶
许
论
讼
讽
设
访
证
评
识
诈
诉
诊
词
译
试
诗
诚
话
诞
询
该
详
诧
诫
诬
语
误
诱
说
诵
请
诸
诺
读
诽
课
谁
调
谅
谈
谊
谋
谍
谎
谐
谓
谜
谢
谣
谤
谦
谨
谬
谱
谴
谷
豆
象
豪
豫
貌
贝
负
贡
财
责
贤
败
账
货
质
贩
贪
贫
贬
购
贯
贴
贵
贷
贸
费
贺
贼
贿
赁
赂
资
赋
赌
赏
赔
赖
赚
赛
赞
赠
赢
赤
走
赴
赶
起
趁
超
越
趋
趟
趣
足
趴
跃
跌
跑
距
跟
跨
跪
路
跳
践
踊
踏
踢
踩
踪
蹈
蹋
蹦
蹬
蹲
躁
身
躬
躲
躺
车
轨
转
轮
软
轰
轻
载
较
辅
辆
辈
辉
辐
辑
输
辕
辖
辙
辛
辜
辞
辟
辣
辨
辩
辫
辰
辱
边
辽
达
迁
迄
迅
过
迈
迎
运
近
返
还
这
进
远
违
连
迟
迫
述
迷
迸
迹
追
退
送
适
逃
逆
选
逊
透
逐
递
途
逗
通
逛
逝
速
造
逢
逮
逻
逼
遇
遍
遏
道
遗
遣
遥
遭
遮
遵
避
邀
那
邮
邻
郁
郊
郎
郑
部
都
鄙
酌
配
酒
酗
酝
酬
酱
酷
酸
酿
醉
醋
醒
采
释
里
重
野
量
金
鉴
针
钉
钓
钙
钝
钞
钟
钢
钥
钦
钩
钱
钻
铁
铃
铅
铜
铭
银
铸
铺
链
销
锁
锅
锈
锋
锐
错
锤
锦
键
锲
锻
镇
镜
镶
长
门
闪
闭
问
闯
闲
间
闷
闹
闻
阂
阅
阐
阔
队
阱
防
阳
阴
阵
阶
阻
附
际
陆
陈
陋
陌
降
限
陡
院
除
险
陪
陵
陶
陷
隆
随
隐
隔
隘
隙
障
隧
隶
难
雀
雄
雅
集
雇
雌
雕
雨
雪
零
雷
雹
雾
需
震
霉
霍
霜
霞
露
霸
青
静
非
靠
面
革
鞋
鞠
鞭
韧
音
页
顶
项
顺
须
顽
顾
顿
颁
颂
预
领
颇
颈
频
颖
颗
题
颜
额
颠
颤
风
飘
飞
食
餐
饥
饪
饭
饮
饰
饱
饲
饶
饺
饼
饿
馅
馆
馈
馋
馒
首
香
马
驰
驱
驳
驶
驻
驾
骂
骄
验
骑
骗
骚
骤
骨
高
髦
鬼
魂
魄
魅
魔
鱼
鲁
鲜
鸟
鸡
鸣
鸦
鸭
鸽
麦
麻
黄
黎
黑
默
鼓
鼠
鼻
齐
齿
龄
龙
