use strict;
use warnings;
use Test::More tests => 68;
use Digest::BLAKE qw(blake_256 blake_256_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::BLAKE->new(256)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            blake_256_hex($data), $digest,
            "blake_256_hex: $len bits of $msg"
        );
        ok(
            blake_256($data) eq pack('H*', $digest),
            "blake_256: $len bits of $msg"
        );
    }

    my $md = Digest::BLAKE->new(256)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $msg");
}
continue { $len++ }

__DATA__
00|73BE7E1E0A7D0A2F0035EDAE62D4412EC43C0308145B5046849A53756BCDA44B
00|11295086B6993FE9D04F6BE3255A24F42FB8CE592EBA1DF5C2B3C3DFD99A2148
C0|E636B38EEB804ED887EA59C464E9E88E94068FB09098216A14173F10D4D821DC
C0|7AB04EC08866091824CC535842CF4FFD10932655716D70F4145B1BE4A776F4E4
80|E9776EE4797E2CD6AF02FC601B4BA740035B33B245C01FFFD4D670DB4AC4CBFB
48|D8B6E9E2700AA1DCD3692C662A2734600FA4A4376832AF835CCF5991FF9F04C0
50|0056117790A9DF356DD05CFE9377E1559D7E93CC9866DACE66F06D4A23144C85
98|CABE9D48012271F9416EDAA4BDA88D1E8807ACEF82BA47363F42C8792814B98E
CC|D63920A3C522500707B6AB79430E44935988EC57C03BA56CCE3E90C37866D457
9800|FCC35B71F96C0E403100DCF386C7B99462356473E7E8A1DA8042C35F84ED53A1
9D40|DB140E78E4E84589869AD611AC2059C4DEE902D7BCC71076C9D7578A33CF5C20
AA80|485F8D1F5D1E19CB3EB229182BD910BBC286095FC6F49EBD6D2F3FD2E94E3133
9830|12B1C31C129CC80ECF144B89E8E046EA03A06879244B700426857F82C34A9092
5030|77771DF0D8B3414F8DD23BF9A8AB4649DE9CC1265394CBEFA2D31F95BDF9C4CC
4D24|94CC035B743AD2E6130A0FC39FE2751D5FB292FABD3F8E4D019CAE7B0FA6958D
CBDE|08BB17993B98D6EDCBC943C3A0E82E309D2FDB19B2181CA029247F13BD1FDCA8
41FB|EC6C0405BCD2CDF2B0A5D50637417E9FC51F6B63D962E80BAF752798A34A77D6
4FF400|2AF068A993BCA384DC687BBDADFE07D10F7B09218B982907C58903BBB82E0E11
FD0440|185DC00F56975421A55CFFE9D2B7E7A5F19B0FDA4BE206F40DF00A5770F79310
424D00|50F0248A940F69D4A8BCAE8D00D7F10CB58E7DB23C66DE3044FFA59307819B0D
3FDEE0|B573053C85F81F73BDBD3D57D82C78421FDB675B9AB7BA69160D3281178E1EDE
335768|BD437FCBC293FDFBBC61B42B0D3979FE308B5FCF4316D76DF4CBBB8C59E80000
051E7C|B927E1E7B3BDBE554EBFF5BE5613D2B78B0C26C0E7D37D916BBCB498C6C2BFED
717F8C|F112B4A9BE63858D075606B5C40EF411AB2D35E58D05A1347175CA513A9B9849
1F877C|F9DE3B32910C66A3996CD4A71DE3D1B2FC7C09C8D481D0B926D7FBA2CB458BEF
EB35CF80|C04916C76DCD9A790D6A8118D8CDFFC590FB2858CF21B5137E76E146A7A043FD
B406C480|FD541337DA46C8A8B7A632221263AE89BD97CA7BC8FEC1CDD045592AF723CDDC
CEE88040|0F9E94515C58062D8DA5515C97CAFC5B35E05214761D14C230C156C9F3F879C8
C584DB70|D88163E052C0336F556BC9E89777B379C25AAFA28E293043E46899C0003BF4CF
53587BC8|68BF211F6B2C227041F5344ABE4396BDD04381FE36AE40FC7BBEBFE790B3951E
69A305B0|C9E72CF115531BBA6965EDCE674EB5B082AE17A3C972B574153084A8E54DECF1
C9375ECE|4E13F0C86CE261DD7138FBB7C7748321F177D62054683268853C324834635151
C1ECFDFC|26A7A3944AB958EEE6C639438730ECE28F7A5FB75149C3DAC2892C079FCA1E84
8D73E8A280|CF93C7DC90A887C52ABB5458097434292AC3433EE98A77E27EAF36A1FC8AD83D
06F2522080|686C4DE0BDCE5AD924942C202E04D9392C618B49401D767605DDE6A11F1B4302
3EF6C36F20|02C0749E70520B655471BE6825C6D87F1BD4BB27B11F399FE5855A91E6A51E6D
0127A1D340|43EBD45584F22111EFC8CC058B322297C1334FFC98BEEA5A445AB822678E9CBC
6A6AB6C210|297075BA2788F9C4271B458D66A84D814E243CBE7D5333478BF1567CA671BD20
AF3175E160|22EB188D37AFECB3B7F0D678992471376B4FCBA0CED6EC65AF69A2754242E451
B66609ED86|3FE9E1C61C5529831766E2F98FF2E111642800FE7FC441F4F6C60A80D296B6E4
21F134AC57|040A7524EF38ABD358368D87E18128824423159E3EEA9DD895FF069CE2BC783D
3DC2AADFFC80|DAB0AC8BC3305909E6FA669A81471B7CB17608890F1508131EB0E293B4434D22
9202736D2240|04EA53A1D872F7A6D57EDFA0B623773FB7F38455F3CD675668BB0EE47D62312B
F219BD629820|0D37F74377C435866C37B2AB9949B102FB0B4DD1A62EF74F1F2FF0C0245D32CD
F3511EE2C4B0|77435236ED8E5964AF587C9760708CD40C0A8B2FF9B917A2FA000DADB4EA1300
3ECAB6BF7720|3C3EBFD6E176873D19AD5DE8FA93604FD19BC2A6C11255C092D0D7ADF5BAC870
CD62F688F498|7DA1B6323819AB7C6F47EBA839EB9FA7979D0C868EAF212BB9D0DC27B13849C0
C2CBAA33A9F8|4DF7730B7DB23977AE21159B2B729E40FB5A6EFA38C9F359010E8C52BC3179E4
C6F50BB74E29|AEC10C331B3FA48DD6AD3B304F1168313F25B8313A3F9ECAB50BE46BB1F7CAF8
79F1B4CCC62A00|B2C3EA552AAB8D2363513EB54A77FB8BD00B0C2357A4D179DA04434A2A2A5291
