package GraphViz::Traverse::Filesystem;
our $AUTHORITY = 'cpan:GENE';
our $VERSION = '0.0201_1';
use strict;
use warnings;
use Carp;
use base qw( GraphViz::Traverse );
use File::Find;
use File::Basename;

sub edge_color { return 'gray' }

sub traverse {
    my( $self, $root ) = @_;
    my $flag_item = sub {
        return if $_ eq '.';
        my $node = $File::Find::name;
        my( $name, $path ) = File::Basename::fileparse( $node );
        $path =~ s/\S$//;
        my $parent = File::Basename::fileparse( $path );
        warn "$node -> $path + $_\n\tL> $parent + $name\n"
            if $self->{_DEBUG};
        $self->mark_item( $node, $path );
    };
    File::Find::find( $flag_item, $root ); 
    return 1;
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

GraphViz::Traverse::Filesystem

=head1 VERSION

version 0.0201_1

=head1 SYNOPSIS

  use GraphViz::Traverse::Filesystem;
  $g = GraphViz::Traverse::Filesystem->new(
      ratio => 'compress', bgcolor => 'beige'
  );
  $g->traverse($root);
  print $g->as_debug;

=head1 DESCRIPTION

B<DEPRECATED>

A C<GraphViz::Traverse::Filesystem> object provides methods to traverse a
file system and render it with C<GraphViz>.

Inherit this module to define and use custom B<node_*> and B<edge_*>
methods.  Example:

  package Foo;
  use strict;
  use warnings;
  use base qw( GraphViz::Traverse::Filesystem );
  sub node_style { return 'filled' }
  sub node_peripheries {
    my $self = shift;
    $_ = shift;
    return !-d $_ && -x $_ ? 2 : 1; # Executable? Get a ring.
  }
  sub node_fillcolor {
    my $self = shift;
    $_ = shift;
    return
        -d $_ ? 'snow' :
        /\.pod$/   ? 'cadetblue' :
        /\.pm$/    ? 'cadetblue4' :
        /\.cgi$/   ? 'cadetblue3' :
        /\.pl$/    ? 'cadetblue2' :
        /(?:readme|changes?)/i ? 'goldenrod' :
        /\.txt$/   ? 'gold4' :
        /\.css$/   ? 'plum' :
        /\.html?$/ ? 'plum3' :
        /\.jpe?g$/ ? 'orchid4' :
        /\.gif$/   ? 'orchid3' :
        /\.png$/   ? 'orchid1' :
        /\.t(?:ar\.)?gz$/ ? 'red3' :
        /\.zip$/   ? 'red1' :
        /\.dump$/  ? 'pink' :
        'yellow';
  }
  sub edge_color { return 'gray' }
  # etc.
  1;

=head1 PUBLIC METHODS

=head2 traverse

  $g->traverse($root);

Traverse a file system starting at the given root path and populate
the C<GraphViz> object with file nodes-and path-edges.

=head2 edge_color

Foo

=head1 SEE ALSO

L<GraphViz>

L<GraphViz::Traverse>

=head1 AUTHOR

Gene Boggs <gene@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2019 by Gene Boggs.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
