# Copyright 2020, Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

package Google::Ads::GoogleAds::V17::Enums::AdTypeEnum;

use strict;
use warnings;

use Const::Exporter enums => [
  UNSPECIFIED                      => "UNSPECIFIED",
  UNKNOWN                          => "UNKNOWN",
  TEXT_AD                          => "TEXT_AD",
  EXPANDED_TEXT_AD                 => "EXPANDED_TEXT_AD",
  EXPANDED_DYNAMIC_SEARCH_AD       => "EXPANDED_DYNAMIC_SEARCH_AD",
  HOTEL_AD                         => "HOTEL_AD",
  SHOPPING_SMART_AD                => "SHOPPING_SMART_AD",
  SHOPPING_PRODUCT_AD              => "SHOPPING_PRODUCT_AD",
  VIDEO_AD                         => "VIDEO_AD",
  IMAGE_AD                         => "IMAGE_AD",
  RESPONSIVE_SEARCH_AD             => "RESPONSIVE_SEARCH_AD",
  LEGACY_RESPONSIVE_DISPLAY_AD     => "LEGACY_RESPONSIVE_DISPLAY_AD",
  APP_AD                           => "APP_AD",
  LEGACY_APP_INSTALL_AD            => "LEGACY_APP_INSTALL_AD",
  RESPONSIVE_DISPLAY_AD            => "RESPONSIVE_DISPLAY_AD",
  LOCAL_AD                         => "LOCAL_AD",
  HTML5_UPLOAD_AD                  => "HTML5_UPLOAD_AD",
  DYNAMIC_HTML5_AD                 => "DYNAMIC_HTML5_AD",
  APP_ENGAGEMENT_AD                => "APP_ENGAGEMENT_AD",
  SHOPPING_COMPARISON_LISTING_AD   => "SHOPPING_COMPARISON_LISTING_AD",
  VIDEO_BUMPER_AD                  => "VIDEO_BUMPER_AD",
  VIDEO_NON_SKIPPABLE_IN_STREAM_AD => "VIDEO_NON_SKIPPABLE_IN_STREAM_AD",
  VIDEO_OUTSTREAM_AD               => "VIDEO_OUTSTREAM_AD",
  VIDEO_TRUEVIEW_IN_STREAM_AD      => "VIDEO_TRUEVIEW_IN_STREAM_AD",
  VIDEO_RESPONSIVE_AD              => "VIDEO_RESPONSIVE_AD",
  SMART_CAMPAIGN_AD                => "SMART_CAMPAIGN_AD",
  CALL_AD                          => "CALL_AD",
  APP_PRE_REGISTRATION_AD          => "APP_PRE_REGISTRATION_AD",
  IN_FEED_VIDEO_AD                 => "IN_FEED_VIDEO_AD",
  DEMAND_GEN_MULTI_ASSET_AD        => "DEMAND_GEN_MULTI_ASSET_AD",
  DEMAND_GEN_CAROUSEL_AD           => "DEMAND_GEN_CAROUSEL_AD",
  TRAVEL_AD                        => "TRAVEL_AD",
  DEMAND_GEN_VIDEO_RESPONSIVE_AD   => "DEMAND_GEN_VIDEO_RESPONSIVE_AD",
  DEMAND_GEN_PRODUCT_AD            => "DEMAND_GEN_PRODUCT_AD"
];

1;
