package Google::Ads::AdWords::v201806::CustomAffinityPage;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/rm/v201806' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %entries_of :ATTR(:get<entries>);
my %totalNumEntries_of :ATTR(:get<totalNumEntries>);

__PACKAGE__->_factory(
    [ qw(        entries
        totalNumEntries

    ) ],
    {
        'entries' => \%entries_of,
        'totalNumEntries' => \%totalNumEntries_of,
    },
    {
        'entries' => 'Google::Ads::AdWords::v201806::CustomAffinity',
        'totalNumEntries' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'entries' => 'entries',
        'totalNumEntries' => 'totalNumEntries',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201806::CustomAffinityPage

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
CustomAffinityPage from the namespace https://adwords.google.com/api/adwords/rm/v201806.

A container that contains a subset of {@link CustomAffinity}s resulting from the filtering of the {@link CustomAffinityService#get} call. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * entries


=item * totalNumEntries




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

