package Google::Ads::AdWords::v201806::Dimensions;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201806' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %width_of :ATTR(:get<width>);
my %height_of :ATTR(:get<height>);

__PACKAGE__->_factory(
    [ qw(        width
        height

    ) ],
    {
        'width' => \%width_of,
        'height' => \%height_of,
    },
    {
        'width' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'height' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
    },
    {

        'width' => 'width',
        'height' => 'height',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201806::Dimensions

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
Dimensions from the namespace https://adwords.google.com/api/adwords/cm/v201806.

Represents a simple height-width dimension. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * width


=item * height




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

