# Generated by default/object.tt
package Paws::EKS::AddonVersionInfo;
  use Moose;
  has AddonVersion => (is => 'ro', isa => 'Str', request_name => 'addonVersion', traits => ['NameInRequest']);
  has Architecture => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'architecture', traits => ['NameInRequest']);
  has Compatibilities => (is => 'ro', isa => 'ArrayRef[Paws::EKS::Compatibility]', request_name => 'compatibilities', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::EKS::AddonVersionInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::EKS::AddonVersionInfo object:

  $service_obj->Method(Att1 => { AddonVersion => $value, ..., Compatibilities => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::EKS::AddonVersionInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->AddonVersion

=head1 DESCRIPTION

Information about an add-on version.

=head1 ATTRIBUTES


=head2 AddonVersion => Str

The version of the add-on.


=head2 Architecture => ArrayRef[Str|Undef]

The architectures that the version supports.


=head2 Compatibilities => ArrayRef[L<Paws::EKS::Compatibility>]

An object that represents the compatibilities of a version.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::EKS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

