package WordList::ZH::HSK;

our $DATE = '2016-02-04'; # DATE
our $VERSION = '0.01'; # VERSION

use utf8;

use WordList;
our @ISA = qw(WordList);

our %STATS = ("shortest_word_len",1,"num_words_contains_nonword_chars",0,"avg_word_len",1.9318,"longest_word_len",4,"num_words_contains_whitespace",0,"num_words_contains_unicode",5000,"num_words",5000); # STATS

1;
# ABSTRACT: HSK (levels 1-6) words

=pod

=encoding UTF-8

=head1 NAME

WordList::ZH::HSK - HSK (levels 1-6) words

=head1 VERSION

This document describes version 0.01 of WordList::ZH::HSK (from Perl distribution WordList-ZH-HSK), released on 2016-02-04.

=head1 SYNOPSIS

 use WordList::ZH::HSK;

 my $wl = WordList::ZH::HSK->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

This is the list of words for the Hanyu Shuiping Kaoshi (Chinese Proficiency
Test), as of September 2012, sorted alphabetically.

For per-level words, see: L<WordList::ZH::HSK1> to L<WordList::ZH::HSK6>.

For list of characters, see: L<WordList::Char::ZH::HSK>.

=head1 STATISTICS

 +----------------------------------+--------+
 | key                              | value  |
 +----------------------------------+--------+
 | avg_word_len                     | 1.9318 |
 | longest_word_len                 | 4      |
 | num_words                        | 5000   |
 | num_words_contains_nonword_chars | 0      |
 | num_words_contains_unicode       | 5000   |
 | num_words_contains_whitespace    | 0      |
 | shortest_word_len                | 1      |
 +----------------------------------+--------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordList-ZH-HSK>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordList-ZH-HSK>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordList-ZH-HSK>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

Hanban which administers the test and publishes the list,
L<http://chinesetest.cn>

About HSK, L<https://en.wikipedia.org/wiki/Hanyu_Shuiping_Kaoshi>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
一
一下
一丝不苟
一举两得
一会儿
一共
一再
一切
一向
一如既往
一定
一帆风顺
一度
一律
一旦
一样
一流
一点儿
一目了然
一直
一致
一般
一贯
一起
一辈子
一边
丁
七
万
万一
万分
丈夫
三
上
上任
上午
上当
上游
上班
上瘾
上级
上网
上进
下
下午
下属
下载
下雨
不
不仅
不但
不像话
不免
不可思议
不堪
不如
不妨
不安
不客气
不屑一顾
不得不
不得了
不得已
不惜
不愧
不择手段
不敢当
不料
不断
不时
不止
不然
不由得
不相上下
不禁
不管
不耐烦
不要紧
不见得
不言而喻
不足
不过
不顾
与
与其
与日俱增
丑
丑恶
专业
专利
专家
专心
专程
专长
专门
专题
世代
世界
世纪
丘陵
丙
业余
业务
丛
东
东张西望
东西
东道主
丝毫
丝绸
丢
丢三落四
丢人
两
严厉
严密
严寒
严峻
严格
严禁
严肃
严重
丧失
个
个人
个体
个别
个子
个性
中介
中午
中国
中央
中心
中文
中断
中旬
中立
中间
丰富
丰收
丰满
丰盛
串
临床
临时
丸
为
为了
为什么
为期
为难
主义
主人
主任
主办
主动
主导
主席
主张
主意
主持
主权
主流
主管
主要
主观
主题
举
举世瞩目
举办
举动
举行
举足轻重
久
义务
之
之际
乌黑
乐器
乐意
乐观
乐谱
乐趣
乒乓球
乖
乘
乘坐
乙
九
乞丐
也
也许
习俗
习惯
乡镇
书
书架
书法
书籍
书记
书面
买
乱
了
了不起
了解
争先恐后
争取
争夺
争气
争端
争议
争论
事业
事件
事先
事务
事实
事态
事情
事故
事物
事迹
事项
二
二氧化碳
于是
亏待
亏损
云
互相
互联网
五
井
亚军
亚洲
些
交
交代
交叉
交往
交换
交易
交流
交涉
交通
交际
亦
产业
产品
产生
享受
京剧
亭子
亮
亲切
亲密
亲戚
亲热
亲爱
亲自
人
人为
人事
人口
人员
人士
人家
人工
人性
人才
人格
人民币
人物
人生
人类
人质
人道
人间
亿
什么
仁慈
今天
介绍
仍旧
仍然
从
从事
从前
从容
从来
从此
从而
仓促
仓库
仔细
他
付款
代价
代替
代理
代表
以
以为
以便
以免
以前
以及
以往
以来
以至
以致
仪器
仪式
件
价值
价格
任何
任务
任命
任性
任意
任重道远
份
仿佛
企业
企图
休息
休闲
众所周知
优先
优势
优异
优惠
优点
优秀
优美
优胜劣汰
优越
伙伴
会
会晤
会计
会议
伞
伟大
传单
传授
传播
传染
传真
传统
传记
传说
传达
伤害
伤心
伤脑筋
伪造
伯母
估计
伴侣
伴随
伶俐
伸
伺候
似乎
似的
但是
位
位于
位置
低
住
住宅
体会
体现
体积
体系
体育
体裁
体谅
体贴
体面
体验
何况
何必
作业
作为
作品
作家
作废
作弊
作息
作文
作用
作者
作风
你
佩服
佳肴
使
使劲儿
使命
使用
侃侃而谈
侄子
例外
例如
供不应求
供给
依托
依据
依旧
依然
依赖
依靠
侥幸
侦探
侧面
侮辱
侵犯
侵略
便
便于
便利
便宜
便条
促使
促进
俗话
俘虏
保养
保卫
保姆
保存
保守
保密
保护
保持
保留
保管
保证
保重
保险
保障
信仰
信任
信号
信封
信心
信念
信息
信用卡
信誉
信赖
俩
修养
修复
修建
修改
修理
俯视
俱乐部
倍
倒
倒闭
倒霉
倔强
倘若
候选
借
借助
借口
借鉴
倡导
倡议
债券
值得
值班
倾向
倾听
倾斜
假
假如
假装
假设
偏偏
偏僻
偏差
偏见
做
做主
停
停泊
停滞
停顿
健全
健康
健身
偶像
偶尔
偶然
偷
偿还
傍晚
储备
储存
储蓄
催
傻
像
僵硬
儒家
儿子
儿童
允许
元
元宵节
元旦
元素
元首
兄弟
充分
充实
充当
充沛
充满
充电器
充足
先
先前
先生
先进
光
光临
光彩
光明
光滑
光盘
光芒
光荣
光辉
克
克制
克服
免得
免疫
免费
兑换
兑现
兔子
党
兜
兢兢业业
入口
全力以赴
全局
全部
全面
八
公主
公元
公共汽车
公关
公务
公司
公告
公园
公安局
公寓
公布
公平
公开
公式
公斤
公正
公民
公然
公认
公证
公道
公里
六
共同
共和国
共计
共鸣
关
关于
关心
关怀
关照
关系
关键
关闭
兴奋
兴旺
兴致勃勃
兴隆
兴高采烈
其中
其他
其余
其实
其次
具体
具备
典型
典礼
养成
兼职
内
内在
内容
内幕
内涵
内科
内部
册
再
再三
再接再厉
再见
冒充
冒犯
冒险
写
写作
军事
军队
农业
农历
农村
农民
冠军
冤枉
冬
冰激凌
冰箱
冰雹
冲
冲击
冲动
冲突
决定
决心
决策
决赛
况且
冷
冷却
冷淡
冷落
冷酷
冷静
冻
冻结
凄凉
准则
准备
准时
准确
凉快
凌晨
减少
减肥
凑合
凝固
凝聚
凝视
几
几乎
凡是
凭
凶恶
凶手
凹凸
出
出卖
出发
出口
出差
出席
出息
出版
出现
出生
出示
出神
出租车
出色
出路
出身
刀
分
分别
分寸
分布
分手
分散
分明
分析
分歧
分泌
分红
分裂
分解
分辨
分配
分量
分钟
切
切实
刊物
刊登
刑事
划
划分
列举
列车
则
刚
刚才
创业
创作
创新
创立
创造
初步
初级
删除
判决
判断
利害
利息
利润
利用
利益
别
别人
别墅
别扭
别致
刮风
到
到处
到底
到达
制作
制定
制度
制服
制止
制约
制裁
制造
刷牙
刹车
刹那
刺
刺激
刻
刻不容缓
刻苦
削
削弱
前提
前景
前途
前面
剑
剥削
剧本
剧烈
剩
剪刀
剪彩
副
割
劈
力争
力所能及
力气
力求
力量
劝
办公室
办法
办理
功劳
功夫
功效
功能
加剧
加工
加油站
加班
务必
动作
动力
动员
动态
动手
动机
动物
动画片
动脉
动荡
动身
动静
助手
助理
努力
劳动
劳驾
势力
势必
勇于
勇敢
勇气
勉励
勉强
勘探
勤俭
勤劳
勤奋
勺子
勾结
勿
包
包含
包围
包子
包庇
包括
包袱
包装
包裹
匆忙
化妆
化学
化石
化肥
化验
北京
北方
北极
匹
区分
区别
区域
医生
医院
十
十分
十足
千
千万
千方百计
升
半
半途而废
华丽
华侨
华裔
协会
协助
协商
协议
协调
卑鄙
卓越
单位
单元
单独
单纯
单调
卖
南
南辕北辙
博士
博大精深
博物馆
博览会
占
占据
占线
占领
卡车
卡通
卧室
卫星
卫生间
印刷
印象
危害
危机
危险
即使
即便
即将
却
卷
历代
历史
历来
厉害
压制
压力
压岁钱
压抑
压榨
压缩
压迫
厌恶
厕所
厘米
厚
原先
原则
原告
原因
原始
原料
原来
原理
原谅
厨房
去
去世
去年
县
参与
参加
参照
参考
参观
参谋
又
叉子
及早
及时
及格
友好
友谊
双
双方
双胞胎
反之
反复
反对
反射
反常
反应
反思
反感
反抗
反映
反正
反而
反问
反面
反馈
反驳
发
发动
发呆
发射
发展
发布
发愁
发扬
发抖
发挥
发明
发炎
发烧
发现
发生
发票
发育
发行
发表
发觉
发言
发誓
发财
发达
叔叔
取
取消
取缔
受不了
受伤
受到
受罪
变化
变故
变质
变迁
叙述
口
口味
口头
口气
口腔
口音
古代
古典
古怪
古董
句子
另外
只
只
只好
只有
只要
叫
召开
叮嘱
可以
可口
可怕
可怜
可恶
可惜
可是
可爱
可能
可行
可见
可观
可靠
台
台阶
台风
右边
叶子
号
号召
号码
司令
司机
司法
叹气
叼
吃
吃亏
吃力
吃惊
吃苦
各
各抒己见
各自
合伙
合作
合同
合并
合影
合成
合格
合法
合理
合算
合适
吉祥
吊
同事
同学
同志
同情
同意
同时
同胞
名副其实
名字
名次
名片
名牌
名胜古迹
名誉
名额
后代
后勤
后悔
后来
后果
后背
后面
后顾之忧
吐
向
向导
向往
向来
吓
吗
君子
吝啬
吞吞吐吐
否决
否则
否定
否认
吨
吩咐
含义
含糊
听
启事
启发
启示
启程
启蒙
吵
吵架
吸取
吸引
吸收
吹
吹捧
吹牛
吻
吼
呀
呆
呈现
告别
告诉
告诫
告辞
呕吐
员工
呢
周到
周围
周密
周年
周折
周期
周末
周转
周边
味道
呵
呻吟
呼吁
呼吸
呼唤
呼啸
命令
命名
命运
咀嚼
咋
和
和平
和气
和睦
和蔼
和解
和谐
咖啡
咨询
咬
咱们
咳嗽
咸
品尝
品德
品种
品质
哄
哆嗦
哇
哈
响
响亮
响应
哥哥
哦
哨
哪
哪儿
哪怕
哭
哭泣
哲学
哺乳
哼
唉
唠叨
售货员
唯一
唯独
唱歌
唾弃
啃
商业
商务
商品
商店
商标
商量
啊
啤酒
啥
啦
啰唆
喂
喂
善于
善良
喇叭
喉咙
喊
喘气
喜悦
喜欢
喜闻乐见
喝
喧哗
嗅觉
嗓子
嗨
嗯
嘈杂
嘉宾
嘛
嘱咐
嘲笑
嘴
嘴唇
嘿
器官
器材
噪音
嚷
四
四肢
回
回忆
回报
回收
回答
回避
回顾
因为
因此
因素
因而
团
团体
团圆
团结
园林
困
困难
围巾
围绕
固体
固定
固执
固有
固然
国务院
国家
国庆节
国王
国籍
国防
国际
图书馆
图案
圆
圆满
圈
圈套
土地
土壤
土豆
在
在乎
在于
在意
地
地位
地势
地区
地图
地址
地方
地步
地毯
地点
地球
地理
地质
地道
地铁
地震
场
场合
场所
场面
均匀
坏
坐
坑
块
坚决
坚固
坚定
坚实
坚强
坚持
坚硬
坚韧
坟墓
坠
坡
坦率
坦白
垂直
垃圾桶
垄断
垫
埋伏
埋怨
埋没
埋葬
城堡
城市
培养
培育
培训
基因
基地
基本
基础
基金
堆
堆积
堕落
堤坝
堵塞
堵车
塌
塑料袋
塑造
塔
填空
境界
墙
增加
增添
墨水儿
士兵
壮丽
壮烈
壮观
声势
声明
声誉
声调
声音
壶
处分
处境
处理
处置
备份
备忘录
复习
复兴
复制
复印
复杂
复活
夏
夏令营
夕阳
外
外交
外公
外向
外界
外行
外表
多
多么
多亏
多余
多元化
多少
夜
够
大
大不了
大伙儿
大体
大使馆
大厦
大型
大夫
大家
大意
大方
大概
大约
大肆
大臣
大致
大象
天伦之乐
天堂
天才
天文
天气
天然气
天生
天真
天空
天赋
太
太太
太极拳
太空
太阳
夫人
夫妇
失业
失事
失去
失望
失眠
失误
失败
失踪
头发
夸
夸张
夹子
夹杂
奇妙
奇怪
奇迹
奉献
奋斗
奔波
奔驰
奖励
奖赏
奖金
套
奠定
奢侈
奥秘
女
女儿
女士
奴隶
奶奶
她
好
好像
好吃
好处
好奇
好客
如今
如何
如果
妄想
妇女
妈妈
妥协
妥善
妥当
妨碍
妹妹
妻子
始终
姐姐
姑且
姑姑
姑娘
姓
委员
委屈
委托
姥姥
姨
姿势
姿态
威信
威力
威望
威胁
威风
娃娃
娇气
娱乐
娶
婚姻
婚礼
婴儿
媒介
媒体
媳妇
嫁
嫂子
嫉妒
嫌
嫌疑
嫩
子弹
孔
孕育
字
字幕
字母
存
存在
孙子
孝顺
季军
季度
季节
孤独
孤立
学习
学位
学历
学期
学术
学校
学生
学说
学问
孩子
宁可
宁愿
宁肯
它
宇宙
守护
安全
安宁
安慰
安排
安置
安装
安详
安静
完
完全
完善
完备
完成
完整
完毕
完美
宏伟
宏观
宗教
宗旨
官
官方
定义
定期
宝贝
宝贵
实习
实事求是
实力
实在
实惠
实施
实现
实用
实行
实话
实质
实践
实际
实验
宠物
审判
审查
审理
审美
客人
客厅
客户
客观
宣传
宣布
宣扬
宣誓
宪法
宫殿
宰
害怕
害羞
宴会
家
家乡
家伙
家具
家务
家喻户晓
家属
家常
家庭
容器
容忍
容易
容纳
容貌
宽
宽容
宽敞
宾馆
宿舍
寂寞
寂静
寄
寄托
密切
密封
密度
密码
富
富裕
寒假
寒暄
寓言
对
对
对不起
对于
对付
对应
对待
对手
对抗
对方
对比
对照
对称
对立
对策
对联
对话
对象
对面
寺庙
寻找
寻觅
导向
导弹
导游
导演
导致
导航
寿命
封建
封锁
封闭
射击
将军
将就
将来
将近
尊严
尊敬
尊重
小
小伙子
小吃
小姐
小心
小心翼翼
小时
小气
小说
小麦
少
尖端
尖锐
尚且
尝
尝试
尤其
就
就业
就职
就近
尴尬
尸体
尺子
尽力
尽快
尽管
尽量
尾巴
局势
局部
局限
局面
屁股
层
层出不穷
层次
居住
居民
居然
屈服
届
屋子
屏幕
屏障
屑
展开
展望
展现
展示
展览
属于
屡次
履行
山脉
岁
岁月
岂有此理
岔
岗位
岛屿
岩石
岳母
岸
峡谷
崇拜
崇敬
崇高
崩溃
崭新
川流不息
州
巡逻
巢穴
工业
工人
工作
工具
工厂
工程师
工艺品
工资
左右
左边
巧克力
巧妙
巨大
巩固
差
差不多
差别
差距
已经
巴不得
巴结
巷
市场
布
布告
布局
布置
帅
师傅
师范
希望
帐篷
带
带领
帮助
帮忙
常识
帽子
幅
幅度
幢
干
干净
干劲
干扰
干旱
干杯
干活儿
干涉
干燥
干脆
干预
平
平凡
平原
平均
平坦
平安
平常
平庸
平方
平时
平等
平行
平衡
平静
平面
年
年代
年度
年级
年纪
年轻
年龄
并且
并列
并非
幸亏
幸福
幸运
幻想
幼儿园
幼稚
幽默
广告
广场
广大
广播
广泛
广阔
庄严
庄稼
庄重
庆祝
床单
序言
应付
应用
应聘
应该
应邀
应酬
底
庞大
废墟
废寝忘食
废话
废除
度过
座
座位
座右铭
庸俗
廉洁
延伸
延期
延续
延长
建立
建筑
建议
建设
开
开发
开始
开展
开幕式
开心
开拓
开支
开放
开明
开朗
开水
开玩笑
开辟
开采
开阔
开除
异常
弄
弊病
弊端
引导
引擎
引用
引起
弟弟
张
弥漫
弥补
弦
弱
弱点
弹性
弹钢琴
强制
强烈
强调
强迫
归根到底
归纳
归还
当
当事人
当代
当初
当前
当务之急
当地
当场
当心
当时
当然
当选
当面
录取
录音
形势
形容
形式
形态
形成
形状
形象
彩票
彩虹
影响
影子
彻底
彼此
往
往事
往常
往往
往返
征收
征服
征求
待遇
很
律师
徒弟
得
得
得不偿失
得力
得天独厚
得意
得罪
徘徊
循序渐进
循环
微不足道
微笑
微观
心得
心态
心情
心灵
心理
心甘情愿
心疼
心眼儿
心脏
心血
必然
必要
必须
忌讳
忍不住
忍受
忍耐
志愿者
志气
忘记
忙
忙碌
忠实
忠诚
忧郁
快
快乐
快活
念
忽然
忽略
忽视
怀孕
怀念
怀疑
态度
怎么
怎么样
思念
思想
思索
思维
思考
怠慢
急于求成
急切
急剧
急功近利
急忙
急诊
急躁
性别
性命
性感
性格
性能
性质
怪不得
总之
总共
总和
总是
总理
总算
总结
总统
总而言之
总裁
恋爱
恍然大悟
恐吓
恐怕
恐怖
恐惧
恢复
恨
恨不得
恩怨
恭喜
恭敬
恰到好处
恰巧
恰当
恳切
恶劣
恶化
恶心
恼火
悄悄
悔恨
悠久
患者
您
悬崖峭壁
悬念
悬挂
悬殊
悲哀
悲惨
悲观
情
情况
情形
情报
情景
情理
情绪
情节
惊动
惊奇
惊讶
惋惜
惦记
惩罚
惭愧
惯例
想
想念
想方设法
想象
惹祸
愈
愉快
意义
意向
意味着
意图
意外
意志
意思
意料
意见
意识
愚昧
愚蠢
感兴趣
感冒
感动
感受
感情
感想
感慨
感染
感激
感觉
感谢
愣
愤怒
愿意
愿望
慈善
慈祥
慌张
慎重
慢
慢性
慰问
慷慨
憋
懂
懒
懒惰
戏剧
成为
成交
成人
成分
成功
成员
成天
成就
成心
成效
成本
成果
成熟
成立
成绩
成语
成长
我
我们
戒
戒备
戒指
或者
或许
战争
战役
战斗
战术
战略
截止
截至
戴
房东
房间
所
所以
所有
扁
扇子
手势
手套
手工
手指
手术
手机
手法
手续
手艺
手表
才
才干
扎
扎实
扑
扒
打交道
打仗
打击
打包
打印
打听
打喷嚏
打官司
打工
打扫
打扮
打扰
打折
打招呼
打架
打猎
打电话
打算
打篮球
打量
打针
扔
托运
扛
扣
执照
执着
执行
扩充
扩大
扩张
扩散
扭转
扮演
扰乱
扶
批
批准
批判
批发
批评
找
承办
承包
承受
承担
承认
承诺
技巧
技术
抄
把
把关
把手
把握
抓
抓紧
投入
投掷
投机
投票
投诉
投资
投降
抗议
折
折磨
折腾
抚养
抚摸
抛弃
抢
抢劫
抢救
护士
护照
报仇
报到
报名
报告
报复
报社
报答
报纸
报警
报道
报酬
报销
披
抬
抱
抱怨
抱歉
抱负
抵制
抵抗
抵达
抹杀
押金
抽屉
抽烟
抽象
拄
担任
担保
担心
拆
拉
拍
拐弯
拐杖
拒绝
拔苗助长
拖延
拘束
拘留
招待
招收
招标
招聘
拜年
拜托
拜访
拟定
拣
拥护
拥抱
拥挤
拥有
拦
拧
拨
拳头
拼命
拼搏
拼音
拽
拾
拿
拿手
持久
持续
挂
挂号
指
指令
指南针
指定
指导
指挥
指望
指标
指甲
指示
指责
按摩
按时
按照
挎
挑剔
挑战
挑拨
挑衅
挖掘
挡
挣
挣扎
挥
挥霍
挪
挫折
振兴
振动
振奋
挺
挺拔
挽回
挽救
捆绑
捍卫
捎
捏
捐
捕捉
捞
损坏
损失
捡
换
捣乱
捧
据悉
据说
掀起
授予
掉
掌握
掏
掐
排列
排放
排斥
排练
排队
排除
掠夺
探望
探测
探索
探讨
接
接受
接待
接着
接触
接近
接连
控制
推
推广
推测
推理
推翻
推荐
推论
推辞
推迟
推销
掩护
掩盖
掩饰
措施
掰
揉
揍
描写
描绘
提
提供
提倡
提前
提拔
提炼
提示
提纲
提议
提醒
提问
提高
插
插座
握手
揭露
搀
搁
搂
搅拌
搏斗
搓
搜索
搞
搬
搭
搭档
搭配
携带
摄影
摄氏度
摆
摆脱
摇
摇摆
摇滚
摊
摔倒
摘
摘要
摧残
摩托车
摩擦
摸
摸索
撇
撒谎
撕
撞
撤退
撤销
播放
播种
擅自
擅长
操作
操劳
操场
操心
操纵
操练
擦
攀登
攒
支
支出
支持
支援
支撑
支柱
支流
支票
支配
收
收入
收拾
收据
收益
收缩
收获
收藏
收音机
改变
改善
改正
改良
改进
改革
攻克
攻击
放
放大
放射
放弃
放心
放暑假
放松
政府
政权
政治
政策
故乡
故事
故意
故障
效果
效率
效益
敌人
敌视
敏感
敏捷
敏锐
救
救护车
救济
教
教养
教室
教授
教材
教练
教育
教训
敞开
敢
散发
散布
散文
散步
敬业
敬礼
数
数字
数学
数据
数码
数量
数额
敲
整个
整体
整理
整顿
整齐
敷衍
文件
文具
文凭
文化
文字
文学
文明
文物
文献
文章
文艺
文雅
斑
斗争
斜
斟酌
斩钉截铁
断
断定
断绝
斯文
新
新娘
新郎
新闻
新陈代谢
新颖
新鲜
方
方位
方便
方向
方圆
方式
方案
方法
方言
方针
方面
施加
施展
旁边
旅游
旅行
旋律
旋转
旗帜
旗袍
无
无偿
无动于衷
无奈
无微不至
无忧无虑
无所谓
无数
无比
无理取闹
无知
无穷无尽
无精打采
无耻
无聊
无能为力
无论
无赖
无辜
无非
既然
日
日历
日子
日常
日新月异
日期
日用品
日益
日程
日记
旧
早上
时事
时代
时候
时光
时刻
时尚
时差
时常
时期
时机
时而
时间
时髦
旷课
昂贵
昆虫
昌盛
明天
明明
明星
明显
明智
明白
明确
昏迷
昔日
星期
春
昨天
是
是否
是非
昼夜
显得
显然
显示
显著
晃
晋升
晒
晕
晚上
普及
普通话
普遍
景色
晴
晴朗
智力
智商
智慧
智能
晾
暂且
暂时
暖和
暗
暗示
暧昧
暴力
暴露
曝光
曲子
曲折
更
更新
更正
曾经
最
最初
最后
最好
最近
月
月亮
有
有利
有名
有条不紊
有趣
朋友
服从
服务员
服气
服装
朗读
朝
朝代
朝气蓬勃
期待
期望
期间
期限
木头
未免
未必
未来
本
本事
本人
本来
本科
本能
本质
本身
本钱
本领
朴实
朴素
朵
机会
机动
机器
机场
机密
机智
机构
机械
机灵
机遇
杀
杂交
杂志
杂技
权利
权力
权威
权衡
材料
杜绝
束
束缚
杠杆
条
条件
条款
条理
条约
来
来不及
来历
来得及
来源
来自
杯子
杰出
极
极其
极端
极限
构思
构成
枕头
枚
果实
果断
果汁
果然
枝
枪
枯燥
枯萎
某
染
柔和
柜台
查获
柴油
标准
标志
标本
标点
标记
标题
栋
栏目
树
树立
校长
株
样品
样子
样式
核心
根
根据
根本
根深蒂固
根源
格外
格局
格式
栽培
桃
框架
案件
案例
桌子
桔子
档案
档次
桥
桥梁
桨
梢
梦
梦想
梨
梳子
检查
检讨
检验
棉花
棍棒
棒
棕色
森林
棵
椅子
植物
椭圆
楼
概念
概括
榜样
模仿
模型
模式
模样
模特
模糊
模范
横
橙
橡皮
欠
次
次品
次序
次要
欢乐
欢迎
欣慰
欣欣向荣
欣赏
欧洲
欲望
欺负
欺骗
款式
款待
歇
歌颂
正
正义
正在
正好
正宗
正常
正式
正当
正月
正气
正确
正经
正规
正负
此外
步伐
步骤
武侠
武器
武术
武装
歧视
歪
歪曲
歹徒
死
死亡
残忍
残留
残疾
残酷
殖民地
殴打
段
毁灭
毅力
毅然
母亲
母语
每
毒品
比
比例
比喻
比如
比方
比赛
比较
比重
毕业
毕竟
毛
毛巾
毛病
毫无
毫米
民主
民族
民间
气候
气功
气势
气压
气味
气概
气氛
气色
气象
气质
气魄
氧气
水
水利
水平
水果
水泥
水龙头
永恒
永远
汇报
汇率
汉语
汗
池塘
污染
污蔑
汤
汹涌
汽油
沉思
沉淀
沉着
沉重
沉闷
沉默
沐浴
沙发
沙滩
沙漠
沟通
没关系
没有
沮丧
沸腾
油漆
油炸
油腻
治安
治理
治疗
沼泽
沾光
沿海
泄气
泄露
法人
法律
法院
泛滥
泡沫
波浪
波涛
注册
注射
注意
注视
注释
注重
泰斗
泼
洒
洗
洗手间
洗澡
洞
津津有味
洪水
活力
活动
活泼
活该
活跃
洽谈
派
派别
派遣
流传
流利
流氓
流泪
流浪
流行
流通
流露
浅
浇
测量
测验
浏览
浑身
浓
浓厚
浪漫
浪费
海关
海拔
海洋
海滨
海鲜
浸泡
涂抹
消化
消失
消息
消极
消毒
消灭
消耗
消费
消防
消除
涉及
涌现
涨
涮火锅
液体
淋
淘气
淘汰
淡
淡季
淡水
深
深刻
深奥
深情厚谊
深沉
混乱
混合
混浊
混淆
淹没
清晨
清晰
清楚
清洁
清淡
清澈
清理
清真
清醒
清除
渔民
渗透
渠道
渣
温和
温带
温度
温暖
温柔
港口
港湾
渴
渴望
游戏
游泳
游览
渺小
湖泊
湿润
溅
源泉
溜
溪
溶解
滋味
滋润
滑
滔滔不绝
滚
滞留
满
满意
满足
滴
漂亮
漂浮
漏
演习
演出
演变
演员
演奏
演绎
演讲
漫画
漫长
潇洒
潜力
潜水
潜移默化
潮流
潮湿
澄清
激动
激励
激发
激情
激烈
濒临
瀑布
灌溉
火
火柴
火焰
火箭
火药
火车站
灭亡
灯
灯笼
灰
灰尘
灰心
灵感
灵敏
灵活
灵魂
灾害
灾难
灿烂
炉灶
炊烟
炎热
炒
炫耀
点
点心
点缀
烂
烘
烟花爆竹
烤鸭
烦恼
烫
热
热心
热情
热泪盈眶
热烈
热爱
热门
热闹
烹饪
焦急
焦点
然后
然而
煎
煤炭
照
照常
照样
照片
照相机
照耀
照顾
煮
熄灭
熊猫
熏陶
熟悉
熟练
熨
熬
熬夜
燃烧
爆发
爆炸
爬山
爱不释手
爱好
爱心
爱惜
爱戴
爱护
父亲
爷爷
爸爸
爽快
片
片刻
片断
片面
版本
牙膏
牙齿
牛仔裤
牛奶
牢固
牢骚
物业
物理
物美价廉
物质
物资
牲畜
牵
牵制
牵扯
特别
特定
特征
特意
特殊
特点
特色
特长
牺牲
犬
状况
状态
犹如
犹豫
狗
狠心
狡猾
独特
独立
独裁
狭窄
狭隘
狮子
狼吞虎咽
狼狈
猛烈
猜
猪
猫
猴子
率领
玉
玉米
王子
玩
玩具
玩弄
玩意儿
环境
环节
现代
现在
现场
现实
现成
现状
现象
现金
玻璃
珍惜
珍珠
珍稀
珍贵
班
球迷
理发
理想
理所当然
理智
理由
理直气壮
理睬
理解
理论
琢磨
瓦解
瓶子
甚至
甜
生产
生动
生命
生存
生态
生意
生效
生日
生机
生气
生活
生物
生理
生疏
生病
生肖
生育
生锈
生长
用
用功
用户
用途
甩
甭
田径
田野
由
由于
甲
申报
申请
电台
电子邮件
电影
电梯
电池
电源
电脑
电视
男
画
画蛇添足
畅通
畅销
界限
畏惧
畔
留
留学
留念
留恋
留神
畜牧
番
疏忽
疏远
疑惑
疑问
疙瘩
疤
疯狂
疲倦
疲劳
疲惫
疼
疼爱
疾病
病毒
症状
痒
痕迹
痛快
痛苦
瘦
瘫痪
瘸
癌症
登录
登机牌
登记
登陆
白
百
百分之
的
的确
皆
皇后
皇帝
皮肤
皮革
皮鞋
皱纹
盆
盆地
盈利
盐
监狱
监督
监视
盒子
盖
盖章
盗窃
盘子
盘旋
盛
盛产
盛开
盛情
盛行
目光
目前
目录
目标
目的
目睹
盯
盲目
直
直径
直接
直播
相似
相信
相关
相反
相同
相声
相处
相对
相差
相应
相当
相等
相辅相成
盼望
省
省会
省略
眉毛
看
看不起
看待
看望
看法
看见
真
真实
真挚
真正
真理
真相
眨
眯
眼光
眼睛
眼神
眼色
眼镜
着
着凉
着急
着想
着手
着火
着迷
着重
睁
睡觉
督促
瞄准
瞎
瞧
瞪
瞬间
瞻仰
矛盾
知觉
知识
知足常乐
知道
短
短促
短信
矮
石头
石油
矿产
矿泉水
码头
砍
砍伐
研究
砖
破
破产
破例
破坏
砸
硕士
硬
硬件
确保
确信
确切
确定
确实
确立
确认
碎
碗
碰
磁带
磅
磋商
磕
磨合
示威
示意
示范
礼尚往来
礼拜天
礼物
礼节
礼貌
社会
社区
祖先
祖国
祖父
祝福
祝贺
神仙
神圣
神奇
神态
神气
神秘
神经
神话
票
禁止
福利
福气
离
离婚
离开
私人
私自
秃
秋
种
种子
种族
种植
种类
科学
科目
秒
秘书
秘密
租
租赁
秤
秩序
积极
积累
称
称号
称呼
称心如意
称赞
移动
移民
程序
程度
稍微
税
稠密
稳定
稻谷
稿件
究竟
穷
空
空前绝后
空想
空气
空洞
空白
空虚
空调
空闲
空间
空隙
穿
穿越
突出
突然
突破
窄
窍门
窗帘
窗户
窜
窝
立交桥
立体
立刻
立即
立场
立方
立足
竖
站
竞争
竞赛
竞选
竟然
章程
童话
竭尽全力
端
端午节
端正
竹子
笑
笑话
笔记本
符号
符合
笨
笨拙
第一
笼罩
等
等
等于
等候
等待
等级
筐
答复
答应
答案
答辩
策划
策略
筛选
筷子
筹备
签
签署
签证
简体字
简化
简单
简历
简直
简要
简陋
算数
管子
管理
管辖
篇
籍贯
米
米饭
类似
类型
粉末
粉碎
粉色
粒
粗心
粗糙
粗鲁
粘贴
粥
粮食
精力
精华
精密
精彩
精心
精打细算
精益求精
精确
精神
精简
精致
精通
糊涂
糖
糟糕
糟蹋
系
系列
系统
系领带
素质
素食
索取
索性
紧张
紧急
紧迫
紫
累
繁体字
繁华
繁忙
繁殖
繁荣
纠正
纠纷
红
纤维
约会
约束
级别
纪录
纪律
纪念
纪要
纯洁
纯粹
纲领
纳闷儿
纵横
纷纷
纺织
纽扣儿
线索
练习
组
组合
组成
组织
绅士
细胞
细致
细节
细菌
终于
终止
终点
终究
终身
经典
经历
经商
经常
经济
经理
经纬
经营
经费
经过
经验
绑架
结合
结婚
结实
结局
结晶
结束
结构
结果
结算
结论
结账
绕
给
给予
络绎不绝
绝对
绝望
统一
统治
统筹兼顾
统统
统计
绣
继承
继续
绳子
维修
维护
维持
维生素
综合
绿
缓和
缓解
编织
编辑
缘故
缠绕
缩短
缴纳
缺乏
缺口
缺少
缺席
缺点
缺陷
罐
网球
网站
网络
罕见
罚款
罢工
罪犯
羊肉
美丽
美妙
美术
美满
美观
羞耻
羡慕
群
群众
羽毛球
羽绒服
翅膀
翘
翻
翻译
翼
耀眼
老
老婆
老实
老师
老板
老百姓
老虎
老鼠
考古
考察
考核
考虑
考试
考验
而
而且
而已
耍
耐心
耐用
耕地
耗费
耳朵
耳环
耸
耽误
聊天
聋哑
职业
职位
职务
职能
联合
联想
联欢
联盟
联系
联络
聚会
聚精会神
聪明
肆无忌惮
肌肉
肖像
肚子
股东
股份
股票
肥沃
肥皂
肩膀
肯定
肺
肿瘤
胃
胃口
胆小鬼
胆怯
背
背叛
背景
背诵
胖
胜利
胜负
胡乱
胡同
胡说
胡须
胳膊
胶水
胸
胸怀
胸膛
能
能力
能干
能源
能量
脂肪
脆弱
脉搏
脏
脑袋
脖子
脚
脱
脱离
脸
脾气
腐朽
腐烂
腐蚀
腐败
腥
腰
腹泻
腿
膜
膝盖
臂
自主
自从
自信
自力更生
自动
自卑
自发
自己
自愿
自满
自然
自由
自私
自行车
自觉
自豪
臭
至于
至今
至少
致使
致力
致辞
舅舅
舆论
舌头
舍不得
舒服
舒畅
舒适
舔
舞蹈
舟
航天
航班
航空
航行
舰艇
舱
船
船舶
艘
良好
良心
艰巨
艰苦
艰难
色彩
艺术
节
节制
节奏
节日
节目
节省
节约
花
花
花瓣
花生
花蕾
苍白
苏醒
苗条
若干
苦
苦尽甘来
苦涩
英俊
英勇
英明
英雄
苹果
茂盛
范围
范畴
茎
茫然
茫茫
茶
草
草案
草率
荒凉
荒唐
荒谬
荣幸
荣誉
荤
药
莫名其妙
获得
菜
菜单
萌芽
营业
营养
落后
落实
落成
著作
著名
葡萄
董事长
蒸发
蓝
蔑视
蔓延
蔚蓝
蔬菜
蕴藏
薄
薄弱
薪水
藐视
虐待
虚伪
虚假
虚心
虚荣
虽然
蚂蚁
蛇
蛋白质
蛋糕
蜜蜂
蜡烛
蝴蝶
融化
融洽
血
血压
行
行业
行为
行人
行列
行动
行政
行李箱
衔接
街道
衣服
衣裳
补偿
补充
补救
补贴
表决
表彰
表态
表情
表扬
表明
表格
表演
表现
表示
表达
表面
衬托
衬衫
衰老
衰退
衷心
袜子
被
被动
被告
被子
袭击
裁判
裁员
裁缝
装
装修
装卸
装备
装饰
裙子
裤子
西
西瓜
西红柿
要
要不
要命
要是
要求
要点
要素
覆盖
见义勇为
见多识广
见解
见闻
见面
观众
观光
观察
观念
观点
规划
规则
规定
规律
规格
规模
规矩
规章
规范
视力
视线
视野
视频
觉得
觉悟
觉醒
角
角度
角色
角落
解体
解决
解剖
解放
解散
解释
解除
解雇
触犯
言论
警告
警察
警惕
譬如
计划
计算
计较
认为
认可
认定
认真
认识
讥笑
讨价还价
讨厌
讨好
讨论
让
让步
训练
议论
记录
记得
记忆
记性
记者
记载
讲
讲座
讲究
许可
许多
论坛
论文
论证
讽刺
设备
设想
设施
设立
设置
设计
访问
证书
证件
证实
证据
证明
评价
评估
评论
识别
诈骗
诉讼
诊断
词典
词汇
词语
试
试卷
试图
试验
诗
诚实
诚恳
诚挚
话筒
话题
诞生
诞辰
询问
详细
诧异
诬陷
语气
语法
语言
误会
误差
误解
诱惑
说
说不定
说明
说服
说话
请
请假
请帖
请教
请柬
请求
请示
诸位
读
诽谤
课
课程
课题
谁
调剂
调动
调和
调整
调料
调查
调皮
调节
调解
谅解
谈
谈判
谋求
谜语
谢绝
谢谢
谣言
谦虚
谦逊
谨慎
谴责
豆腐
象征
象棋
豪华
豪迈
贝壳
负担
负责
贡献
财产
财务
财富
财政
责任
责备
责怪
贤惠
败坏
账户
货币
质量
贩卖
贪婪
贪污
贫乏
贫困
贬义
贬低
购物
贯彻
贵
贵族
贷款
贸易
贼
贿赂
资产
资助
资料
资本
资格
资深
资源
资金
赋予
赌博
赔偿
赚
赞助
赞叹
赞成
赞美
赠送
赢
赤字
赤道
走
走廊
走漏
走私
赶
赶快
赶紧
起伏
起初
起哄
起床
起来
起源
起码
起草
起飞
趁
超市
超级
超越
超过
越
趋势
趟
趣味
足以
趴
跌
跑步
距离
跟
跟前
跟踪
跟随
跨
跪
路
跳舞
跳跃
践踏
踊跃
踏实
踢足球
踩
踪迹
蹦
蹬
蹲
身份
身体
身材
躲藏
躺
车厢
车库
轨道
转
转变
转告
转折
转移
转让
转达
轮廓
轮流
轮胎
轮船
软
软件
轰动
轻
轻易
轻松
轻视
较量
辅助
辅导
辆
辉煌
辐射
输
输入
辛勤
辛苦
辜负
辞职
辣
辣椒
辨认
辩护
辩解
辩论
辩证
辫子
边境
边界
边疆
边缘
辽阔
达到
达成
迁就
迁徙
迄今为止
迅速
过
过
过于
过分
过去
过失
过奖
过度
过敏
过期
过渡
过滤
过瘾
过程
过问
迈
迎接
迎面
运动
运气
运用
运算
运行
运输
近
近代
近来
还
还
还原
还是
这
进
进化
进口
进展
进攻
进步
进而
进行
远
违反
违背
连
连同
连年
连忙
连续
连锁
迟到
迟早
迟疑
迟缓
迟钝
迫不及待
迫切
迫害
迷人
迷信
迷惑
迷路
迸发
迹象
追
追悼
追求
追究
退
退休
退步
送
适合
适宜
适应
逃
逃避
逆行
选举
选手
选拔
选择
透明
透露
逐年
逐步
逐渐
递
递增
途径
逗
通俗
通常
通用
通知
通缉
通讯
通货膨胀
通过
逛
逝世
速度
造型
造成
逢
逮捕
逻辑
逼迫
遇到
遍
遍布
遏制
道德
道歉
道理
遗产
遗传
遗失
遗憾
遗留
遥控
遥远
遭受
遭殃
遭遇
遮挡
遵守
遵循
避免
邀请
那
邮局
邻居
郊区
郑重
部位
部分
部署
部门
都
鄙视
配偶
配合
配备
配套
酒吧
酒精
酗酒
酝酿
酱油
酸
醉
醋
醒
采取
采纳
采访
采购
采集
释放
里
里程碑
重
重叠
重复
重大
重心
重新
重点
重要
重视
重量
野心
野蛮
金属
金融
鉴于
鉴别
鉴定
针对
钓
钙
钞票
钢铁
钥匙
钦佩
钩子
钱
钻石
钻研
铃
铅笔
铜
银
银行
铸造
铺
销售
销毁
锁
锅
锋利
错
错误
锤
锦上添花
键盘
锲而不舍
锻炼
镇定
镇静
镜头
镜子
镶嵌
长
长
长城
长江
长辈
长途
门
闪烁
闪电
闭塞
问
问世
问候
问题
闯
闲话
间接
间谍
间隔
闻
阅读
阐述
队伍
防守
防御
防止
防治
阳光
阳台
阴
阴谋
阵
阵地
阵容
阶层
阶段
阻拦
阻挠
阻止
阻碍
附件
附和
附属
附近
陆地
陆续
陈列
陈旧
陈述
陌生
降临
降低
降落
限制
陡峭
除
除了
除夕
除非
陪
陶瓷
陶醉
陷入
陷害
陷阱
隆重
随便
随即
随意
随手
随时
随着
随身
隐患
隐瞒
隐私
隐约
隐蔽
隔壁
隔离
隔阂
障碍
隧道
难
难免
难受
难堪
难得
难怪
难能可贵
难过
难道
雄伟
雄厚
集中
集体
集合
集团
雇佣
雌雄
雕刻
雕塑
雪
雪上加霜
零
零件
零星
零钱
零食
雷
雷达
雾
需求
需要
震惊
震撼
霞
霸道
青
青少年
青春
非
非常
非法
靠
靠拢
面临
面包
面子
面对
面条
面积
面貌
革命
鞠躬
鞭炮
鞭策
音乐
音响
页
顶
项
项目
项链
顺便
顺利
顺序
须知
顽固
顽强
顾客
顾虑
顾问
顿
顿时
颁发
颁布
预习
预兆
预先
预报
预料
预期
预算
预言
预订
预防
领事馆
领会
领先
领土
领域
领导
领悟
领袖
颇
颈椎
频率
频繁
频道
颗
题
题材
题目
颜色
额外
颠倒
颠簸
颤抖
风俗
风光
风味
风土人情
风度
风景
风暴
风格
风气
风趣
风险
飘
飘扬
飞机
飞禽走兽
飞翔
飞跃
食物
餐厅
饥饿
饭店
饮料
饮食
饱
饱和
饱经沧桑
饲养
饶恕
饺子
饼干
饿
馅儿
馋
馒头
首
首先
首要
首都
首饰
香
香肠
香蕉
马
马上
马虎
驱逐
驻扎
驾驶
骂
骄傲
验收
验证
骑
骗
骚扰
骨头
骨干
高
高兴
高尚
高峰
高明
高档
高涨
高潮
高级
高超
高速公路
魄力
魅力
魔术
魔鬼
鱼
鲜明
鲜艳
鸟
鸡蛋
鸦雀无声
鸽子
麦克风
麻木
麻烦
麻痹
麻醉
黄昏
黄河
黄金
黎明
黑
黑板
默默
鼓动
鼓励
鼓掌
鼓舞
鼠标
鼻子
鼻涕
齐全
齐心协力
龙
