package IO::Iron::PolicyBase::CharacterGroup;

## no critic (Documentation::RequirePodAtEnd)
## no critic (Documentation::RequirePodSections)
## no critic (Subroutines::RequireArgUnpacking)
## no critic (Variables::ProhibitPunctuationVars)

use 5.010_000;
use strict;
use warnings;

# Global creator
BEGIN {
    # Inherit nothing
}

# Global destructor
END {
}


# ABSTRACT: Base package (inherited) for IO::Iron::IronMQ/Cache/Worker::Policy packages.

our $VERSION = '0.13'; # VERSION: generated by DZP::OurPkgVersion

use Log::Any  qw{$log};
use Params::Validate qw(:all);



sub group {
    my %params = validate(
        @_, {
            'character_group' => { type => SCALAR, regex => qr/^[[:graph:]]+$/msx, }, # character group name.
        },
    );
    my ($group_name) = $params{'character_group'} =~ /\[:([[:graph:]]+):\]/msx;
    $log->tracef('group_name=%s;', $group_name);
    if($group_name eq 'alpha') { return alpha(); } ## no critic (ControlStructures::ProhibitCascadingIfElse)
    elsif($group_name eq 'alnum') { return alnum(); }
    elsif($group_name eq 'digit') { return digit(); }
    elsif($group_name eq 'lower') { return lower(); }
    elsif($group_name eq 'upper') { return upper(); }
    elsif($group_name eq 'word') { return word(); }
    else { return; }
}


sub alpha {
    return 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
            .'abcdefghijklmnopqrstuvwxyz';
}


sub alnum {
    return 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
        .'abcdefghijklmnopqrstuvwxyz'
        .'0123456789';
}


sub digit {
    return '0123456789';
}


sub lower {
    return 'abcdefghijklmnopqrstuvwxyz';
}


sub upper {
    return 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
}


sub word {
    return 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
            .'abcdefghijklmnopqrstuvwxyz'
            .'0123456789_';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

IO::Iron::PolicyBase::CharacterGroup - Base package (inherited) for IO::Iron::IronMQ/Cache/Worker::Policy packages.

=head1 VERSION

version 0.13

=head1 SYNOPSIS

This class is for internal use only.

=for stopwords config Mikko Koivunalho

=for stopwords alnum abcdefghijklmnopqrstuvwxyz ABCDEFGHIJKLMNOPQRSTUVWXYZ

=head1 FUNCTIONS

=head2 group

Get the character group.

Parameters:

=over 8

=item character_group. Full group name, e.g. [:digit:].

=back

Return all characters as a string.

=head2 alpha

Group [:alpha:], ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz.

=head2 alnum

Group [:alnum:], ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789.

=head2 digit

Group [:digit:], 0123456789.

=head2 lower

Group [:lower:], abcdefghijklmnopqrstuvwxyz.

=head2 upper

Group [:upper:], ABCDEFGHIJKLMNOPQRSTUVWXYZ.

=head2 word

Group [:word:], ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_.

=head1 AUTHOR

Mikko Koivunalho <mikko.koivunalho@iki.fi>

=head1 BUGS

Please report any bugs or feature requests to bug-io-iron@rt.cpan.org or through the web interface at:
 http://rt.cpan.org/Public/Dist/Display.html?Name=IO-Iron

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Mikko Koivunalho.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

The full text of the license can be found in the
F<LICENSE> file included with this distribution.

=cut
