# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::GG;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20241212130805;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '1481[25-9]\\d{5}',
                'geographic' => '1481[25-9]\\d{5}',
                'mobile' => '
          7(?:
            (?:
              781|
              839
            )\\d|
            911[17]
          )\\d{5}
        ',
                'pager' => '
          76(?:
            464|
            652
          )\\d{5}|
          76(?:
            0[0-28]|
            2[356]|
            34|
            4[01347]|
            5[49]|
            6[0-369]|
            77|
            8[14]|
            9[139]
          )\\d{6}
        ',
                'personal_number' => '70\\d{8}',
                'specialrate' => '(
          (?:
            8(?:
              4[2-5]|
              7[0-3]
            )|
            9(?:
              [01]\\d|
              8[0-3]
            )
          )\\d{7}|
          845464\\d
        )|(
          (?:
            3[0347]|
            55
          )\\d{8}
        )',
                'toll_free' => '
          80[08]\\d{7}|
          800\\d{6}|
          8001111
        ',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"4414346", "Hexham",
"441262", "Bridlington",
"44239", "Portsmouth",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"441368", "Dunbar",
"4414309", "Market\ Weighton",
"441542", "Keith",
"441821", "Kinrossie",
"441571", "Lochinver",
"4419752", "Alford\ \(Aberdeen\)",
"4413390", "Aboyne\/Ballater",
"441978", "Wrexham",
"4415078", "Alford\ \(Lincs\)",
"441433", "Hathersage",
"44114701", "Sheffield",
"44116", "Leicester",
"4414344", "Bellingham",
"442826", "Northern\ Ireland",
"441844", "Thame",
"441631", "Oban",
"441798", "Pulborough",
"441806", "Shetland",
"4416866", "Newtown",
"441558", "Llandeilo",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441951", "Colonsay",
"441361", "Duns",
"4418904", "Coldstream",
"4412297", "Millom",
"441788", "Rugby",
"4418906", "Ayton",
"441663", "New\ Mills",
"441236", "Coatbridge",
"442830", "Newry",
"441638", "Newmarket",
"441845", "Thirsk",
"44238", "Southampton",
"441461", "Gretna",
"44114709", "Sheffield",
"4417687", "Keswick",
"441971", "Scourie",
"441647", "Moretonhampstead",
"4416864", "Llanidloes",
"441942", "Wigan",
"441600", "Monmouth",
"441828", "Coupar\ Angus",
"441578", "Lauder",
"441289", "Berwick\-upon\-Tweed",
"4418513", "Stornoway",
"441623", "Mansfield",
"441833", "Barnard\ Castle",
"442885", "Ballygawley",
"4413391", "Aboyne\/Ballater",
"441593", "Lybster",
"441255", "Clacton\-on\-Sea",
"441444", "Haywards\ Heath",
"441406", "Holbeach",
"441275", "Clevedon",
"442894", "Antrim",
"441297", "Axminster",
"441983", "Isle\ of\ Wight",
"4413392", "Aboyne",
"441509", "Loughborough",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"442879", "Magherafelt",
"441344", "Bracknell",
"441306", "Dorking",
"442884", "Northern\ Ireland",
"441254", "Blackburn",
"441445", "Gairloch",
"441993", "Witney",
"441287", "Guisborough",
"442866", "Enniskillen",
"441260", "Congleton",
"4414372", "Clynderwen\ \(Clunderwen\)",
"441773", "Ripley",
"441428", "Haslemere",
"4414305", "North\ Cave",
"441704", "Southport",
"441299", "Bewdley",
"441753", "Slough",
"441746", "Bridgnorth",
"441909", "Worksop",
"441141", "Sheffield",
"442895", "Belfast",
"441274", "Bradford",
"441540", "Kingussie",
"442877", "Limavady",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441583", "Carradale",
"441328", "Fakenham",
"4418475", "Thurso",
"441743", "Shrewsbury",
"441756", "Skipton",
"441780", "Stamford",
"441355", "East\ Kilbride",
"441564", "Lapworth",
"441550", "Llandovery",
"441767", "Sandy",
"441389", "Dumbarton",
"441475", "Greenock",
"441862", "Tain",
"441497", "Hay\-on\-Wye",
"441915", "Sunderland",
"441586", "Campbeltown",
"442847", "Northern\ Ireland",
"441570", "Lampeter",
"441244", "Chester",
"441455", "Hinckley",
"441206", "Colchester",
"441608", "Chipping\ Norton",
"441375", "Grays\ Thurrock",
"441489", "Bishops\ Waltham",
"442838", "Portadown",
"44151", "Liverpool",
"441142", "Sheffield",
"441630", "Market\ Drayton",
"441397", "Fort\ William",
"441776", "Stranraer",
"441474", "Gravesend",
"441360", "Killearn",
"441950", "Sandwick",
"4418510", "Great\ Bernera\/Stornoway",
"441986", "Bungay",
"441914", "Tyneside",
"441499", "Inveraray",
"4414235", "Harrogate",
"441422", "Halifax",
"441354", "Chatteris",
"441303", "Folkestone",
"441769", "South\ Molton",
"441565", "Knutsford",
"441387", "Dumfries",
"441460", "Chard",
"441228", "Carlisle",
"441790", "Spilsby",
"442849", "Northern\ Ireland",
"441626", "Newton\ Abbot",
"441322", "Dartford",
"441245", "Chelmsford",
"441454", "Chipping\ Sodbury",
"4419753", "Strathdon",
"441970", "Aberystwyth",
"441403", "Horsham",
"441487", "Warboys",
"441268", "Basildon",
"441233", "Ashford\ \(Kent\)",
"441666", "Malmesbury",
"4414373", "Clynderwen\ \(Clunderwen\)",
"441420", "Alton",
"4419648", "Hornsea",
"441855", "Ballachulish",
"4418907", "Ayton",
"441889", "Rugeley",
"441684", "Malvern",
"441952", "Telford",
"441362", "Dereham",
"4412294", "Barrow\-in\-Furness",
"4414239", "Boroughbridge",
"441548", "Kingsbridge",
"441695", "Skelmersdale",
"441320", "Fort\ Augustus",
"441939", "Wem",
"4417684", "Pooley\ Bridge",
"441972", "Glenborrodale",
"4412296", "Barrow\-in\-Furness",
"441677", "Bedale",
"4416867", "Llanidloes",
"441729", "Settle",
"441525", "Leighton\ Buzzard",
"441875", "Tranent",
"441462", "Hitchin",
"441924", "Wakefield",
"441792", "Swansea",
"441685", "Merthyr\ Tydfil",
"4418512", "Stornoway",
"441436", "Helensburgh",
"441261", "Banff",
"441782", "Stoke\-on\-Trent",
"442823", "Northern\ Ireland",
"441854", "Ullapool",
"441659", "Sanquhar",
"441803", "Torquay",
"441887", "Aberfeldy",
"441524", "Lancaster",
"441874", "Brecon",
"4413393", "Aboyne",
"441140", "Sheffield",
"441937", "Wetherby",
"441925", "Warrington",
"441948", "Whitchurch",
"4414347", "Hexham",
"4418511", "Great\ Bernera\/Stornoway",
"441694", "Church\ Stretton",
"441899", "Biggar",
"441822", "Tavistock",
"441572", "Oakham",
"4418479", "Tongue",
"441727", "St\ Albans",
"441539", "Kendal",
"4412290", "Barrow\-in\-Furness\/Millom",
"4418903", "Coldstream",
"441895", "Uxbridge",
"441146", "Sheffield",
"441308", "Bridport",
"441527", "Redditch",
"441877", "Callander",
"441535", "Keighley",
"441772", "Preston",
"441934", "Weston\-super\-Mare",
"441330", "Banchory",
"441929", "Wareham",
"44114705", "Sheffield",
"441724", "Scunthorpe",
"441675", "Coleshill",
"4414377", "Haverfordwest",
"441992", "Lea\ Valley",
"441202", "Bournemouth",
"441697", "Brampton",
"4416863", "Llanidloes",
"441866", "Kilchrenan",
"441408", "Golspie",
"441582", "Luton",
"441655", "Maybole",
"4415075", "Spilsby\ \(Horncastle\)",
"441857", "Sanday",
"441752", "Plymouth",
"441689", "Orpington",
"441884", "Tiverton",
"441223", "Cambridge",
"441832", "Clopton",
"441879", "Scarinish",
"441529", "Sleaford",
"441737", "Redhill",
"441674", "Montrose",
"441725", "Rockbourne",
"441592", "Kirkcaldy",
"441326", "Falmouth",
"441748", "Richmond",
"441301", "Arrochar",
"441534", "Jersey",
"441622", "Maidstone",
"44114704", "Sheffield",
"441935", "Yeovil",
"4414343", "Haltwhistle",
"442868", "Kesh",
"441885", "Pencombe",
"4413397", "Ballater",
"441603", "Norwich",
"441982", "Builth\ Wells",
"441687", "Mallaig",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441654", "Machynlleth",
"441859", "Harris",
"441395", "Budleigh\ Salterton",
"441466", "Huntly",
"441377", "Driffield",
"441808", "Tomatin",
"442828", "Larne",
"441620", "North\ Berwick",
"441249", "Chippenham",
"441796", "Pitlochry",
"441830", "Kirkwhelpington",
"441457", "Glossop",
"441484", "Huddersfield",
"441590", "Lymington",
"442845", "Northern\ Ireland",
"4412292", "Barrow\-in\-Furness",
"441495", "Pontypool",
"441917", "Sunderland",
"441943", "Guiseley",
"441366", "Downham\ Market",
"441980", "Amesbury",
"441477", "Holmes\ Chapel",
"441569", "Stonehaven",
"441765", "Ripon",
"442311", "Southampton",
"441357", "Strathaven",
"441967", "Strontian",
"441384", "Dudley",
"4412291", "Barrow\-in\-Furness\/Millom",
"441332", "Derby",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441379", "Diss",
"441485", "Hunstanton",
"442844", "Downpatrick",
"441576", "Lockerbie",
"441200", "Clitheroe",
"441394", "Felixstowe",
"4418514", "Great\ Bernera",
"4415079", "Alford\ \(Lincs\)",
"442821", "Martinstown",
"441263", "Cromer",
"441636", "Newark\-on\-Trent",
"441770", "Isle\ of\ Arran",
"441432", "Hereford",
"4414308", "Market\ Weighton",
"441750", "Selkirk",
"4413882", "Stanhope\ \(Eastgate\)",
"441567", "Killin",
"441479", "Grantown\-on\-Spey",
"4418516", "Great\ Bernera",
"44114703", "Sheffield",
"441919", "Durham",
"441786", "Stirling",
"4419757", "Strathdon",
"441543", "Cannock",
"441494", "High\ Wycombe",
"441556", "Castle\ Douglas",
"441764", "Crieff",
"441580", "Cranbrook",
"441359", "Pakenham",
"441969", "Leyburn",
"4418478", "Thurso",
"442899", "Northern\ Ireland",
"441740", "Sedgefield",
"441707", "Welwyn\ Garden\ City",
"442822", "Northern\ Ireland",
"441553", "Kings\ Lynn",
"441295", "Banbury",
"441546", "Lochgilphead",
"441905", "Worcester",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"4418517", "Stornoway",
"441277", "Brentwood",
"441349", "Dingwall",
"4419756", "Strathdon",
"441257", "Coppull",
"441284", "Bury\ St\ Edmunds",
"441573", "Kelso",
"441823", "Taunton",
"4419754", "Alford\ \(Aberdeen\)",
"442887", "Dungannon",
"4415395", "Grange\-over\-Sands",
"4414342", "Bellingham",
"441633", "Newport",
"441668", "Bamburgh",
"44287", "Northern\ Ireland",
"441449", "Stowmarket",
"441431", "Helmsdale",
"441294", "Ardrossan",
"441904", "York",
"441363", "Crediton",
"441953", "Wymondham",
"441946", "Whitehaven",
"441709", "Rotherham",
"441505", "Johnstone",
"442897", "Saintfield",
"441347", "Easingwold",
"4416861", "Newtown\/Llanidloes",
"441279", "Bishops\ Stortford",
"4418902", "Coldstream",
"4414238", "Harrogate",
"441300", "Cerne\ Abbas",
"44113", "Leeds",
"442889", "Fivemiletown",
"441463", "Inverness",
"441438", "Stevenage",
"44292", "Cardiff",
"441259", "Alloa",
"441793", "Swindon",
"441661", "Prudhoe",
"4419649", "Hornsea",
"4418901", "Coldstream\/Ayton",
"4416862", "Llanidloes",
"441285", "Cirencester",
"441400", "Honington",
"441621", "Maldon",
"4413396", "Ballater",
"4419645", "Hornsea",
"441778", "Bourne",
"441302", "Doncaster",
"44291", "Cardiff",
"441591", "Llanwrtyd\ Wells",
"441208", "Bodmin",
"441606", "Northwich",
"44247", "Coventry",
"441644", "New\ Galloway",
"442310", "Portsmouth",
"441981", "Wormbridge",
"441323", "Eastbourne",
"441588", "Bishops\ Castle",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"441758", "Pwllheli",
"4413394", "Ballater",
"44114707", "Sheffield",
"441863", "Ardgay",
"441838", "Dalmally",
"4418900", "Coldstream\/Ayton",
"441598", "Lynton",
"4412293", "Millom",
"441771", "Maud",
"441226", "Barnsley",
"442820", "Ballycastle",
"441628", "Maidenhead",
"4414374", "Clynderwen\ \(Clunderwen\)",
"441143", "Sheffield",
"4414376", "Haverfordwest",
"441751", "Pickering",
"4416860", "Newtown\/Llanidloes",
"441581", "New\ Luce",
"4417683", "Appleby",
"441988", "Wigtown",
"441269", "Ammanford",
"441651", "Oldmeldrum",
"441446", "Barry",
"441453", "Dursley",
"441404", "Honiton",
"441373", "Frome",
"441888", "Turriff",
"4413395", "Aboyne",
"4419646", "Patrington",
"441549", "Lairg",
"441745", "Rhyl",
"441531", "Ledbury",
"441963", "Wincanton",
"441353", "Ely",
"441346", "Fraserburgh",
"441938", "Welshpool",
"441304", "Dover",
"4419644", "Patrington",
"441473", "Ipswich",
"441900", "Workington",
"442896", "Belfast",
"441290", "Cumnock",
"441728", "Saxmundham",
"441671", "Newton\ Stewart",
"441947", "Whitby",
"441913", "Durham",
"441642", "Middlesbrough",
"4412298", "Barrow\-in\-Furness",
"4414302", "North\ Cave",
"441267", "Carmarthen",
"4415077", "Louth",
"442886", "Cookstown",
"441280", "Buckingham",
"441243", "Chichester",
"441256", "Basingstoke",
"441405", "Goole",
"441276", "Camberley",
"4414301", "North\ Cave\/Market\ Weighton",
"441678", "Bala",
"442870", "Coleraine",
"441547", "Knighton",
"44286", "Northern\ Ireland",
"441721", "Peebles",
"441949", "Whatton",
"441706", "Rochdale",
"441931", "Shap",
"441744", "St\ Helens",
"4419759", "Alford\ \(Aberdeen\)",
"4414375", "Clynderwen\ \(Clunderwen\)",
"441563", "Kilmarnock",
"441538", "Ipstones",
"441305", "Dorchester",
"44281", "Northern\ Ireland",
"4414379", "Haverfordwest",
"441282", "Burnley",
"441761", "Temple\ Cloud",
"4415394", "Hawkshead",
"441491", "Henley\-on\-Thames",
"4419755", "Alford\ \(Aberdeen\)",
"441873", "Abergavenny",
"441388", "Bishop\ Auckland",
"441227", "Canterbury",
"441235", "Abingdon",
"442824", "Northern\ Ireland",
"4414233", "Boroughbridge",
"441609", "Northallerton",
"441488", "Hungerford",
"441502", "Lowestoft",
"44118", "Reading",
"442841", "Rostrevor",
"4415396", "Sedbergh",
"441923", "Watford",
"441381", "Fortrose",
"441733", "Peterborough",
"4414300", "North\ Cave\/Market\ Weighton",
"441768", "Penrith",
"44241", "Coventry",
"441902", "Wolverhampton",
"441683", "Moffat",
"441292", "Ayr",
"441481", "Guernsey",
"4413399", "Ballater",
"442848", "Northern\ Ireland",
"441234", "Bedford",
"44114700", "Sheffield",
"4418473", "Thurso",
"441398", "Dulverton",
"442837", "Armagh",
"442825", "Ballymena",
"441805", "Torrington",
"441288", "Bude",
"441650", "Cemmaes\ Road",
"4414303", "North\ Cave",
"441435", "Heathfield",
"441869", "Bicester",
"441664", "Melton\ Mowbray",
"441427", "Gainsborough",
"441382", "Dundee",
"441926", "Warwick",
"44161", "Manchester",
"441530", "Coalville",
"441327", "Daventry",
"441508", "Brooke",
"441335", "Ashbourne",
"441482", "Kingston\-upon\-Hull",
"441670", "Morpeth",
"4416973", "Wigton",
"441291", "Chepstow",
"4418470", "Thurso\/Tongue",
"441736", "Penzance",
"441665", "Alnwick",
"441880", "Tarbert",
"441856", "Orkney",
"441843", "Thanet",
"441492", "Colwyn\ Bay",
"441429", "Hartlepool",
"441334", "St\ Andrews",
"441298", "Buxton",
"441720", "Isles\ of\ Scilly",
"4414230", "Harrogate\/Boroughbridge",
"441908", "Milton\ Keynes",
"442842", "Kircubbin",
"441501", "Harthill",
"442871", "Londonderry",
"441392", "Exeter",
"441876", "Lochmaddy",
"441526", "Martin",
"4418515", "Stornoway",
"441329", "Fareham",
"441490", "Corwen",
"4418471", "Thurso\/Tongue",
"441273", "Brighton",
"441760", "Swaffham",
"441557", "Kirkcudbright",
"441985", "Warminster",
"4415074", "Alford\ \(Lincs\)",
"4418519", "Great\ Bernera",
"441584", "Ludlow",
"4414348", "Hexham",
"441959", "Westerham",
"441369", "Dunoon",
"441787", "Sudbury",
"441882", "Kinloch\ Rannoch",
"441754", "Skegness",
"441566", "Launceston",
"4418472", "Thurso",
"441932", "Weybridge",
"441625", "Macclesfield",
"441637", "Newquay",
"441835", "St\ Boswells",
"441827", "Tamworth",
"441577", "Kinross",
"441469", "Killingholme",
"441722", "Salisbury",
"442883", "Northern\ Ireland",
"442840", "Banbridge",
"441253", "Blackpool",
"441799", "Saffron\ Walden",
"441246", "Chesterfield",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"441204", "Bolton",
"441994", "St\ Clears",
"4415076", "Louth",
"441380", "Devizes",
"441559", "Llandysul",
"441343", "Elgin",
"441356", "Brechin",
"4416868", "Newtown",
"442893", "Ballyclare",
"441476", "Grantham",
"4414231", "Harrogate\/Boroughbridge",
"441984", "Watchet\ \(Williton\)",
"441652", "Brigg",
"441916", "Tyneside",
"441367", "Faringdon",
"441957", "Mid\ Yell",
"441789", "Stratford\-upon\-Avon",
"441641", "Strathy",
"441639", "Neath",
"441834", "Narberth",
"441480", "Huntingdon",
"441672", "Marlborough",
"441977", "Pontefract",
"4419647", "Patrington",
"441594", "Lydney",
"441456", "Glenurquhart",
"441443", "Pontypridd",
"441205", "Boston",
"441995", "Garstang",
"441892", "Tunbridge\ Wells",
"4418908", "Coldstream",
"441376", "Braintree",
"441797", "Rye",
"441775", "Spalding",
"4414232", "Harrogate",
"441829", "Tarporley",
"441624", "Isle\ of\ Man",
"441579", "Liskeard",
"441467", "Inverurie",
"441597", "Llandrindod\ Wells",
"441450", "Hawick",
"441825", "Uckfield",
"441575", "Kirriemuir",
"441837", "Okehampton",
"441779", "Peterhead",
"441732", "Sevenoaks",
"44131", "Edinburgh",
"441974", "Llanon",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441922", "Walsall",
"4413398", "Aboyne",
"441635", "Newbury",
"441464", "Insch",
"441209", "Redruth",
"441848", "Thornhill",
"441794", "Romsey",
"441386", "Evesham",
"441350", "Dunkeld",
"441785", "Stafford",
"44141", "Glasgow",
"441903", "Worthing",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"441759", "Pocklington",
"441293", "Crawley",
"441555", "Lanark",
"441987", "Ebbsfleet",
"441364", "Ashburton",
"441954", "Madingley",
"4412295", "Barrow\-in\-Furness",
"441910", "Tyneside\/Durham\/Sunderland",
"441872", "Truro",
"441522", "Lincoln",
"4413885", "Stanhope\ \(Eastgate\)",
"441841", "Newquay\ \(Padstow\)",
"441465", "Girvan",
"441777", "Retford",
"441634", "Medway",
"441599", "Kyle",
"441795", "Sittingbourne",
"441207", "Consett",
"441692", "North\ Walsham",
"441997", "Strathpeffer",
"441283", "Burton\-on\-Trent",
"442846", "Northern\ Ireland",
"441824", "Ruthin",
"441629", "Matlock",
"441554", "Llanelli",
"441496", "Port\ Ellen",
"441503", "Looe",
"441955", "Wick",
"441766", "Porthmadog",
"44280", "Northern\ Ireland",
"4414378", "Haverfordwest",
"441852", "Kilmelford",
"4419643", "Patrington",
"441784", "Staines",
"441560", "Moscow",
"4413873", "Langholm",
"441757", "Selby",
"441989", "Ross\-on\-Wye",
"4414307", "Market\ Weighton",
"442898", "Belfast",
"441690", "Betws\-y\-Coed",
"441726", "St\ Austell",
"441242", "Cheltenham",
"4415072", "Spilsby\ \(Horncastle\)",
"441337", "Ladybank",
"441325", "Darlington",
"441271", "Barnstaple",
"4419758", "Strathdon",
"441520", "Lochcarron",
"441870", "Isle\ of\ Benbecula",
"4418476", "Tongue",
"441144", "Sheffield",
"441348", "Fishguard",
"4418474", "Thurso",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"441425", "Ringwood",
"441562", "Kidderminster",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441669", "Rothbury",
"441864", "Abington\ \(Crawford\)",
"442881", "Newtownstewart",
"441372", "Esher",
"441896", "Galashiels",
"441920", "Ware",
"441341", "Barmouth",
"441708", "Romford",
"441145", "Sheffield",
"4412299", "Millom",
"4414236", "Harrogate",
"441536", "Kettering",
"441278", "Bridgwater",
"441676", "Meriden",
"441452", "Gloucester",
"441324", "Falkirk",
"441730", "Petersfield",
"442891", "Bangor\ \(Co\.\ Down\)",
"441472", "Grimsby",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"442888", "Northern\ Ireland",
"441865", "Oxford",
"441439", "Helmsley",
"441258", "Blandford",
"441656", "Bridgend",
"441912", "Tyneside",
"441643", "Minehead",
"44114702", "Sheffield",
"441352", "Mold",
"441962", "Winchester",
"44114708", "Sheffield",
"441667", "Nairn",
"441424", "Hastings",
"4414234", "Boroughbridge",
"442892", "Lisburn",
"441451", "Stow\-on\-the\-Wold",
"4418909", "Ayton",
"4419641", "Hornsea\/Patrington",
"441604", "Northampton",
"441809", "Tomdoun",
"442829", "Kilrea",
"441646", "Milford\ Haven",
"441653", "Malton",
"4420", "London",
"441248", "Bangor\ \(Gwynedd\)",
"441237", "Bideford",
"441225", "Bath",
"441342", "East\ Grinstead",
"441371", "Great\ Dunmow",
"4416869", "Newtown",
"441568", "Leominster",
"4419642", "Hornsea",
"441911", "Tyneside\/Durham\/Sunderland",
"441673", "Market\ Rasen",
"4414237", "Harrogate",
"441442", "Hemel\ Hempstead",
"44283", "Northern\ Ireland",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"442827", "Ballymoney",
"441702", "Southend\-on\-Sea",
"4414304", "North\ Cave",
"441883", "Caterham",
"441807", "Ballindalloch",
"441224", "Aberdeen",
"441840", "Camelford",
"441239", "Cardigan",
"441241", "Arbroath",
"44115", "Nottingham",
"441458", "Glastonbury",
"44117", "Bristol",
"4418477", "Tongue",
"441723", "Scarborough",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"442882", "Omagh",
"441918", "Tyneside",
"4414349", "Bellingham",
"4416974", "Raughton\ Head",
"441252", "Aldershot",
"4414306", "Market\ Weighton",
"441561", "Laurencekirk",
"4418518", "Stornoway",
"441933", "Wellingborough",
"441358", "Ellon",
"441968", "Penicuik",
"441544", "Kington",
"441493", "Great\ Yarmouth",
"441270", "Crewe",
"441945", "Wisbech",
"441506", "Bathgate",
"441763", "Royston",
"441309", "Forres",
"441738", "Perth",
"441691", "Oswestry",
"441700", "Rothesay",
"441928", "Runcorn",
"4414345", "Haltwhistle",
"4415242", "Hornby",
"441842", "Thetford",
"441747", "Shaftesbury",
"441871", "Castlebay",
"44121", "Birmingham",
"441264", "Andover",
"441409", "Holsworthy",
"442867", "Lisnaskea",
"441286", "Caernarfon",
"4419640", "Hornsea\/Patrington",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"442880", "Carrickmore",
"442843", "Newcastle\ \(Co\.\ Down\)",
"441250", "Blairgowrie",
"441383", "Dunfermline",
"441878", "Lochboisdale",
"441528", "Laggan",
"441307", "Forfar",
"441340", "Craigellachie\ \(Aberlour\)",
"441749", "Shepton\ Mallet",
"441296", "Aylesbury",
"441545", "Llanarth",
"442890", "Belfast",
"441698", "Motherwell",
"4416865", "Newtown",
"441944", "West\ Heslerton",
"4415073", "Louth",
"441483", "Guildford",
"441407", "Holyhead",
"441440", "Haverhill",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"4418905", "Ayton",
"4419467", "Gosforth",
"441858", "Market\ Harborough",};
my $timezones = {
               '' => [
                       'Europe/Guernsey',
                       'Europe/Isle_of_Man',
                       'Europe/Jersey',
                       'Europe/London'
                     ],
               '1' => [
                        'Europe/London'
                      ],
               '1481' => [
                           'Europe/Guernsey'
                         ],
               '1534' => [
                           'Europe/Jersey'
                         ],
               '1624' => [
                           'Europe/Isle_of_Man'
                         ],
               '2' => [
                        'Europe/London'
                      ],
               '3' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '5' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '70' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '71' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '72' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '73' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '74' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '75' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '760' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '762' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '763' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '7640' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7641' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7643' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7644' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7646' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '765' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '766' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '767' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '768' => [
                          'Europe/Guernsey',
                          'Europe/Isle_of_Man',
                          'Europe/London'
                        ],
               '7693' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '7699' => [
                           'Europe/Guernsey',
                           'Europe/Isle_of_Man',
                           'Europe/London'
                         ],
               '77' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '78' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '79' => [
                         'Europe/Guernsey',
                         'Europe/Isle_of_Man',
                         'Europe/London'
                       ],
               '8' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ],
               '9' => [
                        'Europe/Guernsey',
                        'Europe/Isle_of_Man',
                        'Europe/London'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:([25-9]\d{5})$|0)//;
      $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;