# Generated by default/object.tt
package Paws::GlobalAccelerator::PortMapping;
  use Moose;
  has AcceleratorPort => (is => 'ro', isa => 'Int');
  has DestinationSocketAddress => (is => 'ro', isa => 'Paws::GlobalAccelerator::SocketAddress');
  has DestinationTrafficState => (is => 'ro', isa => 'Str');
  has EndpointGroupArn => (is => 'ro', isa => 'Str');
  has EndpointId => (is => 'ro', isa => 'Str');
  has Protocols => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlobalAccelerator::PortMapping

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlobalAccelerator::PortMapping object:

  $service_obj->Method(Att1 => { AcceleratorPort => $value, ..., Protocols => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlobalAccelerator::PortMapping object:

  $result = $service_obj->Method(...);
  $result->Att1->AcceleratorPort

=head1 DESCRIPTION

Returns the ports and associated IP addresses and ports of Amazon EC2
instances in your virtual private cloud (VPC) subnets. Custom routing
is a port mapping protocol in AWS Global Accelerator that statically
associates port ranges with VPC subnets, which allows Global
Accelerator to route to specific instances and ports within one or more
subnets.

=head1 ATTRIBUTES


=head2 AcceleratorPort => Int

The accelerator port.


=head2 DestinationSocketAddress => L<Paws::GlobalAccelerator::SocketAddress>

The EC2 instance IP address and port number in the virtual private
cloud (VPC) subnet.


=head2 DestinationTrafficState => Str

Indicates whether or not a port mapping destination can receive
traffic. The value is either ALLOW, if traffic is allowed to the
destination, or DENY, if traffic is not allowed to the destination.


=head2 EndpointGroupArn => Str

The Amazon Resource Name (ARN) of the endpoint group.


=head2 EndpointId => Str

The IP address of the VPC subnet (the subnet ID).


=head2 Protocols => ArrayRef[Str|Undef]

The protocols supported by the endpoint group.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlobalAccelerator>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

